// Copyright 2018-2020 opcua authors. All rights reserved.
// Use of this source code is governed by a MIT-style license that can be
// found in the LICENSE file.

// Code generated by cmd/service. DO NOT EDIT!

package ua

import "time"

type Request interface {
	Header() *RequestHeader
	SetHeader(*RequestHeader)
}

type Response interface {
	Header() *ResponseHeader
	SetHeader(*ResponseHeader)
}

type Union struct{}

type KeyValuePair struct {
	Key   *QualifiedName
	Value *Variant
}

type AdditionalParametersType struct {
	Parameters []*KeyValuePair
}

type EphemeralKeyType struct {
	PublicKey []byte
	Signature []byte
}

type EndpointType struct {
	EndpointURL         string
	SecurityMode        MessageSecurityMode
	SecurityPolicyURI   string
	TransportProfileURI string
}

type RationalNumber struct {
	Numerator   int32
	Denominator uint32
}

type Vector struct{}

type ThreeDVector struct {
	X float64
	Y float64
	Z float64
}

type CartesianCoordinates struct{}

type ThreeDCartesianCoordinates struct {
	X float64
	Y float64
	Z float64
}

type Orientation struct{}

type ThreeDOrientation struct {
	A float64
	B float64
	C float64
}

type Frame struct{}

type ThreeDFrame struct {
	CartesianCoordinates *ThreeDCartesianCoordinates
	Orientation          *ThreeDOrientation
}

type IdentityMappingRuleType struct {
	CriteriaType IdentityCriteriaType
	Criteria     string
}

type CurrencyUnitType struct {
	NumericCode    int16
	Exponent       int8
	AlphabeticCode string
	Currency       *LocalizedText
}

type TrustListDataType struct {
	SpecifiedLists      uint32
	TrustedCertificates [][]byte
	TrustedCrls         [][]byte
	IssuerCertificates  [][]byte
	IssuerCrls          [][]byte
}

type TransactionErrorType struct {
	TargetID *NodeID
	Error    StatusCode
	Message  *LocalizedText
}

type DataTypeSchemaHeader struct {
	Namespaces         []string
	StructureDataTypes []*StructureDescription
	EnumDataTypes      []*EnumDescription
	SimpleDataTypes    []*SimpleTypeDescription
}

type DataTypeDescription struct {
	DataTypeID *NodeID
	Name       *QualifiedName
}

type StructureDescription struct {
	DataTypeID          *NodeID
	Name                *QualifiedName
	StructureDefinition *StructureDefinition
}

type EnumDescription struct {
	DataTypeID     *NodeID
	Name           *QualifiedName
	EnumDefinition *EnumDefinition
	BuiltInType    uint8
}

type SimpleTypeDescription struct {
	DataTypeID   *NodeID
	Name         *QualifiedName
	BaseDataType *NodeID
	BuiltInType  uint8
}

type UABinaryFileDataType struct {
	Namespaces         []string
	StructureDataTypes []*StructureDescription
	EnumDataTypes      []*EnumDescription
	SimpleDataTypes    []*SimpleTypeDescription
	SchemaLocation     string
	FileHeader         []*KeyValuePair
	Body               *Variant
}

type PortableQualifiedName struct {
	NamespaceURI string
	Name         string
}

type PortableNodeID struct {
	NamespaceURI string
	IDentifier   *NodeID
}

type UnsignedRationalNumber struct {
	Numerator   uint32
	Denominator uint32
}

type DataSetMetaDataType struct {
	Namespaces           []string
	StructureDataTypes   []*StructureDescription
	EnumDataTypes        []*EnumDescription
	SimpleDataTypes      []*SimpleTypeDescription
	Name                 string
	Description          *LocalizedText
	Fields               []*FieldMetaData
	DataSetClassID       *GUID
	ConfigurationVersion *ConfigurationVersionDataType
}

type FieldMetaData struct {
	Name            string
	Description     *LocalizedText
	FieldFlags      DataSetFieldFlags
	BuiltInType     uint8
	DataType        *NodeID
	ValueRank       int32
	ArrayDimensions []uint32
	MaxStringLength uint32
	DataSetFieldID  *GUID
	Properties      []*KeyValuePair
}

type ConfigurationVersionDataType struct {
	MajorVersion uint32
	MinorVersion uint32
}

type PublishedDataSetDataType struct {
	Name            string
	DataSetFolder   []string
	DataSetMetaData *DataSetMetaDataType
	ExtensionFields []*KeyValuePair
	DataSetSource   *ExtensionObject
}

type PublishedDataSetSourceDataType struct{}

type PublishedVariableDataType struct {
	PublishedVariable    *NodeID
	AttributeID          AttributeID
	SamplingIntervalHint float64
	DeadbandType         uint32
	DeadbandValue        float64
	IndexRange           string
	SubstituteValue      *Variant
	MetaDataProperties   []*QualifiedName
}

type PublishedDataItemsDataType struct {
	PublishedData []*PublishedVariableDataType
}

type PublishedEventsDataType struct {
	EventNotifier  *NodeID
	SelectedFields []*SimpleAttributeOperand
	Filter         *ContentFilter
}

type PublishedDataSetCustomSourceDataType struct {
	CyclicDataSet bool
}

type DataSetWriterDataType struct {
	Name                    string
	Enabled                 bool
	DataSetWriterID         uint16
	DataSetFieldContentMask DataSetFieldContentMask
	KeyFrameCount           uint32
	DataSetName             string
	DataSetWriterProperties []*KeyValuePair
	TransportSettings       *ExtensionObject
	MessageSettings         *ExtensionObject
}

type DataSetWriterTransportDataType struct{}

type DataSetWriterMessageDataType struct{}

type PubSubGroupDataType struct {
	Name                  string
	Enabled               bool
	SecurityMode          MessageSecurityMode
	SecurityGroupID       string
	SecurityKeyServices   []*EndpointDescription
	MaxNetworkMessageSize uint32
	GroupProperties       []*KeyValuePair
}

type WriterGroupDataType struct {
	Name                  string
	Enabled               bool
	SecurityMode          MessageSecurityMode
	SecurityGroupID       string
	SecurityKeyServices   []*EndpointDescription
	MaxNetworkMessageSize uint32
	GroupProperties       []*KeyValuePair
	WriterGroupID         uint16
	PublishingInterval    float64
	KeepAliveTime         float64
	Priority              uint8
	LocaleIDs             []string
	HeaderLayoutURI       string
	TransportSettings     *ExtensionObject
	MessageSettings       *ExtensionObject
	DataSetWriters        []*DataSetWriterDataType
}

type WriterGroupTransportDataType struct{}

type WriterGroupMessageDataType struct{}

type PubSubConnectionDataType struct {
	Name                 string
	Enabled              bool
	PublisherID          *Variant
	TransportProfileURI  string
	Address              *ExtensionObject
	ConnectionProperties []*KeyValuePair
	TransportSettings    *ExtensionObject
	WriterGroups         []*WriterGroupDataType
	ReaderGroups         []*ReaderGroupDataType
}

type ConnectionTransportDataType struct{}

type NetworkAddressDataType struct {
	NetworkInterface string
}

type NetworkAddressURLDataType struct {
	NetworkInterface string
	URL              string
}

type ReaderGroupDataType struct {
	Name                  string
	Enabled               bool
	SecurityMode          MessageSecurityMode
	SecurityGroupID       string
	SecurityKeyServices   []*EndpointDescription
	MaxNetworkMessageSize uint32
	GroupProperties       []*KeyValuePair
	TransportSettings     *ExtensionObject
	MessageSettings       *ExtensionObject
	DataSetReaders        []*DataSetReaderDataType
}

type ReaderGroupTransportDataType struct{}

type ReaderGroupMessageDataType struct{}

type DataSetReaderDataType struct {
	Name                    string
	Enabled                 bool
	PublisherID             *Variant
	WriterGroupID           uint16
	DataSetWriterID         uint16
	DataSetMetaData         *DataSetMetaDataType
	DataSetFieldContentMask DataSetFieldContentMask
	MessageReceiveTimeout   float64
	KeyFrameCount           uint32
	HeaderLayoutURI         string
	SecurityMode            MessageSecurityMode
	SecurityGroupID         string
	SecurityKeyServices     []*EndpointDescription
	DataSetReaderProperties []*KeyValuePair
	TransportSettings       *ExtensionObject
	MessageSettings         *ExtensionObject
	SubscribedDataSet       *ExtensionObject
}

type DataSetReaderTransportDataType struct{}

type DataSetReaderMessageDataType struct{}

type SubscribedDataSetDataType struct{}

type TargetVariablesDataType struct {
	TargetVariables []*FieldTargetDataType
}

type FieldTargetDataType struct {
	DataSetFieldID        *GUID
	ReceiverIndexRange    string
	TargetNodeID          *NodeID
	AttributeID           AttributeID
	WriteIndexRange       string
	OverrideValueHandling OverrideValueHandling
	OverrideValue         *Variant
}

type SubscribedDataSetMirrorDataType struct {
	ParentNodeName  string
	RolePermissions []*RolePermissionType
}

type PubSubConfigurationDataType struct {
	PublishedDataSets []*PublishedDataSetDataType
	Connections       []*PubSubConnectionDataType
	Enabled           bool
}

type StandaloneSubscribedDataSetRefDataType struct {
	DataSetName string
}

type StandaloneSubscribedDataSetDataType struct {
	Name              string
	DataSetFolder     []string
	DataSetMetaData   *DataSetMetaDataType
	SubscribedDataSet *ExtensionObject
}

type SecurityGroupDataType struct {
	Name                string
	SecurityGroupFolder []string
	KeyLifetime         float64
	SecurityPolicyURI   string
	MaxFutureKeyCount   uint32
	MaxPastKeyCount     uint32
	SecurityGroupID     string
	RolePermissions     []*RolePermissionType
	GroupProperties     []*KeyValuePair
}

type PubSubKeyPushTargetDataType struct {
	ApplicationURI       string
	PushTargetFolder     []string
	EndpointURL          string
	SecurityPolicyURI    string
	UserTokenType        *UserTokenPolicy
	RequestedKeyCount    uint16
	RetryInterval        float64
	PushTargetProperties []*KeyValuePair
	SecurityGroups       []string
}

type PubSubConfiguration2DataType struct {
	PublishedDataSets          []*PublishedDataSetDataType
	Connections                []*PubSubConnectionDataType
	Enabled                    bool
	SubscribedDataSets         []*StandaloneSubscribedDataSetDataType
	DataSetClasses             []*DataSetMetaDataType
	DefaultSecurityKeyServices []*EndpointDescription
	SecurityGroups             []*SecurityGroupDataType
	PubSubKeyPushTargets       []*PubSubKeyPushTargetDataType
	ConfigurationVersion       uint32
	ConfigurationProperties    []*KeyValuePair
}

type UADPWriterGroupMessageDataType struct {
	GroupVersion              uint32
	DataSetOrdering           DataSetOrderingType
	NetworkMessageContentMask UADPNetworkMessageContentMask
	SamplingOffset            float64
	PublishingOffset          []float64
}

type UADPDataSetWriterMessageDataType struct {
	DataSetMessageContentMask UADPDataSetMessageContentMask
	ConfiguredSize            uint16
	NetworkMessageNumber      uint16
	DataSetOffset             uint16
}

type UADPDataSetReaderMessageDataType struct {
	GroupVersion              uint32
	NetworkMessageNumber      uint16
	DataSetOffset             uint16
	DataSetClassID            *GUID
	NetworkMessageContentMask UADPNetworkMessageContentMask
	DataSetMessageContentMask UADPDataSetMessageContentMask
	PublishingInterval        float64
	ReceiveOffset             float64
	ProcessingOffset          float64
}

type JSONWriterGroupMessageDataType struct {
	NetworkMessageContentMask JSONNetworkMessageContentMask
}

type JSONDataSetWriterMessageDataType struct {
	DataSetMessageContentMask JSONDataSetMessageContentMask
}

type JSONDataSetReaderMessageDataType struct {
	NetworkMessageContentMask JSONNetworkMessageContentMask
	DataSetMessageContentMask JSONDataSetMessageContentMask
}

type QosDataType struct{}

type TransmitQosDataType struct{}

type TransmitQosPriorityDataType struct {
	PriorityLabel string
}

type ReceiveQosDataType struct{}

type ReceiveQosPriorityDataType struct {
	PriorityLabel string
}

type DatagramConnectionTransportDataType struct {
	DiscoveryAddress *ExtensionObject
}

type DatagramConnectionTransport2DataType struct {
	DiscoveryAddress        *ExtensionObject
	DiscoveryAnnounceRate   uint32
	DiscoveryMaxMessageSize uint32
	QosCategory             string
	DatagramQos             []*ExtensionObject
}

type DatagramWriterGroupTransportDataType struct {
	MessageRepeatCount uint8
	MessageRepeatDelay float64
}

type DatagramWriterGroupTransport2DataType struct {
	MessageRepeatCount    uint8
	MessageRepeatDelay    float64
	Address               *ExtensionObject
	QosCategory           string
	DatagramQos           []*ExtensionObject
	DiscoveryAnnounceRate uint32
	Topic                 string
}

type DatagramDataSetReaderTransportDataType struct {
	Address     *ExtensionObject
	QosCategory string
	DatagramQos []*ExtensionObject
	Topic       string
}

type BrokerConnectionTransportDataType struct {
	ResourceURI              string
	AuthenticationProfileURI string
}

type BrokerWriterGroupTransportDataType struct {
	QueueName                  string
	ResourceURI                string
	AuthenticationProfileURI   string
	RequestedDeliveryGuarantee BrokerTransportQoS
}

type BrokerDataSetWriterTransportDataType struct {
	QueueName                  string
	ResourceURI                string
	AuthenticationProfileURI   string
	RequestedDeliveryGuarantee BrokerTransportQoS
	MetaDataQueueName          string
	MetaDataUpdateTime         float64
}

type BrokerDataSetReaderTransportDataType struct {
	QueueName                  string
	ResourceURI                string
	AuthenticationProfileURI   string
	RequestedDeliveryGuarantee BrokerTransportQoS
	MetaDataQueueName          string
}

type PubSubConfigurationRefDataType struct {
	ConfigurationMask PubSubConfigurationRefMask
	ElementIndex      uint16
	ConnectionIndex   uint16
	GroupIndex        uint16
}

type PubSubConfigurationValueDataType struct {
	ConfigurationElement *PubSubConfigurationRefDataType
	Name                 string
	IDentifier           *Variant
}

type AliasNameDataType struct {
	AliasName       *QualifiedName
	ReferencedNodes []*ExpandedNodeID
}

type UserManagementDataType struct {
	UserName          string
	UserConfiguration UserConfigurationMask
	Description       string
}

type PriorityMappingEntryType struct {
	MappingURI         string
	PriorityLabel      string
	PriorityValue_PCP  uint8
	PriorityValue_DSCP uint32
}

type ReferenceDescriptionDataType struct {
	SourceNode    *NodeID
	ReferenceType *NodeID
	IsForward     bool
	TargetNode    *ExpandedNodeID
}

type ReferenceListEntryDataType struct {
	ReferenceType *NodeID
	IsForward     bool
	TargetNode    *ExpandedNodeID
}

type RolePermissionType struct {
	RoleID      *NodeID
	Permissions PermissionType
}

type DataTypeDefinition struct{}

type StructureField struct {
	Name            string
	Description     *LocalizedText
	DataType        *NodeID
	ValueRank       int32
	ArrayDimensions []uint32
	MaxStringLength uint32
	IsOptional      bool
}

type StructureDefinition struct {
	DefaultEncodingID *NodeID
	BaseDataType      *NodeID
	StructureType     StructureType
	Fields            []*StructureField
}

type EnumDefinition struct {
	Fields []*EnumField
}

type Argument struct {
	Name            string
	DataType        *NodeID
	ValueRank       int32
	ArrayDimensions []uint32
	Description     *LocalizedText
}

type EnumValueType struct {
	Value       int64
	DisplayName *LocalizedText
	Description *LocalizedText
}

type EnumField struct {
	Value       int64
	DisplayName *LocalizedText
	Description *LocalizedText
	Name        string
}

type OptionSet struct {
	Value     []byte
	ValidBits []byte
}

type TimeZoneDataType struct {
	Offset                 int16
	DaylightSavingInOffset bool
}

type ApplicationDescription struct {
	ApplicationURI      string
	ProductURI          string
	ApplicationName     *LocalizedText
	ApplicationType     ApplicationType
	GatewayServerURI    string
	DiscoveryProfileURI string
	DiscoveryURLs       []string
}

type RequestHeader struct {
	AuthenticationToken *NodeID
	Timestamp           time.Time
	RequestHandle       uint32
	ReturnDiagnostics   uint32
	AuditEntryID        string
	TimeoutHint         uint32
	AdditionalHeader    *ExtensionObject
}

type ResponseHeader struct {
	Timestamp          time.Time
	RequestHandle      uint32
	ServiceResult      StatusCode
	ServiceDiagnostics *DiagnosticInfo
	StringTable        []string
	AdditionalHeader   *ExtensionObject
}

type ServiceFault struct {
	ResponseHeader *ResponseHeader
}

func (t *ServiceFault) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *ServiceFault) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type SessionlessInvokeRequestType struct {
	URIsVersion   uint32
	NamespaceURIs []string
	ServerURIs    []string
	LocaleIDs     []string
	ServiceID     uint32
}

type SessionlessInvokeResponseType struct {
	NamespaceURIs []string
	ServerURIs    []string
	ServiceID     uint32
}

type FindServersRequest struct {
	RequestHeader *RequestHeader
	EndpointURL   string
	LocaleIDs     []string
	ServerURIs    []string
}

func (t *FindServersRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *FindServersRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type FindServersResponse struct {
	ResponseHeader *ResponseHeader
	Servers        []*ApplicationDescription
}

func (t *FindServersResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *FindServersResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type ServerOnNetwork struct {
	RecordID           uint32
	ServerName         string
	DiscoveryURL       string
	ServerCapabilities []string
}

type FindServersOnNetworkRequest struct {
	RequestHeader          *RequestHeader
	StartingRecordID       uint32
	MaxRecordsToReturn     uint32
	ServerCapabilityFilter []string
}

func (t *FindServersOnNetworkRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *FindServersOnNetworkRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type FindServersOnNetworkResponse struct {
	ResponseHeader       *ResponseHeader
	LastCounterResetTime time.Time
	Servers              []*ServerOnNetwork
}

func (t *FindServersOnNetworkResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *FindServersOnNetworkResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type UserTokenPolicy struct {
	PolicyID          string
	TokenType         UserTokenType
	IssuedTokenType   string
	IssuerEndpointURL string
	SecurityPolicyURI string
}

type EndpointDescription struct {
	EndpointURL         string
	Server              *ApplicationDescription
	ServerCertificate   []byte
	SecurityMode        MessageSecurityMode
	SecurityPolicyURI   string
	UserIdentityTokens  []*UserTokenPolicy
	TransportProfileURI string
	SecurityLevel       uint8
}

type GetEndpointsRequest struct {
	RequestHeader *RequestHeader
	EndpointURL   string
	LocaleIDs     []string
	ProfileURIs   []string
}

func (t *GetEndpointsRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *GetEndpointsRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type GetEndpointsResponse struct {
	ResponseHeader *ResponseHeader
	Endpoints      []*EndpointDescription
}

func (t *GetEndpointsResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *GetEndpointsResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type RegisteredServer struct {
	ServerURI         string
	ProductURI        string
	ServerNames       []*LocalizedText
	ServerType        ApplicationType
	GatewayServerURI  string
	DiscoveryURLs     []string
	SemaphoreFilePath string
	IsOnline          bool
}

type RegisterServerRequest struct {
	RequestHeader *RequestHeader
	Server        *RegisteredServer
}

func (t *RegisterServerRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *RegisterServerRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type RegisterServerResponse struct {
	ResponseHeader *ResponseHeader
}

func (t *RegisterServerResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *RegisterServerResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type DiscoveryConfiguration struct{}

type MdnsDiscoveryConfiguration struct {
	MdnsServerName     string
	ServerCapabilities []string
}

type RegisterServer2Request struct {
	RequestHeader          *RequestHeader
	Server                 *RegisteredServer
	DiscoveryConfiguration []*ExtensionObject
}

func (t *RegisterServer2Request) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *RegisterServer2Request) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type RegisterServer2Response struct {
	ResponseHeader       *ResponseHeader
	ConfigurationResults []StatusCode
	DiagnosticInfos      []*DiagnosticInfo
}

func (t *RegisterServer2Response) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *RegisterServer2Response) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type ChannelSecurityToken struct {
	ChannelID       uint32
	TokenID         uint32
	CreatedAt       time.Time
	RevisedLifetime uint32
}

type OpenSecureChannelRequest struct {
	RequestHeader         *RequestHeader
	ClientProtocolVersion uint32
	RequestType           SecurityTokenRequestType
	SecurityMode          MessageSecurityMode
	ClientNonce           []byte
	RequestedLifetime     uint32
}

func (t *OpenSecureChannelRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *OpenSecureChannelRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type OpenSecureChannelResponse struct {
	ResponseHeader        *ResponseHeader
	ServerProtocolVersion uint32
	SecurityToken         *ChannelSecurityToken
	ServerNonce           []byte
}

func (t *OpenSecureChannelResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *OpenSecureChannelResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type CloseSecureChannelRequest struct {
	RequestHeader *RequestHeader
}

func (t *CloseSecureChannelRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *CloseSecureChannelRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type CloseSecureChannelResponse struct {
	ResponseHeader *ResponseHeader
}

func (t *CloseSecureChannelResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *CloseSecureChannelResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type SignedSoftwareCertificate struct {
	CertificateData []byte
	Signature       []byte
}

type SignatureData struct {
	Algorithm string
	Signature []byte
}

type CreateSessionRequest struct {
	RequestHeader           *RequestHeader
	ClientDescription       *ApplicationDescription
	ServerURI               string
	EndpointURL             string
	SessionName             string
	ClientNonce             []byte
	ClientCertificate       []byte
	RequestedSessionTimeout float64
	MaxResponseMessageSize  uint32
}

func (t *CreateSessionRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *CreateSessionRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type CreateSessionResponse struct {
	ResponseHeader             *ResponseHeader
	SessionID                  *NodeID
	AuthenticationToken        *NodeID
	RevisedSessionTimeout      float64
	ServerNonce                []byte
	ServerCertificate          []byte
	ServerEndpoints            []*EndpointDescription
	ServerSoftwareCertificates []*SignedSoftwareCertificate
	ServerSignature            *SignatureData
	MaxRequestMessageSize      uint32
}

func (t *CreateSessionResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *CreateSessionResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type UserIdentityToken struct {
	PolicyID string
}

type AnonymousIdentityToken struct {
	PolicyID string
}

type UserNameIdentityToken struct {
	PolicyID            string
	UserName            string
	Password            []byte
	EncryptionAlgorithm string
}

type X509IdentityToken struct {
	PolicyID        string
	CertificateData []byte
}

type IssuedIdentityToken struct {
	PolicyID            string
	TokenData           []byte
	EncryptionAlgorithm string
}

type ActivateSessionRequest struct {
	RequestHeader              *RequestHeader
	ClientSignature            *SignatureData
	ClientSoftwareCertificates []*SignedSoftwareCertificate
	LocaleIDs                  []string
	UserIdentityToken          *ExtensionObject
	UserTokenSignature         *SignatureData
}

func (t *ActivateSessionRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *ActivateSessionRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type ActivateSessionResponse struct {
	ResponseHeader  *ResponseHeader
	ServerNonce     []byte
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *ActivateSessionResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *ActivateSessionResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type CloseSessionRequest struct {
	RequestHeader       *RequestHeader
	DeleteSubscriptions bool
}

func (t *CloseSessionRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *CloseSessionRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type CloseSessionResponse struct {
	ResponseHeader *ResponseHeader
}

func (t *CloseSessionResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *CloseSessionResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type CancelRequest struct {
	RequestHeader *RequestHeader
	RequestHandle uint32
}

func (t *CancelRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *CancelRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type CancelResponse struct {
	ResponseHeader *ResponseHeader
	CancelCount    uint32
}

func (t *CancelResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *CancelResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type NodeAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
}

type ObjectAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	EventNotifier       uint8
}

type VariableAttributes struct {
	SpecifiedAttributes     uint32
	DisplayName             *LocalizedText
	Description             *LocalizedText
	WriteMask               uint32
	UserWriteMask           uint32
	Value                   *Variant
	DataType                *NodeID
	ValueRank               int32
	ArrayDimensions         []uint32
	AccessLevel             uint8
	UserAccessLevel         uint8
	MinimumSamplingInterval float64
	Historizing             bool
}

type MethodAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	Executable          bool
	UserExecutable      bool
}

type ObjectTypeAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	IsAbstract          bool
}

type VariableTypeAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	Value               *Variant
	DataType            *NodeID
	ValueRank           int32
	ArrayDimensions     []uint32
	IsAbstract          bool
}

type ReferenceTypeAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	IsAbstract          bool
	Symmetric           bool
	InverseName         *LocalizedText
}

type DataTypeAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	IsAbstract          bool
}

type ViewAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	ContainsNoLoops     bool
	EventNotifier       uint8
}

type GenericAttributeValue struct {
	AttributeID AttributeID
	Value       *Variant
}

type GenericAttributes struct {
	SpecifiedAttributes uint32
	DisplayName         *LocalizedText
	Description         *LocalizedText
	WriteMask           uint32
	UserWriteMask       uint32
	AttributeValues     []*GenericAttributeValue
}

type AddNodesItem struct {
	ParentNodeID       *ExpandedNodeID
	ReferenceTypeID    *NodeID
	RequestedNewNodeID *ExpandedNodeID
	BrowseName         *QualifiedName
	NodeClass          NodeClass
	NodeAttributes     *ExtensionObject
	TypeDefinition     *ExpandedNodeID
}

type AddNodesResult struct {
	StatusCode  StatusCode
	AddedNodeID *NodeID
}

type AddNodesRequest struct {
	RequestHeader *RequestHeader
	NodesToAdd    []*AddNodesItem
}

func (t *AddNodesRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *AddNodesRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type AddNodesResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*AddNodesResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *AddNodesResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *AddNodesResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type AddReferencesItem struct {
	SourceNodeID    *NodeID
	ReferenceTypeID *NodeID
	IsForward       bool
	TargetServerURI string
	TargetNodeID    *ExpandedNodeID
	TargetNodeClass NodeClass
}

type AddReferencesRequest struct {
	RequestHeader   *RequestHeader
	ReferencesToAdd []*AddReferencesItem
}

func (t *AddReferencesRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *AddReferencesRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type AddReferencesResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *AddReferencesResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *AddReferencesResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type DeleteNodesItem struct {
	NodeID                 *NodeID
	DeleteTargetReferences bool
}

type DeleteNodesRequest struct {
	RequestHeader *RequestHeader
	NodesToDelete []*DeleteNodesItem
}

func (t *DeleteNodesRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *DeleteNodesRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type DeleteNodesResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *DeleteNodesResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *DeleteNodesResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type DeleteReferencesItem struct {
	SourceNodeID        *NodeID
	ReferenceTypeID     *NodeID
	IsForward           bool
	TargetNodeID        *ExpandedNodeID
	DeleteBidirectional bool
}

type DeleteReferencesRequest struct {
	RequestHeader      *RequestHeader
	ReferencesToDelete []*DeleteReferencesItem
}

func (t *DeleteReferencesRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *DeleteReferencesRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type DeleteReferencesResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *DeleteReferencesResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *DeleteReferencesResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type ViewDescription struct {
	ViewID      *NodeID
	Timestamp   time.Time
	ViewVersion uint32
}

type BrowseDescription struct {
	NodeID          *NodeID
	BrowseDirection BrowseDirection
	ReferenceTypeID *NodeID
	IncludeSubtypes bool
	NodeClassMask   uint32
	ResultMask      uint32
}

type ReferenceDescription struct {
	ReferenceTypeID *NodeID
	IsForward       bool
	NodeID          *ExpandedNodeID
	BrowseName      *QualifiedName
	DisplayName     *LocalizedText
	NodeClass       NodeClass
	TypeDefinition  *ExpandedNodeID
}

type BrowseResult struct {
	StatusCode        StatusCode
	ContinuationPoint []byte
	References        []*ReferenceDescription
}

type BrowseRequest struct {
	RequestHeader                 *RequestHeader
	View                          *ViewDescription
	RequestedMaxReferencesPerNode uint32
	NodesToBrowse                 []*BrowseDescription
}

func (t *BrowseRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *BrowseRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type BrowseResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*BrowseResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *BrowseResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *BrowseResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type BrowseNextRequest struct {
	RequestHeader             *RequestHeader
	ReleaseContinuationPoints bool
	ContinuationPoints        [][]byte
}

func (t *BrowseNextRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *BrowseNextRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type BrowseNextResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*BrowseResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *BrowseNextResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *BrowseNextResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type RelativePathElement struct {
	ReferenceTypeID *NodeID
	IsInverse       bool
	IncludeSubtypes bool
	TargetName      *QualifiedName
}

type RelativePath struct {
	Elements []*RelativePathElement
}

type BrowsePath struct {
	StartingNode *NodeID
	RelativePath *RelativePath
}

type BrowsePathTarget struct {
	TargetID           *ExpandedNodeID
	RemainingPathIndex uint32
}

type BrowsePathResult struct {
	StatusCode StatusCode
	Targets    []*BrowsePathTarget
}

type TranslateBrowsePathsToNodeIDsRequest struct {
	RequestHeader *RequestHeader
	BrowsePaths   []*BrowsePath
}

func (t *TranslateBrowsePathsToNodeIDsRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *TranslateBrowsePathsToNodeIDsRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type TranslateBrowsePathsToNodeIDsResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*BrowsePathResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *TranslateBrowsePathsToNodeIDsResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *TranslateBrowsePathsToNodeIDsResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type RegisterNodesRequest struct {
	RequestHeader   *RequestHeader
	NodesToRegister []*NodeID
}

func (t *RegisterNodesRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *RegisterNodesRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type RegisterNodesResponse struct {
	ResponseHeader    *ResponseHeader
	RegisteredNodeIDs []*NodeID
}

func (t *RegisterNodesResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *RegisterNodesResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type UnregisterNodesRequest struct {
	RequestHeader     *RequestHeader
	NodesToUnregister []*NodeID
}

func (t *UnregisterNodesRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *UnregisterNodesRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type UnregisterNodesResponse struct {
	ResponseHeader *ResponseHeader
}

func (t *UnregisterNodesResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *UnregisterNodesResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type EndpointConfiguration struct {
	OperationTimeout      int32
	UseBinaryEncoding     bool
	MaxStringLength       int32
	MaxByteStringLength   int32
	MaxArrayLength        int32
	MaxMessageSize        int32
	MaxBufferSize         int32
	ChannelLifetime       int32
	SecurityTokenLifetime int32
}

type QueryDataDescription struct {
	RelativePath *RelativePath
	AttributeID  AttributeID
	IndexRange   string
}

type NodeTypeDescription struct {
	TypeDefinitionNode *ExpandedNodeID
	IncludeSubTypes    bool
	DataToReturn       []*QueryDataDescription
}

type QueryDataSet struct {
	NodeID             *ExpandedNodeID
	TypeDefinitionNode *ExpandedNodeID
	Values             []*Variant
}

type NodeReference struct {
	NodeID            *NodeID
	ReferenceTypeID   *NodeID
	IsForward         bool
	ReferencedNodeIDs []*NodeID
}

type ContentFilterElement struct {
	FilterOperator FilterOperator
	FilterOperands []*ExtensionObject
}

type ContentFilter struct {
	Elements []*ContentFilterElement
}

type FilterOperand struct{}

type ElementOperand struct {
	Index uint32
}

type LiteralOperand struct {
	Value *Variant
}

type AttributeOperand struct {
	NodeID      *NodeID
	Alias       string
	BrowsePath  *RelativePath
	AttributeID AttributeID
	IndexRange  string
}

type SimpleAttributeOperand struct {
	TypeDefinitionID *NodeID
	BrowsePath       []*QualifiedName
	AttributeID      AttributeID
	IndexRange       string
}

type ContentFilterElementResult struct {
	StatusCode             StatusCode
	OperandStatusCodes     []StatusCode
	OperandDiagnosticInfos []*DiagnosticInfo
}

type ContentFilterResult struct {
	ElementResults         []*ContentFilterElementResult
	ElementDiagnosticInfos []*DiagnosticInfo
}

type ParsingResult struct {
	StatusCode          StatusCode
	DataStatusCodes     []StatusCode
	DataDiagnosticInfos []*DiagnosticInfo
}

type QueryFirstRequest struct {
	RequestHeader         *RequestHeader
	View                  *ViewDescription
	NodeTypes             []*NodeTypeDescription
	Filter                *ContentFilter
	MaxDataSetsToReturn   uint32
	MaxReferencesToReturn uint32
}

func (t *QueryFirstRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *QueryFirstRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type QueryFirstResponse struct {
	ResponseHeader    *ResponseHeader
	QueryDataSets     []*QueryDataSet
	ContinuationPoint []byte
	ParsingResults    []*ParsingResult
	DiagnosticInfos   []*DiagnosticInfo
	FilterResult      *ContentFilterResult
}

func (t *QueryFirstResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *QueryFirstResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type QueryNextRequest struct {
	RequestHeader            *RequestHeader
	ReleaseContinuationPoint bool
	ContinuationPoint        []byte
}

func (t *QueryNextRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *QueryNextRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type QueryNextResponse struct {
	ResponseHeader           *ResponseHeader
	QueryDataSets            []*QueryDataSet
	RevisedContinuationPoint []byte
}

func (t *QueryNextResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *QueryNextResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type ReadValueID struct {
	NodeID       *NodeID
	AttributeID  AttributeID
	IndexRange   string
	DataEncoding *QualifiedName
}

type ReadRequest struct {
	RequestHeader      *RequestHeader
	MaxAge             float64
	TimestampsToReturn TimestampsToReturn
	NodesToRead        []*ReadValueID
}

func (t *ReadRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *ReadRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type ReadResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*DataValue
	DiagnosticInfos []*DiagnosticInfo
}

func (t *ReadResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *ReadResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type HistoryReadValueID struct {
	NodeID            *NodeID
	IndexRange        string
	DataEncoding      *QualifiedName
	ContinuationPoint []byte
}

type HistoryReadResult struct {
	StatusCode        StatusCode
	ContinuationPoint []byte
	HistoryData       *ExtensionObject
}

type HistoryReadDetails struct{}

type ReadEventDetails struct {
	NumValuesPerNode uint32
	StartTime        time.Time
	EndTime          time.Time
	Filter           *EventFilter
}

type ReadRawModifiedDetails struct {
	IsReadModified   bool
	StartTime        time.Time
	EndTime          time.Time
	NumValuesPerNode uint32
	ReturnBounds     bool
}

type ReadProcessedDetails struct {
	StartTime              time.Time
	EndTime                time.Time
	ProcessingInterval     float64
	AggregateType          []*NodeID
	AggregateConfiguration *AggregateConfiguration
}

type ReadAtTimeDetails struct {
	ReqTimes        []time.Time
	UseSimpleBounds bool
}

type ReadAnnotationDataDetails struct {
	ReqTimes []time.Time
}

type HistoryData struct {
	DataValues []*DataValue
}

type ModificationInfo struct {
	ModificationTime time.Time
	UpdateType       HistoryUpdateType
	UserName         string
}

type HistoryModifiedData struct {
	DataValues        []*DataValue
	ModificationInfos []*ModificationInfo
}

type HistoryEvent struct {
	Events []*HistoryEventFieldList
}

type HistoryReadRequest struct {
	RequestHeader             *RequestHeader
	HistoryReadDetails        *ExtensionObject
	TimestampsToReturn        TimestampsToReturn
	ReleaseContinuationPoints bool
	NodesToRead               []*HistoryReadValueID
}

func (t *HistoryReadRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *HistoryReadRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type HistoryReadResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*HistoryReadResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *HistoryReadResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *HistoryReadResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type WriteValue struct {
	NodeID      *NodeID
	AttributeID AttributeID
	IndexRange  string
	Value       *DataValue
}

type WriteRequest struct {
	RequestHeader *RequestHeader
	NodesToWrite  []*WriteValue
}

func (t *WriteRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *WriteRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type WriteResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *WriteResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *WriteResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type HistoryUpdateDetails struct {
	NodeID *NodeID
}

type UpdateDataDetails struct {
	NodeID               *NodeID
	PerformInsertReplace PerformUpdateType
	UpdateValues         []*DataValue
}

type UpdateStructureDataDetails struct {
	NodeID               *NodeID
	PerformInsertReplace PerformUpdateType
	UpdateValues         []*DataValue
}

type UpdateEventDetails struct {
	NodeID               *NodeID
	PerformInsertReplace PerformUpdateType
	Filter               *EventFilter
	EventData            []*HistoryEventFieldList
}

type DeleteRawModifiedDetails struct {
	NodeID           *NodeID
	IsDeleteModified bool
	StartTime        time.Time
	EndTime          time.Time
}

type DeleteAtTimeDetails struct {
	NodeID   *NodeID
	ReqTimes []time.Time
}

type DeleteEventDetails struct {
	NodeID   *NodeID
	EventIDs [][]byte
}

type HistoryUpdateResult struct {
	StatusCode       StatusCode
	OperationResults []StatusCode
	DiagnosticInfos  []*DiagnosticInfo
}

type HistoryUpdateRequest struct {
	RequestHeader        *RequestHeader
	HistoryUpdateDetails []*ExtensionObject
}

func (t *HistoryUpdateRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *HistoryUpdateRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type HistoryUpdateResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*HistoryUpdateResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *HistoryUpdateResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *HistoryUpdateResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type CallMethodRequest struct {
	ObjectID       *NodeID
	MethodID       *NodeID
	InputArguments []*Variant
}

type CallMethodResult struct {
	StatusCode                   StatusCode
	InputArgumentResults         []StatusCode
	InputArgumentDiagnosticInfos []*DiagnosticInfo
	OutputArguments              []*Variant
}

type CallRequest struct {
	RequestHeader *RequestHeader
	MethodsToCall []*CallMethodRequest
}

func (t *CallRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *CallRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type CallResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*CallMethodResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *CallResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *CallResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type MonitoringFilter struct{}

type DataChangeFilter struct {
	Trigger       DataChangeTrigger
	DeadbandType  uint32
	DeadbandValue float64
}

type EventFilter struct {
	SelectClauses []*SimpleAttributeOperand
	WhereClause   *ContentFilter
}

type AggregateConfiguration struct {
	UseServerCapabilitiesDefaults bool
	TreatUncertainAsBad           bool
	PercentDataBad                uint8
	PercentDataGood               uint8
	UseSlopedExtrapolation        bool
}

type AggregateFilter struct {
	StartTime              time.Time
	AggregateType          *NodeID
	ProcessingInterval     float64
	AggregateConfiguration *AggregateConfiguration
}

type MonitoringFilterResult struct{}

type EventFilterResult struct {
	SelectClauseResults         []StatusCode
	SelectClauseDiagnosticInfos []*DiagnosticInfo
	WhereClauseResult           *ContentFilterResult
}

type AggregateFilterResult struct {
	RevisedStartTime              time.Time
	RevisedProcessingInterval     float64
	RevisedAggregateConfiguration *AggregateConfiguration
}

type MonitoringParameters struct {
	ClientHandle     uint32
	SamplingInterval float64
	Filter           *ExtensionObject
	QueueSize        uint32
	DiscardOldest    bool
}

type MonitoredItemCreateRequest struct {
	ItemToMonitor       *ReadValueID
	MonitoringMode      MonitoringMode
	RequestedParameters *MonitoringParameters
}

type MonitoredItemCreateResult struct {
	StatusCode              StatusCode
	MonitoredItemID         uint32
	RevisedSamplingInterval float64
	RevisedQueueSize        uint32
	FilterResult            *ExtensionObject
}

type CreateMonitoredItemsRequest struct {
	RequestHeader      *RequestHeader
	SubscriptionID     uint32
	TimestampsToReturn TimestampsToReturn
	ItemsToCreate      []*MonitoredItemCreateRequest
}

func (t *CreateMonitoredItemsRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *CreateMonitoredItemsRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type CreateMonitoredItemsResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*MonitoredItemCreateResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *CreateMonitoredItemsResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *CreateMonitoredItemsResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type MonitoredItemModifyRequest struct {
	MonitoredItemID     uint32
	RequestedParameters *MonitoringParameters
}

type MonitoredItemModifyResult struct {
	StatusCode              StatusCode
	RevisedSamplingInterval float64
	RevisedQueueSize        uint32
	FilterResult            *ExtensionObject
}

type ModifyMonitoredItemsRequest struct {
	RequestHeader      *RequestHeader
	SubscriptionID     uint32
	TimestampsToReturn TimestampsToReturn
	ItemsToModify      []*MonitoredItemModifyRequest
}

func (t *ModifyMonitoredItemsRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *ModifyMonitoredItemsRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type ModifyMonitoredItemsResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*MonitoredItemModifyResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *ModifyMonitoredItemsResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *ModifyMonitoredItemsResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type SetMonitoringModeRequest struct {
	RequestHeader    *RequestHeader
	SubscriptionID   uint32
	MonitoringMode   MonitoringMode
	MonitoredItemIDs []uint32
}

func (t *SetMonitoringModeRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *SetMonitoringModeRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type SetMonitoringModeResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *SetMonitoringModeResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *SetMonitoringModeResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type SetTriggeringRequest struct {
	RequestHeader    *RequestHeader
	SubscriptionID   uint32
	TriggeringItemID uint32
	LinksToAdd       []uint32
	LinksToRemove    []uint32
}

func (t *SetTriggeringRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *SetTriggeringRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type SetTriggeringResponse struct {
	ResponseHeader        *ResponseHeader
	AddResults            []StatusCode
	AddDiagnosticInfos    []*DiagnosticInfo
	RemoveResults         []StatusCode
	RemoveDiagnosticInfos []*DiagnosticInfo
}

func (t *SetTriggeringResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *SetTriggeringResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type DeleteMonitoredItemsRequest struct {
	RequestHeader    *RequestHeader
	SubscriptionID   uint32
	MonitoredItemIDs []uint32
}

func (t *DeleteMonitoredItemsRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *DeleteMonitoredItemsRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type DeleteMonitoredItemsResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *DeleteMonitoredItemsResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *DeleteMonitoredItemsResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type CreateSubscriptionRequest struct {
	RequestHeader               *RequestHeader
	RequestedPublishingInterval float64
	RequestedLifetimeCount      uint32
	RequestedMaxKeepAliveCount  uint32
	MaxNotificationsPerPublish  uint32
	PublishingEnabled           bool
	Priority                    uint8
}

func (t *CreateSubscriptionRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *CreateSubscriptionRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type CreateSubscriptionResponse struct {
	ResponseHeader            *ResponseHeader
	SubscriptionID            uint32
	RevisedPublishingInterval float64
	RevisedLifetimeCount      uint32
	RevisedMaxKeepAliveCount  uint32
}

func (t *CreateSubscriptionResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *CreateSubscriptionResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type ModifySubscriptionRequest struct {
	RequestHeader               *RequestHeader
	SubscriptionID              uint32
	RequestedPublishingInterval float64
	RequestedLifetimeCount      uint32
	RequestedMaxKeepAliveCount  uint32
	MaxNotificationsPerPublish  uint32
	Priority                    uint8
}

func (t *ModifySubscriptionRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *ModifySubscriptionRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type ModifySubscriptionResponse struct {
	ResponseHeader            *ResponseHeader
	RevisedPublishingInterval float64
	RevisedLifetimeCount      uint32
	RevisedMaxKeepAliveCount  uint32
}

func (t *ModifySubscriptionResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *ModifySubscriptionResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type SetPublishingModeRequest struct {
	RequestHeader     *RequestHeader
	PublishingEnabled bool
	SubscriptionIDs   []uint32
}

func (t *SetPublishingModeRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *SetPublishingModeRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type SetPublishingModeResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *SetPublishingModeResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *SetPublishingModeResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type NotificationMessage struct {
	SequenceNumber   uint32
	PublishTime      time.Time
	NotificationData []*ExtensionObject
}

type NotificationData struct{}

type DataChangeNotification struct {
	MonitoredItems  []*MonitoredItemNotification
	DiagnosticInfos []*DiagnosticInfo
}

type MonitoredItemNotification struct {
	ClientHandle uint32
	Value        *DataValue
}

type EventNotificationList struct {
	Events []*EventFieldList
}

type EventFieldList struct {
	ClientHandle uint32
	EventFields  []*Variant
}

type HistoryEventFieldList struct {
	EventFields []*Variant
}

type StatusChangeNotification struct {
	Status         StatusCode
	DiagnosticInfo *DiagnosticInfo
}

type SubscriptionAcknowledgement struct {
	SubscriptionID uint32
	SequenceNumber uint32
}

type PublishRequest struct {
	RequestHeader                *RequestHeader
	SubscriptionAcknowledgements []*SubscriptionAcknowledgement
}

func (t *PublishRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *PublishRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type PublishResponse struct {
	ResponseHeader           *ResponseHeader
	SubscriptionID           uint32
	AvailableSequenceNumbers []uint32
	MoreNotifications        bool
	NotificationMessage      *NotificationMessage
	Results                  []StatusCode
	DiagnosticInfos          []*DiagnosticInfo
}

func (t *PublishResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *PublishResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type RepublishRequest struct {
	RequestHeader            *RequestHeader
	SubscriptionID           uint32
	RetransmitSequenceNumber uint32
}

func (t *RepublishRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *RepublishRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type RepublishResponse struct {
	ResponseHeader      *ResponseHeader
	NotificationMessage *NotificationMessage
}

func (t *RepublishResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *RepublishResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type TransferResult struct {
	StatusCode               StatusCode
	AvailableSequenceNumbers []uint32
}

type TransferSubscriptionsRequest struct {
	RequestHeader     *RequestHeader
	SubscriptionIDs   []uint32
	SendInitialValues bool
}

func (t *TransferSubscriptionsRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *TransferSubscriptionsRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type TransferSubscriptionsResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []*TransferResult
	DiagnosticInfos []*DiagnosticInfo
}

func (t *TransferSubscriptionsResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *TransferSubscriptionsResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type DeleteSubscriptionsRequest struct {
	RequestHeader   *RequestHeader
	SubscriptionIDs []uint32
}

func (t *DeleteSubscriptionsRequest) Header() *RequestHeader {
	return t.RequestHeader
}

func (t *DeleteSubscriptionsRequest) SetHeader(h *RequestHeader) {
	t.RequestHeader = h
}

type DeleteSubscriptionsResponse struct {
	ResponseHeader  *ResponseHeader
	Results         []StatusCode
	DiagnosticInfos []*DiagnosticInfo
}

func (t *DeleteSubscriptionsResponse) Header() *ResponseHeader {
	return t.ResponseHeader
}

func (t *DeleteSubscriptionsResponse) SetHeader(h *ResponseHeader) {
	t.ResponseHeader = h
}

type BuildInfo struct {
	ProductURI       string
	ManufacturerName string
	ProductName      string
	SoftwareVersion  string
	BuildNumber      string
	BuildDate        time.Time
}

type RedundantServerDataType struct {
	ServerID     string
	ServiceLevel uint8
	ServerState  ServerState
}

type EndpointURLListDataType struct {
	EndpointURLList []string
}

type NetworkGroupDataType struct {
	ServerURI    string
	NetworkPaths []*EndpointURLListDataType
}

type SamplingIntervalDiagnosticsDataType struct {
	SamplingInterval           float64
	MonitoredItemCount         uint32
	MaxMonitoredItemCount      uint32
	DisabledMonitoredItemCount uint32
}

type ServerDiagnosticsSummaryDataType struct {
	ServerViewCount               uint32
	CurrentSessionCount           uint32
	CumulatedSessionCount         uint32
	SecurityRejectedSessionCount  uint32
	RejectedSessionCount          uint32
	SessionTimeoutCount           uint32
	SessionAbortCount             uint32
	CurrentSubscriptionCount      uint32
	CumulatedSubscriptionCount    uint32
	PublishingIntervalCount       uint32
	SecurityRejectedRequestsCount uint32
	RejectedRequestsCount         uint32
}

type ServerStatusDataType struct {
	StartTime           time.Time
	CurrentTime         time.Time
	State               ServerState
	BuildInfo           *BuildInfo
	SecondsTillShutdown uint32
	ShutdownReason      *LocalizedText
}

type SessionDiagnosticsDataType struct {
	SessionID                          *NodeID
	SessionName                        string
	ClientDescription                  *ApplicationDescription
	ServerURI                          string
	EndpointURL                        string
	LocaleIDs                          []string
	ActualSessionTimeout               float64
	MaxResponseMessageSize             uint32
	ClientConnectionTime               time.Time
	ClientLastContactTime              time.Time
	CurrentSubscriptionsCount          uint32
	CurrentMonitoredItemsCount         uint32
	CurrentPublishRequestsInQueue      uint32
	TotalRequestCount                  *ServiceCounterDataType
	UnauthorizedRequestCount           uint32
	ReadCount                          *ServiceCounterDataType
	HistoryReadCount                   *ServiceCounterDataType
	WriteCount                         *ServiceCounterDataType
	HistoryUpdateCount                 *ServiceCounterDataType
	CallCount                          *ServiceCounterDataType
	CreateMonitoredItemsCount          *ServiceCounterDataType
	ModifyMonitoredItemsCount          *ServiceCounterDataType
	SetMonitoringModeCount             *ServiceCounterDataType
	SetTriggeringCount                 *ServiceCounterDataType
	DeleteMonitoredItemsCount          *ServiceCounterDataType
	CreateSubscriptionCount            *ServiceCounterDataType
	ModifySubscriptionCount            *ServiceCounterDataType
	SetPublishingModeCount             *ServiceCounterDataType
	PublishCount                       *ServiceCounterDataType
	RepublishCount                     *ServiceCounterDataType
	TransferSubscriptionsCount         *ServiceCounterDataType
	DeleteSubscriptionsCount           *ServiceCounterDataType
	AddNodesCount                      *ServiceCounterDataType
	AddReferencesCount                 *ServiceCounterDataType
	DeleteNodesCount                   *ServiceCounterDataType
	DeleteReferencesCount              *ServiceCounterDataType
	BrowseCount                        *ServiceCounterDataType
	BrowseNextCount                    *ServiceCounterDataType
	TranslateBrowsePathsToNodeIDsCount *ServiceCounterDataType
	QueryFirstCount                    *ServiceCounterDataType
	QueryNextCount                     *ServiceCounterDataType
	RegisterNodesCount                 *ServiceCounterDataType
	UnregisterNodesCount               *ServiceCounterDataType
}

type SessionSecurityDiagnosticsDataType struct {
	SessionID               *NodeID
	ClientUserIDOfSession   string
	ClientUserIDHistory     []string
	AuthenticationMechanism string
	Encoding                string
	TransportProtocol       string
	SecurityMode            MessageSecurityMode
	SecurityPolicyURI       string
	ClientCertificate       []byte
}

type ServiceCounterDataType struct {
	TotalCount uint32
	ErrorCount uint32
}

type StatusResult struct {
	StatusCode     StatusCode
	DiagnosticInfo *DiagnosticInfo
}

type SubscriptionDiagnosticsDataType struct {
	SessionID                    *NodeID
	SubscriptionID               uint32
	Priority                     uint8
	PublishingInterval           float64
	MaxKeepAliveCount            uint32
	MaxLifetimeCount             uint32
	MaxNotificationsPerPublish   uint32
	PublishingEnabled            bool
	ModifyCount                  uint32
	EnableCount                  uint32
	DisableCount                 uint32
	RepublishRequestCount        uint32
	RepublishMessageRequestCount uint32
	RepublishMessageCount        uint32
	TransferRequestCount         uint32
	TransferredToAltClientCount  uint32
	TransferredToSameClientCount uint32
	PublishRequestCount          uint32
	DataChangeNotificationsCount uint32
	EventNotificationsCount      uint32
	NotificationsCount           uint32
	LatePublishRequestCount      uint32
	CurrentKeepAliveCount        uint32
	CurrentLifetimeCount         uint32
	UnacknowledgedMessageCount   uint32
	DiscardedMessageCount        uint32
	MonitoredItemCount           uint32
	DisabledMonitoredItemCount   uint32
	MonitoringQueueOverflowCount uint32
	NextSequenceNumber           uint32
	EventQueueOverFlowCount      uint32
}

type ModelChangeStructureDataType struct {
	Affected     *NodeID
	AffectedType *NodeID
	Verb         uint8
}

type SemanticChangeStructureDataType struct {
	Affected     *NodeID
	AffectedType *NodeID
}

type Range struct {
	Low  float64
	High float64
}

type EUInformation struct {
	NamespaceURI string
	UnitID       int32
	DisplayName  *LocalizedText
	Description  *LocalizedText
}

type ComplexNumberType struct {
	Real      float32
	Imaginary float32
}

type DoubleComplexNumberType struct {
	Real      float64
	Imaginary float64
}

type AxisInformation struct {
	EngineeringUnits *EUInformation
	EURange          *Range
	Title            *LocalizedText
	AxisScaleType    AxisScaleEnumeration
	AxisSteps        []float64
}

type XVType struct {
	X     float64
	Value float32
}

type ProgramDiagnosticDataType struct {
	CreateSessionID           *NodeID
	CreateClientName          string
	InvocationCreationTime    time.Time
	LastTransitionTime        time.Time
	LastMethodCall            string
	LastMethodSessionID       *NodeID
	LastMethodInputArguments  []*Argument
	LastMethodOutputArguments []*Argument
	LastMethodCallTime        time.Time
	LastMethodReturnStatus    *StatusResult
}

type ProgramDiagnostic2DataType struct {
	CreateSessionID           *NodeID
	CreateClientName          string
	InvocationCreationTime    time.Time
	LastTransitionTime        time.Time
	LastMethodCall            string
	LastMethodSessionID       *NodeID
	LastMethodInputArguments  []*Argument
	LastMethodOutputArguments []*Argument
	LastMethodInputValues     []*Variant
	LastMethodOutputValues    []*Variant
	LastMethodCallTime        time.Time
	LastMethodReturnStatus    StatusCode
}

type Annotation struct {
	Message        string
	UserName       string
	AnnotationTime time.Time
}
