// Prevent go install ./... from complaining about different packages in the same dir.
// +build

package main

import (
	"bytes"
	"encoding/gob"
	"encoding/hex"
)

// START OMIT
const data = "4dffb503010102303001ff30000109010130010800010130010800010130" +
	"01ffb80001014a01ffb60001014b01ff860001013001ff860001013001ff" +
	"860001013001ff860001013001ffb80000001eff850401010e3030303030" +
	"30303030303030303001ff3000010c0104000016ffb70201010830303030" +
	"3030303001ff3000010c000030ffb6040405fcff00303030303030303030" +
	"303030303030303030303030303030303030303030303030303030303030" +
	"303030303030303030303030303030303030303030303030303030303030" +
	"30303030303030"

type X struct {
	J *X
	K map[string]int
}

func main() {
	raw, _ := hex.DecodeString(data)
	gob.NewDecoder(bytes.NewReader(raw)).Decode(new(X))
}

// END OMIT
