// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opCloneReceiptRuleSet = "CloneReceiptRuleSet"

// CloneReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the CloneReceiptRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CloneReceiptRuleSet for more information on using the CloneReceiptRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CloneReceiptRuleSetRequest method.
//	req, resp := client.CloneReceiptRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet
func (c *SES) CloneReceiptRuleSetRequest(input *CloneReceiptRuleSetInput) (req *request.Request, output *CloneReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opCloneReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloneReceiptRuleSetInput{}
	}

	output = &CloneReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CloneReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Creates a receipt rule set by cloning an existing one. All receipt rules
// and configurations are copied to the new receipt rule set and are completely
// independent of the source rule set.
//
// For information about setting up rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CloneReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
//   - ErrCodeAlreadyExistsException "AlreadyExists"
//     Indicates that a resource could not be created because of a naming conflict.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet
func (c *SES) CloneReceiptRuleSet(input *CloneReceiptRuleSetInput) (*CloneReceiptRuleSetOutput, error) {
	req, out := c.CloneReceiptRuleSetRequest(input)
	return out, req.Send()
}

// CloneReceiptRuleSetWithContext is the same as CloneReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See CloneReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CloneReceiptRuleSetWithContext(ctx aws.Context, input *CloneReceiptRuleSetInput, opts ...request.Option) (*CloneReceiptRuleSetOutput, error) {
	req, out := c.CloneReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSet = "CreateConfigurationSet"

// CreateConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSet for more information on using the CreateConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfigurationSetRequest method.
//	req, resp := client.CreateConfigurationSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet
func (c *SES) CreateConfigurationSetRequest(input *CreateConfigurationSetInput) (req *request.Request, output *CreateConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationSetInput{}
	}

	output = &CreateConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSet API operation for Amazon Simple Email Service.
//
// Creates a configuration set.
//
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateConfigurationSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetAlreadyExistsException "ConfigurationSetAlreadyExists"
//     Indicates that the configuration set could not be created because of a naming
//     conflict.
//
//   - ErrCodeInvalidConfigurationSetException "InvalidConfigurationSet"
//     Indicates that the configuration set is invalid. See the error message for
//     details.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet
func (c *SES) CreateConfigurationSet(input *CreateConfigurationSetInput) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetWithContext is the same as CreateConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateConfigurationSetWithContext(ctx aws.Context, input *CreateConfigurationSetInput, opts ...request.Option) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSetEventDestination = "CreateConfigurationSetEventDestination"

// CreateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSetEventDestination for more information on using the CreateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfigurationSetEventDestinationRequest method.
//	req, resp := client.CreateConfigurationSetEventDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination
func (c *SES) CreateConfigurationSetEventDestinationRequest(input *CreateConfigurationSetEventDestinationInput) (req *request.Request, output *CreateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationSetEventDestinationInput{}
	}

	output = &CreateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Creates a configuration set event destination.
//
// When you create or update an event destination, you must provide one, and
// only one, destination. The destination can be CloudWatch, Amazon Kinesis
// Firehose, or Amazon Simple Notification Service (Amazon SNS).
//
// An event destination is the Amazon Web Services service to which Amazon SES
// publishes the email sending events associated with a configuration set. For
// information about using configuration sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeEventDestinationAlreadyExistsException "EventDestinationAlreadyExists"
//     Indicates that the event destination could not be created because of a naming
//     conflict.
//
//   - ErrCodeInvalidCloudWatchDestinationException "InvalidCloudWatchDestination"
//     Indicates that the Amazon CloudWatch destination is invalid. See the error
//     message for details.
//
//   - ErrCodeInvalidFirehoseDestinationException "InvalidFirehoseDestination"
//     Indicates that the Amazon Kinesis Firehose destination is invalid. See the
//     error message for details.
//
//   - ErrCodeInvalidSNSDestinationException "InvalidSNSDestination"
//     Indicates that the Amazon Simple Notification Service (Amazon SNS) destination
//     is invalid. See the error message for details.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination
func (c *SES) CreateConfigurationSetEventDestination(input *CreateConfigurationSetEventDestinationInput) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetEventDestinationWithContext is the same as CreateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *CreateConfigurationSetEventDestinationInput, opts ...request.Option) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSetTrackingOptions = "CreateConfigurationSetTrackingOptions"

// CreateConfigurationSetTrackingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSetTrackingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSetTrackingOptions for more information on using the CreateConfigurationSetTrackingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfigurationSetTrackingOptionsRequest method.
//	req, resp := client.CreateConfigurationSetTrackingOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetTrackingOptions
func (c *SES) CreateConfigurationSetTrackingOptionsRequest(input *CreateConfigurationSetTrackingOptionsInput) (req *request.Request, output *CreateConfigurationSetTrackingOptionsOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSetTrackingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationSetTrackingOptionsInput{}
	}

	output = &CreateConfigurationSetTrackingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSetTrackingOptions API operation for Amazon Simple Email Service.
//
// Creates an association between a configuration set and a custom domain for
// open and click event tracking.
//
// By default, images and links used for tracking open and click events are
// hosted on domains operated by Amazon SES. You can configure a subdomain of
// your own to handle these events. For information about using custom domains,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateConfigurationSetTrackingOptions for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeTrackingOptionsAlreadyExistsException "TrackingOptionsAlreadyExistsException"
//     Indicates that the configuration set you specified already contains a TrackingOptions
//     object.
//
//   - ErrCodeInvalidTrackingOptionsException "InvalidTrackingOptions"
//     Indicates that the custom domain to be used for open and click tracking redirects
//     is invalid. This error appears most often in the following situations:
//
//   - When the tracking domain you specified is not verified in Amazon SES.
//
//   - When the tracking domain you specified is not a valid domain or subdomain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetTrackingOptions
func (c *SES) CreateConfigurationSetTrackingOptions(input *CreateConfigurationSetTrackingOptionsInput) (*CreateConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.CreateConfigurationSetTrackingOptionsRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetTrackingOptionsWithContext is the same as CreateConfigurationSetTrackingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSetTrackingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateConfigurationSetTrackingOptionsWithContext(ctx aws.Context, input *CreateConfigurationSetTrackingOptionsInput, opts ...request.Option) (*CreateConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.CreateConfigurationSetTrackingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomVerificationEmailTemplate = "CreateCustomVerificationEmailTemplate"

// CreateCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomVerificationEmailTemplate for more information on using the CreateCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomVerificationEmailTemplateRequest method.
//	req, resp := client.CreateCustomVerificationEmailTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateCustomVerificationEmailTemplate
func (c *SES) CreateCustomVerificationEmailTemplateRequest(input *CreateCustomVerificationEmailTemplateInput) (req *request.Request, output *CreateCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateCustomVerificationEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomVerificationEmailTemplateInput{}
	}

	output = &CreateCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Creates a new custom verification email template.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateCustomVerificationEmailTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCustomVerificationEmailTemplateAlreadyExistsException "CustomVerificationEmailTemplateAlreadyExists"
//     Indicates that a custom verification email template with the name you specified
//     already exists.
//
//   - ErrCodeFromEmailAddressNotVerifiedException "FromEmailAddressNotVerified"
//     Indicates that the sender address specified for a custom verification email
//     is not verified, and is therefore not eligible to send the custom verification
//     email.
//
//   - ErrCodeCustomVerificationEmailInvalidContentException "CustomVerificationEmailInvalidContent"
//     Indicates that custom verification email template provided content is invalid.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateCustomVerificationEmailTemplate
func (c *SES) CreateCustomVerificationEmailTemplate(input *CreateCustomVerificationEmailTemplateInput) (*CreateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.CreateCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// CreateCustomVerificationEmailTemplateWithContext is the same as CreateCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *CreateCustomVerificationEmailTemplateInput, opts ...request.Option) (*CreateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.CreateCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReceiptFilter = "CreateReceiptFilter"

// CreateReceiptFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateReceiptFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReceiptFilter for more information on using the CreateReceiptFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReceiptFilterRequest method.
//	req, resp := client.CreateReceiptFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter
func (c *SES) CreateReceiptFilterRequest(input *CreateReceiptFilterInput) (req *request.Request, output *CreateReceiptFilterOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptFilterInput{}
	}

	output = &CreateReceiptFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateReceiptFilter API operation for Amazon Simple Email Service.
//
// Creates a new IP address filter.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateReceiptFilter for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
//   - ErrCodeAlreadyExistsException "AlreadyExists"
//     Indicates that a resource could not be created because of a naming conflict.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter
func (c *SES) CreateReceiptFilter(input *CreateReceiptFilterInput) (*CreateReceiptFilterOutput, error) {
	req, out := c.CreateReceiptFilterRequest(input)
	return out, req.Send()
}

// CreateReceiptFilterWithContext is the same as CreateReceiptFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReceiptFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateReceiptFilterWithContext(ctx aws.Context, input *CreateReceiptFilterInput, opts ...request.Option) (*CreateReceiptFilterOutput, error) {
	req, out := c.CreateReceiptFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReceiptRule = "CreateReceiptRule"

// CreateReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateReceiptRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReceiptRule for more information on using the CreateReceiptRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReceiptRuleRequest method.
//	req, resp := client.CreateReceiptRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule
func (c *SES) CreateReceiptRuleRequest(input *CreateReceiptRuleInput) (req *request.Request, output *CreateReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptRuleInput{}
	}

	output = &CreateReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateReceiptRule API operation for Amazon Simple Email Service.
//
// Creates a receipt rule.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateReceiptRule for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidSnsTopicException "InvalidSnsTopic"
//     Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
//     could not publish to the topic, possibly due to permissions issues. For information
//     about giving permissions, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   - ErrCodeInvalidS3ConfigurationException "InvalidS3Configuration"
//     Indicates that the provided Amazon S3 bucket or Amazon Web Services KMS encryption
//     key is invalid, or that Amazon SES could not publish to the bucket, possibly
//     due to permissions issues. For information about giving permissions, see
//     the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   - ErrCodeInvalidLambdaFunctionException "InvalidLambdaFunction"
//     Indicates that the provided Amazon Web Services Lambda function is invalid,
//     or that Amazon SES could not execute the provided function, possibly due
//     to permissions issues. For information about giving permissions, see the
//     Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   - ErrCodeAlreadyExistsException "AlreadyExists"
//     Indicates that a resource could not be created because of a naming conflict.
//
//   - ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//     Indicates that the provided receipt rule does not exist.
//
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule
func (c *SES) CreateReceiptRule(input *CreateReceiptRuleInput) (*CreateReceiptRuleOutput, error) {
	req, out := c.CreateReceiptRuleRequest(input)
	return out, req.Send()
}

// CreateReceiptRuleWithContext is the same as CreateReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateReceiptRuleWithContext(ctx aws.Context, input *CreateReceiptRuleInput, opts ...request.Option) (*CreateReceiptRuleOutput, error) {
	req, out := c.CreateReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReceiptRuleSet = "CreateReceiptRuleSet"

// CreateReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateReceiptRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReceiptRuleSet for more information on using the CreateReceiptRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReceiptRuleSetRequest method.
//	req, resp := client.CreateReceiptRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet
func (c *SES) CreateReceiptRuleSetRequest(input *CreateReceiptRuleSetInput) (req *request.Request, output *CreateReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptRuleSetInput{}
	}

	output = &CreateReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Creates an empty receipt rule set.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeAlreadyExistsException "AlreadyExists"
//     Indicates that a resource could not be created because of a naming conflict.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet
func (c *SES) CreateReceiptRuleSet(input *CreateReceiptRuleSetInput) (*CreateReceiptRuleSetOutput, error) {
	req, out := c.CreateReceiptRuleSetRequest(input)
	return out, req.Send()
}

// CreateReceiptRuleSetWithContext is the same as CreateReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateReceiptRuleSetWithContext(ctx aws.Context, input *CreateReceiptRuleSetInput, opts ...request.Option) (*CreateReceiptRuleSetOutput, error) {
	req, out := c.CreateReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateRequest method.
//	req, resp := client.CreateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateTemplate
func (c *SES) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTemplate API operation for Amazon Simple Email Service.
//
// Creates an email template. Email templates enable you to send personalized
// email to one or more destinations in a single operation. For more information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeAlreadyExistsException "AlreadyExists"
//     Indicates that a resource could not be created because of a naming conflict.
//
//   - ErrCodeInvalidTemplateException "InvalidTemplate"
//     Indicates that the template that you specified could not be rendered. This
//     issue may occur when a template refers to a partial that does not exist.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateTemplate
func (c *SES) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSet = "DeleteConfigurationSet"

// DeleteConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSet for more information on using the DeleteConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfigurationSetRequest method.
//	req, resp := client.DeleteConfigurationSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet
func (c *SES) DeleteConfigurationSetRequest(input *DeleteConfigurationSetInput) (req *request.Request, output *DeleteConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationSetInput{}
	}

	output = &DeleteConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSet API operation for Amazon Simple Email Service.
//
// Deletes a configuration set. Configuration sets enable you to publish email
// sending events. For information about using configuration sets, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteConfigurationSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet
func (c *SES) DeleteConfigurationSet(input *DeleteConfigurationSetInput) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetWithContext is the same as DeleteConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteConfigurationSetWithContext(ctx aws.Context, input *DeleteConfigurationSetInput, opts ...request.Option) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSetEventDestination = "DeleteConfigurationSetEventDestination"

// DeleteConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSetEventDestination for more information on using the DeleteConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfigurationSetEventDestinationRequest method.
//	req, resp := client.DeleteConfigurationSetEventDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination
func (c *SES) DeleteConfigurationSetEventDestinationRequest(input *DeleteConfigurationSetEventDestinationInput) (req *request.Request, output *DeleteConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationSetEventDestinationInput{}
	}

	output = &DeleteConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Deletes a configuration set event destination. Configuration set event destinations
// are associated with configuration sets, which enable you to publish email
// sending events. For information about using configuration sets, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteConfigurationSetEventDestination for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeEventDestinationDoesNotExistException "EventDestinationDoesNotExist"
//     Indicates that the event destination does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination
func (c *SES) DeleteConfigurationSetEventDestination(input *DeleteConfigurationSetEventDestinationInput) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetEventDestinationWithContext is the same as DeleteConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteConfigurationSetEventDestinationWithContext(ctx aws.Context, input *DeleteConfigurationSetEventDestinationInput, opts ...request.Option) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSetTrackingOptions = "DeleteConfigurationSetTrackingOptions"

// DeleteConfigurationSetTrackingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSetTrackingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSetTrackingOptions for more information on using the DeleteConfigurationSetTrackingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfigurationSetTrackingOptionsRequest method.
//	req, resp := client.DeleteConfigurationSetTrackingOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetTrackingOptions
func (c *SES) DeleteConfigurationSetTrackingOptionsRequest(input *DeleteConfigurationSetTrackingOptionsInput) (req *request.Request, output *DeleteConfigurationSetTrackingOptionsOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSetTrackingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationSetTrackingOptionsInput{}
	}

	output = &DeleteConfigurationSetTrackingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSetTrackingOptions API operation for Amazon Simple Email Service.
//
// Deletes an association between a configuration set and a custom domain for
// open and click event tracking.
//
// By default, images and links used for tracking open and click events are
// hosted on domains operated by Amazon SES. You can configure a subdomain of
// your own to handle these events. For information about using custom domains,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
//
// Deleting this kind of association results in emails sent using the specified
// configuration set to capture open and click events using the standard, Amazon
// SES-operated domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteConfigurationSetTrackingOptions for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeTrackingOptionsDoesNotExistException "TrackingOptionsDoesNotExistException"
//     Indicates that the TrackingOptions object you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetTrackingOptions
func (c *SES) DeleteConfigurationSetTrackingOptions(input *DeleteConfigurationSetTrackingOptionsInput) (*DeleteConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.DeleteConfigurationSetTrackingOptionsRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetTrackingOptionsWithContext is the same as DeleteConfigurationSetTrackingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSetTrackingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteConfigurationSetTrackingOptionsWithContext(ctx aws.Context, input *DeleteConfigurationSetTrackingOptionsInput, opts ...request.Option) (*DeleteConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.DeleteConfigurationSetTrackingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomVerificationEmailTemplate = "DeleteCustomVerificationEmailTemplate"

// DeleteCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomVerificationEmailTemplate for more information on using the DeleteCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomVerificationEmailTemplateRequest method.
//	req, resp := client.DeleteCustomVerificationEmailTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteCustomVerificationEmailTemplate
func (c *SES) DeleteCustomVerificationEmailTemplateRequest(input *DeleteCustomVerificationEmailTemplateInput) (req *request.Request, output *DeleteCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomVerificationEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomVerificationEmailTemplateInput{}
	}

	output = &DeleteCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Deletes an existing custom verification email template.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteCustomVerificationEmailTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteCustomVerificationEmailTemplate
func (c *SES) DeleteCustomVerificationEmailTemplate(input *DeleteCustomVerificationEmailTemplateInput) (*DeleteCustomVerificationEmailTemplateOutput, error) {
	req, out := c.DeleteCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// DeleteCustomVerificationEmailTemplateWithContext is the same as DeleteCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *DeleteCustomVerificationEmailTemplateInput, opts ...request.Option) (*DeleteCustomVerificationEmailTemplateOutput, error) {
	req, out := c.DeleteCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentity = "DeleteIdentity"

// DeleteIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentity for more information on using the DeleteIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdentityRequest method.
//	req, resp := client.DeleteIdentityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity
func (c *SES) DeleteIdentityRequest(input *DeleteIdentityInput) (req *request.Request, output *DeleteIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityInput{}
	}

	output = &DeleteIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdentity API operation for Amazon Simple Email Service.
//
// Deletes the specified identity (an email address or a domain) from the list
// of verified identities.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteIdentity for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity
func (c *SES) DeleteIdentity(input *DeleteIdentityInput) (*DeleteIdentityOutput, error) {
	req, out := c.DeleteIdentityRequest(input)
	return out, req.Send()
}

// DeleteIdentityWithContext is the same as DeleteIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteIdentityWithContext(ctx aws.Context, input *DeleteIdentityInput, opts ...request.Option) (*DeleteIdentityOutput, error) {
	req, out := c.DeleteIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentityPolicy = "DeleteIdentityPolicy"

// DeleteIdentityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentityPolicy for more information on using the DeleteIdentityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdentityPolicyRequest method.
//	req, resp := client.DeleteIdentityPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy
func (c *SES) DeleteIdentityPolicyRequest(input *DeleteIdentityPolicyInput) (req *request.Request, output *DeleteIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityPolicyInput{}
	}

	output = &DeleteIdentityPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdentityPolicy API operation for Amazon Simple Email Service.
//
// Deletes the specified sending authorization policy for the given identity
// (an email address or a domain). This operation returns successfully even
// if a policy with the specified name does not exist.
//
// This operation is for the identity owner only. If you have not verified the
// identity, it returns an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteIdentityPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy
func (c *SES) DeleteIdentityPolicy(input *DeleteIdentityPolicyInput) (*DeleteIdentityPolicyOutput, error) {
	req, out := c.DeleteIdentityPolicyRequest(input)
	return out, req.Send()
}

// DeleteIdentityPolicyWithContext is the same as DeleteIdentityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteIdentityPolicyWithContext(ctx aws.Context, input *DeleteIdentityPolicyInput, opts ...request.Option) (*DeleteIdentityPolicyOutput, error) {
	req, out := c.DeleteIdentityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReceiptFilter = "DeleteReceiptFilter"

// DeleteReceiptFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReceiptFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReceiptFilter for more information on using the DeleteReceiptFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReceiptFilterRequest method.
//	req, resp := client.DeleteReceiptFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter
func (c *SES) DeleteReceiptFilterRequest(input *DeleteReceiptFilterInput) (req *request.Request, output *DeleteReceiptFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptFilterInput{}
	}

	output = &DeleteReceiptFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReceiptFilter API operation for Amazon Simple Email Service.
//
// Deletes the specified IP address filter.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteReceiptFilter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter
func (c *SES) DeleteReceiptFilter(input *DeleteReceiptFilterInput) (*DeleteReceiptFilterOutput, error) {
	req, out := c.DeleteReceiptFilterRequest(input)
	return out, req.Send()
}

// DeleteReceiptFilterWithContext is the same as DeleteReceiptFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReceiptFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteReceiptFilterWithContext(ctx aws.Context, input *DeleteReceiptFilterInput, opts ...request.Option) (*DeleteReceiptFilterOutput, error) {
	req, out := c.DeleteReceiptFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReceiptRule = "DeleteReceiptRule"

// DeleteReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReceiptRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReceiptRule for more information on using the DeleteReceiptRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReceiptRuleRequest method.
//	req, resp := client.DeleteReceiptRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule
func (c *SES) DeleteReceiptRuleRequest(input *DeleteReceiptRuleInput) (req *request.Request, output *DeleteReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptRuleInput{}
	}

	output = &DeleteReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReceiptRule API operation for Amazon Simple Email Service.
//
// Deletes the specified receipt rule.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteReceiptRule for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule
func (c *SES) DeleteReceiptRule(input *DeleteReceiptRuleInput) (*DeleteReceiptRuleOutput, error) {
	req, out := c.DeleteReceiptRuleRequest(input)
	return out, req.Send()
}

// DeleteReceiptRuleWithContext is the same as DeleteReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteReceiptRuleWithContext(ctx aws.Context, input *DeleteReceiptRuleInput, opts ...request.Option) (*DeleteReceiptRuleOutput, error) {
	req, out := c.DeleteReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReceiptRuleSet = "DeleteReceiptRuleSet"

// DeleteReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReceiptRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReceiptRuleSet for more information on using the DeleteReceiptRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReceiptRuleSetRequest method.
//	req, resp := client.DeleteReceiptRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet
func (c *SES) DeleteReceiptRuleSetRequest(input *DeleteReceiptRuleSetInput) (req *request.Request, output *DeleteReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptRuleSetInput{}
	}

	output = &DeleteReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Deletes the specified receipt rule set and all of the receipt rules it contains.
//
// The currently active rule set cannot be deleted.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCannotDeleteException "CannotDelete"
//     Indicates that the delete operation could not be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet
func (c *SES) DeleteReceiptRuleSet(input *DeleteReceiptRuleSetInput) (*DeleteReceiptRuleSetOutput, error) {
	req, out := c.DeleteReceiptRuleSetRequest(input)
	return out, req.Send()
}

// DeleteReceiptRuleSetWithContext is the same as DeleteReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteReceiptRuleSetWithContext(ctx aws.Context, input *DeleteReceiptRuleSetInput, opts ...request.Option) (*DeleteReceiptRuleSetOutput, error) {
	req, out := c.DeleteReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplate for more information on using the DeleteTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateRequest method.
//	req, resp := client.DeleteTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteTemplate
func (c *SES) DeleteTemplateRequest(input *DeleteTemplateInput) (req *request.Request, output *DeleteTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	output = &DeleteTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTemplate API operation for Amazon Simple Email Service.
//
// Deletes an email template.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteTemplate
func (c *SES) DeleteTemplate(input *DeleteTemplateInput) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	return out, req.Send()
}

// DeleteTemplateWithContext is the same as DeleteTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteTemplateWithContext(ctx aws.Context, input *DeleteTemplateInput, opts ...request.Option) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVerifiedEmailAddress = "DeleteVerifiedEmailAddress"

// DeleteVerifiedEmailAddressRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVerifiedEmailAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVerifiedEmailAddress for more information on using the DeleteVerifiedEmailAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVerifiedEmailAddressRequest method.
//	req, resp := client.DeleteVerifiedEmailAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress
func (c *SES) DeleteVerifiedEmailAddressRequest(input *DeleteVerifiedEmailAddressInput) (req *request.Request, output *DeleteVerifiedEmailAddressOutput) {
	op := &request.Operation{
		Name:       opDeleteVerifiedEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedEmailAddressInput{}
	}

	output = &DeleteVerifiedEmailAddressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVerifiedEmailAddress API operation for Amazon Simple Email Service.
//
// Deprecated. Use the DeleteIdentity operation to delete email addresses and
// domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteVerifiedEmailAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress
func (c *SES) DeleteVerifiedEmailAddress(input *DeleteVerifiedEmailAddressInput) (*DeleteVerifiedEmailAddressOutput, error) {
	req, out := c.DeleteVerifiedEmailAddressRequest(input)
	return out, req.Send()
}

// DeleteVerifiedEmailAddressWithContext is the same as DeleteVerifiedEmailAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVerifiedEmailAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteVerifiedEmailAddressWithContext(ctx aws.Context, input *DeleteVerifiedEmailAddressInput, opts ...request.Option) (*DeleteVerifiedEmailAddressOutput, error) {
	req, out := c.DeleteVerifiedEmailAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActiveReceiptRuleSet = "DescribeActiveReceiptRuleSet"

// DescribeActiveReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActiveReceiptRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActiveReceiptRuleSet for more information on using the DescribeActiveReceiptRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeActiveReceiptRuleSetRequest method.
//	req, resp := client.DescribeActiveReceiptRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet
func (c *SES) DescribeActiveReceiptRuleSetRequest(input *DescribeActiveReceiptRuleSetInput) (req *request.Request, output *DescribeActiveReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDescribeActiveReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActiveReceiptRuleSetInput{}
	}

	output = &DescribeActiveReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActiveReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Returns the metadata and receipt rules for the receipt rule set that is currently
// active.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeActiveReceiptRuleSet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet
func (c *SES) DescribeActiveReceiptRuleSet(input *DescribeActiveReceiptRuleSetInput) (*DescribeActiveReceiptRuleSetOutput, error) {
	req, out := c.DescribeActiveReceiptRuleSetRequest(input)
	return out, req.Send()
}

// DescribeActiveReceiptRuleSetWithContext is the same as DescribeActiveReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActiveReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeActiveReceiptRuleSetWithContext(ctx aws.Context, input *DescribeActiveReceiptRuleSetInput, opts ...request.Option) (*DescribeActiveReceiptRuleSetOutput, error) {
	req, out := c.DescribeActiveReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationSet = "DescribeConfigurationSet"

// DescribeConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationSet for more information on using the DescribeConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConfigurationSetRequest method.
//	req, resp := client.DescribeConfigurationSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet
func (c *SES) DescribeConfigurationSetRequest(input *DescribeConfigurationSetInput) (req *request.Request, output *DescribeConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationSetInput{}
	}

	output = &DescribeConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationSet API operation for Amazon Simple Email Service.
//
// Returns the details of the specified configuration set. For information about
// using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeConfigurationSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet
func (c *SES) DescribeConfigurationSet(input *DescribeConfigurationSetInput) (*DescribeConfigurationSetOutput, error) {
	req, out := c.DescribeConfigurationSetRequest(input)
	return out, req.Send()
}

// DescribeConfigurationSetWithContext is the same as DescribeConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeConfigurationSetWithContext(ctx aws.Context, input *DescribeConfigurationSetInput, opts ...request.Option) (*DescribeConfigurationSetOutput, error) {
	req, out := c.DescribeConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReceiptRule = "DescribeReceiptRule"

// DescribeReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReceiptRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReceiptRule for more information on using the DescribeReceiptRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReceiptRuleRequest method.
//	req, resp := client.DescribeReceiptRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule
func (c *SES) DescribeReceiptRuleRequest(input *DescribeReceiptRuleInput) (req *request.Request, output *DescribeReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleInput{}
	}

	output = &DescribeReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReceiptRule API operation for Amazon Simple Email Service.
//
// Returns the details of the specified receipt rule.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeReceiptRule for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//     Indicates that the provided receipt rule does not exist.
//
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule
func (c *SES) DescribeReceiptRule(input *DescribeReceiptRuleInput) (*DescribeReceiptRuleOutput, error) {
	req, out := c.DescribeReceiptRuleRequest(input)
	return out, req.Send()
}

// DescribeReceiptRuleWithContext is the same as DescribeReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeReceiptRuleWithContext(ctx aws.Context, input *DescribeReceiptRuleInput, opts ...request.Option) (*DescribeReceiptRuleOutput, error) {
	req, out := c.DescribeReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReceiptRuleSet = "DescribeReceiptRuleSet"

// DescribeReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReceiptRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReceiptRuleSet for more information on using the DescribeReceiptRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReceiptRuleSetRequest method.
//	req, resp := client.DescribeReceiptRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet
func (c *SES) DescribeReceiptRuleSetRequest(input *DescribeReceiptRuleSetInput) (req *request.Request, output *DescribeReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDescribeReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleSetInput{}
	}

	output = &DescribeReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Returns the details of the specified receipt rule set.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet
func (c *SES) DescribeReceiptRuleSet(input *DescribeReceiptRuleSetInput) (*DescribeReceiptRuleSetOutput, error) {
	req, out := c.DescribeReceiptRuleSetRequest(input)
	return out, req.Send()
}

// DescribeReceiptRuleSetWithContext is the same as DescribeReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeReceiptRuleSetWithContext(ctx aws.Context, input *DescribeReceiptRuleSetInput, opts ...request.Option) (*DescribeReceiptRuleSetOutput, error) {
	req, out := c.DescribeReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSendingEnabled = "GetAccountSendingEnabled"

// GetAccountSendingEnabledRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSendingEnabled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSendingEnabled for more information on using the GetAccountSendingEnabled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountSendingEnabledRequest method.
//	req, resp := client.GetAccountSendingEnabledRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled
func (c *SES) GetAccountSendingEnabledRequest(input *GetAccountSendingEnabledInput) (req *request.Request, output *GetAccountSendingEnabledOutput) {
	op := &request.Operation{
		Name:       opGetAccountSendingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSendingEnabledInput{}
	}

	output = &GetAccountSendingEnabledOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSendingEnabled API operation for Amazon Simple Email Service.
//
// Returns the email sending status of the Amazon SES account for the current
// Region.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetAccountSendingEnabled for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled
func (c *SES) GetAccountSendingEnabled(input *GetAccountSendingEnabledInput) (*GetAccountSendingEnabledOutput, error) {
	req, out := c.GetAccountSendingEnabledRequest(input)
	return out, req.Send()
}

// GetAccountSendingEnabledWithContext is the same as GetAccountSendingEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSendingEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetAccountSendingEnabledWithContext(ctx aws.Context, input *GetAccountSendingEnabledInput, opts ...request.Option) (*GetAccountSendingEnabledOutput, error) {
	req, out := c.GetAccountSendingEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCustomVerificationEmailTemplate = "GetCustomVerificationEmailTemplate"

// GetCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCustomVerificationEmailTemplate for more information on using the GetCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCustomVerificationEmailTemplateRequest method.
//	req, resp := client.GetCustomVerificationEmailTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplate
func (c *SES) GetCustomVerificationEmailTemplateRequest(input *GetCustomVerificationEmailTemplateInput) (req *request.Request, output *GetCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opGetCustomVerificationEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCustomVerificationEmailTemplateInput{}
	}

	output = &GetCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Returns the custom email verification template for the template name you
// specify.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetCustomVerificationEmailTemplate for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeCustomVerificationEmailTemplateDoesNotExistException "CustomVerificationEmailTemplateDoesNotExist"
//     Indicates that a custom verification email template with the name you specified
//     does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplate
func (c *SES) GetCustomVerificationEmailTemplate(input *GetCustomVerificationEmailTemplateInput) (*GetCustomVerificationEmailTemplateOutput, error) {
	req, out := c.GetCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// GetCustomVerificationEmailTemplateWithContext is the same as GetCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *GetCustomVerificationEmailTemplateInput, opts ...request.Option) (*GetCustomVerificationEmailTemplateOutput, error) {
	req, out := c.GetCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityDkimAttributes = "GetIdentityDkimAttributes"

// GetIdentityDkimAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityDkimAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityDkimAttributes for more information on using the GetIdentityDkimAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityDkimAttributesRequest method.
//	req, resp := client.GetIdentityDkimAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes
func (c *SES) GetIdentityDkimAttributesRequest(input *GetIdentityDkimAttributesInput) (req *request.Request, output *GetIdentityDkimAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityDkimAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityDkimAttributesInput{}
	}

	output = &GetIdentityDkimAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityDkimAttributes API operation for Amazon Simple Email Service.
//
// Returns the current status of Easy DKIM signing for an entity. For domain
// name identities, this operation also returns the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES has successfully verified that
// these tokens have been published.
//
// This operation takes a list of identities as input and returns the following
// information for each:
//
//   - Whether Easy DKIM signing is enabled or disabled.
//
//   - A set of DKIM tokens that represent the identity. If the identity is
//     an email address, the tokens represent the domain of that address.
//
//   - Whether Amazon SES has successfully verified the DKIM tokens published
//     in the domain's DNS. This information is only returned for domain name
//     identities, not for email addresses.
//
// This operation is throttled at one request per second and can only get DKIM
// attributes for up to 100 identities at a time.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy-managing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityDkimAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes
func (c *SES) GetIdentityDkimAttributes(input *GetIdentityDkimAttributesInput) (*GetIdentityDkimAttributesOutput, error) {
	req, out := c.GetIdentityDkimAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityDkimAttributesWithContext is the same as GetIdentityDkimAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityDkimAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityDkimAttributesWithContext(ctx aws.Context, input *GetIdentityDkimAttributesInput, opts ...request.Option) (*GetIdentityDkimAttributesOutput, error) {
	req, out := c.GetIdentityDkimAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityMailFromDomainAttributes = "GetIdentityMailFromDomainAttributes"

// GetIdentityMailFromDomainAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityMailFromDomainAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityMailFromDomainAttributes for more information on using the GetIdentityMailFromDomainAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityMailFromDomainAttributesRequest method.
//	req, resp := client.GetIdentityMailFromDomainAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes
func (c *SES) GetIdentityMailFromDomainAttributesRequest(input *GetIdentityMailFromDomainAttributesInput) (req *request.Request, output *GetIdentityMailFromDomainAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityMailFromDomainAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityMailFromDomainAttributesInput{}
	}

	output = &GetIdentityMailFromDomainAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityMailFromDomainAttributes API operation for Amazon Simple Email Service.
//
// Returns the custom MAIL FROM attributes for a list of identities (email addresses
// : domains).
//
// This operation is throttled at one request per second and can only get custom
// MAIL FROM attributes for up to 100 identities at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityMailFromDomainAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes
func (c *SES) GetIdentityMailFromDomainAttributes(input *GetIdentityMailFromDomainAttributesInput) (*GetIdentityMailFromDomainAttributesOutput, error) {
	req, out := c.GetIdentityMailFromDomainAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityMailFromDomainAttributesWithContext is the same as GetIdentityMailFromDomainAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityMailFromDomainAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityMailFromDomainAttributesWithContext(ctx aws.Context, input *GetIdentityMailFromDomainAttributesInput, opts ...request.Option) (*GetIdentityMailFromDomainAttributesOutput, error) {
	req, out := c.GetIdentityMailFromDomainAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityNotificationAttributes = "GetIdentityNotificationAttributes"

// GetIdentityNotificationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityNotificationAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityNotificationAttributes for more information on using the GetIdentityNotificationAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityNotificationAttributesRequest method.
//	req, resp := client.GetIdentityNotificationAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes
func (c *SES) GetIdentityNotificationAttributesRequest(input *GetIdentityNotificationAttributesInput) (req *request.Request, output *GetIdentityNotificationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityNotificationAttributesInput{}
	}

	output = &GetIdentityNotificationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityNotificationAttributes API operation for Amazon Simple Email Service.
//
// Given a list of verified identities (email addresses and/or domains), returns
// a structure describing identity notification attributes.
//
// This operation is throttled at one request per second and can only get notification
// attributes for up to 100 identities at a time.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityNotificationAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes
func (c *SES) GetIdentityNotificationAttributes(input *GetIdentityNotificationAttributesInput) (*GetIdentityNotificationAttributesOutput, error) {
	req, out := c.GetIdentityNotificationAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityNotificationAttributesWithContext is the same as GetIdentityNotificationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityNotificationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityNotificationAttributesWithContext(ctx aws.Context, input *GetIdentityNotificationAttributesInput, opts ...request.Option) (*GetIdentityNotificationAttributesOutput, error) {
	req, out := c.GetIdentityNotificationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityPolicies = "GetIdentityPolicies"

// GetIdentityPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityPolicies for more information on using the GetIdentityPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityPoliciesRequest method.
//	req, resp := client.GetIdentityPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies
func (c *SES) GetIdentityPoliciesRequest(input *GetIdentityPoliciesInput) (req *request.Request, output *GetIdentityPoliciesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityPoliciesInput{}
	}

	output = &GetIdentityPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityPolicies API operation for Amazon Simple Email Service.
//
// Returns the requested sending authorization policies for the given identity
// (an email address or a domain). The policies are returned as a map of policy
// names to policy contents. You can retrieve a maximum of 20 policies at a
// time.
//
// This operation is for the identity owner only. If you have not verified the
// identity, it returns an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityPolicies for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies
func (c *SES) GetIdentityPolicies(input *GetIdentityPoliciesInput) (*GetIdentityPoliciesOutput, error) {
	req, out := c.GetIdentityPoliciesRequest(input)
	return out, req.Send()
}

// GetIdentityPoliciesWithContext is the same as GetIdentityPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityPoliciesWithContext(ctx aws.Context, input *GetIdentityPoliciesInput, opts ...request.Option) (*GetIdentityPoliciesOutput, error) {
	req, out := c.GetIdentityPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityVerificationAttributes = "GetIdentityVerificationAttributes"

// GetIdentityVerificationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityVerificationAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityVerificationAttributes for more information on using the GetIdentityVerificationAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdentityVerificationAttributesRequest method.
//	req, resp := client.GetIdentityVerificationAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes
func (c *SES) GetIdentityVerificationAttributesRequest(input *GetIdentityVerificationAttributesInput) (req *request.Request, output *GetIdentityVerificationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityVerificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityVerificationAttributesInput{}
	}

	output = &GetIdentityVerificationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityVerificationAttributes API operation for Amazon Simple Email Service.
//
// Given a list of identities (email addresses and/or domains), returns the
// verification status and (for domain identities) the verification token for
// each identity.
//
// The verification status of an email address is "Pending" until the email
// address owner clicks the link within the verification email that Amazon SES
// sent to that address. If the email address owner clicks the link within 24
// hours, the verification status of the email address changes to "Success".
// If the link is not clicked within 24 hours, the verification status changes
// to "Failed." In that case, to verify the email address, you must restart
// the verification process from the beginning.
//
// For domain identities, the domain's verification status is "Pending" as Amazon
// SES searches for the required TXT record in the DNS settings of the domain.
// When Amazon SES detects the record, the domain's verification status changes
// to "Success". If Amazon SES is unable to detect the record within 72 hours,
// the domain's verification status changes to "Failed." In that case, to verify
// the domain, you must restart the verification process from the beginning.
//
// This operation is throttled at one request per second and can only get verification
// attributes for up to 100 identities at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityVerificationAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes
func (c *SES) GetIdentityVerificationAttributes(input *GetIdentityVerificationAttributesInput) (*GetIdentityVerificationAttributesOutput, error) {
	req, out := c.GetIdentityVerificationAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityVerificationAttributesWithContext is the same as GetIdentityVerificationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityVerificationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityVerificationAttributesWithContext(ctx aws.Context, input *GetIdentityVerificationAttributesInput, opts ...request.Option) (*GetIdentityVerificationAttributesOutput, error) {
	req, out := c.GetIdentityVerificationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSendQuota = "GetSendQuota"

// GetSendQuotaRequest generates a "aws/request.Request" representing the
// client's request for the GetSendQuota operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSendQuota for more information on using the GetSendQuota
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSendQuotaRequest method.
//	req, resp := client.GetSendQuotaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota
func (c *SES) GetSendQuotaRequest(input *GetSendQuotaInput) (req *request.Request, output *GetSendQuotaOutput) {
	op := &request.Operation{
		Name:       opGetSendQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendQuotaInput{}
	}

	output = &GetSendQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSendQuota API operation for Amazon Simple Email Service.
//
// Provides the sending limits for the Amazon SES account.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetSendQuota for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota
func (c *SES) GetSendQuota(input *GetSendQuotaInput) (*GetSendQuotaOutput, error) {
	req, out := c.GetSendQuotaRequest(input)
	return out, req.Send()
}

// GetSendQuotaWithContext is the same as GetSendQuota with the addition of
// the ability to pass a context and additional request options.
//
// See GetSendQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetSendQuotaWithContext(ctx aws.Context, input *GetSendQuotaInput, opts ...request.Option) (*GetSendQuotaOutput, error) {
	req, out := c.GetSendQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSendStatistics = "GetSendStatistics"

// GetSendStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetSendStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSendStatistics for more information on using the GetSendStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSendStatisticsRequest method.
//	req, resp := client.GetSendStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics
func (c *SES) GetSendStatisticsRequest(input *GetSendStatisticsInput) (req *request.Request, output *GetSendStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetSendStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendStatisticsInput{}
	}

	output = &GetSendStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSendStatistics API operation for Amazon Simple Email Service.
//
// Provides sending statistics for the current Amazon Web Services Region. The
// result is a list of data points, representing the last two weeks of sending
// activity. Each data point in the list contains statistics for a 15-minute
// period of time.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetSendStatistics for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics
func (c *SES) GetSendStatistics(input *GetSendStatisticsInput) (*GetSendStatisticsOutput, error) {
	req, out := c.GetSendStatisticsRequest(input)
	return out, req.Send()
}

// GetSendStatisticsWithContext is the same as GetSendStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetSendStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetSendStatisticsWithContext(ctx aws.Context, input *GetSendStatisticsInput, opts ...request.Option) (*GetSendStatisticsOutput, error) {
	req, out := c.GetSendStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplate for more information on using the GetTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateRequest method.
//	req, resp := client.GetTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetTemplate
func (c *SES) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output = &GetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplate API operation for Amazon Simple Email Service.
//
// Displays the template object (which includes the Subject line, HTML part
// and text part) for the template you specify.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetTemplate for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeTemplateDoesNotExistException "TemplateDoesNotExist"
//     Indicates that the Template object you specified does not exist in your Amazon
//     SES account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetTemplate
func (c *SES) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	return out, req.Send()
}

// GetTemplateWithContext is the same as GetTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetTemplateWithContext(ctx aws.Context, input *GetTemplateInput, opts ...request.Option) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurationSets = "ListConfigurationSets"

// ListConfigurationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationSets for more information on using the ListConfigurationSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfigurationSetsRequest method.
//	req, resp := client.ListConfigurationSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets
func (c *SES) ListConfigurationSetsRequest(input *ListConfigurationSetsInput) (req *request.Request, output *ListConfigurationSetsOutput) {
	op := &request.Operation{
		Name:       opListConfigurationSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConfigurationSetsInput{}
	}

	output = &ListConfigurationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationSets API operation for Amazon Simple Email Service.
//
// Provides a list of the configuration sets associated with your Amazon SES
// account in the current Amazon Web Services Region. For information about
// using configuration sets, see Monitoring Your Amazon SES Sending Activity
// (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second. This operation
// returns up to 1,000 configuration sets each time it is run. If your Amazon
// SES account has more than 1,000 configuration sets, this operation also returns
// NextToken. You can then execute the ListConfigurationSets operation again,
// passing the NextToken parameter and the value of the NextToken element to
// retrieve additional results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListConfigurationSets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets
func (c *SES) ListConfigurationSets(input *ListConfigurationSetsInput) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	return out, req.Send()
}

// ListConfigurationSetsWithContext is the same as ListConfigurationSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListConfigurationSetsWithContext(ctx aws.Context, input *ListConfigurationSetsInput, opts ...request.Option) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCustomVerificationEmailTemplates = "ListCustomVerificationEmailTemplates"

// ListCustomVerificationEmailTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomVerificationEmailTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomVerificationEmailTemplates for more information on using the ListCustomVerificationEmailTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomVerificationEmailTemplatesRequest method.
//	req, resp := client.ListCustomVerificationEmailTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates
func (c *SES) ListCustomVerificationEmailTemplatesRequest(input *ListCustomVerificationEmailTemplatesInput) (req *request.Request, output *ListCustomVerificationEmailTemplatesOutput) {
	op := &request.Operation{
		Name:       opListCustomVerificationEmailTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomVerificationEmailTemplatesInput{}
	}

	output = &ListCustomVerificationEmailTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomVerificationEmailTemplates API operation for Amazon Simple Email Service.
//
// Lists the existing custom verification email templates for your account in
// the current Amazon Web Services Region.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListCustomVerificationEmailTemplates for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListCustomVerificationEmailTemplates
func (c *SES) ListCustomVerificationEmailTemplates(input *ListCustomVerificationEmailTemplatesInput) (*ListCustomVerificationEmailTemplatesOutput, error) {
	req, out := c.ListCustomVerificationEmailTemplatesRequest(input)
	return out, req.Send()
}

// ListCustomVerificationEmailTemplatesWithContext is the same as ListCustomVerificationEmailTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomVerificationEmailTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListCustomVerificationEmailTemplatesWithContext(ctx aws.Context, input *ListCustomVerificationEmailTemplatesInput, opts ...request.Option) (*ListCustomVerificationEmailTemplatesOutput, error) {
	req, out := c.ListCustomVerificationEmailTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomVerificationEmailTemplatesPages iterates over the pages of a ListCustomVerificationEmailTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomVerificationEmailTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomVerificationEmailTemplates operation.
//	pageNum := 0
//	err := client.ListCustomVerificationEmailTemplatesPages(params,
//	    func(page *ses.ListCustomVerificationEmailTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SES) ListCustomVerificationEmailTemplatesPages(input *ListCustomVerificationEmailTemplatesInput, fn func(*ListCustomVerificationEmailTemplatesOutput, bool) bool) error {
	return c.ListCustomVerificationEmailTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomVerificationEmailTemplatesPagesWithContext same as ListCustomVerificationEmailTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListCustomVerificationEmailTemplatesPagesWithContext(ctx aws.Context, input *ListCustomVerificationEmailTemplatesInput, fn func(*ListCustomVerificationEmailTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomVerificationEmailTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomVerificationEmailTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomVerificationEmailTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentities = "ListIdentities"

// ListIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentities for more information on using the ListIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentitiesRequest method.
//	req, resp := client.ListIdentitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities
func (c *SES) ListIdentitiesRequest(input *ListIdentitiesInput) (req *request.Request, output *ListIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentitiesInput{}
	}

	output = &ListIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentities API operation for Amazon Simple Email Service.
//
// Returns a list containing all of the identities (email addresses and domains)
// for your Amazon Web Services account in the current Amazon Web Services Region,
// regardless of verification status.
//
// You can execute this operation no more than once per second.
//
// It's recommended that for successive pagination calls of this API, you continue
// to the use the same parameter/value pairs as used in the original call, e.g.,
// if you used IdentityType=Domain in the the original call and received a NextToken
// in the response, you should continue providing the IdentityType=Domain parameter
// for further NextToken calls; however, if you didn't provide the IdentityType
// parameter in the original call, then continue to not provide it for successive
// pagination calls. Using this protocol will ensure consistent results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListIdentities for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities
func (c *SES) ListIdentities(input *ListIdentitiesInput) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	return out, req.Send()
}

// ListIdentitiesWithContext is the same as ListIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListIdentitiesWithContext(ctx aws.Context, input *ListIdentitiesInput, opts ...request.Option) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentitiesPages iterates over the pages of a ListIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdentities operation.
//	pageNum := 0
//	err := client.ListIdentitiesPages(params,
//	    func(page *ses.ListIdentitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SES) ListIdentitiesPages(input *ListIdentitiesInput, fn func(*ListIdentitiesOutput, bool) bool) error {
	return c.ListIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentitiesPagesWithContext same as ListIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListIdentitiesPagesWithContext(ctx aws.Context, input *ListIdentitiesInput, fn func(*ListIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentityPolicies = "ListIdentityPolicies"

// ListIdentityPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityPolicies for more information on using the ListIdentityPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentityPoliciesRequest method.
//	req, resp := client.ListIdentityPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies
func (c *SES) ListIdentityPoliciesRequest(input *ListIdentityPoliciesInput) (req *request.Request, output *ListIdentityPoliciesOutput) {
	op := &request.Operation{
		Name:       opListIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityPoliciesInput{}
	}

	output = &ListIdentityPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityPolicies API operation for Amazon Simple Email Service.
//
// Returns a list of sending authorization policies that are attached to the
// given identity (an email address or a domain). This operation returns only
// a list. To get the actual policy content, use GetIdentityPolicies.
//
// This operation is for the identity owner only. If you have not verified the
// identity, it returns an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListIdentityPolicies for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies
func (c *SES) ListIdentityPolicies(input *ListIdentityPoliciesInput) (*ListIdentityPoliciesOutput, error) {
	req, out := c.ListIdentityPoliciesRequest(input)
	return out, req.Send()
}

// ListIdentityPoliciesWithContext is the same as ListIdentityPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListIdentityPoliciesWithContext(ctx aws.Context, input *ListIdentityPoliciesInput, opts ...request.Option) (*ListIdentityPoliciesOutput, error) {
	req, out := c.ListIdentityPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListReceiptFilters = "ListReceiptFilters"

// ListReceiptFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListReceiptFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReceiptFilters for more information on using the ListReceiptFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReceiptFiltersRequest method.
//	req, resp := client.ListReceiptFiltersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters
func (c *SES) ListReceiptFiltersRequest(input *ListReceiptFiltersInput) (req *request.Request, output *ListReceiptFiltersOutput) {
	op := &request.Operation{
		Name:       opListReceiptFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReceiptFiltersInput{}
	}

	output = &ListReceiptFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReceiptFilters API operation for Amazon Simple Email Service.
//
// Lists the IP address filters associated with your Amazon Web Services account
// in the current Amazon Web Services Region.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListReceiptFilters for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters
func (c *SES) ListReceiptFilters(input *ListReceiptFiltersInput) (*ListReceiptFiltersOutput, error) {
	req, out := c.ListReceiptFiltersRequest(input)
	return out, req.Send()
}

// ListReceiptFiltersWithContext is the same as ListReceiptFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListReceiptFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListReceiptFiltersWithContext(ctx aws.Context, input *ListReceiptFiltersInput, opts ...request.Option) (*ListReceiptFiltersOutput, error) {
	req, out := c.ListReceiptFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListReceiptRuleSets = "ListReceiptRuleSets"

// ListReceiptRuleSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListReceiptRuleSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReceiptRuleSets for more information on using the ListReceiptRuleSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReceiptRuleSetsRequest method.
//	req, resp := client.ListReceiptRuleSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets
func (c *SES) ListReceiptRuleSetsRequest(input *ListReceiptRuleSetsInput) (req *request.Request, output *ListReceiptRuleSetsOutput) {
	op := &request.Operation{
		Name:       opListReceiptRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReceiptRuleSetsInput{}
	}

	output = &ListReceiptRuleSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReceiptRuleSets API operation for Amazon Simple Email Service.
//
// Lists the receipt rule sets that exist under your Amazon Web Services account
// in the current Amazon Web Services Region. If there are additional receipt
// rule sets to be retrieved, you receive a NextToken that you can provide to
// the next call to ListReceiptRuleSets to retrieve the additional entries.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListReceiptRuleSets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets
func (c *SES) ListReceiptRuleSets(input *ListReceiptRuleSetsInput) (*ListReceiptRuleSetsOutput, error) {
	req, out := c.ListReceiptRuleSetsRequest(input)
	return out, req.Send()
}

// ListReceiptRuleSetsWithContext is the same as ListReceiptRuleSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListReceiptRuleSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListReceiptRuleSetsWithContext(ctx aws.Context, input *ListReceiptRuleSetsInput, opts ...request.Option) (*ListReceiptRuleSetsOutput, error) {
	req, out := c.ListReceiptRuleSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTemplatesRequest method.
//	req, resp := client.ListTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates
func (c *SES) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for Amazon Simple Email Service.
//
// Lists the email templates present in your Amazon SES account in the current
// Amazon Web Services Region.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListTemplates for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListTemplates
func (c *SES) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVerifiedEmailAddresses = "ListVerifiedEmailAddresses"

// ListVerifiedEmailAddressesRequest generates a "aws/request.Request" representing the
// client's request for the ListVerifiedEmailAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVerifiedEmailAddresses for more information on using the ListVerifiedEmailAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVerifiedEmailAddressesRequest method.
//	req, resp := client.ListVerifiedEmailAddressesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses
func (c *SES) ListVerifiedEmailAddressesRequest(input *ListVerifiedEmailAddressesInput) (req *request.Request, output *ListVerifiedEmailAddressesOutput) {
	op := &request.Operation{
		Name:       opListVerifiedEmailAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVerifiedEmailAddressesInput{}
	}

	output = &ListVerifiedEmailAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVerifiedEmailAddresses API operation for Amazon Simple Email Service.
//
// Deprecated. Use the ListIdentities operation to list the email addresses
// and domains associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListVerifiedEmailAddresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses
func (c *SES) ListVerifiedEmailAddresses(input *ListVerifiedEmailAddressesInput) (*ListVerifiedEmailAddressesOutput, error) {
	req, out := c.ListVerifiedEmailAddressesRequest(input)
	return out, req.Send()
}

// ListVerifiedEmailAddressesWithContext is the same as ListVerifiedEmailAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See ListVerifiedEmailAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListVerifiedEmailAddressesWithContext(ctx aws.Context, input *ListVerifiedEmailAddressesInput, opts ...request.Option) (*ListVerifiedEmailAddressesOutput, error) {
	req, out := c.ListVerifiedEmailAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetDeliveryOptions = "PutConfigurationSetDeliveryOptions"

// PutConfigurationSetDeliveryOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetDeliveryOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetDeliveryOptions for more information on using the PutConfigurationSetDeliveryOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutConfigurationSetDeliveryOptionsRequest method.
//	req, resp := client.PutConfigurationSetDeliveryOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutConfigurationSetDeliveryOptions
func (c *SES) PutConfigurationSetDeliveryOptionsRequest(input *PutConfigurationSetDeliveryOptionsInput) (req *request.Request, output *PutConfigurationSetDeliveryOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetDeliveryOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurationSetDeliveryOptionsInput{}
	}

	output = &PutConfigurationSetDeliveryOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetDeliveryOptions API operation for Amazon Simple Email Service.
//
// Adds or updates the delivery options for a configuration set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutConfigurationSetDeliveryOptions for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeInvalidDeliveryOptionsException "InvalidDeliveryOptions"
//     Indicates that provided delivery option is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutConfigurationSetDeliveryOptions
func (c *SES) PutConfigurationSetDeliveryOptions(input *PutConfigurationSetDeliveryOptionsInput) (*PutConfigurationSetDeliveryOptionsOutput, error) {
	req, out := c.PutConfigurationSetDeliveryOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetDeliveryOptionsWithContext is the same as PutConfigurationSetDeliveryOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetDeliveryOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) PutConfigurationSetDeliveryOptionsWithContext(ctx aws.Context, input *PutConfigurationSetDeliveryOptionsInput, opts ...request.Option) (*PutConfigurationSetDeliveryOptionsOutput, error) {
	req, out := c.PutConfigurationSetDeliveryOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutIdentityPolicy = "PutIdentityPolicy"

// PutIdentityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutIdentityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutIdentityPolicy for more information on using the PutIdentityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutIdentityPolicyRequest method.
//	req, resp := client.PutIdentityPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy
func (c *SES) PutIdentityPolicyRequest(input *PutIdentityPolicyInput) (req *request.Request, output *PutIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opPutIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutIdentityPolicyInput{}
	}

	output = &PutIdentityPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutIdentityPolicy API operation for Amazon Simple Email Service.
//
// Adds or updates a sending authorization policy for the specified identity
// (an email address or a domain).
//
// This operation is for the identity owner only. If you have not verified the
// identity, it returns an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutIdentityPolicy for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeInvalidPolicyException "InvalidPolicy"
//     Indicates that the provided policy is invalid. Check the error stack for
//     more information about what caused the error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy
func (c *SES) PutIdentityPolicy(input *PutIdentityPolicyInput) (*PutIdentityPolicyOutput, error) {
	req, out := c.PutIdentityPolicyRequest(input)
	return out, req.Send()
}

// PutIdentityPolicyWithContext is the same as PutIdentityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutIdentityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) PutIdentityPolicyWithContext(ctx aws.Context, input *PutIdentityPolicyInput, opts ...request.Option) (*PutIdentityPolicyOutput, error) {
	req, out := c.PutIdentityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReorderReceiptRuleSet = "ReorderReceiptRuleSet"

// ReorderReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the ReorderReceiptRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReorderReceiptRuleSet for more information on using the ReorderReceiptRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReorderReceiptRuleSetRequest method.
//	req, resp := client.ReorderReceiptRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet
func (c *SES) ReorderReceiptRuleSetRequest(input *ReorderReceiptRuleSetInput) (req *request.Request, output *ReorderReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opReorderReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReorderReceiptRuleSetInput{}
	}

	output = &ReorderReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReorderReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Reorders the receipt rules within a receipt rule set.
//
// All of the rules in the rule set must be represented in this request. That
// is, it is error if the reorder request doesn't explicitly position all of
// the rules.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ReorderReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
//   - ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//     Indicates that the provided receipt rule does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet
func (c *SES) ReorderReceiptRuleSet(input *ReorderReceiptRuleSetInput) (*ReorderReceiptRuleSetOutput, error) {
	req, out := c.ReorderReceiptRuleSetRequest(input)
	return out, req.Send()
}

// ReorderReceiptRuleSetWithContext is the same as ReorderReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See ReorderReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ReorderReceiptRuleSetWithContext(ctx aws.Context, input *ReorderReceiptRuleSetInput, opts ...request.Option) (*ReorderReceiptRuleSetOutput, error) {
	req, out := c.ReorderReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendBounce = "SendBounce"

// SendBounceRequest generates a "aws/request.Request" representing the
// client's request for the SendBounce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendBounce for more information on using the SendBounce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendBounceRequest method.
//	req, resp := client.SendBounceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce
func (c *SES) SendBounceRequest(input *SendBounceInput) (req *request.Request, output *SendBounceOutput) {
	op := &request.Operation{
		Name:       opSendBounce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendBounceInput{}
	}

	output = &SendBounceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendBounce API operation for Amazon Simple Email Service.
//
// Generates and sends a bounce message to the sender of an email you received
// through Amazon SES. You can only use this operation on an email up to 24
// hours after you receive it.
//
// You cannot use this operation to send generic bounces for mail that was not
// received by Amazon SES.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendBounce for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeMessageRejected "MessageRejected"
//     Indicates that the action failed, and the message could not be sent. Check
//     the error stack for more information about what caused the error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce
func (c *SES) SendBounce(input *SendBounceInput) (*SendBounceOutput, error) {
	req, out := c.SendBounceRequest(input)
	return out, req.Send()
}

// SendBounceWithContext is the same as SendBounce with the addition of
// the ability to pass a context and additional request options.
//
// See SendBounce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendBounceWithContext(ctx aws.Context, input *SendBounceInput, opts ...request.Option) (*SendBounceOutput, error) {
	req, out := c.SendBounceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendBulkTemplatedEmail = "SendBulkTemplatedEmail"

// SendBulkTemplatedEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendBulkTemplatedEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendBulkTemplatedEmail for more information on using the SendBulkTemplatedEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendBulkTemplatedEmailRequest method.
//	req, resp := client.SendBulkTemplatedEmailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBulkTemplatedEmail
func (c *SES) SendBulkTemplatedEmailRequest(input *SendBulkTemplatedEmailInput) (req *request.Request, output *SendBulkTemplatedEmailOutput) {
	op := &request.Operation{
		Name:       opSendBulkTemplatedEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendBulkTemplatedEmailInput{}
	}

	output = &SendBulkTemplatedEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendBulkTemplatedEmail API operation for Amazon Simple Email Service.
//
// Composes an email message to multiple destinations. The message body is created
// using an email template.
//
// To send email using this operation, your call must meet the following requirements:
//
//   - The call must refer to an existing email template. You can create email
//     templates using CreateTemplate.
//
//   - The message must be sent from a verified email address or domain.
//
//   - If your account is still in the Amazon SES sandbox, you may send only
//     to verified addresses or domains, or to email addresses associated with
//     the Amazon SES Mailbox Simulator. For more information, see Verifying
//     Email Addresses and Domains (https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html)
//     in the Amazon SES Developer Guide.
//
//   - The maximum message size is 10 MB.
//
//   - Each Destination parameter must include at least one recipient email
//     address. The recipient address can be a To: address, a CC: address, or
//     a BCC: address. If a recipient email address is invalid (that is, it is
//     not in the format UserName@[SubDomain.]Domain.TopLevelDomain), the entire
//     message is rejected, even if the message contains other recipients that
//     are valid.
//
//   - The message may not include more than 50 recipients, across the To:,
//     CC: and BCC: fields. If you need to send an email message to a larger
//     audience, you can divide your recipient list into groups of 50 or fewer,
//     and then call the SendBulkTemplatedEmail operation several times to send
//     the message to each group.
//
//   - The number of destinations you can contact in a single call can be limited
//     by your account's maximum sending rate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendBulkTemplatedEmail for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeMessageRejected "MessageRejected"
//     Indicates that the action failed, and the message could not be sent. Check
//     the error stack for more information about what caused the error.
//
//   - ErrCodeMailFromDomainNotVerifiedException "MailFromDomainNotVerifiedException"
//     Indicates that the message could not be sent because Amazon SES could not
//     read the MX record required to use the specified MAIL FROM domain. For information
//     about editing the custom MAIL FROM domain settings for an identity, see the
//     Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html).
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeTemplateDoesNotExistException "TemplateDoesNotExist"
//     Indicates that the Template object you specified does not exist in your Amazon
//     SES account.
//
//   - ErrCodeConfigurationSetSendingPausedException "ConfigurationSetSendingPausedException"
//     Indicates that email sending is disabled for the configuration set.
//
//     You can enable or disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled.
//
//   - ErrCodeAccountSendingPausedException "AccountSendingPausedException"
//     Indicates that email sending is disabled for your entire Amazon SES account.
//
//     You can enable or disable email sending for your Amazon SES account using
//     UpdateAccountSendingEnabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBulkTemplatedEmail
func (c *SES) SendBulkTemplatedEmail(input *SendBulkTemplatedEmailInput) (*SendBulkTemplatedEmailOutput, error) {
	req, out := c.SendBulkTemplatedEmailRequest(input)
	return out, req.Send()
}

// SendBulkTemplatedEmailWithContext is the same as SendBulkTemplatedEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendBulkTemplatedEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendBulkTemplatedEmailWithContext(ctx aws.Context, input *SendBulkTemplatedEmailInput, opts ...request.Option) (*SendBulkTemplatedEmailOutput, error) {
	req, out := c.SendBulkTemplatedEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendCustomVerificationEmail = "SendCustomVerificationEmail"

// SendCustomVerificationEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendCustomVerificationEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendCustomVerificationEmail for more information on using the SendCustomVerificationEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendCustomVerificationEmailRequest method.
//	req, resp := client.SendCustomVerificationEmailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendCustomVerificationEmail
func (c *SES) SendCustomVerificationEmailRequest(input *SendCustomVerificationEmailInput) (req *request.Request, output *SendCustomVerificationEmailOutput) {
	op := &request.Operation{
		Name:       opSendCustomVerificationEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendCustomVerificationEmailInput{}
	}

	output = &SendCustomVerificationEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendCustomVerificationEmail API operation for Amazon Simple Email Service.
//
// Adds an email address to the list of identities for your Amazon SES account
// in the current Amazon Web Services Region and attempts to verify it. As a
// result of executing this operation, a customized verification email is sent
// to the specified address.
//
// To use this operation, you must first create a custom verification email
// template. For more information about creating and using custom verification
// email templates, see Using Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendCustomVerificationEmail for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeMessageRejected "MessageRejected"
//     Indicates that the action failed, and the message could not be sent. Check
//     the error stack for more information about what caused the error.
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeCustomVerificationEmailTemplateDoesNotExistException "CustomVerificationEmailTemplateDoesNotExist"
//     Indicates that a custom verification email template with the name you specified
//     does not exist.
//
//   - ErrCodeFromEmailAddressNotVerifiedException "FromEmailAddressNotVerified"
//     Indicates that the sender address specified for a custom verification email
//     is not verified, and is therefore not eligible to send the custom verification
//     email.
//
//   - ErrCodeProductionAccessNotGrantedException "ProductionAccessNotGranted"
//     Indicates that the account has not been granted production access.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendCustomVerificationEmail
func (c *SES) SendCustomVerificationEmail(input *SendCustomVerificationEmailInput) (*SendCustomVerificationEmailOutput, error) {
	req, out := c.SendCustomVerificationEmailRequest(input)
	return out, req.Send()
}

// SendCustomVerificationEmailWithContext is the same as SendCustomVerificationEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendCustomVerificationEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendCustomVerificationEmailWithContext(ctx aws.Context, input *SendCustomVerificationEmailInput, opts ...request.Option) (*SendCustomVerificationEmailOutput, error) {
	req, out := c.SendCustomVerificationEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendEmail = "SendEmail"

// SendEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendEmail for more information on using the SendEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendEmailRequest method.
//	req, resp := client.SendEmailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail
func (c *SES) SendEmailRequest(input *SendEmailInput) (req *request.Request, output *SendEmailOutput) {
	op := &request.Operation{
		Name:       opSendEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendEmailInput{}
	}

	output = &SendEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendEmail API operation for Amazon Simple Email Service.
//
// Composes an email message and immediately queues it for sending. To send
// email using this operation, your message must meet the following requirements:
//
//   - The message must be sent from a verified email address or domain. If
//     you attempt to send email using a non-verified address or domain, the
//     operation results in an "Email address not verified" error.
//
//   - If your account is still in the Amazon SES sandbox, you may only send
//     to verified addresses or domains, or to email addresses associated with
//     the Amazon SES Mailbox Simulator. For more information, see Verifying
//     Email Addresses and Domains (https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html)
//     in the Amazon SES Developer Guide.
//
//   - The maximum message size is 10 MB.
//
//   - The message must include at least one recipient email address. The recipient
//     address can be a To: address, a CC: address, or a BCC: address. If a recipient
//     email address is invalid (that is, it is not in the format UserName@[SubDomain.]Domain.TopLevelDomain),
//     the entire message is rejected, even if the message contains other recipients
//     that are valid.
//
//   - The message may not include more than 50 recipients, across the To:,
//     CC: and BCC: fields. If you need to send an email message to a larger
//     audience, you can divide your recipient list into groups of 50 or fewer,
//     and then call the SendEmail operation several times to send the message
//     to each group.
//
// For every message that you send, the total number of recipients (including
// each recipient in the To:, CC: and BCC: fields) is counted against the maximum
// number of emails you can send in a 24-hour period (your sending quota). For
// more information about sending quotas in Amazon SES, see Managing Your Amazon
// SES Sending Limits (https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html)
// in the Amazon SES Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendEmail for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeMessageRejected "MessageRejected"
//     Indicates that the action failed, and the message could not be sent. Check
//     the error stack for more information about what caused the error.
//
//   - ErrCodeMailFromDomainNotVerifiedException "MailFromDomainNotVerifiedException"
//     Indicates that the message could not be sent because Amazon SES could not
//     read the MX record required to use the specified MAIL FROM domain. For information
//     about editing the custom MAIL FROM domain settings for an identity, see the
//     Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html).
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeConfigurationSetSendingPausedException "ConfigurationSetSendingPausedException"
//     Indicates that email sending is disabled for the configuration set.
//
//     You can enable or disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled.
//
//   - ErrCodeAccountSendingPausedException "AccountSendingPausedException"
//     Indicates that email sending is disabled for your entire Amazon SES account.
//
//     You can enable or disable email sending for your Amazon SES account using
//     UpdateAccountSendingEnabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail
func (c *SES) SendEmail(input *SendEmailInput) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	return out, req.Send()
}

// SendEmailWithContext is the same as SendEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendEmailWithContext(ctx aws.Context, input *SendEmailInput, opts ...request.Option) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendRawEmail = "SendRawEmail"

// SendRawEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendRawEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendRawEmail for more information on using the SendRawEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendRawEmailRequest method.
//	req, resp := client.SendRawEmailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail
func (c *SES) SendRawEmailRequest(input *SendRawEmailInput) (req *request.Request, output *SendRawEmailOutput) {
	op := &request.Operation{
		Name:       opSendRawEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendRawEmailInput{}
	}

	output = &SendRawEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendRawEmail API operation for Amazon Simple Email Service.
//
// Composes an email message and immediately queues it for sending.
//
// This operation is more flexible than the SendEmail operation. When you use
// the SendRawEmail operation, you can specify the headers of the message as
// well as its content. This flexibility is useful, for example, when you need
// to send a multipart MIME email (such a message that contains both a text
// and an HTML version). You can also use this operation to send messages that
// include attachments.
//
// The SendRawEmail operation has the following requirements:
//
//   - You can only send email from verified email addresses or domains (https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html).
//     If you try to send email from an address that isn't verified, the operation
//     results in an "Email address not verified" error.
//
//   - If your account is still in the Amazon SES sandbox (https://docs.aws.amazon.com/ses/latest/dg/request-production-access.html),
//     you can only send email to other verified addresses in your account, or
//     to addresses that are associated with the Amazon SES mailbox simulator
//     (https://docs.aws.amazon.com/ses/latest/dg/send-an-email-from-console.html).
//
//   - The maximum message size, including attachments, is 10 MB.
//
//   - Each message has to include at least one recipient address. A recipient
//     address includes any address on the To:, CC:, or BCC: lines.
//
//   - If you send a single message to more than one recipient address, and
//     one of the recipient addresses isn't in a valid format (that is, it's
//     not in the format UserName@[SubDomain.]Domain.TopLevelDomain), Amazon
//     SES rejects the entire message, even if the other addresses are valid.
//
//   - Each message can include up to 50 recipient addresses across the To:,
//     CC:, or BCC: lines. If you need to send a single message to more than
//     50 recipients, you have to split the list of recipient addresses into
//     groups of less than 50 recipients, and send separate messages to each
//     group.
//
//   - Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for
//     MIME message parts. However, if Amazon SES has to modify the contents
//     of your message (for example, if you use open and click tracking), 8-bit
//     content isn't preserved. For this reason, we highly recommend that you
//     encode all content that isn't 7-bit ASCII. For more information, see MIME
//     Encoding (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html#send-email-mime-encoding)
//     in the Amazon SES Developer Guide.
//
// Additionally, keep the following considerations in mind when using the SendRawEmail
// operation:
//
//   - Although you can customize the message headers when using the SendRawEmail
//     operation, Amazon SES automatically applies its own Message-ID and Date
//     headers; if you passed these headers when creating the message, they are
//     overwritten by the values that Amazon SES provides.
//
//   - If you are using sending authorization to send on behalf of another
//     user, SendRawEmail enables you to specify the cross-account identity for
//     the email's Source, From, and Return-Path parameters in one of two ways:
//     you can pass optional parameters SourceArn, FromArn, and/or ReturnPathArn,
//     or you can include the following X-headers in the header of your raw email:
//     X-SES-SOURCE-ARN X-SES-FROM-ARN X-SES-RETURN-PATH-ARN Don't include these
//     X-headers in the DKIM signature. Amazon SES removes these before it sends
//     the email. If you only specify the SourceIdentityArn parameter, Amazon
//     SES sets the From and Return-Path addresses to the same identity that
//     you specified. For more information about sending authorization, see the
//     Using Sending Authorization with Amazon SES (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html)
//     in the Amazon SES Developer Guide.
//
//   - For every message that you send, the total number of recipients (including
//     each recipient in the To:, CC: and BCC: fields) is counted against the
//     maximum number of emails you can send in a 24-hour period (your sending
//     quota). For more information about sending quotas in Amazon SES, see Managing
//     Your Amazon SES Sending Limits (https://docs.aws.amazon.com/ses/latest/dg/manage-sending-quotas.html)
//     in the Amazon SES Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendRawEmail for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeMessageRejected "MessageRejected"
//     Indicates that the action failed, and the message could not be sent. Check
//     the error stack for more information about what caused the error.
//
//   - ErrCodeMailFromDomainNotVerifiedException "MailFromDomainNotVerifiedException"
//     Indicates that the message could not be sent because Amazon SES could not
//     read the MX record required to use the specified MAIL FROM domain. For information
//     about editing the custom MAIL FROM domain settings for an identity, see the
//     Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html).
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeConfigurationSetSendingPausedException "ConfigurationSetSendingPausedException"
//     Indicates that email sending is disabled for the configuration set.
//
//     You can enable or disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled.
//
//   - ErrCodeAccountSendingPausedException "AccountSendingPausedException"
//     Indicates that email sending is disabled for your entire Amazon SES account.
//
//     You can enable or disable email sending for your Amazon SES account using
//     UpdateAccountSendingEnabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail
func (c *SES) SendRawEmail(input *SendRawEmailInput) (*SendRawEmailOutput, error) {
	req, out := c.SendRawEmailRequest(input)
	return out, req.Send()
}

// SendRawEmailWithContext is the same as SendRawEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendRawEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendRawEmailWithContext(ctx aws.Context, input *SendRawEmailInput, opts ...request.Option) (*SendRawEmailOutput, error) {
	req, out := c.SendRawEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTemplatedEmail = "SendTemplatedEmail"

// SendTemplatedEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendTemplatedEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTemplatedEmail for more information on using the SendTemplatedEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendTemplatedEmailRequest method.
//	req, resp := client.SendTemplatedEmailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendTemplatedEmail
func (c *SES) SendTemplatedEmailRequest(input *SendTemplatedEmailInput) (req *request.Request, output *SendTemplatedEmailOutput) {
	op := &request.Operation{
		Name:       opSendTemplatedEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTemplatedEmailInput{}
	}

	output = &SendTemplatedEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendTemplatedEmail API operation for Amazon Simple Email Service.
//
// Composes an email message using an email template and immediately queues
// it for sending.
//
// To send email using this operation, your call must meet the following requirements:
//
//   - The call must refer to an existing email template. You can create email
//     templates using the CreateTemplate operation.
//
//   - The message must be sent from a verified email address or domain.
//
//   - If your account is still in the Amazon SES sandbox, you may only send
//     to verified addresses or domains, or to email addresses associated with
//     the Amazon SES Mailbox Simulator. For more information, see Verifying
//     Email Addresses and Domains (https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html)
//     in the Amazon SES Developer Guide.
//
//   - The maximum message size is 10 MB.
//
//   - Calls to the SendTemplatedEmail operation may only include one Destination
//     parameter. A destination is a set of recipients that receives the same
//     version of the email. The Destination parameter can include up to 50 recipients,
//     across the To:, CC: and BCC: fields.
//
//   - The Destination parameter must include at least one recipient email
//     address. The recipient address can be a To: address, a CC: address, or
//     a BCC: address. If a recipient email address is invalid (that is, it is
//     not in the format UserName@[SubDomain.]Domain.TopLevelDomain), the entire
//     message is rejected, even if the message contains other recipients that
//     are valid.
//
// If your call to the SendTemplatedEmail operation includes all of the required
// parameters, Amazon SES accepts it and returns a Message ID. However, if Amazon
// SES can't render the email because the template contains errors, it doesn't
// send the email. Additionally, because it already accepted the message, Amazon
// SES doesn't return a message stating that it was unable to send the email.
//
// For these reasons, we highly recommend that you set up Amazon SES to send
// you notifications when Rendering Failure events occur. For more information,
// see Sending Personalized Email Using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html)
// in the Amazon Simple Email Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendTemplatedEmail for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeMessageRejected "MessageRejected"
//     Indicates that the action failed, and the message could not be sent. Check
//     the error stack for more information about what caused the error.
//
//   - ErrCodeMailFromDomainNotVerifiedException "MailFromDomainNotVerifiedException"
//     Indicates that the message could not be sent because Amazon SES could not
//     read the MX record required to use the specified MAIL FROM domain. For information
//     about editing the custom MAIL FROM domain settings for an identity, see the
//     Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html).
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeTemplateDoesNotExistException "TemplateDoesNotExist"
//     Indicates that the Template object you specified does not exist in your Amazon
//     SES account.
//
//   - ErrCodeConfigurationSetSendingPausedException "ConfigurationSetSendingPausedException"
//     Indicates that email sending is disabled for the configuration set.
//
//     You can enable or disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled.
//
//   - ErrCodeAccountSendingPausedException "AccountSendingPausedException"
//     Indicates that email sending is disabled for your entire Amazon SES account.
//
//     You can enable or disable email sending for your Amazon SES account using
//     UpdateAccountSendingEnabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendTemplatedEmail
func (c *SES) SendTemplatedEmail(input *SendTemplatedEmailInput) (*SendTemplatedEmailOutput, error) {
	req, out := c.SendTemplatedEmailRequest(input)
	return out, req.Send()
}

// SendTemplatedEmailWithContext is the same as SendTemplatedEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendTemplatedEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendTemplatedEmailWithContext(ctx aws.Context, input *SendTemplatedEmailInput, opts ...request.Option) (*SendTemplatedEmailOutput, error) {
	req, out := c.SendTemplatedEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetActiveReceiptRuleSet = "SetActiveReceiptRuleSet"

// SetActiveReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the SetActiveReceiptRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetActiveReceiptRuleSet for more information on using the SetActiveReceiptRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetActiveReceiptRuleSetRequest method.
//	req, resp := client.SetActiveReceiptRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet
func (c *SES) SetActiveReceiptRuleSetRequest(input *SetActiveReceiptRuleSetInput) (req *request.Request, output *SetActiveReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opSetActiveReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetActiveReceiptRuleSetInput{}
	}

	output = &SetActiveReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetActiveReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Sets the specified receipt rule set as the active receipt rule set.
//
// To disable your email-receiving through Amazon SES completely, you can call
// this operation with RuleSetName set to null.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetActiveReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet
func (c *SES) SetActiveReceiptRuleSet(input *SetActiveReceiptRuleSetInput) (*SetActiveReceiptRuleSetOutput, error) {
	req, out := c.SetActiveReceiptRuleSetRequest(input)
	return out, req.Send()
}

// SetActiveReceiptRuleSetWithContext is the same as SetActiveReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See SetActiveReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetActiveReceiptRuleSetWithContext(ctx aws.Context, input *SetActiveReceiptRuleSetInput, opts ...request.Option) (*SetActiveReceiptRuleSetOutput, error) {
	req, out := c.SetActiveReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityDkimEnabled = "SetIdentityDkimEnabled"

// SetIdentityDkimEnabledRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityDkimEnabled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIdentityDkimEnabled for more information on using the SetIdentityDkimEnabled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetIdentityDkimEnabledRequest method.
//	req, resp := client.SetIdentityDkimEnabledRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled
func (c *SES) SetIdentityDkimEnabledRequest(input *SetIdentityDkimEnabledInput) (req *request.Request, output *SetIdentityDkimEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityDkimEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityDkimEnabledInput{}
	}

	output = &SetIdentityDkimEnabledOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetIdentityDkimEnabled API operation for Amazon Simple Email Service.
//
// Enables or disables Easy DKIM signing of email sent from an identity. If
// Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to sign
// all email that it sends from addresses on that domain. If Easy DKIM signing
// is enabled for an email address, then Amazon SES uses DKIM to sign all email
// it sends from that address.
//
// For email addresses (for example, user@example.com), you can only enable
// DKIM signing if the corresponding domain (in this case, example.com) has
// been set up to use Easy DKIM.
//
// You can enable DKIM signing for an identity at any time after you start the
// verification process for the identity, even if the verification process isn't
// complete.
//
// You can execute this operation no more than once per second.
//
// For more information about Easy DKIM signing, go to the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityDkimEnabled for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled
func (c *SES) SetIdentityDkimEnabled(input *SetIdentityDkimEnabledInput) (*SetIdentityDkimEnabledOutput, error) {
	req, out := c.SetIdentityDkimEnabledRequest(input)
	return out, req.Send()
}

// SetIdentityDkimEnabledWithContext is the same as SetIdentityDkimEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityDkimEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityDkimEnabledWithContext(ctx aws.Context, input *SetIdentityDkimEnabledInput, opts ...request.Option) (*SetIdentityDkimEnabledOutput, error) {
	req, out := c.SetIdentityDkimEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityFeedbackForwardingEnabled = "SetIdentityFeedbackForwardingEnabled"

// SetIdentityFeedbackForwardingEnabledRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityFeedbackForwardingEnabled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIdentityFeedbackForwardingEnabled for more information on using the SetIdentityFeedbackForwardingEnabled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetIdentityFeedbackForwardingEnabledRequest method.
//	req, resp := client.SetIdentityFeedbackForwardingEnabledRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled
func (c *SES) SetIdentityFeedbackForwardingEnabledRequest(input *SetIdentityFeedbackForwardingEnabledInput) (req *request.Request, output *SetIdentityFeedbackForwardingEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityFeedbackForwardingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityFeedbackForwardingEnabledInput{}
	}

	output = &SetIdentityFeedbackForwardingEnabledOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetIdentityFeedbackForwardingEnabled API operation for Amazon Simple Email Service.
//
// Given an identity (an email address or a domain), enables or disables whether
// Amazon SES forwards bounce and complaint notifications as email. Feedback
// forwarding can only be disabled when Amazon Simple Notification Service (Amazon
// SNS) topics are specified for both bounces and complaints.
//
// Feedback forwarding does not apply to delivery notifications. Delivery notifications
// are only available through Amazon SNS.
//
// You can execute this operation no more than once per second.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityFeedbackForwardingEnabled for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled
func (c *SES) SetIdentityFeedbackForwardingEnabled(input *SetIdentityFeedbackForwardingEnabledInput) (*SetIdentityFeedbackForwardingEnabledOutput, error) {
	req, out := c.SetIdentityFeedbackForwardingEnabledRequest(input)
	return out, req.Send()
}

// SetIdentityFeedbackForwardingEnabledWithContext is the same as SetIdentityFeedbackForwardingEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityFeedbackForwardingEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityFeedbackForwardingEnabledWithContext(ctx aws.Context, input *SetIdentityFeedbackForwardingEnabledInput, opts ...request.Option) (*SetIdentityFeedbackForwardingEnabledOutput, error) {
	req, out := c.SetIdentityFeedbackForwardingEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityHeadersInNotificationsEnabled = "SetIdentityHeadersInNotificationsEnabled"

// SetIdentityHeadersInNotificationsEnabledRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityHeadersInNotificationsEnabled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIdentityHeadersInNotificationsEnabled for more information on using the SetIdentityHeadersInNotificationsEnabled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetIdentityHeadersInNotificationsEnabledRequest method.
//	req, resp := client.SetIdentityHeadersInNotificationsEnabledRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled
func (c *SES) SetIdentityHeadersInNotificationsEnabledRequest(input *SetIdentityHeadersInNotificationsEnabledInput) (req *request.Request, output *SetIdentityHeadersInNotificationsEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityHeadersInNotificationsEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityHeadersInNotificationsEnabledInput{}
	}

	output = &SetIdentityHeadersInNotificationsEnabledOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetIdentityHeadersInNotificationsEnabled API operation for Amazon Simple Email Service.
//
// Given an identity (an email address or a domain), sets whether Amazon SES
// includes the original email headers in the Amazon Simple Notification Service
// (Amazon SNS) notifications of a specified type.
//
// You can execute this operation no more than once per second.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityHeadersInNotificationsEnabled for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled
func (c *SES) SetIdentityHeadersInNotificationsEnabled(input *SetIdentityHeadersInNotificationsEnabledInput) (*SetIdentityHeadersInNotificationsEnabledOutput, error) {
	req, out := c.SetIdentityHeadersInNotificationsEnabledRequest(input)
	return out, req.Send()
}

// SetIdentityHeadersInNotificationsEnabledWithContext is the same as SetIdentityHeadersInNotificationsEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityHeadersInNotificationsEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityHeadersInNotificationsEnabledWithContext(ctx aws.Context, input *SetIdentityHeadersInNotificationsEnabledInput, opts ...request.Option) (*SetIdentityHeadersInNotificationsEnabledOutput, error) {
	req, out := c.SetIdentityHeadersInNotificationsEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityMailFromDomain = "SetIdentityMailFromDomain"

// SetIdentityMailFromDomainRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityMailFromDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIdentityMailFromDomain for more information on using the SetIdentityMailFromDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetIdentityMailFromDomainRequest method.
//	req, resp := client.SetIdentityMailFromDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain
func (c *SES) SetIdentityMailFromDomainRequest(input *SetIdentityMailFromDomainInput) (req *request.Request, output *SetIdentityMailFromDomainOutput) {
	op := &request.Operation{
		Name:       opSetIdentityMailFromDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityMailFromDomainInput{}
	}

	output = &SetIdentityMailFromDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetIdentityMailFromDomain API operation for Amazon Simple Email Service.
//
// Enables or disables the custom MAIL FROM domain setup for a verified identity
// (an email address or a domain).
//
// To send emails using the specified MAIL FROM domain, you must add an MX record
// to your MAIL FROM domain's DNS settings. To ensure that your emails pass
// Sender Policy Framework (SPF) checks, you must also add or update an SPF
// record. For more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/mail-from.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityMailFromDomain for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain
func (c *SES) SetIdentityMailFromDomain(input *SetIdentityMailFromDomainInput) (*SetIdentityMailFromDomainOutput, error) {
	req, out := c.SetIdentityMailFromDomainRequest(input)
	return out, req.Send()
}

// SetIdentityMailFromDomainWithContext is the same as SetIdentityMailFromDomain with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityMailFromDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityMailFromDomainWithContext(ctx aws.Context, input *SetIdentityMailFromDomainInput, opts ...request.Option) (*SetIdentityMailFromDomainOutput, error) {
	req, out := c.SetIdentityMailFromDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityNotificationTopic = "SetIdentityNotificationTopic"

// SetIdentityNotificationTopicRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityNotificationTopic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIdentityNotificationTopic for more information on using the SetIdentityNotificationTopic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetIdentityNotificationTopicRequest method.
//	req, resp := client.SetIdentityNotificationTopicRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic
func (c *SES) SetIdentityNotificationTopicRequest(input *SetIdentityNotificationTopicInput) (req *request.Request, output *SetIdentityNotificationTopicOutput) {
	op := &request.Operation{
		Name:       opSetIdentityNotificationTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityNotificationTopicInput{}
	}

	output = &SetIdentityNotificationTopicOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetIdentityNotificationTopic API operation for Amazon Simple Email Service.
//
// Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when
// delivering notifications. When you use this operation, you specify a verified
// identity, such as an email address or domain. When you send an email that
// uses the chosen identity in the Source field, Amazon SES sends notifications
// to the topic you specified. You can send bounce, complaint, or delivery notifications
// (or any combination of the three) to the Amazon SNS topic that you specify.
//
// You can execute this operation no more than once per second.
//
// For more information about feedback notification, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityNotificationTopic for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic
func (c *SES) SetIdentityNotificationTopic(input *SetIdentityNotificationTopicInput) (*SetIdentityNotificationTopicOutput, error) {
	req, out := c.SetIdentityNotificationTopicRequest(input)
	return out, req.Send()
}

// SetIdentityNotificationTopicWithContext is the same as SetIdentityNotificationTopic with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityNotificationTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityNotificationTopicWithContext(ctx aws.Context, input *SetIdentityNotificationTopicInput, opts ...request.Option) (*SetIdentityNotificationTopicOutput, error) {
	req, out := c.SetIdentityNotificationTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetReceiptRulePosition = "SetReceiptRulePosition"

// SetReceiptRulePositionRequest generates a "aws/request.Request" representing the
// client's request for the SetReceiptRulePosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetReceiptRulePosition for more information on using the SetReceiptRulePosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetReceiptRulePositionRequest method.
//	req, resp := client.SetReceiptRulePositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition
func (c *SES) SetReceiptRulePositionRequest(input *SetReceiptRulePositionInput) (req *request.Request, output *SetReceiptRulePositionOutput) {
	op := &request.Operation{
		Name:       opSetReceiptRulePosition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetReceiptRulePositionInput{}
	}

	output = &SetReceiptRulePositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetReceiptRulePosition API operation for Amazon Simple Email Service.
//
// Sets the position of the specified receipt rule in the receipt rule set.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetReceiptRulePosition for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
//   - ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//     Indicates that the provided receipt rule does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition
func (c *SES) SetReceiptRulePosition(input *SetReceiptRulePositionInput) (*SetReceiptRulePositionOutput, error) {
	req, out := c.SetReceiptRulePositionRequest(input)
	return out, req.Send()
}

// SetReceiptRulePositionWithContext is the same as SetReceiptRulePosition with the addition of
// the ability to pass a context and additional request options.
//
// See SetReceiptRulePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetReceiptRulePositionWithContext(ctx aws.Context, input *SetReceiptRulePositionInput, opts ...request.Option) (*SetReceiptRulePositionOutput, error) {
	req, out := c.SetReceiptRulePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestRenderTemplate = "TestRenderTemplate"

// TestRenderTemplateRequest generates a "aws/request.Request" representing the
// client's request for the TestRenderTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestRenderTemplate for more information on using the TestRenderTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TestRenderTemplateRequest method.
//	req, resp := client.TestRenderTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplate
func (c *SES) TestRenderTemplateRequest(input *TestRenderTemplateInput) (req *request.Request, output *TestRenderTemplateOutput) {
	op := &request.Operation{
		Name:       opTestRenderTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestRenderTemplateInput{}
	}

	output = &TestRenderTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestRenderTemplate API operation for Amazon Simple Email Service.
//
// Creates a preview of the MIME content of an email when provided with a template
// and a set of replacement data.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation TestRenderTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeTemplateDoesNotExistException "TemplateDoesNotExist"
//     Indicates that the Template object you specified does not exist in your Amazon
//     SES account.
//
//   - ErrCodeInvalidRenderingParameterException "InvalidRenderingParameter"
//     Indicates that one or more of the replacement values you provided is invalid.
//     This error may occur when the TemplateData object contains invalid JSON.
//
//   - ErrCodeMissingRenderingAttributeException "MissingRenderingAttribute"
//     Indicates that one or more of the replacement values for the specified template
//     was not specified. Ensure that the TemplateData object contains references
//     to all of the replacement tags in the specified template.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplate
func (c *SES) TestRenderTemplate(input *TestRenderTemplateInput) (*TestRenderTemplateOutput, error) {
	req, out := c.TestRenderTemplateRequest(input)
	return out, req.Send()
}

// TestRenderTemplateWithContext is the same as TestRenderTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See TestRenderTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) TestRenderTemplateWithContext(ctx aws.Context, input *TestRenderTemplateInput, opts ...request.Option) (*TestRenderTemplateOutput, error) {
	req, out := c.TestRenderTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSendingEnabled = "UpdateAccountSendingEnabled"

// UpdateAccountSendingEnabledRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSendingEnabled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSendingEnabled for more information on using the UpdateAccountSendingEnabled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountSendingEnabledRequest method.
//	req, resp := client.UpdateAccountSendingEnabledRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateAccountSendingEnabled
func (c *SES) UpdateAccountSendingEnabledRequest(input *UpdateAccountSendingEnabledInput) (req *request.Request, output *UpdateAccountSendingEnabledOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSendingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccountSendingEnabledInput{}
	}

	output = &UpdateAccountSendingEnabledOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAccountSendingEnabled API operation for Amazon Simple Email Service.
//
// Enables or disables email sending across your entire Amazon SES account in
// the current Amazon Web Services Region. You can use this operation in conjunction
// with Amazon CloudWatch alarms to temporarily pause email sending across your
// Amazon SES account in a given Amazon Web Services Region when reputation
// metrics (such as your bounce or complaint rates) reach certain thresholds.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateAccountSendingEnabled for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateAccountSendingEnabled
func (c *SES) UpdateAccountSendingEnabled(input *UpdateAccountSendingEnabledInput) (*UpdateAccountSendingEnabledOutput, error) {
	req, out := c.UpdateAccountSendingEnabledRequest(input)
	return out, req.Send()
}

// UpdateAccountSendingEnabledWithContext is the same as UpdateAccountSendingEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSendingEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateAccountSendingEnabledWithContext(ctx aws.Context, input *UpdateAccountSendingEnabledInput, opts ...request.Option) (*UpdateAccountSendingEnabledOutput, error) {
	req, out := c.UpdateAccountSendingEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetEventDestination = "UpdateConfigurationSetEventDestination"

// UpdateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationSetEventDestination for more information on using the UpdateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfigurationSetEventDestinationRequest method.
//	req, resp := client.UpdateConfigurationSetEventDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination
func (c *SES) UpdateConfigurationSetEventDestinationRequest(input *UpdateConfigurationSetEventDestinationInput) (req *request.Request, output *UpdateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationSetEventDestinationInput{}
	}

	output = &UpdateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Updates the event destination of a configuration set. Event destinations
// are associated with configuration sets, which enable you to publish email
// sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple
// Notification Service (Amazon SNS). For information about using configuration
// sets, see Monitoring Your Amazon SES Sending Activity (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html)
// in the Amazon SES Developer Guide.
//
// When you create or update an event destination, you must provide one, and
// only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis
// Firehose, or Amazon Simple Notification Service (Amazon SNS).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeEventDestinationDoesNotExistException "EventDestinationDoesNotExist"
//     Indicates that the event destination does not exist.
//
//   - ErrCodeInvalidCloudWatchDestinationException "InvalidCloudWatchDestination"
//     Indicates that the Amazon CloudWatch destination is invalid. See the error
//     message for details.
//
//   - ErrCodeInvalidFirehoseDestinationException "InvalidFirehoseDestination"
//     Indicates that the Amazon Kinesis Firehose destination is invalid. See the
//     error message for details.
//
//   - ErrCodeInvalidSNSDestinationException "InvalidSNSDestination"
//     Indicates that the Amazon Simple Notification Service (Amazon SNS) destination
//     is invalid. See the error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination
func (c *SES) UpdateConfigurationSetEventDestination(input *UpdateConfigurationSetEventDestinationInput) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetEventDestinationWithContext is the same as UpdateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *UpdateConfigurationSetEventDestinationInput, opts ...request.Option) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetReputationMetricsEnabled = "UpdateConfigurationSetReputationMetricsEnabled"

// UpdateConfigurationSetReputationMetricsEnabledRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetReputationMetricsEnabled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationSetReputationMetricsEnabled for more information on using the UpdateConfigurationSetReputationMetricsEnabled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfigurationSetReputationMetricsEnabledRequest method.
//	req, resp := client.UpdateConfigurationSetReputationMetricsEnabledRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabled
func (c *SES) UpdateConfigurationSetReputationMetricsEnabledRequest(input *UpdateConfigurationSetReputationMetricsEnabledInput) (req *request.Request, output *UpdateConfigurationSetReputationMetricsEnabledOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetReputationMetricsEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationSetReputationMetricsEnabledInput{}
	}

	output = &UpdateConfigurationSetReputationMetricsEnabledOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfigurationSetReputationMetricsEnabled API operation for Amazon Simple Email Service.
//
// Enables or disables the publishing of reputation metrics for emails sent
// using a specific configuration set in a given Amazon Web Services Region.
// Reputation metrics include bounce and complaint rates. These metrics are
// published to Amazon CloudWatch. By using CloudWatch, you can create alarms
// when bounce or complaint rates exceed certain thresholds.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateConfigurationSetReputationMetricsEnabled for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetReputationMetricsEnabled
func (c *SES) UpdateConfigurationSetReputationMetricsEnabled(input *UpdateConfigurationSetReputationMetricsEnabledInput) (*UpdateConfigurationSetReputationMetricsEnabledOutput, error) {
	req, out := c.UpdateConfigurationSetReputationMetricsEnabledRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetReputationMetricsEnabledWithContext is the same as UpdateConfigurationSetReputationMetricsEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetReputationMetricsEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateConfigurationSetReputationMetricsEnabledWithContext(ctx aws.Context, input *UpdateConfigurationSetReputationMetricsEnabledInput, opts ...request.Option) (*UpdateConfigurationSetReputationMetricsEnabledOutput, error) {
	req, out := c.UpdateConfigurationSetReputationMetricsEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetSendingEnabled = "UpdateConfigurationSetSendingEnabled"

// UpdateConfigurationSetSendingEnabledRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetSendingEnabled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationSetSendingEnabled for more information on using the UpdateConfigurationSetSendingEnabled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfigurationSetSendingEnabledRequest method.
//	req, resp := client.UpdateConfigurationSetSendingEnabledRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetSendingEnabled
func (c *SES) UpdateConfigurationSetSendingEnabledRequest(input *UpdateConfigurationSetSendingEnabledInput) (req *request.Request, output *UpdateConfigurationSetSendingEnabledOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetSendingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationSetSendingEnabledInput{}
	}

	output = &UpdateConfigurationSetSendingEnabledOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfigurationSetSendingEnabled API operation for Amazon Simple Email Service.
//
// Enables or disables email sending for messages sent using a specific configuration
// set in a given Amazon Web Services Region. You can use this operation in
// conjunction with Amazon CloudWatch alarms to temporarily pause email sending
// for a configuration set when the reputation metrics for that configuration
// set (such as your bounce on complaint rate) exceed certain thresholds.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateConfigurationSetSendingEnabled for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetSendingEnabled
func (c *SES) UpdateConfigurationSetSendingEnabled(input *UpdateConfigurationSetSendingEnabledInput) (*UpdateConfigurationSetSendingEnabledOutput, error) {
	req, out := c.UpdateConfigurationSetSendingEnabledRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetSendingEnabledWithContext is the same as UpdateConfigurationSetSendingEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetSendingEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateConfigurationSetSendingEnabledWithContext(ctx aws.Context, input *UpdateConfigurationSetSendingEnabledInput, opts ...request.Option) (*UpdateConfigurationSetSendingEnabledOutput, error) {
	req, out := c.UpdateConfigurationSetSendingEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetTrackingOptions = "UpdateConfigurationSetTrackingOptions"

// UpdateConfigurationSetTrackingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetTrackingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationSetTrackingOptions for more information on using the UpdateConfigurationSetTrackingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfigurationSetTrackingOptionsRequest method.
//	req, resp := client.UpdateConfigurationSetTrackingOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptions
func (c *SES) UpdateConfigurationSetTrackingOptionsRequest(input *UpdateConfigurationSetTrackingOptionsInput) (req *request.Request, output *UpdateConfigurationSetTrackingOptionsOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetTrackingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationSetTrackingOptionsInput{}
	}

	output = &UpdateConfigurationSetTrackingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfigurationSetTrackingOptions API operation for Amazon Simple Email Service.
//
// Modifies an association between a configuration set and a custom domain for
// open and click event tracking.
//
// By default, images and links used for tracking open and click events are
// hosted on domains operated by Amazon SES. You can configure a subdomain of
// your own to handle these events. For information about using custom domains,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateConfigurationSetTrackingOptions for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//     Indicates that the configuration set does not exist.
//
//   - ErrCodeTrackingOptionsDoesNotExistException "TrackingOptionsDoesNotExistException"
//     Indicates that the TrackingOptions object you specified does not exist.
//
//   - ErrCodeInvalidTrackingOptionsException "InvalidTrackingOptions"
//     Indicates that the custom domain to be used for open and click tracking redirects
//     is invalid. This error appears most often in the following situations:
//
//   - When the tracking domain you specified is not verified in Amazon SES.
//
//   - When the tracking domain you specified is not a valid domain or subdomain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetTrackingOptions
func (c *SES) UpdateConfigurationSetTrackingOptions(input *UpdateConfigurationSetTrackingOptionsInput) (*UpdateConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.UpdateConfigurationSetTrackingOptionsRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetTrackingOptionsWithContext is the same as UpdateConfigurationSetTrackingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetTrackingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateConfigurationSetTrackingOptionsWithContext(ctx aws.Context, input *UpdateConfigurationSetTrackingOptionsInput, opts ...request.Option) (*UpdateConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.UpdateConfigurationSetTrackingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomVerificationEmailTemplate = "UpdateCustomVerificationEmailTemplate"

// UpdateCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomVerificationEmailTemplate for more information on using the UpdateCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCustomVerificationEmailTemplateRequest method.
//	req, resp := client.UpdateCustomVerificationEmailTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateCustomVerificationEmailTemplate
func (c *SES) UpdateCustomVerificationEmailTemplateRequest(input *UpdateCustomVerificationEmailTemplateInput) (req *request.Request, output *UpdateCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomVerificationEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomVerificationEmailTemplateInput{}
	}

	output = &UpdateCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Updates an existing custom verification email template.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateCustomVerificationEmailTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeCustomVerificationEmailTemplateDoesNotExistException "CustomVerificationEmailTemplateDoesNotExist"
//     Indicates that a custom verification email template with the name you specified
//     does not exist.
//
//   - ErrCodeFromEmailAddressNotVerifiedException "FromEmailAddressNotVerified"
//     Indicates that the sender address specified for a custom verification email
//     is not verified, and is therefore not eligible to send the custom verification
//     email.
//
//   - ErrCodeCustomVerificationEmailInvalidContentException "CustomVerificationEmailInvalidContent"
//     Indicates that custom verification email template provided content is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateCustomVerificationEmailTemplate
func (c *SES) UpdateCustomVerificationEmailTemplate(input *UpdateCustomVerificationEmailTemplateInput) (*UpdateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.UpdateCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// UpdateCustomVerificationEmailTemplateWithContext is the same as UpdateCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *UpdateCustomVerificationEmailTemplateInput, opts ...request.Option) (*UpdateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.UpdateCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReceiptRule = "UpdateReceiptRule"

// UpdateReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReceiptRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReceiptRule for more information on using the UpdateReceiptRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReceiptRuleRequest method.
//	req, resp := client.UpdateReceiptRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule
func (c *SES) UpdateReceiptRuleRequest(input *UpdateReceiptRuleInput) (req *request.Request, output *UpdateReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateReceiptRuleInput{}
	}

	output = &UpdateReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateReceiptRule API operation for Amazon Simple Email Service.
//
// Updates a receipt rule.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateReceiptRule for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidSnsTopicException "InvalidSnsTopic"
//     Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
//     could not publish to the topic, possibly due to permissions issues. For information
//     about giving permissions, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   - ErrCodeInvalidS3ConfigurationException "InvalidS3Configuration"
//     Indicates that the provided Amazon S3 bucket or Amazon Web Services KMS encryption
//     key is invalid, or that Amazon SES could not publish to the bucket, possibly
//     due to permissions issues. For information about giving permissions, see
//     the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   - ErrCodeInvalidLambdaFunctionException "InvalidLambdaFunction"
//     Indicates that the provided Amazon Web Services Lambda function is invalid,
//     or that Amazon SES could not execute the provided function, possibly due
//     to permissions issues. For information about giving permissions, see the
//     Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   - ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//     Indicates that the provided receipt rule set does not exist.
//
//   - ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//     Indicates that the provided receipt rule does not exist.
//
//   - ErrCodeLimitExceededException "LimitExceeded"
//     Indicates that a resource could not be created because of service limits.
//     For a list of Amazon SES limits, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule
func (c *SES) UpdateReceiptRule(input *UpdateReceiptRuleInput) (*UpdateReceiptRuleOutput, error) {
	req, out := c.UpdateReceiptRuleRequest(input)
	return out, req.Send()
}

// UpdateReceiptRuleWithContext is the same as UpdateReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateReceiptRuleWithContext(ctx aws.Context, input *UpdateReceiptRuleInput, opts ...request.Option) (*UpdateReceiptRuleOutput, error) {
	req, out := c.UpdateReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateRequest method.
//	req, resp := client.UpdateTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateTemplate
func (c *SES) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTemplate API operation for Amazon Simple Email Service.
//
// Updates an email template. Email templates enable you to send personalized
// email to one or more destinations in a single operation. For more information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeTemplateDoesNotExistException "TemplateDoesNotExist"
//     Indicates that the Template object you specified does not exist in your Amazon
//     SES account.
//
//   - ErrCodeInvalidTemplateException "InvalidTemplate"
//     Indicates that the template that you specified could not be rendered. This
//     issue may occur when a template refers to a partial that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateTemplate
func (c *SES) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyDomainDkim = "VerifyDomainDkim"

// VerifyDomainDkimRequest generates a "aws/request.Request" representing the
// client's request for the VerifyDomainDkim operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyDomainDkim for more information on using the VerifyDomainDkim
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyDomainDkimRequest method.
//	req, resp := client.VerifyDomainDkimRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim
func (c *SES) VerifyDomainDkimRequest(input *VerifyDomainDkimInput) (req *request.Request, output *VerifyDomainDkimOutput) {
	op := &request.Operation{
		Name:       opVerifyDomainDkim,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainDkimInput{}
	}

	output = &VerifyDomainDkimOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyDomainDkim API operation for Amazon Simple Email Service.
//
// Returns a set of DKIM tokens for a domain identity.
//
// When you execute the VerifyDomainDkim operation, the domain that you specify
// is added to the list of identities that are associated with your account.
// This is true even if you haven't already associated the domain with your
// account by using the VerifyDomainIdentity operation. However, you can't send
// email from the domain until you either successfully verify it (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#verify-domain-procedure)
// or you successfully set up DKIM for it (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
//
// You use the tokens that are generated by this operation to create CNAME records.
// When Amazon SES detects that you've added these records to the DNS configuration
// for a domain, you can start sending email from that domain. You can start
// sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity
// operation to the DNS configuration for your domain. All email that you send
// from the domain is authenticated using DKIM.
//
// To create the CNAME records for DKIM authentication, use the following values:
//
//   - Name: token._domainkey.example.com
//
//   - Type: CNAME
//
//   - Value: token.dkim.amazonses.com
//
// In the preceding example, replace token with one of the tokens that are generated
// when you execute this operation. Replace example.com with your domain. Repeat
// this process for each token that's generated by this operation.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyDomainDkim for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim
func (c *SES) VerifyDomainDkim(input *VerifyDomainDkimInput) (*VerifyDomainDkimOutput, error) {
	req, out := c.VerifyDomainDkimRequest(input)
	return out, req.Send()
}

// VerifyDomainDkimWithContext is the same as VerifyDomainDkim with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyDomainDkim for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyDomainDkimWithContext(ctx aws.Context, input *VerifyDomainDkimInput, opts ...request.Option) (*VerifyDomainDkimOutput, error) {
	req, out := c.VerifyDomainDkimRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyDomainIdentity = "VerifyDomainIdentity"

// VerifyDomainIdentityRequest generates a "aws/request.Request" representing the
// client's request for the VerifyDomainIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyDomainIdentity for more information on using the VerifyDomainIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyDomainIdentityRequest method.
//	req, resp := client.VerifyDomainIdentityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity
func (c *SES) VerifyDomainIdentityRequest(input *VerifyDomainIdentityInput) (req *request.Request, output *VerifyDomainIdentityOutput) {
	op := &request.Operation{
		Name:       opVerifyDomainIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainIdentityInput{}
	}

	output = &VerifyDomainIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyDomainIdentity API operation for Amazon Simple Email Service.
//
// Adds a domain to the list of identities for your Amazon SES account in the
// current Amazon Web Services Region and attempts to verify it. For more information
// about verifying domains, see Verifying Email Addresses and Domains (https://docs.aws.amazon.com/ses/latest/dg/verify-addresses-and-domains.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyDomainIdentity for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity
func (c *SES) VerifyDomainIdentity(input *VerifyDomainIdentityInput) (*VerifyDomainIdentityOutput, error) {
	req, out := c.VerifyDomainIdentityRequest(input)
	return out, req.Send()
}

// VerifyDomainIdentityWithContext is the same as VerifyDomainIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyDomainIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyDomainIdentityWithContext(ctx aws.Context, input *VerifyDomainIdentityInput, opts ...request.Option) (*VerifyDomainIdentityOutput, error) {
	req, out := c.VerifyDomainIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyEmailAddress = "VerifyEmailAddress"

// VerifyEmailAddressRequest generates a "aws/request.Request" representing the
// client's request for the VerifyEmailAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyEmailAddress for more information on using the VerifyEmailAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyEmailAddressRequest method.
//	req, resp := client.VerifyEmailAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress
func (c *SES) VerifyEmailAddressRequest(input *VerifyEmailAddressInput) (req *request.Request, output *VerifyEmailAddressOutput) {
	op := &request.Operation{
		Name:       opVerifyEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailAddressInput{}
	}

	output = &VerifyEmailAddressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// VerifyEmailAddress API operation for Amazon Simple Email Service.
//
// Deprecated. Use the VerifyEmailIdentity operation to verify a new email address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyEmailAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress
func (c *SES) VerifyEmailAddress(input *VerifyEmailAddressInput) (*VerifyEmailAddressOutput, error) {
	req, out := c.VerifyEmailAddressRequest(input)
	return out, req.Send()
}

// VerifyEmailAddressWithContext is the same as VerifyEmailAddress with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyEmailAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyEmailAddressWithContext(ctx aws.Context, input *VerifyEmailAddressInput, opts ...request.Option) (*VerifyEmailAddressOutput, error) {
	req, out := c.VerifyEmailAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyEmailIdentity = "VerifyEmailIdentity"

// VerifyEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the VerifyEmailIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyEmailIdentity for more information on using the VerifyEmailIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyEmailIdentityRequest method.
//	req, resp := client.VerifyEmailIdentityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity
func (c *SES) VerifyEmailIdentityRequest(input *VerifyEmailIdentityInput) (req *request.Request, output *VerifyEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opVerifyEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailIdentityInput{}
	}

	output = &VerifyEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// VerifyEmailIdentity API operation for Amazon Simple Email Service.
//
// Adds an email address to the list of identities for your Amazon SES account
// in the current Amazon Web Services Region and attempts to verify it. As a
// result of executing this operation, a verification email is sent to the specified
// address.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyEmailIdentity for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity
func (c *SES) VerifyEmailIdentity(input *VerifyEmailIdentityInput) (*VerifyEmailIdentityOutput, error) {
	req, out := c.VerifyEmailIdentityRequest(input)
	return out, req.Send()
}

// VerifyEmailIdentityWithContext is the same as VerifyEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyEmailIdentityWithContext(ctx aws.Context, input *VerifyEmailIdentityInput, opts ...request.Option) (*VerifyEmailIdentityOutput, error) {
	req, out := c.VerifyEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// When included in a receipt rule, this action adds a header to the received
// email.
//
// For information about adding a header using a receipt rule, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-add-header.html).
type AddHeaderAction struct {
	_ struct{} `type:"structure"`

	// The name of the header to add to the incoming message. The name must contain
	// at least one character, and can contain up to 50 characters. It consists
	// of alphanumeric (a–z, A–Z, 0–9) characters and dashes.
	//
	// HeaderName is a required field
	HeaderName *string `type:"string" required:"true"`

	// The content to include in the header. This value can contain up to 2048 characters.
	// It can't contain newline (\n) or carriage return (\r) characters.
	//
	// HeaderValue is a required field
	HeaderValue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddHeaderAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddHeaderAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddHeaderAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddHeaderAction"}
	if s.HeaderName == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderValue == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderName sets the HeaderName field's value.
func (s *AddHeaderAction) SetHeaderName(v string) *AddHeaderAction {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *AddHeaderAction) SetHeaderValue(v string) *AddHeaderAction {
	s.HeaderValue = &v
	return s
}

// Represents the body of the message. You can specify text, HTML, or both.
// If you use both, then the message should display correctly in the widest
// variety of email clients.
type Body struct {
	_ struct{} `type:"structure"`

	// The content of the message, in HTML format. Use this for email clients that
	// can process HTML. You can include clickable links, formatted text, and much
	// more in an HTML message.
	Html *Content `type:"structure"`

	// The content of the message, in text format. Use this for text-based email
	// clients, or clients on high-latency networks (such as mobile devices).
	Text *Content `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Body) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Body) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Body"}
	if s.Html != nil {
		if err := s.Html.Validate(); err != nil {
			invalidParams.AddNested("Html", err.(request.ErrInvalidParams))
		}
	}
	if s.Text != nil {
		if err := s.Text.Validate(); err != nil {
			invalidParams.AddNested("Text", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHtml sets the Html field's value.
func (s *Body) SetHtml(v *Content) *Body {
	s.Html = v
	return s
}

// SetText sets the Text field's value.
func (s *Body) SetText(v *Content) *Body {
	s.Text = v
	return s
}

// When included in a receipt rule, this action rejects the received email by
// returning a bounce response to the sender and, optionally, publishes a notification
// to Amazon Simple Notification Service (Amazon SNS).
//
// For information about sending a bounce message in response to a received
// email, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-bounce.html).
type BounceAction struct {
	_ struct{} `type:"structure"`

	// Human-readable text to include in the bounce message.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The email address of the sender of the bounced email. This is the address
	// from which the bounce message is sent.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The SMTP reply code, as defined by RFC 5321 (https://tools.ietf.org/html/rfc5321).
	//
	// SmtpReplyCode is a required field
	SmtpReplyCode *string `type:"string" required:"true"`

	// The SMTP enhanced status code, as defined by RFC 3463 (https://tools.ietf.org/html/rfc3463).
	StatusCode *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// bounce action is taken. You can find the ARN of a topic by using the ListTopics
	// (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation
	// in Amazon SNS.
	//
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BounceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BounceAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BounceAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BounceAction"}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Sender == nil {
		invalidParams.Add(request.NewErrParamRequired("Sender"))
	}
	if s.SmtpReplyCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SmtpReplyCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessage sets the Message field's value.
func (s *BounceAction) SetMessage(v string) *BounceAction {
	s.Message = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *BounceAction) SetSender(v string) *BounceAction {
	s.Sender = &v
	return s
}

// SetSmtpReplyCode sets the SmtpReplyCode field's value.
func (s *BounceAction) SetSmtpReplyCode(v string) *BounceAction {
	s.SmtpReplyCode = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *BounceAction) SetStatusCode(v string) *BounceAction {
	s.StatusCode = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *BounceAction) SetTopicArn(v string) *BounceAction {
	s.TopicArn = &v
	return s
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
type BouncedRecipientInfo struct {
	_ struct{} `type:"structure"`

	// The reason for the bounce. You must provide either this parameter or RecipientDsnFields.
	BounceType *string `type:"string" enum:"BounceType"`

	// The email address of the recipient of the bounced email.
	//
	// Recipient is a required field
	Recipient *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to receive email for the recipient of the bounced email. For more information
	// about sending authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	RecipientArn *string `type:"string"`

	// Recipient-related DSN fields, most of which would normally be filled in automatically
	// when provided with a BounceType. You must provide either this parameter or
	// BounceType.
	RecipientDsnFields *RecipientDsnFields `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BouncedRecipientInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BouncedRecipientInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BouncedRecipientInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BouncedRecipientInfo"}
	if s.Recipient == nil {
		invalidParams.Add(request.NewErrParamRequired("Recipient"))
	}
	if s.RecipientDsnFields != nil {
		if err := s.RecipientDsnFields.Validate(); err != nil {
			invalidParams.AddNested("RecipientDsnFields", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBounceType sets the BounceType field's value.
func (s *BouncedRecipientInfo) SetBounceType(v string) *BouncedRecipientInfo {
	s.BounceType = &v
	return s
}

// SetRecipient sets the Recipient field's value.
func (s *BouncedRecipientInfo) SetRecipient(v string) *BouncedRecipientInfo {
	s.Recipient = &v
	return s
}

// SetRecipientArn sets the RecipientArn field's value.
func (s *BouncedRecipientInfo) SetRecipientArn(v string) *BouncedRecipientInfo {
	s.RecipientArn = &v
	return s
}

// SetRecipientDsnFields sets the RecipientDsnFields field's value.
func (s *BouncedRecipientInfo) SetRecipientDsnFields(v *RecipientDsnFields) *BouncedRecipientInfo {
	s.RecipientDsnFields = v
	return s
}

// An array that contains one or more Destinations, as well as the tags and
// replacement data associated with each of those Destinations.
type BulkEmailDestination struct {
	_ struct{} `type:"structure"`

	// Represents the destination of the message, consisting of To:, CC:, and BCC:
	// fields.
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
	// (https://tools.ietf.org/html/rfc6531). For this reason, the email address
	// string must be 7-bit ASCII. If you want to send to or from email addresses
	// that contain Unicode characters in the domain part of an address, you must
	// encode the domain using Punycode. Punycode is not permitted in the local
	// part of the email address (the part before the @ sign) nor in the "friendly
	// from" name. If you want to use Unicode characters in the "friendly from"
	// name, you must encode the "friendly from" name using MIME encoded-word syntax,
	// as described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
	// For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492).
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using SendBulkTemplatedEmail. Tags correspond to characteristics
	// of the email that you define, so that you can publish email sending events.
	ReplacementTags []*MessageTag `type:"list"`

	// A list of replacement values to apply to the template. This parameter is
	// a JSON object, typically consisting of key-value pairs in which the keys
	// correspond to replacement tags in the email template.
	ReplacementTemplateData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkEmailDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkEmailDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BulkEmailDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BulkEmailDestination"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.ReplacementTags != nil {
		for i, v := range s.ReplacementTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplacementTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *BulkEmailDestination) SetDestination(v *Destination) *BulkEmailDestination {
	s.Destination = v
	return s
}

// SetReplacementTags sets the ReplacementTags field's value.
func (s *BulkEmailDestination) SetReplacementTags(v []*MessageTag) *BulkEmailDestination {
	s.ReplacementTags = v
	return s
}

// SetReplacementTemplateData sets the ReplacementTemplateData field's value.
func (s *BulkEmailDestination) SetReplacementTemplateData(v string) *BulkEmailDestination {
	s.ReplacementTemplateData = &v
	return s
}

// An object that contains the response from the SendBulkTemplatedEmail operation.
type BulkEmailDestinationStatus struct {
	_ struct{} `type:"structure"`

	// A description of an error that prevented a message being sent using the SendBulkTemplatedEmail
	// operation.
	Error *string `type:"string"`

	// The unique message identifier returned from the SendBulkTemplatedEmail operation.
	MessageId *string `type:"string"`

	// The status of a message sent using the SendBulkTemplatedEmail operation.
	//
	// Possible values for this parameter include:
	//
	//    * Success: Amazon SES accepted the message, and attempts to deliver it
	//    to the recipients.
	//
	//    * MessageRejected: The message was rejected because it contained a virus.
	//
	//    * MailFromDomainNotVerified: The sender's email address or domain was
	//    not verified.
	//
	//    * ConfigurationSetDoesNotExist: The configuration set you specified does
	//    not exist.
	//
	//    * TemplateDoesNotExist: The template you specified does not exist.
	//
	//    * AccountSuspended: Your account has been shut down because of issues
	//    related to your email sending practices.
	//
	//    * AccountThrottled: The number of emails you can send has been reduced
	//    because your account has exceeded its allocated sending limit.
	//
	//    * AccountDailyQuotaExceeded: You have reached or exceeded the maximum
	//    number of emails you can send from your account in a 24-hour period.
	//
	//    * InvalidSendingPoolName: The configuration set you specified refers to
	//    an IP pool that does not exist.
	//
	//    * AccountSendingPaused: Email sending for the Amazon SES account was disabled
	//    using the UpdateAccountSendingEnabled operation.
	//
	//    * ConfigurationSetSendingPaused: Email sending for this configuration
	//    set was disabled using the UpdateConfigurationSetSendingEnabled operation.
	//
	//    * InvalidParameterValue: One or more of the parameters you specified when
	//    calling this operation was invalid. See the error message for additional
	//    information.
	//
	//    * TransientFailure: Amazon SES was unable to process your request because
	//    of a temporary issue.
	//
	//    * Failed: Amazon SES was unable to process your request. See the error
	//    message for additional information.
	Status *string `type:"string" enum:"BulkEmailStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkEmailDestinationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BulkEmailDestinationStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BulkEmailDestinationStatus) SetError(v string) *BulkEmailDestinationStatus {
	s.Error = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *BulkEmailDestinationStatus) SetMessageId(v string) *BulkEmailDestinationStatus {
	s.MessageId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BulkEmailDestinationStatus) SetStatus(v string) *BulkEmailDestinationStatus {
	s.Status = &v
	return s
}

// Represents a request to create a receipt rule set by cloning an existing
// one. You use receipt rule sets to receive email with Amazon SES. For more
// information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type CloneReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule set to clone.
	//
	// OriginalRuleSetName is a required field
	OriginalRuleSetName *string `type:"string" required:"true"`

	// The name of the rule set to create. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain 64 characters or fewer.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloneReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloneReceiptRuleSetInput"}
	if s.OriginalRuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginalRuleSetName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginalRuleSetName sets the OriginalRuleSetName field's value.
func (s *CloneReceiptRuleSetInput) SetOriginalRuleSetName(v string) *CloneReceiptRuleSetInput {
	s.OriginalRuleSetName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CloneReceiptRuleSetInput) SetRuleSetName(v string) *CloneReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type CloneReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Contains information associated with an Amazon CloudWatch event destination
// to which email sending events are published.
//
// Event destinations, such as Amazon CloudWatch, are associated with configuration
// sets, which enable you to publish email sending events. For information about
// using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type CloudWatchDestination struct {
	_ struct{} `type:"structure"`

	// A list of dimensions upon which to categorize your emails when you publish
	// email sending events to Amazon CloudWatch.
	//
	// DimensionConfigurations is a required field
	DimensionConfigurations []*CloudWatchDimensionConfiguration `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDestination"}
	if s.DimensionConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionConfigurations"))
	}
	if s.DimensionConfigurations != nil {
		for i, v := range s.DimensionConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionConfigurations sets the DimensionConfigurations field's value.
func (s *CloudWatchDestination) SetDimensionConfigurations(v []*CloudWatchDimensionConfiguration) *CloudWatchDestination {
	s.DimensionConfigurations = v
	return s
}

// Contains the dimension configuration to use when you publish email sending
// events to Amazon CloudWatch.
//
// For information about publishing email sending events to Amazon CloudWatch,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type CloudWatchDimensionConfiguration struct {
	_ struct{} `type:"structure"`

	// The default value of the dimension that is published to Amazon CloudWatch
	// if you do not provide the value of the dimension when you send an email.
	// The default value must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    dashes (-), at signs (@), or periods (.).
	//
	//    * Contain 256 characters or fewer.
	//
	// DefaultDimensionValue is a required field
	DefaultDimensionValue *string `type:"string" required:"true"`

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    dashes (-), or colons (:).
	//
	//    * Contain 256 characters or fewer.
	//
	// DimensionName is a required field
	DimensionName *string `type:"string" required:"true"`

	// The place where Amazon SES finds the value of a dimension to publish to Amazon
	// CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS
	// header or a parameter to the SendEmail/SendRawEmail API, specify messageTag.
	// To use your own email headers, specify emailHeader. To put a custom tag on
	// any link included in your email, specify linkTag.
	//
	// DimensionValueSource is a required field
	DimensionValueSource *string `type:"string" required:"true" enum:"DimensionValueSource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchDimensionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchDimensionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDimensionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDimensionConfiguration"}
	if s.DefaultDimensionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultDimensionValue"))
	}
	if s.DimensionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionName"))
	}
	if s.DimensionValueSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionValueSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultDimensionValue sets the DefaultDimensionValue field's value.
func (s *CloudWatchDimensionConfiguration) SetDefaultDimensionValue(v string) *CloudWatchDimensionConfiguration {
	s.DefaultDimensionValue = &v
	return s
}

// SetDimensionName sets the DimensionName field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionName(v string) *CloudWatchDimensionConfiguration {
	s.DimensionName = &v
	return s
}

// SetDimensionValueSource sets the DimensionValueSource field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionValueSource(v string) *CloudWatchDimensionConfiguration {
	s.DimensionValueSource = &v
	return s
}

// The name of the configuration set.
//
// Configuration sets let you create groups of rules that you can apply to the
// emails you send using Amazon SES. For more information about using configuration
// sets, see Using Amazon SES Configuration Sets (https://docs.aws.amazon.com/ses/latest/dg/using-configuration-sets.html)
// in the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/).
type ConfigurationSet struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set. The name must meet the following requirements:
	//
	//    * Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or
	//    dashes (-).
	//
	//    * Contain 64 characters or fewer.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationSet"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ConfigurationSet) SetName(v string) *ConfigurationSet {
	s.Name = &v
	return s
}

// Represents textual data, plus an optional character set specification.
//
// By default, the text must be 7-bit ASCII, due to the constraints of the SMTP
// protocol. If the text must contain any other characters, then you must also
// specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
type Content struct {
	_ struct{} `type:"structure"`

	// The character set of the content.
	Charset *string `type:"string"`

	// The textual data of the content.
	//
	// Data is a required field
	Data *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Content) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Content"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCharset sets the Charset field's value.
func (s *Content) SetCharset(v string) *Content {
	s.Charset = &v
	return s
}

// SetData sets the Data field's value.
func (s *Content) SetData(v string) *Content {
	s.Data = &v
	return s
}

// Represents a request to create a configuration set event destination. A configuration
// set event destination, which can be either Amazon CloudWatch or Amazon Kinesis
// Firehose, describes an Amazon Web Services service in which Amazon SES publishes
// the email sending events associated with a configuration set. For information
// about using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type CreateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that the event destination should be associated
	// with.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// An object that describes the Amazon Web Services service that email sending
	// event where information is published.
	//
	// EventDestination is a required field
	EventDestination *EventDestination `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *CreateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestination) *CreateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// An empty element returned on a successful request.
type CreateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// Represents a request to create a configuration set. Configuration sets enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type CreateConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the name of the configuration set.
	//
	// ConfigurationSet is a required field
	ConfigurationSet *ConfigurationSet `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetInput"}
	if s.ConfigurationSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSet"))
	}
	if s.ConfigurationSet != nil {
		if err := s.ConfigurationSet.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *CreateConfigurationSetInput) SetConfigurationSet(v *ConfigurationSet) *CreateConfigurationSetInput {
	s.ConfigurationSet = v
	return s
}

// An empty element returned on a successful request.
type CreateConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetOutput) GoString() string {
	return s.String()
}

// Represents a request to create an open and click tracking option object in
// a configuration set.
type CreateConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that the tracking options should be associated
	// with.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// A domain that is used to redirect email recipients to an Amazon SES-operated
	// domain. This domain captures open and click events generated by Amazon SES
	// emails.
	//
	// For more information, see Configuring Custom Domains to Handle Open and Click
	// Tracking (https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html)
	// in the Amazon SES Developer Guide.
	//
	// TrackingOptions is a required field
	TrackingOptions *TrackingOptions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetTrackingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetTrackingOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.TrackingOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackingOptions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetTrackingOptionsInput) SetConfigurationSetName(v string) *CreateConfigurationSetTrackingOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetTrackingOptions sets the TrackingOptions field's value.
func (s *CreateConfigurationSetTrackingOptionsInput) SetTrackingOptions(v *TrackingOptions) *CreateConfigurationSetTrackingOptionsInput {
	s.TrackingOptions = v
	return s
}

// An empty element returned on a successful request.
type CreateConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfigurationSetTrackingOptionsOutput) GoString() string {
	return s.String()
}

// Represents a request to create a custom verification email template.
type CreateCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	//
	// FailureRedirectionURL is a required field
	FailureRedirectionURL *string `type:"string" required:"true"`

	// The email address that the custom verification email is sent from.
	//
	// FromEmailAddress is a required field
	FromEmailAddress *string `type:"string" required:"true"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	//
	// SuccessRedirectionURL is a required field
	SuccessRedirectionURL *string `type:"string" required:"true"`

	// The content of the custom verification email. The total size of the email
	// must be less than 10 MB. The message body may contain HTML, with some limitations.
	// For more information, see Custom Verification Email Frequently Asked Questions
	// (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
	// in the Amazon SES Developer Guide.
	//
	// TemplateContent is a required field
	TemplateContent *string `type:"string" required:"true"`

	// The name of the custom verification email template.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The subject line of the custom verification email.
	//
	// TemplateSubject is a required field
	TemplateSubject *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomVerificationEmailTemplateInput"}
	if s.FailureRedirectionURL == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureRedirectionURL"))
	}
	if s.FromEmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("FromEmailAddress"))
	}
	if s.SuccessRedirectionURL == nil {
		invalidParams.Add(request.NewErrParamRequired("SuccessRedirectionURL"))
	}
	if s.TemplateContent == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateContent"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateSubject == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateSubject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetFailureRedirectionURL(v string) *CreateCustomVerificationEmailTemplateInput {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetFromEmailAddress(v string) *CreateCustomVerificationEmailTemplateInput {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetSuccessRedirectionURL(v string) *CreateCustomVerificationEmailTemplateInput {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetTemplateContent(v string) *CreateCustomVerificationEmailTemplateInput {
	s.TemplateContent = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetTemplateName(v string) *CreateCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetTemplateSubject(v string) *CreateCustomVerificationEmailTemplateInput {
	s.TemplateSubject = &v
	return s
}

type CreateCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// Represents a request to create a new IP address filter. You use IP address
// filters when you receive email with Amazon SES. For more information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type CreateReceiptFilterInput struct {
	_ struct{} `type:"structure"`

	// A data structure that describes the IP address filter to create, which consists
	// of a name, an IP address range, and whether to allow or block mail from it.
	//
	// Filter is a required field
	Filter *ReceiptFilter `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReceiptFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReceiptFilterInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *CreateReceiptFilterInput) SetFilter(v *ReceiptFilter) *CreateReceiptFilterInput {
	s.Filter = v
	return s
}

// An empty element returned on a successful request.
type CreateReceiptFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptFilterOutput) GoString() string {
	return s.String()
}

// Represents a request to create a receipt rule. You use receipt rules to receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type CreateReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing rule after which the new rule is placed. If this
	// parameter is null, the new rule is inserted at the beginning of the rule
	// list.
	After *string `type:"string"`

	// A data structure that contains the specified rule's name, actions, recipients,
	// domains, enabled status, scan status, and TLS policy.
	//
	// Rule is a required field
	Rule *ReceiptRule `type:"structure" required:"true"`

	// The name of the rule set where the receipt rule is added.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReceiptRuleInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfter sets the After field's value.
func (s *CreateReceiptRuleInput) SetAfter(v string) *CreateReceiptRuleInput {
	s.After = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *CreateReceiptRuleInput) SetRule(v *ReceiptRule) *CreateReceiptRuleInput {
	s.Rule = v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CreateReceiptRuleInput) SetRuleSetName(v string) *CreateReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type CreateReceiptRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleOutput) GoString() string {
	return s.String()
}

// Represents a request to create an empty receipt rule set. You use receipt
// rule sets to receive email with Amazon SES. For more information, see the
// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type CreateReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule set to create. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain 64 characters or fewer.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReceiptRuleSetInput"}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CreateReceiptRuleSetInput) SetRuleSetName(v string) *CreateReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type CreateReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request to create an email template. For more information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// The content of the email, composed of a subject line and either an HTML part
	// or a text-only part.
	//
	// Template is a required field
	Template *Template `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateInput"}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil {
		if err := s.Template.Validate(); err != nil {
			invalidParams.AddNested("Template", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplate sets the Template field's value.
func (s *CreateTemplateInput) SetTemplate(v *Template) *CreateTemplateInput {
	s.Template = v
	return s
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) GoString() string {
	return s.String()
}

// Contains information about a custom verification email template.
type CustomVerificationEmailTemplate struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The name of the custom verification email template.
	TemplateName *string `type:"string"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVerificationEmailTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVerificationEmailTemplate) GoString() string {
	return s.String()
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *CustomVerificationEmailTemplate) SetFailureRedirectionURL(v string) *CustomVerificationEmailTemplate {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *CustomVerificationEmailTemplate) SetFromEmailAddress(v string) *CustomVerificationEmailTemplate {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *CustomVerificationEmailTemplate) SetSuccessRedirectionURL(v string) *CustomVerificationEmailTemplate {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CustomVerificationEmailTemplate) SetTemplateName(v string) *CustomVerificationEmailTemplate {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *CustomVerificationEmailTemplate) SetTemplateSubject(v string) *CustomVerificationEmailTemplate {
	s.TemplateSubject = &v
	return s
}

// Represents a request to delete a configuration set event destination. Configuration
// set event destinations are associated with configuration sets, which enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type DeleteConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set from which to delete the event destination.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// The name of the event destination to delete.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An empty element returned on a successful request.
type DeleteConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a configuration set. Configuration sets enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type DeleteConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to delete.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetInput) SetConfigurationSetName(v string) *DeleteConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// An empty element returned on a successful request.
type DeleteConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetOutput) GoString() string {
	return s.String()
}

// Represents a request to delete open and click tracking options in a configuration
// set.
type DeleteConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetTrackingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetTrackingOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetTrackingOptionsInput) SetConfigurationSetName(v string) *DeleteConfigurationSetTrackingOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// An empty element returned on a successful request.
type DeleteConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationSetTrackingOptionsOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an existing custom verification email template.
type DeleteCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom verification email template to delete.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomVerificationEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteCustomVerificationEmailTemplateInput) SetTemplateName(v string) *DeleteCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

type DeleteCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// Represents a request to delete one of your Amazon SES identities (an email
// address or domain).
type DeleteIdentityInput struct {
	_ struct{} `type:"structure"`

	// The identity to be removed from the list of identities for the Amazon Web
	// Services account.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *DeleteIdentityInput) SetIdentity(v string) *DeleteIdentityInput {
	s.Identity = &v
	return s
}

// An empty element returned on a successful request.
type DeleteIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a sending authorization policy for an identity.
// Sending authorization is an Amazon SES feature that enables you to authorize
// other senders to use your identities. For information, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
type DeleteIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity that is associated with the policy to delete. You can specify
	// the identity by using its name or by using its Amazon Resource Name (ARN).
	// Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this operation, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The name of the policy to be deleted.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityPolicyInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *DeleteIdentityPolicyInput) SetIdentity(v string) *DeleteIdentityPolicyInput {
	s.Identity = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteIdentityPolicyInput) SetPolicyName(v string) *DeleteIdentityPolicyInput {
	s.PolicyName = &v
	return s
}

// An empty element returned on a successful request.
type DeleteIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an IP address filter. You use IP address filters
// when you receive email with Amazon SES. For more information, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type DeleteReceiptFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the IP address filter to delete.
	//
	// FilterName is a required field
	FilterName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReceiptFilterInput"}
	if s.FilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterName sets the FilterName field's value.
func (s *DeleteReceiptFilterInput) SetFilterName(v string) *DeleteReceiptFilterInput {
	s.FilterName = &v
	return s
}

// An empty element returned on a successful request.
type DeleteReceiptFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptFilterOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a receipt rule. You use receipt rules to receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type DeleteReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule to delete.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that contains the receipt rule to delete.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReceiptRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteReceiptRuleInput) SetRuleName(v string) *DeleteReceiptRuleInput {
	s.RuleName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DeleteReceiptRuleInput) SetRuleSetName(v string) *DeleteReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type DeleteReceiptRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a receipt rule set and all of the receipt
// rules it contains. You use receipt rule sets to receive email with Amazon
// SES. For more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type DeleteReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to delete.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReceiptRuleSetInput"}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DeleteReceiptRuleSetInput) SetRuleSetName(v string) *DeleteReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type DeleteReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an email template. For more information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
type DeleteTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the template to be deleted.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteTemplateInput) SetTemplateName(v string) *DeleteTemplateInput {
	s.TemplateName = &v
	return s
}

type DeleteTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an email address from the list of email addresses
// you have attempted to verify under your Amazon Web Services account.
type DeleteVerifiedEmailAddressInput struct {
	_ struct{} `type:"structure"`

	// An email address to be removed from the list of verified addresses.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVerifiedEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVerifiedEmailAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVerifiedEmailAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVerifiedEmailAddressInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *DeleteVerifiedEmailAddressInput) SetEmailAddress(v string) *DeleteVerifiedEmailAddressInput {
	s.EmailAddress = &v
	return s
}

type DeleteVerifiedEmailAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVerifiedEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVerifiedEmailAddressOutput) GoString() string {
	return s.String()
}

// Specifies whether messages that use the configuration set are required to
// use Transport Layer Security (TLS).
type DeliveryOptions struct {
	_ struct{} `type:"structure"`

	// Specifies whether messages that use the configuration set are required to
	// use Transport Layer Security (TLS). If the value is Require, messages are
	// only delivered if a TLS connection can be established. If the value is Optional,
	// messages can be delivered in plain text if a TLS connection can't be established.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryOptions) GoString() string {
	return s.String()
}

// SetTlsPolicy sets the TlsPolicy field's value.
func (s *DeliveryOptions) SetTlsPolicy(v string) *DeliveryOptions {
	s.TlsPolicy = &v
	return s
}

// Represents a request to return the metadata and receipt rules for the receipt
// rule set that is currently active. You use receipt rule sets to receive email
// with Amazon SES. For more information, see the Amazon SES Developer Guide
// (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type DescribeActiveReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeActiveReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeActiveReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Represents the metadata and receipt rules for the receipt rule set that is
// currently active.
type DescribeActiveReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the currently active receipt rule set. The metadata consists
	// of the rule set name and a timestamp of when the rule set was created.
	Metadata *ReceiptRuleSetMetadata `type:"structure"`

	// The receipt rules that belong to the active rule set.
	Rules []*ReceiptRule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeActiveReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeActiveReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *DescribeActiveReceiptRuleSetOutput) SetMetadata(v *ReceiptRuleSetMetadata) *DescribeActiveReceiptRuleSetOutput {
	s.Metadata = v
	return s
}

// SetRules sets the Rules field's value.
func (s *DescribeActiveReceiptRuleSetOutput) SetRules(v []*ReceiptRule) *DescribeActiveReceiptRuleSetOutput {
	s.Rules = v
	return s
}

// Represents a request to return the details of a configuration set. Configuration
// sets enable you to publish email sending events. For information about using
// configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type DescribeConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration set attributes to return.
	ConfigurationSetAttributeNames []*string `type:"list" enum:"ConfigurationSetAttribute"`

	// The name of the configuration set to describe.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetAttributeNames sets the ConfigurationSetAttributeNames field's value.
func (s *DescribeConfigurationSetInput) SetConfigurationSetAttributeNames(v []*string) *DescribeConfigurationSetInput {
	s.ConfigurationSetAttributeNames = v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DescribeConfigurationSetInput) SetConfigurationSetName(v string) *DescribeConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// Represents the details of a configuration set. Configuration sets enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type DescribeConfigurationSetOutput struct {
	_ struct{} `type:"structure"`

	// The configuration set object associated with the specified configuration
	// set.
	ConfigurationSet *ConfigurationSet `type:"structure"`

	// Specifies whether messages that use the configuration set are required to
	// use Transport Layer Security (TLS).
	DeliveryOptions *DeliveryOptions `type:"structure"`

	// A list of event destinations associated with the configuration set.
	EventDestinations []*EventDestination `type:"list"`

	// An object that represents the reputation settings for the configuration set.
	ReputationOptions *ReputationOptions `type:"structure"`

	// The name of the custom open and click tracking domain associated with the
	// configuration set.
	TrackingOptions *TrackingOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationSetOutput) GoString() string {
	return s.String()
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *DescribeConfigurationSetOutput) SetConfigurationSet(v *ConfigurationSet) *DescribeConfigurationSetOutput {
	s.ConfigurationSet = v
	return s
}

// SetDeliveryOptions sets the DeliveryOptions field's value.
func (s *DescribeConfigurationSetOutput) SetDeliveryOptions(v *DeliveryOptions) *DescribeConfigurationSetOutput {
	s.DeliveryOptions = v
	return s
}

// SetEventDestinations sets the EventDestinations field's value.
func (s *DescribeConfigurationSetOutput) SetEventDestinations(v []*EventDestination) *DescribeConfigurationSetOutput {
	s.EventDestinations = v
	return s
}

// SetReputationOptions sets the ReputationOptions field's value.
func (s *DescribeConfigurationSetOutput) SetReputationOptions(v *ReputationOptions) *DescribeConfigurationSetOutput {
	s.ReputationOptions = v
	return s
}

// SetTrackingOptions sets the TrackingOptions field's value.
func (s *DescribeConfigurationSetOutput) SetTrackingOptions(v *TrackingOptions) *DescribeConfigurationSetOutput {
	s.TrackingOptions = v
	return s
}

// Represents a request to return the details of a receipt rule. You use receipt
// rules to receive email with Amazon SES. For more information, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type DescribeReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that the receipt rule belongs to.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReceiptRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DescribeReceiptRuleInput) SetRuleName(v string) *DescribeReceiptRuleInput {
	s.RuleName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DescribeReceiptRuleInput) SetRuleSetName(v string) *DescribeReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// Represents the details of a receipt rule.
type DescribeReceiptRuleOutput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the specified receipt rule's name, actions,
	// recipients, domains, enabled status, scan status, and Transport Layer Security
	// (TLS) policy.
	Rule *ReceiptRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *DescribeReceiptRuleOutput) SetRule(v *ReceiptRule) *DescribeReceiptRuleOutput {
	s.Rule = v
	return s
}

// Represents a request to return the details of a receipt rule set. You use
// receipt rule sets to receive email with Amazon SES. For more information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type DescribeReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to describe.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReceiptRuleSetInput"}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DescribeReceiptRuleSetInput) SetRuleSetName(v string) *DescribeReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// Represents the details of the specified receipt rule set.
type DescribeReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the receipt rule set, which consists of the rule set name
	// and the timestamp of when the rule set was created.
	Metadata *ReceiptRuleSetMetadata `type:"structure"`

	// A list of the receipt rules that belong to the specified receipt rule set.
	Rules []*ReceiptRule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *DescribeReceiptRuleSetOutput) SetMetadata(v *ReceiptRuleSetMetadata) *DescribeReceiptRuleSetOutput {
	s.Metadata = v
	return s
}

// SetRules sets the Rules field's value.
func (s *DescribeReceiptRuleSetOutput) SetRules(v []*ReceiptRule) *DescribeReceiptRuleSetOutput {
	s.Rules = v
	return s
}

// Represents the destination of the message, consisting of To:, CC:, and BCC:
// fields.
//
// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
// (https://tools.ietf.org/html/rfc6531). For this reason, the email address
// string must be 7-bit ASCII. If you want to send to or from email addresses
// that contain Unicode characters in the domain part of an address, you must
// encode the domain using Punycode. Punycode is not permitted in the local
// part of the email address (the part before the @ sign) nor in the "friendly
// from" name. If you want to use Unicode characters in the "friendly from"
// name, you must encode the "friendly from" name using MIME encoded-word syntax,
// as described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
// For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492).
type Destination struct {
	_ struct{} `type:"structure"`

	// The recipients to place on the BCC: line of the message.
	BccAddresses []*string `type:"list"`

	// The recipients to place on the CC: line of the message.
	CcAddresses []*string `type:"list"`

	// The recipients to place on the To: line of the message.
	ToAddresses []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// SetBccAddresses sets the BccAddresses field's value.
func (s *Destination) SetBccAddresses(v []*string) *Destination {
	s.BccAddresses = v
	return s
}

// SetCcAddresses sets the CcAddresses field's value.
func (s *Destination) SetCcAddresses(v []*string) *Destination {
	s.CcAddresses = v
	return s
}

// SetToAddresses sets the ToAddresses field's value.
func (s *Destination) SetToAddresses(v []*string) *Destination {
	s.ToAddresses = v
	return s
}

// Contains information about an event destination.
//
// When you create or update an event destination, you must provide one, and
// only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis
// Firehose or Amazon Simple Notification Service (Amazon SNS).
//
// Event destinations are associated with configuration sets, which enable you
// to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose,
// or Amazon Simple Notification Service (Amazon SNS). For information about
// using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that contains the names, default values, and sources of the dimensions
	// associated with an Amazon CloudWatch event destination.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// Sets whether Amazon SES publishes events to this destination when you send
	// an email with the associated configuration set. Set to true to enable publishing
	// to this destination; set to false to prevent publishing to this destination.
	// The default value is false.
	Enabled *bool `type:"boolean"`

	// An object that contains the delivery stream ARN and the IAM role ARN associated
	// with an Amazon Kinesis Firehose event destination.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// The type of email sending events to publish to the event destination.
	//
	//    * send - The call was successful and Amazon SES is attempting to deliver
	//    the email.
	//
	//    * reject - Amazon SES determined that the email contained a virus and
	//    rejected it.
	//
	//    * bounce - The recipient's mail server permanently rejected the email.
	//    This corresponds to a hard bounce.
	//
	//    * complaint - The recipient marked the email as spam.
	//
	//    * delivery - Amazon SES successfully delivered the email to the recipient's
	//    mail server.
	//
	//    * open - The recipient received the email and opened it in their email
	//    client.
	//
	//    * click - The recipient clicked one or more links in the email.
	//
	//    * renderingFailure - Amazon SES did not send the email because of a template
	//    rendering issue.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []*string `type:"list" required:"true" enum:"EventType"`

	// The name of the event destination. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain 64 characters or fewer.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An object that contains the topic ARN associated with an Amazon Simple Notification
	// Service (Amazon SNS) event destination.
	SNSDestination *SNSDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventDestination"}
	if s.MatchingEventTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchingEventTypes"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.CloudWatchDestination != nil {
		if err := s.CloudWatchDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.SNSDestination != nil {
		if err := s.SNSDestination.Validate(); err != nil {
			invalidParams.AddNested("SNSDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchDestination sets the CloudWatchDestination field's value.
func (s *EventDestination) SetCloudWatchDestination(v *CloudWatchDestination) *EventDestination {
	s.CloudWatchDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestination) SetEnabled(v bool) *EventDestination {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestination) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestination {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestination) SetMatchingEventTypes(v []*string) *EventDestination {
	s.MatchingEventTypes = v
	return s
}

// SetName sets the Name field's value.
func (s *EventDestination) SetName(v string) *EventDestination {
	s.Name = &v
	return s
}

// SetSNSDestination sets the SNSDestination field's value.
func (s *EventDestination) SetSNSDestination(v *SNSDestination) *EventDestination {
	s.SNSDestination = v
	return s
}

// Additional X-headers to include in the Delivery Status Notification (DSN)
// when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
type ExtensionField struct {
	_ struct{} `type:"structure"`

	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the header to add. Must contain 2048 characters or fewer, and
	// must not contain newline characters ("\r" or "\n").
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtensionField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtensionField"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ExtensionField) SetName(v string) *ExtensionField {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExtensionField) SetValue(v string) *ExtensionField {
	s.Value = &v
	return s
}

type GetAccountSendingEnabledInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSendingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSendingEnabledInput) GoString() string {
	return s.String()
}

// Represents a request to return the email sending status for your Amazon SES
// account in the current Amazon Web Services Region.
type GetAccountSendingEnabledOutput struct {
	_ struct{} `type:"structure"`

	// Describes whether email sending is enabled or disabled for your Amazon SES
	// account in the current Amazon Web Services Region.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSendingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSendingEnabledOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *GetAccountSendingEnabledOutput) SetEnabled(v bool) *GetAccountSendingEnabledOutput {
	s.Enabled = &v
	return s
}

// Represents a request to retrieve an existing custom verification email template.
type GetCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom verification email template to retrieve.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCustomVerificationEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetCustomVerificationEmailTemplateInput) SetTemplateName(v string) *GetCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// The content of the custom verification email template.
type GetCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The content of the custom verification email.
	TemplateContent *string `type:"string"`

	// The name of the custom verification email template.
	TemplateName *string `type:"string"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetFailureRedirectionURL(v string) *GetCustomVerificationEmailTemplateOutput {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetFromEmailAddress(v string) *GetCustomVerificationEmailTemplateOutput {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetSuccessRedirectionURL(v string) *GetCustomVerificationEmailTemplateOutput {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetTemplateContent(v string) *GetCustomVerificationEmailTemplateOutput {
	s.TemplateContent = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetTemplateName(v string) *GetCustomVerificationEmailTemplateOutput {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetTemplateSubject(v string) *GetCustomVerificationEmailTemplateOutput {
	s.TemplateSubject = &v
	return s
}

// Represents a request for the status of Amazon SES Easy DKIM signing for an
// identity. For domain identities, this request also returns the DKIM tokens
// that are required for Easy DKIM signing, and whether Amazon SES successfully
// verified that these tokens were published. For more information about Easy
// DKIM, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
type GetIdentityDkimAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of one or more verified identities - email addresses, domains, or
	// both.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityDkimAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityDkimAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityDkimAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityDkimAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityDkimAttributesInput) SetIdentities(v []*string) *GetIdentityDkimAttributesInput {
	s.Identities = v
	return s
}

// Represents the status of Amazon SES Easy DKIM signing for an identity. For
// domain identities, this response also contains the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES successfully verified that
// these tokens were published.
type GetIdentityDkimAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The DKIM attributes for an email address or a domain.
	//
	// DkimAttributes is a required field
	DkimAttributes map[string]*IdentityDkimAttributes `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityDkimAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityDkimAttributesOutput) GoString() string {
	return s.String()
}

// SetDkimAttributes sets the DkimAttributes field's value.
func (s *GetIdentityDkimAttributesOutput) SetDkimAttributes(v map[string]*IdentityDkimAttributes) *GetIdentityDkimAttributesOutput {
	s.DkimAttributes = v
	return s
}

// Represents a request to return the Amazon SES custom MAIL FROM attributes
// for a list of identities. For information about using a custom MAIL FROM
// domain, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/mail-from.html).
type GetIdentityMailFromDomainAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of one or more identities.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityMailFromDomainAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityMailFromDomainAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityMailFromDomainAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityMailFromDomainAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityMailFromDomainAttributesInput) SetIdentities(v []*string) *GetIdentityMailFromDomainAttributesInput {
	s.Identities = v
	return s
}

// Represents the custom MAIL FROM attributes for a list of identities.
type GetIdentityMailFromDomainAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of identities to custom MAIL FROM attributes.
	//
	// MailFromDomainAttributes is a required field
	MailFromDomainAttributes map[string]*IdentityMailFromDomainAttributes `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityMailFromDomainAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityMailFromDomainAttributesOutput) GoString() string {
	return s.String()
}

// SetMailFromDomainAttributes sets the MailFromDomainAttributes field's value.
func (s *GetIdentityMailFromDomainAttributesOutput) SetMailFromDomainAttributes(v map[string]*IdentityMailFromDomainAttributes) *GetIdentityMailFromDomainAttributesOutput {
	s.MailFromDomainAttributes = v
	return s
}

// Represents a request to return the notification attributes for a list of
// identities you verified with Amazon SES. For information about Amazon SES
// notifications, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications.html).
type GetIdentityNotificationAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of one or more identities. You can specify an identity by using its
	// name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityNotificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityNotificationAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityNotificationAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityNotificationAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityNotificationAttributesInput) SetIdentities(v []*string) *GetIdentityNotificationAttributesInput {
	s.Identities = v
	return s
}

// Represents the notification attributes for a list of identities.
type GetIdentityNotificationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of Identity to IdentityNotificationAttributes.
	//
	// NotificationAttributes is a required field
	NotificationAttributes map[string]*IdentityNotificationAttributes `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityNotificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityNotificationAttributesOutput) GoString() string {
	return s.String()
}

// SetNotificationAttributes sets the NotificationAttributes field's value.
func (s *GetIdentityNotificationAttributesOutput) SetNotificationAttributes(v map[string]*IdentityNotificationAttributes) *GetIdentityNotificationAttributesOutput {
	s.NotificationAttributes = v
	return s
}

// Represents a request to return the requested sending authorization policies
// for an identity. Sending authorization is an Amazon SES feature that enables
// you to authorize other senders to use your identities. For information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
type GetIdentityPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The identity for which the policies are retrieved. You can specify an identity
	// by using its name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this operation, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// A list of the names of policies to be retrieved. You can retrieve a maximum
	// of 20 policies at a time. If you do not know the names of the policies that
	// are attached to the identity, you can use ListIdentityPolicies.
	//
	// PolicyNames is a required field
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityPoliciesInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.PolicyNames == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *GetIdentityPoliciesInput) SetIdentity(v string) *GetIdentityPoliciesInput {
	s.Identity = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *GetIdentityPoliciesInput) SetPolicyNames(v []*string) *GetIdentityPoliciesInput {
	s.PolicyNames = v
	return s
}

// Represents the requested sending authorization policies.
type GetIdentityPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A map of policy names to policies.
	//
	// Policies is a required field
	Policies map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityPoliciesOutput) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *GetIdentityPoliciesOutput) SetPolicies(v map[string]*string) *GetIdentityPoliciesOutput {
	s.Policies = v
	return s
}

// Represents a request to return the Amazon SES verification status of a list
// of identities. For domain identities, this request also returns the verification
// token. For information about verifying identities with Amazon SES, see the
// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
type GetIdentityVerificationAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of identities.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityVerificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityVerificationAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityVerificationAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityVerificationAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityVerificationAttributesInput) SetIdentities(v []*string) *GetIdentityVerificationAttributesInput {
	s.Identities = v
	return s
}

// The Amazon SES verification status of a list of identities. For domain identities,
// this response also contains the verification token.
type GetIdentityVerificationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of Identities to IdentityVerificationAttributes objects.
	//
	// VerificationAttributes is a required field
	VerificationAttributes map[string]*IdentityVerificationAttributes `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityVerificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdentityVerificationAttributesOutput) GoString() string {
	return s.String()
}

// SetVerificationAttributes sets the VerificationAttributes field's value.
func (s *GetIdentityVerificationAttributesOutput) SetVerificationAttributes(v map[string]*IdentityVerificationAttributes) *GetIdentityVerificationAttributesOutput {
	s.VerificationAttributes = v
	return s
}

type GetSendQuotaInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendQuotaInput) GoString() string {
	return s.String()
}

// Represents your Amazon SES daily sending quota, maximum send rate, and the
// number of emails you have sent in the last 24 hours.
type GetSendQuotaOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of emails the user is allowed to send in a 24-hour interval.
	// A value of -1 signifies an unlimited quota.
	Max24HourSend *float64 `type:"double"`

	// The maximum number of emails that Amazon SES can accept from the user's account
	// per second.
	//
	// The rate at which Amazon SES accepts the user's messages might be less than
	// the maximum send rate.
	MaxSendRate *float64 `type:"double"`

	// The number of emails sent during the previous 24 hours.
	SentLast24Hours *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendQuotaOutput) GoString() string {
	return s.String()
}

// SetMax24HourSend sets the Max24HourSend field's value.
func (s *GetSendQuotaOutput) SetMax24HourSend(v float64) *GetSendQuotaOutput {
	s.Max24HourSend = &v
	return s
}

// SetMaxSendRate sets the MaxSendRate field's value.
func (s *GetSendQuotaOutput) SetMaxSendRate(v float64) *GetSendQuotaOutput {
	s.MaxSendRate = &v
	return s
}

// SetSentLast24Hours sets the SentLast24Hours field's value.
func (s *GetSendQuotaOutput) SetSentLast24Hours(v float64) *GetSendQuotaOutput {
	s.SentLast24Hours = &v
	return s
}

type GetSendStatisticsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendStatisticsInput) GoString() string {
	return s.String()
}

// Represents a list of data points. This list contains aggregated data from
// the previous two weeks of your sending activity with Amazon SES.
type GetSendStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// A list of data points, each of which represents 15 minutes of activity.
	SendDataPoints []*SendDataPoint `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSendStatisticsOutput) GoString() string {
	return s.String()
}

// SetSendDataPoints sets the SendDataPoints field's value.
func (s *GetSendStatisticsOutput) SetSendDataPoints(v []*SendDataPoint) *GetSendStatisticsOutput {
	s.SendDataPoints = v
	return s
}

type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the template to retrieve.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetTemplateInput) SetTemplateName(v string) *GetTemplateInput {
	s.TemplateName = &v
	return s
}

type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The content of the email, composed of a subject line and either an HTML part
	// or a text-only part.
	Template *Template `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SetTemplate sets the Template field's value.
func (s *GetTemplateOutput) SetTemplate(v *Template) *GetTemplateOutput {
	s.Template = v
	return s
}

// Represents the DKIM attributes of a verified email address or a domain.
type IdentityDkimAttributes struct {
	_ struct{} `type:"structure"`

	// Is true if DKIM signing is enabled for email sent from the identity. It's
	// false otherwise. The default value is true.
	//
	// DkimEnabled is a required field
	DkimEnabled *bool `type:"boolean" required:"true"`

	// A set of character strings that represent the domain's identity. Using these
	// tokens, you need to create DNS CNAME records that point to DKIM public keys
	// that are hosted by Amazon SES. Amazon Web Services eventually detects that
	// you've updated your DNS records. This detection process might take up to
	// 72 hours. After successful detection, Amazon SES is able to DKIM-sign email
	// originating from that domain. (This only applies to domain identities, not
	// email address identities.)
	//
	// For more information about creating DNS records using DKIM tokens, see the
	// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
	DkimTokens []*string `type:"list"`

	// Describes whether Amazon SES has successfully verified the DKIM DNS records
	// (tokens) published in the domain name's DNS. (This only applies to domain
	// identities, not email address identities.)
	//
	// DkimVerificationStatus is a required field
	DkimVerificationStatus *string `type:"string" required:"true" enum:"VerificationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityDkimAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityDkimAttributes) GoString() string {
	return s.String()
}

// SetDkimEnabled sets the DkimEnabled field's value.
func (s *IdentityDkimAttributes) SetDkimEnabled(v bool) *IdentityDkimAttributes {
	s.DkimEnabled = &v
	return s
}

// SetDkimTokens sets the DkimTokens field's value.
func (s *IdentityDkimAttributes) SetDkimTokens(v []*string) *IdentityDkimAttributes {
	s.DkimTokens = v
	return s
}

// SetDkimVerificationStatus sets the DkimVerificationStatus field's value.
func (s *IdentityDkimAttributes) SetDkimVerificationStatus(v string) *IdentityDkimAttributes {
	s.DkimVerificationStatus = &v
	return s
}

// Represents the custom MAIL FROM domain attributes of a verified identity
// (email address or domain).
type IdentityMailFromDomainAttributes struct {
	_ struct{} `type:"structure"`

	// The action that Amazon SES takes if it cannot successfully read the required
	// MX record when you send an email. A value of UseDefaultValue indicates that
	// if Amazon SES cannot read the required MX record, it uses amazonses.com (or
	// a subdomain of that) as the MAIL FROM domain. A value of RejectMessage indicates
	// that if Amazon SES cannot read the required MX record, Amazon SES returns
	// a MailFromDomainNotVerified error and does not send the email.
	//
	// The custom MAIL FROM setup states that result in this behavior are Pending,
	// Failed, and TemporaryFailure.
	//
	// BehaviorOnMXFailure is a required field
	BehaviorOnMXFailure *string `type:"string" required:"true" enum:"BehaviorOnMXFailure"`

	// The custom MAIL FROM domain that the identity is configured to use.
	//
	// MailFromDomain is a required field
	MailFromDomain *string `type:"string" required:"true"`

	// The state that indicates whether Amazon SES has successfully read the MX
	// record required for custom MAIL FROM domain setup. If the state is Success,
	// Amazon SES uses the specified custom MAIL FROM domain when the verified identity
	// sends an email. All other states indicate that Amazon SES takes the action
	// described by BehaviorOnMXFailure.
	//
	// MailFromDomainStatus is a required field
	MailFromDomainStatus *string `type:"string" required:"true" enum:"CustomMailFromStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityMailFromDomainAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityMailFromDomainAttributes) GoString() string {
	return s.String()
}

// SetBehaviorOnMXFailure sets the BehaviorOnMXFailure field's value.
func (s *IdentityMailFromDomainAttributes) SetBehaviorOnMXFailure(v string) *IdentityMailFromDomainAttributes {
	s.BehaviorOnMXFailure = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *IdentityMailFromDomainAttributes) SetMailFromDomain(v string) *IdentityMailFromDomainAttributes {
	s.MailFromDomain = &v
	return s
}

// SetMailFromDomainStatus sets the MailFromDomainStatus field's value.
func (s *IdentityMailFromDomainAttributes) SetMailFromDomainStatus(v string) *IdentityMailFromDomainAttributes {
	s.MailFromDomainStatus = &v
	return s
}

// Represents the notification attributes of an identity, including whether
// an identity has Amazon Simple Notification Service (Amazon SNS) topics set
// for bounce, complaint, and/or delivery notifications, and whether feedback
// forwarding is enabled for bounce and complaint notifications.
type IdentityNotificationAttributes struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes
	// bounce notifications.
	//
	// BounceTopic is a required field
	BounceTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes
	// complaint notifications.
	//
	// ComplaintTopic is a required field
	ComplaintTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes
	// delivery notifications.
	//
	// DeliveryTopic is a required field
	DeliveryTopic *string `type:"string" required:"true"`

	// Describes whether Amazon SES forwards bounce and complaint notifications
	// as email. true indicates that Amazon SES forwards bounce and complaint notifications
	// as email, while false indicates that bounce and complaint notifications are
	// published only to the specified bounce and complaint Amazon SNS topics.
	//
	// ForwardingEnabled is a required field
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Bounce. A value of true specifies that Amazon SES
	// includes headers in bounce notifications, and a value of false specifies
	// that Amazon SES does not include headers in bounce notifications.
	HeadersInBounceNotificationsEnabled *bool `type:"boolean"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Complaint. A value of true specifies that Amazon
	// SES includes headers in complaint notifications, and a value of false specifies
	// that Amazon SES does not include headers in complaint notifications.
	HeadersInComplaintNotificationsEnabled *bool `type:"boolean"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Delivery. A value of true specifies that Amazon
	// SES includes headers in delivery notifications, and a value of false specifies
	// that Amazon SES does not include headers in delivery notifications.
	HeadersInDeliveryNotificationsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityNotificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityNotificationAttributes) GoString() string {
	return s.String()
}

// SetBounceTopic sets the BounceTopic field's value.
func (s *IdentityNotificationAttributes) SetBounceTopic(v string) *IdentityNotificationAttributes {
	s.BounceTopic = &v
	return s
}

// SetComplaintTopic sets the ComplaintTopic field's value.
func (s *IdentityNotificationAttributes) SetComplaintTopic(v string) *IdentityNotificationAttributes {
	s.ComplaintTopic = &v
	return s
}

// SetDeliveryTopic sets the DeliveryTopic field's value.
func (s *IdentityNotificationAttributes) SetDeliveryTopic(v string) *IdentityNotificationAttributes {
	s.DeliveryTopic = &v
	return s
}

// SetForwardingEnabled sets the ForwardingEnabled field's value.
func (s *IdentityNotificationAttributes) SetForwardingEnabled(v bool) *IdentityNotificationAttributes {
	s.ForwardingEnabled = &v
	return s
}

// SetHeadersInBounceNotificationsEnabled sets the HeadersInBounceNotificationsEnabled field's value.
func (s *IdentityNotificationAttributes) SetHeadersInBounceNotificationsEnabled(v bool) *IdentityNotificationAttributes {
	s.HeadersInBounceNotificationsEnabled = &v
	return s
}

// SetHeadersInComplaintNotificationsEnabled sets the HeadersInComplaintNotificationsEnabled field's value.
func (s *IdentityNotificationAttributes) SetHeadersInComplaintNotificationsEnabled(v bool) *IdentityNotificationAttributes {
	s.HeadersInComplaintNotificationsEnabled = &v
	return s
}

// SetHeadersInDeliveryNotificationsEnabled sets the HeadersInDeliveryNotificationsEnabled field's value.
func (s *IdentityNotificationAttributes) SetHeadersInDeliveryNotificationsEnabled(v bool) *IdentityNotificationAttributes {
	s.HeadersInDeliveryNotificationsEnabled = &v
	return s
}

// Represents the verification attributes of a single identity.
type IdentityVerificationAttributes struct {
	_ struct{} `type:"structure"`

	// The verification status of the identity: "Pending", "Success", "Failed",
	// or "TemporaryFailure".
	//
	// VerificationStatus is a required field
	VerificationStatus *string `type:"string" required:"true" enum:"VerificationStatus"`

	// The verification token for a domain identity. Null for email address identities.
	VerificationToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityVerificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityVerificationAttributes) GoString() string {
	return s.String()
}

// SetVerificationStatus sets the VerificationStatus field's value.
func (s *IdentityVerificationAttributes) SetVerificationStatus(v string) *IdentityVerificationAttributes {
	s.VerificationStatus = &v
	return s
}

// SetVerificationToken sets the VerificationToken field's value.
func (s *IdentityVerificationAttributes) SetVerificationToken(v string) *IdentityVerificationAttributes {
	s.VerificationToken = &v
	return s
}

// Contains the delivery stream ARN and the IAM role ARN associated with an
// Amazon Kinesis Firehose event destination.
//
// Event destinations, such as Amazon Kinesis Firehose, are associated with
// configuration sets, which enable you to publish email sending events. For
// information about using configuration sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Kinesis Firehose stream that email sending events should
	// be published to.
	//
	// DeliveryStreamARN is a required field
	DeliveryStreamARN *string `type:"string" required:"true"`

	// The ARN of the IAM role under which Amazon SES publishes email sending events
	// to the Amazon Kinesis Firehose stream.
	//
	// IAMRoleARN is a required field
	IAMRoleARN *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseDestination"}
	if s.DeliveryStreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamARN"))
	}
	if s.IAMRoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("IAMRoleARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamARN sets the DeliveryStreamARN field's value.
func (s *KinesisFirehoseDestination) SetDeliveryStreamARN(v string) *KinesisFirehoseDestination {
	s.DeliveryStreamARN = &v
	return s
}

// SetIAMRoleARN sets the IAMRoleARN field's value.
func (s *KinesisFirehoseDestination) SetIAMRoleARN(v string) *KinesisFirehoseDestination {
	s.IAMRoleARN = &v
	return s
}

// When included in a receipt rule, this action calls an Amazon Web Services
// Lambda function and, optionally, publishes a notification to Amazon Simple
// Notification Service (Amazon SNS).
//
// To enable Amazon SES to call your Amazon Web Services Lambda function or
// to publish to an Amazon SNS topic of another account, Amazon SES must have
// permission to access those resources. For information about giving permissions,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html).
//
// For information about using Amazon Web Services Lambda actions in receipt
// rules, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-lambda.html).
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function.
	// An example of an Amazon Web Services Lambda function ARN is arn:aws:lambda:us-west-2:account-id:function:MyFunction.
	// For more information about Amazon Web Services Lambda, see the Amazon Web
	// Services Lambda Developer Guide (https://docs.aws.amazon.com/lambda/latest/dg/welcome.html).
	//
	// FunctionArn is a required field
	FunctionArn *string `type:"string" required:"true"`

	// The invocation type of the Amazon Web Services Lambda function. An invocation
	// type of RequestResponse means that the execution of the function immediately
	// results in a response, and a value of Event means that the function is invoked
	// asynchronously. The default value is Event. For information about Amazon
	// Web Services Lambda invocation types, see the Amazon Web Services Lambda
	// Developer Guide (https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html).
	//
	// There is a 30-second timeout on RequestResponse invocations. You should use
	// Event invocation in most cases. Use RequestResponse only to make a mail flow
	// decision, such as whether to stop the receipt rule or the receipt rule set.
	InvocationType *string `type:"string" enum:"InvocationType"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// Lambda action is executed. You can find the ARN of a topic by using the ListTopics
	// (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation
	// in Amazon SNS.
	//
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaAction"}
	if s.FunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *LambdaAction) SetFunctionArn(v string) *LambdaAction {
	s.FunctionArn = &v
	return s
}

// SetInvocationType sets the InvocationType field's value.
func (s *LambdaAction) SetInvocationType(v string) *LambdaAction {
	s.InvocationType = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *LambdaAction) SetTopicArn(v string) *LambdaAction {
	s.TopicArn = &v
	return s
}

// Represents a request to list the configuration sets associated with your
// Amazon Web Services account. Configuration sets enable you to publish email
// sending events. For information about using configuration sets, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type ListConfigurationSetsInput struct {
	_ struct{} `type:"structure"`

	// The number of configuration sets to return.
	MaxItems *int64 `type:"integer"`

	// A token returned from a previous call to ListConfigurationSets to indicate
	// the position of the configuration set in the configuration set list.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsInput) GoString() string {
	return s.String()
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListConfigurationSetsInput) SetMaxItems(v int64) *ListConfigurationSetsInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsInput) SetNextToken(v string) *ListConfigurationSetsInput {
	s.NextToken = &v
	return s
}

// A list of configuration sets associated with your Amazon Web Services account.
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type ListConfigurationSetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of configuration sets.
	ConfigurationSets []*ConfigurationSet `type:"list"`

	// A token indicating that there are additional configuration sets available
	// to be listed. Pass this token to successive calls of ListConfigurationSets.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfigurationSetsOutput) GoString() string {
	return s.String()
}

// SetConfigurationSets sets the ConfigurationSets field's value.
func (s *ListConfigurationSetsOutput) SetConfigurationSets(v []*ConfigurationSet) *ListConfigurationSetsOutput {
	s.ConfigurationSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsOutput) SetNextToken(v string) *ListConfigurationSetsOutput {
	s.NextToken = &v
	return s
}

// Represents a request to list the existing custom verification email templates
// for your account.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
// in the Amazon SES Developer Guide.
type ListCustomVerificationEmailTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom verification email templates to return. This
	// value must be at least 1 and less than or equal to 50. If you do not specify
	// a value, or if you specify a value less than 1 or greater than 50, the operation
	// returns up to 50 results.
	MaxResults *int64 `min:"1" type:"integer"`

	// An array the contains the name and creation time stamp for each template
	// in your Amazon SES account.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVerificationEmailTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVerificationEmailTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomVerificationEmailTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomVerificationEmailTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomVerificationEmailTemplatesInput) SetMaxResults(v int64) *ListCustomVerificationEmailTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomVerificationEmailTemplatesInput) SetNextToken(v string) *ListCustomVerificationEmailTemplatesInput {
	s.NextToken = &v
	return s
}

// A paginated list of custom verification email templates.
type ListCustomVerificationEmailTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the custom verification email templates that exist in your account.
	CustomVerificationEmailTemplates []*CustomVerificationEmailTemplate `type:"list"`

	// A token indicating that there are additional custom verification email templates
	// available to be listed. Pass this token to a subsequent call to ListTemplates
	// to retrieve the next 50 custom verification email templates.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVerificationEmailTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVerificationEmailTemplatesOutput) GoString() string {
	return s.String()
}

// SetCustomVerificationEmailTemplates sets the CustomVerificationEmailTemplates field's value.
func (s *ListCustomVerificationEmailTemplatesOutput) SetCustomVerificationEmailTemplates(v []*CustomVerificationEmailTemplate) *ListCustomVerificationEmailTemplatesOutput {
	s.CustomVerificationEmailTemplates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomVerificationEmailTemplatesOutput) SetNextToken(v string) *ListCustomVerificationEmailTemplatesOutput {
	s.NextToken = &v
	return s
}

// Represents a request to return a list of all identities (email addresses
// and domains) that you have attempted to verify under your Amazon Web Services
// account, regardless of verification status.
type ListIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// The type of the identities to list. Possible values are "EmailAddress" and
	// "Domain". If this parameter is omitted, then all identities are listed.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The maximum number of identities per page. Possible values are 1-1000 inclusive.
	MaxItems *int64 `type:"integer"`

	// The token to use for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitiesInput) GoString() string {
	return s.String()
}

// SetIdentityType sets the IdentityType field's value.
func (s *ListIdentitiesInput) SetIdentityType(v string) *ListIdentitiesInput {
	s.IdentityType = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListIdentitiesInput) SetMaxItems(v int64) *ListIdentitiesInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitiesInput) SetNextToken(v string) *ListIdentitiesInput {
	s.NextToken = &v
	return s
}

// A list of all identities that you have attempted to verify under your Amazon
// Web Services account, regardless of verification status.
type ListIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// A list of identities.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`

	// The token used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentitiesOutput) GoString() string {
	return s.String()
}

// SetIdentities sets the Identities field's value.
func (s *ListIdentitiesOutput) SetIdentities(v []*string) *ListIdentitiesOutput {
	s.Identities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitiesOutput) SetNextToken(v string) *ListIdentitiesOutput {
	s.NextToken = &v
	return s
}

// Represents a request to return a list of sending authorization policies that
// are attached to an identity. Sending authorization is an Amazon SES feature
// that enables you to authorize other senders to use your identities. For information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
type ListIdentityPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The identity that is associated with the policy for which the policies are
	// listed. You can specify an identity by using its name or by using its Amazon
	// Resource Name (ARN). Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this operation, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityPoliciesInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *ListIdentityPoliciesInput) SetIdentity(v string) *ListIdentityPoliciesInput {
	s.Identity = &v
	return s
}

// A list of names of sending authorization policies that apply to an identity.
type ListIdentityPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of names of policies that apply to the specified identity.
	//
	// PolicyNames is a required field
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityPoliciesOutput) GoString() string {
	return s.String()
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *ListIdentityPoliciesOutput) SetPolicyNames(v []*string) *ListIdentityPoliciesOutput {
	s.PolicyNames = v
	return s
}

// Represents a request to list the IP address filters that exist under your
// Amazon Web Services account. You use IP address filters when you receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type ListReceiptFiltersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptFiltersInput) GoString() string {
	return s.String()
}

// A list of IP address filters that exist under your Amazon Web Services account.
type ListReceiptFiltersOutput struct {
	_ struct{} `type:"structure"`

	// A list of IP address filter data structures, which each consist of a name,
	// an IP address range, and whether to allow or block mail from it.
	Filters []*ReceiptFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptFiltersOutput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ListReceiptFiltersOutput) SetFilters(v []*ReceiptFilter) *ListReceiptFiltersOutput {
	s.Filters = v
	return s
}

// Represents a request to list the receipt rule sets that exist under your
// Amazon Web Services account. You use receipt rule sets to receive email with
// Amazon SES. For more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type ListReceiptRuleSetsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListReceiptRuleSets to indicate
	// the position in the receipt rule set list.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptRuleSetsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReceiptRuleSetsInput) SetNextToken(v string) *ListReceiptRuleSetsInput {
	s.NextToken = &v
	return s
}

// A list of receipt rule sets that exist under your Amazon Web Services account.
type ListReceiptRuleSetsOutput struct {
	_ struct{} `type:"structure"`

	// A token indicating that there are additional receipt rule sets available
	// to be listed. Pass this token to successive calls of ListReceiptRuleSets
	// to retrieve up to 100 receipt rule sets at a time.
	NextToken *string `type:"string"`

	// The metadata for the currently active receipt rule set. The metadata consists
	// of the rule set name and the timestamp of when the rule set was created.
	RuleSets []*ReceiptRuleSetMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReceiptRuleSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReceiptRuleSetsOutput) SetNextToken(v string) *ListReceiptRuleSetsOutput {
	s.NextToken = &v
	return s
}

// SetRuleSets sets the RuleSets field's value.
func (s *ListReceiptRuleSetsOutput) SetRuleSets(v []*ReceiptRuleSetMetadata) *ListReceiptRuleSetsOutput {
	s.RuleSets = v
	return s
}

type ListTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of templates to return. This value must be at least 1
	// and less than or equal to 100. If more than 100 items are requested, the
	// page size will automatically set to 100. If you do not specify a value, 10
	// is the default page size.
	MaxItems *int64 `type:"integer"`

	// A token returned from a previous call to ListTemplates to indicate the position
	// in the list of email templates.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesInput) GoString() string {
	return s.String()
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListTemplatesInput) SetMaxItems(v int64) *ListTemplatesInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesInput) SetNextToken(v string) *ListTemplatesInput {
	s.NextToken = &v
	return s
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A token indicating that there are additional email templates available to
	// be listed. Pass this token to a subsequent call to ListTemplates to retrieve
	// the next set of email templates within your page size.
	NextToken *string `type:"string"`

	// An array the contains the name and creation time stamp for each template
	// in your Amazon SES account.
	TemplatesMetadata []*TemplateMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTemplatesOutput) SetNextToken(v string) *ListTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplatesMetadata sets the TemplatesMetadata field's value.
func (s *ListTemplatesOutput) SetTemplatesMetadata(v []*TemplateMetadata) *ListTemplatesOutput {
	s.TemplatesMetadata = v
	return s
}

type ListVerifiedEmailAddressesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVerifiedEmailAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVerifiedEmailAddressesInput) GoString() string {
	return s.String()
}

// A list of email addresses that you have verified with Amazon SES under your
// Amazon Web Services account.
type ListVerifiedEmailAddressesOutput struct {
	_ struct{} `type:"structure"`

	// A list of email addresses that have been verified.
	VerifiedEmailAddresses []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVerifiedEmailAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVerifiedEmailAddressesOutput) GoString() string {
	return s.String()
}

// SetVerifiedEmailAddresses sets the VerifiedEmailAddresses field's value.
func (s *ListVerifiedEmailAddressesOutput) SetVerifiedEmailAddresses(v []*string) *ListVerifiedEmailAddressesOutput {
	s.VerifiedEmailAddresses = v
	return s
}

// Represents the message to be sent, composed of a subject and a body.
type Message struct {
	_ struct{} `type:"structure"`

	// The message body.
	//
	// Body is a required field
	Body *Body `type:"structure" required:"true"`

	// The subject of the message: A short summary of the content, which appears
	// in the recipient's inbox.
	//
	// Subject is a required field
	Subject *Content `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Body != nil {
		if err := s.Body.Validate(); err != nil {
			invalidParams.AddNested("Body", err.(request.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v *Body) *Message {
	s.Body = v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Message) SetSubject(v *Content) *Message {
	s.Subject = v
	return s
}

// Message-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
type MessageDsn struct {
	_ struct{} `type:"structure"`

	// When the message was received by the reporting mail transfer agent (MTA),
	// in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt) date-time format.
	ArrivalDate *time.Time `type:"timestamp"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []*ExtensionField `type:"list"`

	// The reporting MTA that attempted to deliver the message, formatted as specified
	// in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type; mta-name).
	// The default value is dns; inbound-smtp.[region].amazonaws.com.
	//
	// ReportingMta is a required field
	ReportingMta *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageDsn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageDsn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageDsn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageDsn"}
	if s.ReportingMta == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportingMta"))
	}
	if s.ExtensionFields != nil {
		for i, v := range s.ExtensionFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtensionFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArrivalDate sets the ArrivalDate field's value.
func (s *MessageDsn) SetArrivalDate(v time.Time) *MessageDsn {
	s.ArrivalDate = &v
	return s
}

// SetExtensionFields sets the ExtensionFields field's value.
func (s *MessageDsn) SetExtensionFields(v []*ExtensionField) *MessageDsn {
	s.ExtensionFields = v
	return s
}

// SetReportingMta sets the ReportingMta field's value.
func (s *MessageDsn) SetReportingMta(v string) *MessageDsn {
	s.ReportingMta = &v
	return s
}

// Contains the name and value of a tag that you can provide to SendEmail or
// SendRawEmail to apply to an email.
//
// Message tags, which you use with configuration sets, enable you to publish
// email sending events. For information about using configuration sets, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type MessageTag struct {
	_ struct{} `type:"structure"`

	// The name of the tag. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain 256 characters or fewer.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the tag. The value must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain 256 characters or fewer.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageTag"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MessageTag) SetName(v string) *MessageTag {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MessageTag) SetValue(v string) *MessageTag {
	s.Value = &v
	return s
}

// A request to modify the delivery options for a configuration set.
type PutConfigurationSetDeliveryOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// Specifies whether messages that use the configuration set are required to
	// use Transport Layer Security (TLS).
	DeliveryOptions *DeliveryOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfigurationSetDeliveryOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfigurationSetDeliveryOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetDeliveryOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetDeliveryOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetDeliveryOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDeliveryOptions sets the DeliveryOptions field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetDeliveryOptions(v *DeliveryOptions) *PutConfigurationSetDeliveryOptionsInput {
	s.DeliveryOptions = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetDeliveryOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfigurationSetDeliveryOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfigurationSetDeliveryOptionsOutput) GoString() string {
	return s.String()
}

// Represents a request to add or update a sending authorization policy for
// an identity. Sending authorization is an Amazon SES feature that enables
// you to authorize other senders to use your identities. For information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
type PutIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity to which that the policy applies. You can specify an identity
	// by using its name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this operation, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The text of the policy in JSON format. The policy cannot exceed 4 KB.
	//
	// For information about the syntax of sending authorization policies, see the
	// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-policies.html).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIdentityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIdentityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutIdentityPolicyInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *PutIdentityPolicyInput) SetIdentity(v string) *PutIdentityPolicyInput {
	s.Identity = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutIdentityPolicyInput) SetPolicy(v string) *PutIdentityPolicyInput {
	s.Policy = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutIdentityPolicyInput) SetPolicyName(v string) *PutIdentityPolicyInput {
	s.PolicyName = &v
	return s
}

// An empty element returned on a successful request.
type PutIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents the raw data of the message.
type RawMessage struct {
	_ struct{} `type:"structure"`

	// The raw data of the message. This data needs to base64-encoded if you are
	// accessing Amazon SES directly through the HTTPS interface. If you are accessing
	// Amazon SES using an Amazon Web Services SDK, the SDK takes care of the base
	// 64-encoding for you. In all cases, the client must ensure that the message
	// format complies with Internet email standards regarding email header fields,
	// MIME types, and MIME encoding.
	//
	// The To:, CC:, and BCC: headers in the raw message can contain a group list.
	//
	// If you are using SendRawEmail with sending authorization, you can include
	// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
	// addresses. For more information, see the documentation for SendRawEmail.
	//
	// Do not include these X-headers in the DKIM signature, because they are removed
	// by Amazon SES before sending the email.
	//
	// For more information, go to the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RawMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RawMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RawMessage"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *RawMessage) SetData(v []byte) *RawMessage {
	s.Data = v
	return s
}

// An action that Amazon SES can take when it receives an email on behalf of
// one or more email addresses or domains that you own. An instance of this
// data type can represent only one action.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
type ReceiptAction struct {
	_ struct{} `type:"structure"`

	// Adds a header to the received email.
	AddHeaderAction *AddHeaderAction `type:"structure"`

	// Rejects the received email by returning a bounce response to the sender and,
	// optionally, publishes a notification to Amazon Simple Notification Service
	// (Amazon SNS).
	BounceAction *BounceAction `type:"structure"`

	// Calls an Amazon Web Services Lambda function, and optionally, publishes a
	// notification to Amazon SNS.
	LambdaAction *LambdaAction `type:"structure"`

	// Saves the received message to an Amazon Simple Storage Service (Amazon S3)
	// bucket and, optionally, publishes a notification to Amazon SNS.
	S3Action *S3Action `type:"structure"`

	// Publishes the email content within a notification to Amazon SNS.
	SNSAction *SNSAction `type:"structure"`

	// Terminates the evaluation of the receipt rule set and optionally publishes
	// a notification to Amazon SNS.
	StopAction *StopAction `type:"structure"`

	// Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
	// Amazon SNS.
	WorkmailAction *WorkmailAction `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptAction"}
	if s.AddHeaderAction != nil {
		if err := s.AddHeaderAction.Validate(); err != nil {
			invalidParams.AddNested("AddHeaderAction", err.(request.ErrInvalidParams))
		}
	}
	if s.BounceAction != nil {
		if err := s.BounceAction.Validate(); err != nil {
			invalidParams.AddNested("BounceAction", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaAction != nil {
		if err := s.LambdaAction.Validate(); err != nil {
			invalidParams.AddNested("LambdaAction", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Action != nil {
		if err := s.S3Action.Validate(); err != nil {
			invalidParams.AddNested("S3Action", err.(request.ErrInvalidParams))
		}
	}
	if s.SNSAction != nil {
		if err := s.SNSAction.Validate(); err != nil {
			invalidParams.AddNested("SNSAction", err.(request.ErrInvalidParams))
		}
	}
	if s.StopAction != nil {
		if err := s.StopAction.Validate(); err != nil {
			invalidParams.AddNested("StopAction", err.(request.ErrInvalidParams))
		}
	}
	if s.WorkmailAction != nil {
		if err := s.WorkmailAction.Validate(); err != nil {
			invalidParams.AddNested("WorkmailAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddHeaderAction sets the AddHeaderAction field's value.
func (s *ReceiptAction) SetAddHeaderAction(v *AddHeaderAction) *ReceiptAction {
	s.AddHeaderAction = v
	return s
}

// SetBounceAction sets the BounceAction field's value.
func (s *ReceiptAction) SetBounceAction(v *BounceAction) *ReceiptAction {
	s.BounceAction = v
	return s
}

// SetLambdaAction sets the LambdaAction field's value.
func (s *ReceiptAction) SetLambdaAction(v *LambdaAction) *ReceiptAction {
	s.LambdaAction = v
	return s
}

// SetS3Action sets the S3Action field's value.
func (s *ReceiptAction) SetS3Action(v *S3Action) *ReceiptAction {
	s.S3Action = v
	return s
}

// SetSNSAction sets the SNSAction field's value.
func (s *ReceiptAction) SetSNSAction(v *SNSAction) *ReceiptAction {
	s.SNSAction = v
	return s
}

// SetStopAction sets the StopAction field's value.
func (s *ReceiptAction) SetStopAction(v *StopAction) *ReceiptAction {
	s.StopAction = v
	return s
}

// SetWorkmailAction sets the WorkmailAction field's value.
func (s *ReceiptAction) SetWorkmailAction(v *WorkmailAction) *ReceiptAction {
	s.WorkmailAction = v
	return s
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
type ReceiptFilter struct {
	_ struct{} `type:"structure"`

	// A structure that provides the IP addresses to block or allow, and whether
	// to block or allow incoming mail from them.
	//
	// IpFilter is a required field
	IpFilter *ReceiptIpFilter `type:"structure" required:"true"`

	// The name of the IP address filter. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain 64 characters or fewer.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptFilter"}
	if s.IpFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("IpFilter"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.IpFilter != nil {
		if err := s.IpFilter.Validate(); err != nil {
			invalidParams.AddNested("IpFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpFilter sets the IpFilter field's value.
func (s *ReceiptFilter) SetIpFilter(v *ReceiptIpFilter) *ReceiptFilter {
	s.IpFilter = v
	return s
}

// SetName sets the Name field's value.
func (s *ReceiptFilter) SetName(v string) *ReceiptFilter {
	s.Name = &v
	return s
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-ip-filtering-console-walkthrough.html).
type ReceiptIpFilter struct {
	_ struct{} `type:"structure"`

	// A single IP address or a range of IP addresses to block or allow, specified
	// in Classless Inter-Domain Routing (CIDR) notation. An example of a single
	// email address is 10.0.0.1. An example of a range of IP addresses is 10.0.0.1/24.
	// For more information about CIDR notation, see RFC 2317 (https://tools.ietf.org/html/rfc2317).
	//
	// Cidr is a required field
	Cidr *string `type:"string" required:"true"`

	// Indicates whether to block or allow incoming mail from the specified IP addresses.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true" enum:"ReceiptFilterPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptIpFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptIpFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptIpFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptIpFilter"}
	if s.Cidr == nil {
		invalidParams.Add(request.NewErrParamRequired("Cidr"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidr sets the Cidr field's value.
func (s *ReceiptIpFilter) SetCidr(v string) *ReceiptIpFilter {
	s.Cidr = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *ReceiptIpFilter) SetPolicy(v string) *ReceiptIpFilter {
	s.Policy = &v
	return s
}

// Receipt rules enable you to specify which actions Amazon SES should take
// when it receives mail on behalf of one or more email addresses or domains
// that you own.
//
// Each receipt rule defines a set of email addresses or domains that it applies
// to. If the email addresses or domains match at least one recipient address
// of the message, Amazon SES executes all of the receipt rule's actions on
// the message.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html).
type ReceiptRule struct {
	_ struct{} `type:"structure"`

	// An ordered list of actions to perform on messages that match at least one
	// of the recipient email addresses or domains specified in the receipt rule.
	Actions []*ReceiptAction `type:"list"`

	// If true, the receipt rule is active. The default value is false.
	Enabled *bool `type:"boolean"`

	// The name of the receipt rule. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    dashes (-), or periods (.).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain 64 characters or fewer.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The recipient domains and email addresses that the receipt rule applies to.
	// If this field is not specified, this rule matches all recipients on all verified
	// domains.
	Recipients []*string `type:"list"`

	// If true, then messages that this receipt rule applies to are scanned for
	// spam and viruses. The default value is false.
	ScanEnabled *bool `type:"boolean"`

	// Specifies whether Amazon SES should require that incoming email is delivered
	// over a connection encrypted with Transport Layer Security (TLS). If this
	// parameter is set to Require, Amazon SES bounces emails that are not received
	// over TLS. The default is Optional.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptRule"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *ReceiptRule) SetActions(v []*ReceiptAction) *ReceiptRule {
	s.Actions = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ReceiptRule) SetEnabled(v bool) *ReceiptRule {
	s.Enabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReceiptRule) SetName(v string) *ReceiptRule {
	s.Name = &v
	return s
}

// SetRecipients sets the Recipients field's value.
func (s *ReceiptRule) SetRecipients(v []*string) *ReceiptRule {
	s.Recipients = v
	return s
}

// SetScanEnabled sets the ScanEnabled field's value.
func (s *ReceiptRule) SetScanEnabled(v bool) *ReceiptRule {
	s.ScanEnabled = &v
	return s
}

// SetTlsPolicy sets the TlsPolicy field's value.
func (s *ReceiptRule) SetTlsPolicy(v string) *ReceiptRule {
	s.TlsPolicy = &v
	return s
}

// Information about a receipt rule set.
//
// A receipt rule set is a collection of rules that specify what Amazon SES
// should do with mail it receives on behalf of your account's verified domains.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html#receiving-email-concepts-rules).
type ReceiptRuleSetMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time the receipt rule set was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The name of the receipt rule set. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain 64 characters or fewer.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptRuleSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReceiptRuleSetMetadata) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ReceiptRuleSetMetadata) SetCreatedTimestamp(v time.Time) *ReceiptRuleSetMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReceiptRuleSetMetadata) SetName(v string) *ReceiptRuleSetMetadata {
	s.Name = &v
	return s
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email.html).
type RecipientDsnFields struct {
	_ struct{} `type:"structure"`

	// The action performed by the reporting mail transfer agent (MTA) as a result
	// of its attempt to deliver the message to the recipient address. This is required
	// by RFC 3464 (https://tools.ietf.org/html/rfc3464).
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"DsnAction"`

	// An extended explanation of what went wrong; this is usually an SMTP response.
	// See RFC 3463 (https://tools.ietf.org/html/rfc3463) for the correct formatting
	// of this parameter.
	DiagnosticCode *string `type:"string"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []*ExtensionField `type:"list"`

	// The email address that the message was ultimately delivered to. This corresponds
	// to the Final-Recipient in the DSN. If not specified, FinalRecipient is set
	// to the Recipient specified in the BouncedRecipientInfo structure. Either
	// FinalRecipient or the recipient in BouncedRecipientInfo must be a recipient
	// of the original bounced message.
	//
	// Do not prepend the FinalRecipient email address with rfc 822;, as described
	// in RFC 3798 (https://tools.ietf.org/html/rfc3798).
	FinalRecipient *string `type:"string"`

	// The time the final delivery attempt was made, in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt)
	// date-time format.
	LastAttemptDate *time.Time `type:"timestamp"`

	// The MTA to which the remote MTA attempted to deliver the message, formatted
	// as specified in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type;
	// mta-name). This parameter typically applies only to propagating synchronous
	// bounces.
	RemoteMta *string `type:"string"`

	// The status code that indicates what went wrong. This is required by RFC 3464
	// (https://tools.ietf.org/html/rfc3464).
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipientDsnFields) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecipientDsnFields) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecipientDsnFields) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecipientDsnFields"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.ExtensionFields != nil {
		for i, v := range s.ExtensionFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtensionFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RecipientDsnFields) SetAction(v string) *RecipientDsnFields {
	s.Action = &v
	return s
}

// SetDiagnosticCode sets the DiagnosticCode field's value.
func (s *RecipientDsnFields) SetDiagnosticCode(v string) *RecipientDsnFields {
	s.DiagnosticCode = &v
	return s
}

// SetExtensionFields sets the ExtensionFields field's value.
func (s *RecipientDsnFields) SetExtensionFields(v []*ExtensionField) *RecipientDsnFields {
	s.ExtensionFields = v
	return s
}

// SetFinalRecipient sets the FinalRecipient field's value.
func (s *RecipientDsnFields) SetFinalRecipient(v string) *RecipientDsnFields {
	s.FinalRecipient = &v
	return s
}

// SetLastAttemptDate sets the LastAttemptDate field's value.
func (s *RecipientDsnFields) SetLastAttemptDate(v time.Time) *RecipientDsnFields {
	s.LastAttemptDate = &v
	return s
}

// SetRemoteMta sets the RemoteMta field's value.
func (s *RecipientDsnFields) SetRemoteMta(v string) *RecipientDsnFields {
	s.RemoteMta = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecipientDsnFields) SetStatus(v string) *RecipientDsnFields {
	s.Status = &v
	return s
}

// Represents a request to reorder the receipt rules within a receipt rule set.
// You use receipt rule sets to receive email with Amazon SES. For more information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type ReorderReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The specified receipt rule set's receipt rules, in order.
	//
	// RuleNames is a required field
	RuleNames []*string `type:"list" required:"true"`

	// The name of the receipt rule set to reorder.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReorderReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReorderReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReorderReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReorderReceiptRuleSetInput"}
	if s.RuleNames == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNames"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleNames sets the RuleNames field's value.
func (s *ReorderReceiptRuleSetInput) SetRuleNames(v []*string) *ReorderReceiptRuleSetInput {
	s.RuleNames = v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *ReorderReceiptRuleSetInput) SetRuleSetName(v string) *ReorderReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type ReorderReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReorderReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReorderReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Contains information about the reputation settings for a configuration set.
type ReputationOptions struct {
	_ struct{} `type:"structure"`

	// The date and time at which the reputation metrics for the configuration set
	// were last reset. Resetting these metrics is known as a fresh start.
	//
	// When you disable email sending for a configuration set using UpdateConfigurationSetSendingEnabled
	// and later re-enable it, the reputation metrics for the configuration set
	// (but not for the entire Amazon SES account) are reset.
	//
	// If email sending for the configuration set has never been disabled and later
	// re-enabled, the value of this attribute is null.
	LastFreshStart *time.Time `type:"timestamp"`

	// Describes whether or not Amazon SES publishes reputation metrics for the
	// configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
	//
	// If the value is true, reputation metrics are published. If the value is false,
	// reputation metrics are not published. The default value is false.
	ReputationMetricsEnabled *bool `type:"boolean"`

	// Describes whether email sending is enabled or disabled for the configuration
	// set. If the value is true, then Amazon SES sends emails that use the configuration
	// set. If the value is false, Amazon SES does not send emails that use the
	// configuration set. The default value is true. You can change this setting
	// using UpdateConfigurationSetSendingEnabled.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReputationOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReputationOptions) GoString() string {
	return s.String()
}

// SetLastFreshStart sets the LastFreshStart field's value.
func (s *ReputationOptions) SetLastFreshStart(v time.Time) *ReputationOptions {
	s.LastFreshStart = &v
	return s
}

// SetReputationMetricsEnabled sets the ReputationMetricsEnabled field's value.
func (s *ReputationOptions) SetReputationMetricsEnabled(v bool) *ReputationOptions {
	s.ReputationMetricsEnabled = &v
	return s
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *ReputationOptions) SetSendingEnabled(v bool) *ReputationOptions {
	s.SendingEnabled = &v
	return s
}

// When included in a receipt rule, this action saves the received message to
// an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes
// a notification to Amazon Simple Notification Service (Amazon SNS).
//
// To enable Amazon SES to write emails to your Amazon S3 bucket, use an Amazon
// Web Services KMS key to encrypt your emails, or publish to an Amazon SNS
// topic of another account, Amazon SES must have permission to access those
// resources. For information about granting permissions, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html).
//
// When you save your emails to an Amazon S3 bucket, the maximum email size
// (including headers) is 40 MB. Emails larger than that bounces.
//
// For information about specifying Amazon S3 actions in receipt rules, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-s3.html).
type S3Action struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket for incoming email.
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The customer master key that Amazon SES should use to encrypt your emails
	// before saving them to the Amazon S3 bucket. You can use the default master
	// key or a custom master key that you created in Amazon Web Services KMS as
	// follows:
	//
	//    * To use the default master key, provide an ARN in the form of arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses.
	//    For example, if your Amazon Web Services account ID is 123456789012 and
	//    you want to use the default master key in the US West (Oregon) Region,
	//    the ARN of the default master key would be arn:aws:kms:us-west-2:123456789012:alias/aws/ses.
	//    If you use the default master key, you don't need to perform any extra
	//    steps to give Amazon SES permission to use the key.
	//
	//    * To use a custom master key that you created in Amazon Web Services KMS,
	//    provide the ARN of the master key and ensure that you add a statement
	//    to your key's policy to give Amazon SES permission to use it. For more
	//    information about giving permissions, see the Amazon SES Developer Guide
	//    (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html).
	//
	// For more information about key policies, see the Amazon Web Services KMS
	// Developer Guide (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
	// If you do not specify a master key, Amazon SES does not encrypt your emails.
	//
	// Your mail is encrypted by Amazon SES using the Amazon S3 encryption client
	// before the mail is submitted to Amazon S3 for storage. It is not encrypted
	// using Amazon S3 server-side encryption. This means that you must use the
	// Amazon S3 encryption client to decrypt the email after retrieving it from
	// Amazon S3, as the service has no access to use your Amazon Web Services KMS
	// keys for decryption. This encryption client is currently available with the
	// Amazon Web Services SDK for Java (http://aws.amazon.com/sdk-for-java/) and
	// Amazon Web Services SDK for Ruby (http://aws.amazon.com/sdk-for-ruby/) only.
	// For more information about client-side encryption using Amazon Web Services
	// KMS master keys, see the Amazon S3 Developer Guide (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
	KmsKeyArn *string `type:"string"`

	// The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory
	// name that enables you to store similar data under the same directory in a
	// bucket.
	ObjectKeyPrefix *string `type:"string"`

	// The ARN of the Amazon SNS topic to notify when the message is saved to the
	// Amazon S3 bucket. You can find the ARN of a topic by using the ListTopics
	// (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation
	// in Amazon SNS.
	//
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Action"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Action) SetBucketName(v string) *S3Action {
	s.BucketName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *S3Action) SetKmsKeyArn(v string) *S3Action {
	s.KmsKeyArn = &v
	return s
}

// SetObjectKeyPrefix sets the ObjectKeyPrefix field's value.
func (s *S3Action) SetObjectKeyPrefix(v string) *S3Action {
	s.ObjectKeyPrefix = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *S3Action) SetTopicArn(v string) *S3Action {
	s.TopicArn = &v
	return s
}

// When included in a receipt rule, this action publishes a notification to
// Amazon Simple Notification Service (Amazon SNS). This action includes a complete
// copy of the email content in the Amazon SNS notifications. Amazon SNS notifications
// for all other actions simply provide information about the email. They do
// not include the email content itself.
//
// If you own the Amazon SNS topic, you don't need to do anything to give Amazon
// SES permission to publish emails to it. However, if you don't own the Amazon
// SNS topic, you need to attach a policy to the topic to give Amazon SES permissions
// to access it. For information about giving permissions, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html).
//
// You can only publish emails that are 150 KB or less (including the header)
// to Amazon SNS. Larger emails bounce. If you anticipate emails larger than
// 150 KB, use the S3 action instead.
//
// For information about using a receipt rule to publish an Amazon SNS notification,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-sns.html).
type SNSAction struct {
	_ struct{} `type:"structure"`

	// The encoding to use for the email within the Amazon SNS notification. UTF-8
	// is easier to use, but may not preserve all special characters when a message
	// was encoded with a different encoding format. Base64 preserves all special
	// characters. The default value is UTF-8.
	Encoding *string `type:"string" enum:"SNSActionEncoding"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. You can
	// find the ARN of a topic by using the ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// operation in Amazon SNS.
	//
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNSAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNSAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SNSAction"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncoding sets the Encoding field's value.
func (s *SNSAction) SetEncoding(v string) *SNSAction {
	s.Encoding = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *SNSAction) SetTopicArn(v string) *SNSAction {
	s.TopicArn = &v
	return s
}

// Contains the topic ARN associated with an Amazon Simple Notification Service
// (Amazon SNS) event destination.
//
// Event destinations, such as Amazon SNS, are associated with configuration
// sets, which enable you to publish email sending events. For information about
// using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type SNSDestination struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon SNS topic for email sending events. You can find the
	// ARN of a topic by using the ListTopics (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html)
	// Amazon SNS operation.
	//
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicARN is a required field
	TopicARN *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNSDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNSDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SNSDestination"}
	if s.TopicARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicARN sets the TopicARN field's value.
func (s *SNSDestination) SetTopicARN(v string) *SNSDestination {
	s.TopicARN = &v
	return s
}

// Represents a request to send a bounce message to the sender of an email you
// received through Amazon SES.
type SendBounceInput struct {
	_ struct{} `type:"structure"`

	// The address to use in the "From" header of the bounce message. This must
	// be an identity that you have verified with Amazon SES.
	//
	// BounceSender is a required field
	BounceSender *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the address in the "From" header of the bounce. For more information
	// about sending authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	BounceSenderArn *string `type:"string"`

	// A list of recipients of the bounced message, including the information required
	// to create the Delivery Status Notifications (DSNs) for the recipients. You
	// must specify at least one BouncedRecipientInfo in the list.
	//
	// BouncedRecipientInfoList is a required field
	BouncedRecipientInfoList []*BouncedRecipientInfo `type:"list" required:"true"`

	// Human-readable text for the bounce message to explain the failure. If not
	// specified, the text is auto-generated based on the bounced recipient information.
	Explanation *string `type:"string"`

	// Message-related DSN fields. If not specified, Amazon SES chooses the values.
	MessageDsn *MessageDsn `type:"structure"`

	// The message ID of the message to be bounced.
	//
	// OriginalMessageId is a required field
	OriginalMessageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBounceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBounceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendBounceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendBounceInput"}
	if s.BounceSender == nil {
		invalidParams.Add(request.NewErrParamRequired("BounceSender"))
	}
	if s.BouncedRecipientInfoList == nil {
		invalidParams.Add(request.NewErrParamRequired("BouncedRecipientInfoList"))
	}
	if s.OriginalMessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginalMessageId"))
	}
	if s.BouncedRecipientInfoList != nil {
		for i, v := range s.BouncedRecipientInfoList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BouncedRecipientInfoList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MessageDsn != nil {
		if err := s.MessageDsn.Validate(); err != nil {
			invalidParams.AddNested("MessageDsn", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBounceSender sets the BounceSender field's value.
func (s *SendBounceInput) SetBounceSender(v string) *SendBounceInput {
	s.BounceSender = &v
	return s
}

// SetBounceSenderArn sets the BounceSenderArn field's value.
func (s *SendBounceInput) SetBounceSenderArn(v string) *SendBounceInput {
	s.BounceSenderArn = &v
	return s
}

// SetBouncedRecipientInfoList sets the BouncedRecipientInfoList field's value.
func (s *SendBounceInput) SetBouncedRecipientInfoList(v []*BouncedRecipientInfo) *SendBounceInput {
	s.BouncedRecipientInfoList = v
	return s
}

// SetExplanation sets the Explanation field's value.
func (s *SendBounceInput) SetExplanation(v string) *SendBounceInput {
	s.Explanation = &v
	return s
}

// SetMessageDsn sets the MessageDsn field's value.
func (s *SendBounceInput) SetMessageDsn(v *MessageDsn) *SendBounceInput {
	s.MessageDsn = v
	return s
}

// SetOriginalMessageId sets the OriginalMessageId field's value.
func (s *SendBounceInput) SetOriginalMessageId(v string) *SendBounceInput {
	s.OriginalMessageId = &v
	return s
}

// Represents a unique message ID.
type SendBounceOutput struct {
	_ struct{} `type:"structure"`

	// The message ID of the bounce message.
	MessageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBounceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBounceOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendBounceOutput) SetMessageId(v string) *SendBounceOutput {
	s.MessageId = &v
	return s
}

// Represents a request to send a templated email to multiple destinations using
// Amazon SES. For more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
type SendBulkTemplatedEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use when you send an email using SendBulkTemplatedEmail.
	ConfigurationSetName *string `type:"string"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send to a destination using SendBulkTemplatedEmail.
	DefaultTags []*MessageTag `type:"list"`

	// A list of replacement values to apply to the template when replacement data
	// is not specified in a Destination object. These values act as a default or
	// fallback option when no other data is available.
	//
	// The template data is a JSON object, typically consisting of key-value pairs
	// in which the keys correspond to replacement tags in the email template.
	DefaultTemplateData *string `type:"string"`

	// One or more Destination objects. All of the recipients in a Destination receive
	// the same version of the email. You can specify up to 50 Destination objects
	// within a Destinations array.
	//
	// Destinations is a required field
	Destinations []*BulkEmailDestination `type:"list" required:"true"`

	// The reply-to email address(es) for the message. If the recipient replies
	// to the message, each reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email address that bounces and complaints are forwarded to when feedback
	// forwarding is enabled. If the message cannot be delivered to the recipient,
	// then an error message is returned from the recipient's ISP; this message
	// is forwarded to the email address specified by the ReturnPath parameter.
	// The ReturnPath parameter is never overwritten. This email address must be
	// either individually verified with Amazon SES, or from a domain that has been
	// verified with Amazon SES.
	ReturnPath *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	ReturnPathArn *string `type:"string"`

	// The email address that is sending the email. This email address must be either
	// individually verified with Amazon SES, or from a domain that has been verified
	// with Amazon SES. For information about verifying identities, see the Amazon
	// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
	//
	// If you are sending on behalf of another user and have been permitted to do
	// so by a sending authorization policy, then you must also specify the SourceArn
	// parameter. For more information about sending authorization, see the Amazon
	// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
	// (https://tools.ietf.org/html/rfc6531). For this reason, the email address
	// string must be 7-bit ASCII. If you want to send to or from email addresses
	// that contain Unicode characters in the domain part of an address, you must
	// encode the domain using Punycode. Punycode is not permitted in the local
	// part of the email address (the part before the @ sign) nor in the "friendly
	// from" name. If you want to use Unicode characters in the "friendly from"
	// name, you must encode the "friendly from" name using MIME encoded-word syntax,
	// as described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
	// For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492).
	//
	// Source is a required field
	Source *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	SourceArn *string `type:"string"`

	// The template to use when sending this email.
	//
	// Template is a required field
	Template *string `type:"string" required:"true"`

	// The ARN of the template to use when sending this email.
	TemplateArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBulkTemplatedEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBulkTemplatedEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendBulkTemplatedEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendBulkTemplatedEmailInput"}
	if s.Destinations == nil {
		invalidParams.Add(request.NewErrParamRequired("Destinations"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.DefaultTags != nil {
		for i, v := range s.DefaultTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendBulkTemplatedEmailInput) SetConfigurationSetName(v string) *SendBulkTemplatedEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDefaultTags sets the DefaultTags field's value.
func (s *SendBulkTemplatedEmailInput) SetDefaultTags(v []*MessageTag) *SendBulkTemplatedEmailInput {
	s.DefaultTags = v
	return s
}

// SetDefaultTemplateData sets the DefaultTemplateData field's value.
func (s *SendBulkTemplatedEmailInput) SetDefaultTemplateData(v string) *SendBulkTemplatedEmailInput {
	s.DefaultTemplateData = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *SendBulkTemplatedEmailInput) SetDestinations(v []*BulkEmailDestination) *SendBulkTemplatedEmailInput {
	s.Destinations = v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *SendBulkTemplatedEmailInput) SetReplyToAddresses(v []*string) *SendBulkTemplatedEmailInput {
	s.ReplyToAddresses = v
	return s
}

// SetReturnPath sets the ReturnPath field's value.
func (s *SendBulkTemplatedEmailInput) SetReturnPath(v string) *SendBulkTemplatedEmailInput {
	s.ReturnPath = &v
	return s
}

// SetReturnPathArn sets the ReturnPathArn field's value.
func (s *SendBulkTemplatedEmailInput) SetReturnPathArn(v string) *SendBulkTemplatedEmailInput {
	s.ReturnPathArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *SendBulkTemplatedEmailInput) SetSource(v string) *SendBulkTemplatedEmailInput {
	s.Source = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *SendBulkTemplatedEmailInput) SetSourceArn(v string) *SendBulkTemplatedEmailInput {
	s.SourceArn = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *SendBulkTemplatedEmailInput) SetTemplate(v string) *SendBulkTemplatedEmailInput {
	s.Template = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *SendBulkTemplatedEmailInput) SetTemplateArn(v string) *SendBulkTemplatedEmailInput {
	s.TemplateArn = &v
	return s
}

type SendBulkTemplatedEmailOutput struct {
	_ struct{} `type:"structure"`

	// One object per intended recipient. Check each response object and retry any
	// messages with a failure status. (Note that order of responses will be respective
	// to order of destinations in the request.)Receipt rules enable you to specify
	// which actions
	//
	// Status is a required field
	Status []*BulkEmailDestinationStatus `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBulkTemplatedEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendBulkTemplatedEmailOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *SendBulkTemplatedEmailOutput) SetStatus(v []*BulkEmailDestinationStatus) *SendBulkTemplatedEmailOutput {
	s.Status = v
	return s
}

// Represents a request to send a custom verification email to a specified recipient.
type SendCustomVerificationEmailInput struct {
	_ struct{} `type:"structure"`

	// Name of a configuration set to use when sending the verification email.
	ConfigurationSetName *string `type:"string"`

	// The email address to verify.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`

	// The name of the custom verification email template to use when sending the
	// verification email.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCustomVerificationEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCustomVerificationEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendCustomVerificationEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendCustomVerificationEmailInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendCustomVerificationEmailInput) SetConfigurationSetName(v string) *SendCustomVerificationEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *SendCustomVerificationEmailInput) SetEmailAddress(v string) *SendCustomVerificationEmailInput {
	s.EmailAddress = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *SendCustomVerificationEmailInput) SetTemplateName(v string) *SendCustomVerificationEmailInput {
	s.TemplateName = &v
	return s
}

// The response received when attempting to send the custom verification email.
type SendCustomVerificationEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendCustomVerificationEmail
	// operation.
	MessageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCustomVerificationEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendCustomVerificationEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendCustomVerificationEmailOutput) SetMessageId(v string) *SendCustomVerificationEmailOutput {
	s.MessageId = &v
	return s
}

// Represents sending statistics data. Each SendDataPoint contains statistics
// for a 15-minute period of sending activity.
type SendDataPoint struct {
	_ struct{} `type:"structure"`

	// Number of emails that have bounced.
	Bounces *int64 `type:"long"`

	// Number of unwanted emails that were rejected by recipients.
	Complaints *int64 `type:"long"`

	// Number of emails that have been sent.
	DeliveryAttempts *int64 `type:"long"`

	// Number of emails rejected by Amazon SES.
	Rejects *int64 `type:"long"`

	// Time of the data point.
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendDataPoint) GoString() string {
	return s.String()
}

// SetBounces sets the Bounces field's value.
func (s *SendDataPoint) SetBounces(v int64) *SendDataPoint {
	s.Bounces = &v
	return s
}

// SetComplaints sets the Complaints field's value.
func (s *SendDataPoint) SetComplaints(v int64) *SendDataPoint {
	s.Complaints = &v
	return s
}

// SetDeliveryAttempts sets the DeliveryAttempts field's value.
func (s *SendDataPoint) SetDeliveryAttempts(v int64) *SendDataPoint {
	s.DeliveryAttempts = &v
	return s
}

// SetRejects sets the Rejects field's value.
func (s *SendDataPoint) SetRejects(v int64) *SendDataPoint {
	s.Rejects = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SendDataPoint) SetTimestamp(v time.Time) *SendDataPoint {
	s.Timestamp = &v
	return s
}

// Represents a request to send a single formatted email using Amazon SES. For
// more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-formatted.html).
type SendEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use when you send an email using SendEmail.
	ConfigurationSetName *string `type:"string"`

	// The destination for this email, composed of To:, CC:, and BCC: fields.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// The message to be sent.
	//
	// Message is a required field
	Message *Message `type:"structure" required:"true"`

	// The reply-to email address(es) for the message. If the recipient replies
	// to the message, each reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email address that bounces and complaints are forwarded to when feedback
	// forwarding is enabled. If the message cannot be delivered to the recipient,
	// then an error message is returned from the recipient's ISP; this message
	// is forwarded to the email address specified by the ReturnPath parameter.
	// The ReturnPath parameter is never overwritten. This email address must be
	// either individually verified with Amazon SES, or from a domain that has been
	// verified with Amazon SES.
	ReturnPath *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	ReturnPathArn *string `type:"string"`

	// The email address that is sending the email. This email address must be either
	// individually verified with Amazon SES, or from a domain that has been verified
	// with Amazon SES. For information about verifying identities, see the Amazon
	// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
	//
	// If you are sending on behalf of another user and have been permitted to do
	// so by a sending authorization policy, then you must also specify the SourceArn
	// parameter. For more information about sending authorization, see the Amazon
	// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
	// (https://tools.ietf.org/html/rfc6531). For this reason, the email address
	// string must be 7-bit ASCII. If you want to send to or from email addresses
	// that contain Unicode characters in the domain part of an address, you must
	// encode the domain using Punycode. Punycode is not permitted in the local
	// part of the email address (the part before the @ sign) nor in the "friendly
	// from" name. If you want to use Unicode characters in the "friendly from"
	// name, you must encode the "friendly from" name using MIME encoded-word syntax,
	// as described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
	// For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492).
	//
	// Source is a required field
	Source *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	SourceArn *string `type:"string"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using SendEmail. Tags correspond to characteristics of the email
	// that you define, so that you can publish email sending events.
	Tags []*MessageTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEmailInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Message != nil {
		if err := s.Message.Validate(); err != nil {
			invalidParams.AddNested("Message", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendEmailInput) SetConfigurationSetName(v string) *SendEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *SendEmailInput) SetDestination(v *Destination) *SendEmailInput {
	s.Destination = v
	return s
}

// SetMessage sets the Message field's value.
func (s *SendEmailInput) SetMessage(v *Message) *SendEmailInput {
	s.Message = v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *SendEmailInput) SetReplyToAddresses(v []*string) *SendEmailInput {
	s.ReplyToAddresses = v
	return s
}

// SetReturnPath sets the ReturnPath field's value.
func (s *SendEmailInput) SetReturnPath(v string) *SendEmailInput {
	s.ReturnPath = &v
	return s
}

// SetReturnPathArn sets the ReturnPathArn field's value.
func (s *SendEmailInput) SetReturnPathArn(v string) *SendEmailInput {
	s.ReturnPathArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *SendEmailInput) SetSource(v string) *SendEmailInput {
	s.Source = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *SendEmailInput) SetSourceArn(v string) *SendEmailInput {
	s.SourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SendEmailInput) SetTags(v []*MessageTag) *SendEmailInput {
	s.Tags = v
	return s
}

// Represents a unique message ID.
type SendEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendEmail action.
	//
	// MessageId is a required field
	MessageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendEmailOutput) SetMessageId(v string) *SendEmailOutput {
	s.MessageId = &v
	return s
}

// Represents a request to send a single raw email using Amazon SES. For more
// information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
type SendRawEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use when you send an email using SendRawEmail.
	ConfigurationSetName *string `type:"string"`

	// A list of destinations for the message, consisting of To:, CC:, and BCC:
	// addresses.
	Destinations []*string `type:"list"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to specify a particular "From" address in the header of the raw email.
	//
	// Instead of using this parameter, you can use the X-header X-SES-FROM-ARN
	// in the raw message of the email. If you use both the FromArn parameter and
	// the corresponding X-header, Amazon SES uses the value of the FromArn parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
	FromArn *string `type:"string"`

	// The raw email message itself. The message has to meet the following criteria:
	//
	//    * The message has to contain a header and a body, separated by a blank
	//    line.
	//
	//    * All of the required header fields must be present in the message.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * Attachments must be of a content type that Amazon SES supports. For
	//    a list on unsupported content types, see Unsupported Attachment Types
	//    (https://docs.aws.amazon.com/ses/latest/dg/mime-types.html) in the Amazon
	//    SES Developer Guide.
	//
	//    * The entire message must be base64-encoded.
	//
	//    * If any of the MIME parts in your message contain content that is outside
	//    of the 7-bit ASCII character range, we highly recommend that you encode
	//    that content. For more information, see Sending Raw Email (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html)
	//    in the Amazon SES Developer Guide.
	//
	//    * Per RFC 5321 (https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6),
	//    the maximum length of each line of text, including the <CRLF>, must not
	//    exceed 1,000 characters.
	//
	// RawMessage is a required field
	RawMessage *RawMessage `type:"structure" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-RETURN-PATH-ARN
	// in the raw message of the email. If you use both the ReturnPathArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the ReturnPathArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
	ReturnPathArn *string `type:"string"`

	// The identity's email address. If you do not provide a value for this parameter,
	// you must specify a "From" address in the raw text of the message. (You can
	// also specify both.)
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described inRFC6531
	// (https://tools.ietf.org/html/rfc6531). For this reason, the email address
	// string must be 7-bit ASCII. If you want to send to or from email addresses
	// that contain Unicode characters in the domain part of an address, you must
	// encode the domain using Punycode. Punycode is not permitted in the local
	// part of the email address (the part before the @ sign) nor in the "friendly
	// from" name. If you want to use Unicode characters in the "friendly from"
	// name, you must encode the "friendly from" name using MIME encoded-word syntax,
	// as described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
	// For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492).
	//
	// If you specify the Source parameter and have feedback forwarding enabled,
	// then bounces and complaints are sent to this email address. This takes precedence
	// over any Return-Path header that you might include in the raw text of the
	// message.
	Source *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-SOURCE-ARN
	// in the raw message of the email. If you use both the SourceArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the SourceArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization-delegate-sender-tasks-email.html).
	SourceArn *string `type:"string"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using SendRawEmail. Tags correspond to characteristics of the email
	// that you define, so that you can publish email sending events.
	Tags []*MessageTag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendRawEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendRawEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendRawEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendRawEmailInput"}
	if s.RawMessage == nil {
		invalidParams.Add(request.NewErrParamRequired("RawMessage"))
	}
	if s.RawMessage != nil {
		if err := s.RawMessage.Validate(); err != nil {
			invalidParams.AddNested("RawMessage", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendRawEmailInput) SetConfigurationSetName(v string) *SendRawEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *SendRawEmailInput) SetDestinations(v []*string) *SendRawEmailInput {
	s.Destinations = v
	return s
}

// SetFromArn sets the FromArn field's value.
func (s *SendRawEmailInput) SetFromArn(v string) *SendRawEmailInput {
	s.FromArn = &v
	return s
}

// SetRawMessage sets the RawMessage field's value.
func (s *SendRawEmailInput) SetRawMessage(v *RawMessage) *SendRawEmailInput {
	s.RawMessage = v
	return s
}

// SetReturnPathArn sets the ReturnPathArn field's value.
func (s *SendRawEmailInput) SetReturnPathArn(v string) *SendRawEmailInput {
	s.ReturnPathArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *SendRawEmailInput) SetSource(v string) *SendRawEmailInput {
	s.Source = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *SendRawEmailInput) SetSourceArn(v string) *SendRawEmailInput {
	s.SourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SendRawEmailInput) SetTags(v []*MessageTag) *SendRawEmailInput {
	s.Tags = v
	return s
}

// Represents a unique message ID.
type SendRawEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendRawEmail action.
	//
	// MessageId is a required field
	MessageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendRawEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendRawEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendRawEmailOutput) SetMessageId(v string) *SendRawEmailOutput {
	s.MessageId = &v
	return s
}

// Represents a request to send a templated email using Amazon SES. For more
// information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-personalized-email-api.html).
type SendTemplatedEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use when you send an email using SendTemplatedEmail.
	ConfigurationSetName *string `type:"string"`

	// The destination for this email, composed of To:, CC:, and BCC: fields. A
	// Destination can include up to 50 recipients across these three fields.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// The reply-to email address(es) for the message. If the recipient replies
	// to the message, each reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email address that bounces and complaints are forwarded to when feedback
	// forwarding is enabled. If the message cannot be delivered to the recipient,
	// then an error message is returned from the recipient's ISP; this message
	// is forwarded to the email address specified by the ReturnPath parameter.
	// The ReturnPath parameter is never overwritten. This email address must be
	// either individually verified with Amazon SES, or from a domain that has been
	// verified with Amazon SES.
	ReturnPath *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	ReturnPathArn *string `type:"string"`

	// The email address that is sending the email. This email address must be either
	// individually verified with Amazon SES, or from a domain that has been verified
	// with Amazon SES. For information about verifying identities, see the Amazon
	// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html).
	//
	// If you are sending on behalf of another user and have been permitted to do
	// so by a sending authorization policy, then you must also specify the SourceArn
	// parameter. For more information about sending authorization, see the Amazon
	// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
	// (https://tools.ietf.org/html/rfc6531). for this reason, The email address
	// string must be 7-bit ASCII. If you want to send to or from email addresses
	// that contain Unicode characters in the domain part of an address, you must
	// encode the domain using Punycode. Punycode is not permitted in the local
	// part of the email address (the part before the @ sign) nor in the "friendly
	// from" name. If you want to use Unicode characters in the "friendly from"
	// name, you must encode the "friendly from" name using MIME encoded-word syntax,
	// as described in Sending raw email using the Amazon SES API (https://docs.aws.amazon.com/ses/latest/dg/send-email-raw.html).
	// For more information about Punycode, see RFC 3492 (http://tools.ietf.org/html/rfc3492).
	//
	// Source is a required field
	Source *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html).
	SourceArn *string `type:"string"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using SendTemplatedEmail. Tags correspond to characteristics of
	// the email that you define, so that you can publish email sending events.
	Tags []*MessageTag `type:"list"`

	// The template to use when sending this email.
	//
	// Template is a required field
	Template *string `type:"string" required:"true"`

	// The ARN of the template to use when sending this email.
	TemplateArn *string `type:"string"`

	// A list of replacement values to apply to the template. This parameter is
	// a JSON object, typically consisting of key-value pairs in which the keys
	// correspond to replacement tags in the email template.
	//
	// TemplateData is a required field
	TemplateData *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTemplatedEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTemplatedEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTemplatedEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTemplatedEmailInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.TemplateData == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateData"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendTemplatedEmailInput) SetConfigurationSetName(v string) *SendTemplatedEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *SendTemplatedEmailInput) SetDestination(v *Destination) *SendTemplatedEmailInput {
	s.Destination = v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *SendTemplatedEmailInput) SetReplyToAddresses(v []*string) *SendTemplatedEmailInput {
	s.ReplyToAddresses = v
	return s
}

// SetReturnPath sets the ReturnPath field's value.
func (s *SendTemplatedEmailInput) SetReturnPath(v string) *SendTemplatedEmailInput {
	s.ReturnPath = &v
	return s
}

// SetReturnPathArn sets the ReturnPathArn field's value.
func (s *SendTemplatedEmailInput) SetReturnPathArn(v string) *SendTemplatedEmailInput {
	s.ReturnPathArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *SendTemplatedEmailInput) SetSource(v string) *SendTemplatedEmailInput {
	s.Source = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *SendTemplatedEmailInput) SetSourceArn(v string) *SendTemplatedEmailInput {
	s.SourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SendTemplatedEmailInput) SetTags(v []*MessageTag) *SendTemplatedEmailInput {
	s.Tags = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *SendTemplatedEmailInput) SetTemplate(v string) *SendTemplatedEmailInput {
	s.Template = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *SendTemplatedEmailInput) SetTemplateArn(v string) *SendTemplatedEmailInput {
	s.TemplateArn = &v
	return s
}

// SetTemplateData sets the TemplateData field's value.
func (s *SendTemplatedEmailInput) SetTemplateData(v string) *SendTemplatedEmailInput {
	s.TemplateData = &v
	return s
}

type SendTemplatedEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendTemplatedEmail action.
	//
	// MessageId is a required field
	MessageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTemplatedEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SendTemplatedEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendTemplatedEmailOutput) SetMessageId(v string) *SendTemplatedEmailOutput {
	s.MessageId = &v
	return s
}

// Represents a request to set a receipt rule set as the active receipt rule
// set. You use receipt rule sets to receive email with Amazon SES. For more
// information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type SetActiveReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to make active. Setting this value to null
	// disables all email receiving.
	RuleSetName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetActiveReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetActiveReceiptRuleSetInput) GoString() string {
	return s.String()
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *SetActiveReceiptRuleSetInput) SetRuleSetName(v string) *SetActiveReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type SetActiveReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetActiveReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetActiveReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request to enable or disable Amazon SES Easy DKIM signing for
// an identity. For more information about setting up Easy DKIM, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
type SetIdentityDkimEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether DKIM signing is enabled for an identity. Set to true to enable
	// DKIM signing for this identity; false to disable it.
	//
	// DkimEnabled is a required field
	DkimEnabled *bool `type:"boolean" required:"true"`

	// The identity for which DKIM signing should be enabled or disabled.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityDkimEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityDkimEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityDkimEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityDkimEnabledInput"}
	if s.DkimEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("DkimEnabled"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDkimEnabled sets the DkimEnabled field's value.
func (s *SetIdentityDkimEnabledInput) SetDkimEnabled(v bool) *SetIdentityDkimEnabledInput {
	s.DkimEnabled = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityDkimEnabledInput) SetIdentity(v string) *SetIdentityDkimEnabledInput {
	s.Identity = &v
	return s
}

// An empty element returned on a successful request.
type SetIdentityDkimEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityDkimEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityDkimEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to enable or disable whether Amazon SES forwards you
// bounce and complaint notifications through email. For information about email
// feedback forwarding, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications-email.html).
type SetIdentityFeedbackForwardingEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether Amazon SES forwards bounce and complaint notifications as email.
	// true specifies that Amazon SES forwards bounce and complaint notifications
	// as email, in addition to any Amazon SNS topic publishing otherwise specified.
	// false specifies that Amazon SES publishes bounce and complaint notifications
	// only through Amazon SNS. This value can only be set to false when Amazon
	// SNS topics are set for both Bounce and Complaint notification types.
	//
	// ForwardingEnabled is a required field
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// The identity for which to set bounce and complaint notification forwarding.
	// Examples: user@example.com, example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityFeedbackForwardingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityFeedbackForwardingEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityFeedbackForwardingEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityFeedbackForwardingEnabledInput"}
	if s.ForwardingEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardingEnabled"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForwardingEnabled sets the ForwardingEnabled field's value.
func (s *SetIdentityFeedbackForwardingEnabledInput) SetForwardingEnabled(v bool) *SetIdentityFeedbackForwardingEnabledInput {
	s.ForwardingEnabled = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityFeedbackForwardingEnabledInput) SetIdentity(v string) *SetIdentityFeedbackForwardingEnabledInput {
	s.Identity = &v
	return s
}

// An empty element returned on a successful request.
type SetIdentityFeedbackForwardingEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityFeedbackForwardingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityFeedbackForwardingEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to set whether Amazon SES includes the original email
// headers in the Amazon SNS notifications of a specified type. For information
// about notifications, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications-sns.html).
type SetIdentityHeadersInNotificationsEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether Amazon SES includes the original email headers in Amazon SNS
	// notifications of the specified notification type. A value of true specifies
	// that Amazon SES includes headers in notifications, and a value of false specifies
	// that Amazon SES does not include headers in notifications.
	//
	// This value can only be set when NotificationType is already set to use a
	// particular Amazon SNS topic.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The identity for which to enable or disable headers in notifications. Examples:
	// user@example.com, example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The notification type for which to enable or disable headers in notifications.
	//
	// NotificationType is a required field
	NotificationType *string `type:"string" required:"true" enum:"NotificationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityHeadersInNotificationsEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityHeadersInNotificationsEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityHeadersInNotificationsEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityHeadersInNotificationsEnabledInput"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.NotificationType == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *SetIdentityHeadersInNotificationsEnabledInput) SetEnabled(v bool) *SetIdentityHeadersInNotificationsEnabledInput {
	s.Enabled = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityHeadersInNotificationsEnabledInput) SetIdentity(v string) *SetIdentityHeadersInNotificationsEnabledInput {
	s.Identity = &v
	return s
}

// SetNotificationType sets the NotificationType field's value.
func (s *SetIdentityHeadersInNotificationsEnabledInput) SetNotificationType(v string) *SetIdentityHeadersInNotificationsEnabledInput {
	s.NotificationType = &v
	return s
}

// An empty element returned on a successful request.
type SetIdentityHeadersInNotificationsEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityHeadersInNotificationsEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityHeadersInNotificationsEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to enable or disable the Amazon SES custom MAIL FROM
// domain setup for a verified identity. For information about using a custom
// MAIL FROM domain, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/mail-from.html).
type SetIdentityMailFromDomainInput struct {
	_ struct{} `type:"structure"`

	// The action for Amazon SES to take if it cannot successfully read the required
	// MX record when you send an email. If you choose UseDefaultValue, Amazon SES
	// uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you
	// choose RejectMessage, Amazon SES returns a MailFromDomainNotVerified error
	// and not send the email.
	//
	// The action specified in BehaviorOnMXFailure is taken when the custom MAIL
	// FROM domain setup is in the Pending, Failed, and TemporaryFailure states.
	BehaviorOnMXFailure *string `type:"string" enum:"BehaviorOnMXFailure"`

	// The verified identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The custom MAIL FROM domain for the verified identity to use. The MAIL FROM
	// domain must 1) be a subdomain of the verified identity, 2) not be used in
	// a "From" address if the MAIL FROM domain is the destination of email feedback
	// forwarding (for more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/mail-from.html)),
	// and 3) not be used to receive emails. A value of null disables the custom
	// MAIL FROM setting for the identity.
	MailFromDomain *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityMailFromDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityMailFromDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityMailFromDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityMailFromDomainInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBehaviorOnMXFailure sets the BehaviorOnMXFailure field's value.
func (s *SetIdentityMailFromDomainInput) SetBehaviorOnMXFailure(v string) *SetIdentityMailFromDomainInput {
	s.BehaviorOnMXFailure = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityMailFromDomainInput) SetIdentity(v string) *SetIdentityMailFromDomainInput {
	s.Identity = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *SetIdentityMailFromDomainInput) SetMailFromDomain(v string) *SetIdentityMailFromDomainInput {
	s.MailFromDomain = &v
	return s
}

// An empty element returned on a successful request.
type SetIdentityMailFromDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityMailFromDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityMailFromDomainOutput) GoString() string {
	return s.String()
}

// Represents a request to specify the Amazon SNS topic to which Amazon SES
// publishes bounce, complaint, or delivery notifications for emails sent with
// that identity as the source. For information about Amazon SES notifications,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity-using-notifications-sns.html).
type SetIdentityNotificationTopicInput struct {
	_ struct{} `type:"structure"`

	// The identity (email address or domain) for the Amazon SNS topic.
	//
	// You can only specify a verified identity for this parameter.
	//
	// You can specify an identity by using its name or by using its Amazon Resource
	// Name (ARN). The following examples are all valid identities: sender@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The type of notifications that are published to the specified Amazon SNS
	// topic.
	//
	// NotificationType is a required field
	NotificationType *string `type:"string" required:"true" enum:"NotificationType"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter
	// is omitted from the request or a null value is passed, SnsTopic is cleared
	// and publishing is disabled.
	SnsTopic *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityNotificationTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityNotificationTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityNotificationTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityNotificationTopicInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.NotificationType == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityNotificationTopicInput) SetIdentity(v string) *SetIdentityNotificationTopicInput {
	s.Identity = &v
	return s
}

// SetNotificationType sets the NotificationType field's value.
func (s *SetIdentityNotificationTopicInput) SetNotificationType(v string) *SetIdentityNotificationTopicInput {
	s.NotificationType = &v
	return s
}

// SetSnsTopic sets the SnsTopic field's value.
func (s *SetIdentityNotificationTopicInput) SetSnsTopic(v string) *SetIdentityNotificationTopicInput {
	s.SnsTopic = &v
	return s
}

// An empty element returned on a successful request.
type SetIdentityNotificationTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityNotificationTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetIdentityNotificationTopicOutput) GoString() string {
	return s.String()
}

// Represents a request to set the position of a receipt rule in a receipt rule
// set. You use receipt rule sets to receive email with Amazon SES. For more
// information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type SetReceiptRulePositionInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule after which to place the specified receipt rule.
	After *string `type:"string"`

	// The name of the receipt rule to reposition.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that contains the receipt rule to reposition.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetReceiptRulePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetReceiptRulePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetReceiptRulePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetReceiptRulePositionInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfter sets the After field's value.
func (s *SetReceiptRulePositionInput) SetAfter(v string) *SetReceiptRulePositionInput {
	s.After = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *SetReceiptRulePositionInput) SetRuleName(v string) *SetReceiptRulePositionInput {
	s.RuleName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *SetReceiptRulePositionInput) SetRuleSetName(v string) *SetReceiptRulePositionInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type SetReceiptRulePositionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetReceiptRulePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetReceiptRulePositionOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action terminates the evaluation of
// the receipt rule set and, optionally, publishes a notification to Amazon
// Simple Notification Service (Amazon SNS).
//
// For information about setting a stop action in a receipt rule, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-stop.html).
type StopAction struct {
	_ struct{} `type:"structure"`

	// The scope of the StopAction. The only acceptable value is RuleSet.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"StopScope"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// stop action is taken. You can find the ARN of a topic by using the ListTopics
	// (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) Amazon SNS
	// operation.
	//
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopAction"}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScope sets the Scope field's value.
func (s *StopAction) SetScope(v string) *StopAction {
	s.Scope = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *StopAction) SetTopicArn(v string) *StopAction {
	s.TopicArn = &v
	return s
}

// The content of the email, composed of a subject line and either an HTML part
// or a text-only part.
type Template struct {
	_ struct{} `type:"structure"`

	// The HTML body of the email.
	HtmlPart *string `type:"string"`

	// The subject line of the email.
	SubjectPart *string `type:"string"`

	// The name of the template. You use this name when you send email using the
	// SendTemplatedEmail or SendBulkTemplatedEmail operations.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The email body that is visible to recipients whose email clients do not display
	// HTML content.
	TextPart *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Template) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Template) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Template"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHtmlPart sets the HtmlPart field's value.
func (s *Template) SetHtmlPart(v string) *Template {
	s.HtmlPart = &v
	return s
}

// SetSubjectPart sets the SubjectPart field's value.
func (s *Template) SetSubjectPart(v string) *Template {
	s.SubjectPart = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *Template) SetTemplateName(v string) *Template {
	s.TemplateName = &v
	return s
}

// SetTextPart sets the TextPart field's value.
func (s *Template) SetTextPart(v string) *Template {
	s.TextPart = &v
	return s
}

// Contains information about an email template.
type TemplateMetadata struct {
	_ struct{} `type:"structure"`

	// The time and date the template was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The name of the template.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateMetadata) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *TemplateMetadata) SetCreatedTimestamp(v time.Time) *TemplateMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateMetadata) SetName(v string) *TemplateMetadata {
	s.Name = &v
	return s
}

type TestRenderTemplateInput struct {
	_ struct{} `type:"structure"`

	// A list of replacement values to apply to the template. This parameter is
	// a JSON object, typically consisting of key-value pairs in which the keys
	// correspond to replacement tags in the email template.
	//
	// TemplateData is a required field
	TemplateData *string `type:"string" required:"true"`

	// The name of the template to render.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRenderTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRenderTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestRenderTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestRenderTemplateInput"}
	if s.TemplateData == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateData"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateData sets the TemplateData field's value.
func (s *TestRenderTemplateInput) SetTemplateData(v string) *TestRenderTemplateInput {
	s.TemplateData = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *TestRenderTemplateInput) SetTemplateName(v string) *TestRenderTemplateInput {
	s.TemplateName = &v
	return s
}

type TestRenderTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The complete MIME message rendered by applying the data in the TemplateData
	// parameter to the template specified in the TemplateName parameter.
	RenderedTemplate *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRenderTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestRenderTemplateOutput) GoString() string {
	return s.String()
}

// SetRenderedTemplate sets the RenderedTemplate field's value.
func (s *TestRenderTemplateOutput) SetRenderedTemplate(v string) *TestRenderTemplateOutput {
	s.RenderedTemplate = &v
	return s
}

// A domain that is used to redirect email recipients to an Amazon SES-operated
// domain. This domain captures open and click events generated by Amazon SES
// emails.
//
// For more information, see Configuring Custom Domains to Handle Open and Click
// Tracking (https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html)
// in the Amazon SES Developer Guide.
type TrackingOptions struct {
	_ struct{} `type:"structure"`

	// The custom subdomain that is used to redirect email recipients to the Amazon
	// SES event tracking domain.
	CustomRedirectDomain *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrackingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrackingOptions) GoString() string {
	return s.String()
}

// SetCustomRedirectDomain sets the CustomRedirectDomain field's value.
func (s *TrackingOptions) SetCustomRedirectDomain(v string) *TrackingOptions {
	s.CustomRedirectDomain = &v
	return s
}

// Represents a request to enable or disable the email sending capabilities
// for your entire Amazon SES account.
type UpdateAccountSendingEnabledInput struct {
	_ struct{} `type:"structure"`

	// Describes whether email sending is enabled or disabled for your Amazon SES
	// account in the current Amazon Web Services Region.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSendingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSendingEnabledInput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateAccountSendingEnabledInput) SetEnabled(v bool) *UpdateAccountSendingEnabledInput {
	s.Enabled = &v
	return s
}

type UpdateAccountSendingEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSendingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSendingEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to update the event destination of a configuration set.
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/monitor-sending-activity.html).
type UpdateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that contains the event destination.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// The event destination object.
	//
	// EventDestination is a required field
	EventDestination *EventDestination `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestination) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// An empty element returned on a successful request.
type UpdateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// Represents a request to modify the reputation metric publishing settings
// for a configuration set.
type UpdateConfigurationSetReputationMetricsEnabledInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to update.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// Describes whether or not Amazon SES publishes reputation metrics for the
	// configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetReputationMetricsEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetReputationMetricsEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetReputationMetricsEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetReputationMetricsEnabledInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetReputationMetricsEnabledInput) SetConfigurationSetName(v string) *UpdateConfigurationSetReputationMetricsEnabledInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateConfigurationSetReputationMetricsEnabledInput) SetEnabled(v bool) *UpdateConfigurationSetReputationMetricsEnabledInput {
	s.Enabled = &v
	return s
}

type UpdateConfigurationSetReputationMetricsEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetReputationMetricsEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetReputationMetricsEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to enable or disable the email sending capabilities
// for a specific configuration set.
type UpdateConfigurationSetSendingEnabledInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to update.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// Describes whether email sending is enabled or disabled for the configuration
	// set.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetSendingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetSendingEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetSendingEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetSendingEnabledInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetSendingEnabledInput) SetConfigurationSetName(v string) *UpdateConfigurationSetSendingEnabledInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateConfigurationSetSendingEnabledInput) SetEnabled(v bool) *UpdateConfigurationSetSendingEnabledInput {
	s.Enabled = &v
	return s
}

type UpdateConfigurationSetSendingEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetSendingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetSendingEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to update the tracking options for a configuration set.
type UpdateConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// A domain that is used to redirect email recipients to an Amazon SES-operated
	// domain. This domain captures open and click events generated by Amazon SES
	// emails.
	//
	// For more information, see Configuring Custom Domains to Handle Open and Click
	// Tracking (https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html)
	// in the Amazon SES Developer Guide.
	//
	// TrackingOptions is a required field
	TrackingOptions *TrackingOptions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetTrackingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetTrackingOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.TrackingOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackingOptions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetTrackingOptionsInput) SetConfigurationSetName(v string) *UpdateConfigurationSetTrackingOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetTrackingOptions sets the TrackingOptions field's value.
func (s *UpdateConfigurationSetTrackingOptionsInput) SetTrackingOptions(v *TrackingOptions) *UpdateConfigurationSetTrackingOptionsInput {
	s.TrackingOptions = v
	return s
}

// An empty element returned on a successful request.
type UpdateConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfigurationSetTrackingOptionsOutput) GoString() string {
	return s.String()
}

// Represents a request to update an existing custom verification email template.
type UpdateCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The content of the custom verification email. The total size of the email
	// must be less than 10 MB. The message body may contain HTML, with some limitations.
	// For more information, see Custom Verification Email Frequently Asked Questions
	// (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#send-email-verify-address-custom)
	// in the Amazon SES Developer Guide.
	TemplateContent *string `type:"string"`

	// The name of the custom verification email template to update.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomVerificationEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetFailureRedirectionURL(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetFromEmailAddress(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetSuccessRedirectionURL(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetTemplateContent(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.TemplateContent = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetTemplateName(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetTemplateSubject(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.TemplateSubject = &v
	return s
}

type UpdateCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// Represents a request to update a receipt rule. You use receipt rules to receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-concepts.html).
type UpdateReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the updated receipt rule information.
	//
	// Rule is a required field
	Rule *ReceiptRule `type:"structure" required:"true"`

	// The name of the receipt rule set that the receipt rule belongs to.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReceiptRuleInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *UpdateReceiptRuleInput) SetRule(v *ReceiptRule) *UpdateReceiptRuleInput {
	s.Rule = v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *UpdateReceiptRuleInput) SetRuleSetName(v string) *UpdateReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
type UpdateReceiptRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReceiptRuleOutput) GoString() string {
	return s.String()
}

type UpdateTemplateInput struct {
	_ struct{} `type:"structure"`

	// The content of the email, composed of a subject line and either an HTML part
	// or a text-only part.
	//
	// Template is a required field
	Template *Template `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateInput"}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil {
		if err := s.Template.Validate(); err != nil {
			invalidParams.AddNested("Template", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplate sets the Template field's value.
func (s *UpdateTemplateInput) SetTemplate(v *Template) *UpdateTemplateInput {
	s.Template = v
	return s
}

type UpdateTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateOutput) GoString() string {
	return s.String()
}

// Represents a request to generate the CNAME records needed to set up Easy
// DKIM with Amazon SES. For more information about setting up Easy DKIM, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
type VerifyDomainDkimInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to be verified for Easy DKIM signing.
	//
	// Domain is a required field
	Domain *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainDkimInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainDkimInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyDomainDkimInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyDomainDkimInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *VerifyDomainDkimInput) SetDomain(v string) *VerifyDomainDkimInput {
	s.Domain = &v
	return s
}

// Returns CNAME records that you must publish to the DNS server of your domain
// to set up Easy DKIM with Amazon SES.
type VerifyDomainDkimOutput struct {
	_ struct{} `type:"structure"`

	// A set of character strings that represent the domain's identity. If the identity
	// is an email address, the tokens represent the domain of that address.
	//
	// Using these tokens, you need to create DNS CNAME records that point to DKIM
	// public keys that are hosted by Amazon SES. Amazon Web Services eventually
	// detects that you've updated your DNS records. This detection process might
	// take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign
	// email originating from that domain. (This only applies to domain identities,
	// not email address identities.)
	//
	// For more information about creating DNS records using DKIM tokens, see the
	// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html).
	//
	// DkimTokens is a required field
	DkimTokens []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainDkimOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainDkimOutput) GoString() string {
	return s.String()
}

// SetDkimTokens sets the DkimTokens field's value.
func (s *VerifyDomainDkimOutput) SetDkimTokens(v []*string) *VerifyDomainDkimOutput {
	s.DkimTokens = v
	return s
}

// Represents a request to begin Amazon SES domain verification and to generate
// the TXT records that you must publish to the DNS server of your domain to
// complete the verification. For information about domain verification, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#verify-domain-procedure).
type VerifyDomainIdentityInput struct {
	_ struct{} `type:"structure"`

	// The domain to be verified.
	//
	// Domain is a required field
	Domain *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyDomainIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyDomainIdentityInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *VerifyDomainIdentityInput) SetDomain(v string) *VerifyDomainIdentityInput {
	s.Domain = &v
	return s
}

// Returns a TXT record that you must publish to the DNS server of your domain
// to complete domain verification with Amazon SES.
type VerifyDomainIdentityOutput struct {
	_ struct{} `type:"structure"`

	// A TXT record that you must place in the DNS settings of the domain to complete
	// domain verification with Amazon SES.
	//
	// As Amazon SES searches for the TXT record, the domain's verification status
	// is "Pending". When Amazon SES detects the record, the domain's verification
	// status changes to "Success". If Amazon SES is unable to detect the record
	// within 72 hours, the domain's verification status changes to "Failed." In
	// that case, to verify the domain, you must restart the verification process
	// from the beginning. The domain's verification status also changes to "Success"
	// when it is DKIM verified.
	//
	// VerificationToken is a required field
	VerificationToken *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyDomainIdentityOutput) GoString() string {
	return s.String()
}

// SetVerificationToken sets the VerificationToken field's value.
func (s *VerifyDomainIdentityOutput) SetVerificationToken(v string) *VerifyDomainIdentityOutput {
	s.VerificationToken = &v
	return s
}

// Represents a request to begin email address verification with Amazon SES.
// For information about email address verification, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#verify-email-addresses-procedure).
type VerifyEmailAddressInput struct {
	_ struct{} `type:"structure"`

	// The email address to be verified.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyEmailAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyEmailAddressInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *VerifyEmailAddressInput) SetEmailAddress(v string) *VerifyEmailAddressInput {
	s.EmailAddress = &v
	return s
}

type VerifyEmailAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailAddressOutput) GoString() string {
	return s.String()
}

// Represents a request to begin email address verification with Amazon SES.
// For information about email address verification, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/dg/creating-identities.html#verify-email-addresses-procedure).
type VerifyEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The email address to be verified.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyEmailIdentityInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *VerifyEmailIdentityInput) SetEmailAddress(v string) *VerifyEmailIdentityInput {
	s.EmailAddress = &v
	return s
}

// An empty element returned on a successful request.
type VerifyEmailIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyEmailIdentityOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action calls Amazon WorkMail and, optionally,
// publishes a notification to Amazon Simple Notification Service (Amazon SNS).
// It usually isn't necessary to set this up manually, because Amazon WorkMail
// adds the rule automatically during its setup procedure.
//
// For information using a receipt rule to call Amazon WorkMail, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-workmail.html).
type WorkmailAction struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon
	// WorkMail ARNs use the following format:
	//
	// arn:aws:workmail:<region>:<awsAccountId>:organization/<workmailOrganizationId>
	//
	// You can find the ID of your organization by using the ListOrganizations (https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html)
	// operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with
	// "m-", followed by a string of alphanumeric characters.
	//
	// For information about Amazon WorkMail organizations, see the Amazon WorkMail
	// Administrator Guide (https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html).
	//
	// OrganizationArn is a required field
	OrganizationArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// WorkMail action is called. You can find the ARN of a topic by using the ListTopics
	// (https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html) operation
	// in Amazon SNS.
	//
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkmailAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkmailAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkmailAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkmailAction"}
	if s.OrganizationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationArn sets the OrganizationArn field's value.
func (s *WorkmailAction) SetOrganizationArn(v string) *WorkmailAction {
	s.OrganizationArn = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *WorkmailAction) SetTopicArn(v string) *WorkmailAction {
	s.TopicArn = &v
	return s
}

const (
	// BehaviorOnMXFailureUseDefaultValue is a BehaviorOnMXFailure enum value
	BehaviorOnMXFailureUseDefaultValue = "UseDefaultValue"

	// BehaviorOnMXFailureRejectMessage is a BehaviorOnMXFailure enum value
	BehaviorOnMXFailureRejectMessage = "RejectMessage"
)

// BehaviorOnMXFailure_Values returns all elements of the BehaviorOnMXFailure enum
func BehaviorOnMXFailure_Values() []string {
	return []string{
		BehaviorOnMXFailureUseDefaultValue,
		BehaviorOnMXFailureRejectMessage,
	}
}

const (
	// BounceTypeDoesNotExist is a BounceType enum value
	BounceTypeDoesNotExist = "DoesNotExist"

	// BounceTypeMessageTooLarge is a BounceType enum value
	BounceTypeMessageTooLarge = "MessageTooLarge"

	// BounceTypeExceededQuota is a BounceType enum value
	BounceTypeExceededQuota = "ExceededQuota"

	// BounceTypeContentRejected is a BounceType enum value
	BounceTypeContentRejected = "ContentRejected"

	// BounceTypeUndefined is a BounceType enum value
	BounceTypeUndefined = "Undefined"

	// BounceTypeTemporaryFailure is a BounceType enum value
	BounceTypeTemporaryFailure = "TemporaryFailure"
)

// BounceType_Values returns all elements of the BounceType enum
func BounceType_Values() []string {
	return []string{
		BounceTypeDoesNotExist,
		BounceTypeMessageTooLarge,
		BounceTypeExceededQuota,
		BounceTypeContentRejected,
		BounceTypeUndefined,
		BounceTypeTemporaryFailure,
	}
}

const (
	// BulkEmailStatusSuccess is a BulkEmailStatus enum value
	BulkEmailStatusSuccess = "Success"

	// BulkEmailStatusMessageRejected is a BulkEmailStatus enum value
	BulkEmailStatusMessageRejected = "MessageRejected"

	// BulkEmailStatusMailFromDomainNotVerified is a BulkEmailStatus enum value
	BulkEmailStatusMailFromDomainNotVerified = "MailFromDomainNotVerified"

	// BulkEmailStatusConfigurationSetDoesNotExist is a BulkEmailStatus enum value
	BulkEmailStatusConfigurationSetDoesNotExist = "ConfigurationSetDoesNotExist"

	// BulkEmailStatusTemplateDoesNotExist is a BulkEmailStatus enum value
	BulkEmailStatusTemplateDoesNotExist = "TemplateDoesNotExist"

	// BulkEmailStatusAccountSuspended is a BulkEmailStatus enum value
	BulkEmailStatusAccountSuspended = "AccountSuspended"

	// BulkEmailStatusAccountThrottled is a BulkEmailStatus enum value
	BulkEmailStatusAccountThrottled = "AccountThrottled"

	// BulkEmailStatusAccountDailyQuotaExceeded is a BulkEmailStatus enum value
	BulkEmailStatusAccountDailyQuotaExceeded = "AccountDailyQuotaExceeded"

	// BulkEmailStatusInvalidSendingPoolName is a BulkEmailStatus enum value
	BulkEmailStatusInvalidSendingPoolName = "InvalidSendingPoolName"

	// BulkEmailStatusAccountSendingPaused is a BulkEmailStatus enum value
	BulkEmailStatusAccountSendingPaused = "AccountSendingPaused"

	// BulkEmailStatusConfigurationSetSendingPaused is a BulkEmailStatus enum value
	BulkEmailStatusConfigurationSetSendingPaused = "ConfigurationSetSendingPaused"

	// BulkEmailStatusInvalidParameterValue is a BulkEmailStatus enum value
	BulkEmailStatusInvalidParameterValue = "InvalidParameterValue"

	// BulkEmailStatusTransientFailure is a BulkEmailStatus enum value
	BulkEmailStatusTransientFailure = "TransientFailure"

	// BulkEmailStatusFailed is a BulkEmailStatus enum value
	BulkEmailStatusFailed = "Failed"
)

// BulkEmailStatus_Values returns all elements of the BulkEmailStatus enum
func BulkEmailStatus_Values() []string {
	return []string{
		BulkEmailStatusSuccess,
		BulkEmailStatusMessageRejected,
		BulkEmailStatusMailFromDomainNotVerified,
		BulkEmailStatusConfigurationSetDoesNotExist,
		BulkEmailStatusTemplateDoesNotExist,
		BulkEmailStatusAccountSuspended,
		BulkEmailStatusAccountThrottled,
		BulkEmailStatusAccountDailyQuotaExceeded,
		BulkEmailStatusInvalidSendingPoolName,
		BulkEmailStatusAccountSendingPaused,
		BulkEmailStatusConfigurationSetSendingPaused,
		BulkEmailStatusInvalidParameterValue,
		BulkEmailStatusTransientFailure,
		BulkEmailStatusFailed,
	}
}

const (
	// ConfigurationSetAttributeEventDestinations is a ConfigurationSetAttribute enum value
	ConfigurationSetAttributeEventDestinations = "eventDestinations"

	// ConfigurationSetAttributeTrackingOptions is a ConfigurationSetAttribute enum value
	ConfigurationSetAttributeTrackingOptions = "trackingOptions"

	// ConfigurationSetAttributeDeliveryOptions is a ConfigurationSetAttribute enum value
	ConfigurationSetAttributeDeliveryOptions = "deliveryOptions"

	// ConfigurationSetAttributeReputationOptions is a ConfigurationSetAttribute enum value
	ConfigurationSetAttributeReputationOptions = "reputationOptions"
)

// ConfigurationSetAttribute_Values returns all elements of the ConfigurationSetAttribute enum
func ConfigurationSetAttribute_Values() []string {
	return []string{
		ConfigurationSetAttributeEventDestinations,
		ConfigurationSetAttributeTrackingOptions,
		ConfigurationSetAttributeDeliveryOptions,
		ConfigurationSetAttributeReputationOptions,
	}
}

const (
	// CustomMailFromStatusPending is a CustomMailFromStatus enum value
	CustomMailFromStatusPending = "Pending"

	// CustomMailFromStatusSuccess is a CustomMailFromStatus enum value
	CustomMailFromStatusSuccess = "Success"

	// CustomMailFromStatusFailed is a CustomMailFromStatus enum value
	CustomMailFromStatusFailed = "Failed"

	// CustomMailFromStatusTemporaryFailure is a CustomMailFromStatus enum value
	CustomMailFromStatusTemporaryFailure = "TemporaryFailure"
)

// CustomMailFromStatus_Values returns all elements of the CustomMailFromStatus enum
func CustomMailFromStatus_Values() []string {
	return []string{
		CustomMailFromStatusPending,
		CustomMailFromStatusSuccess,
		CustomMailFromStatusFailed,
		CustomMailFromStatusTemporaryFailure,
	}
}

const (
	// DimensionValueSourceMessageTag is a DimensionValueSource enum value
	DimensionValueSourceMessageTag = "messageTag"

	// DimensionValueSourceEmailHeader is a DimensionValueSource enum value
	DimensionValueSourceEmailHeader = "emailHeader"

	// DimensionValueSourceLinkTag is a DimensionValueSource enum value
	DimensionValueSourceLinkTag = "linkTag"
)

// DimensionValueSource_Values returns all elements of the DimensionValueSource enum
func DimensionValueSource_Values() []string {
	return []string{
		DimensionValueSourceMessageTag,
		DimensionValueSourceEmailHeader,
		DimensionValueSourceLinkTag,
	}
}

const (
	// DsnActionFailed is a DsnAction enum value
	DsnActionFailed = "failed"

	// DsnActionDelayed is a DsnAction enum value
	DsnActionDelayed = "delayed"

	// DsnActionDelivered is a DsnAction enum value
	DsnActionDelivered = "delivered"

	// DsnActionRelayed is a DsnAction enum value
	DsnActionRelayed = "relayed"

	// DsnActionExpanded is a DsnAction enum value
	DsnActionExpanded = "expanded"
)

// DsnAction_Values returns all elements of the DsnAction enum
func DsnAction_Values() []string {
	return []string{
		DsnActionFailed,
		DsnActionDelayed,
		DsnActionDelivered,
		DsnActionRelayed,
		DsnActionExpanded,
	}
}

const (
	// EventTypeSend is a EventType enum value
	EventTypeSend = "send"

	// EventTypeReject is a EventType enum value
	EventTypeReject = "reject"

	// EventTypeBounce is a EventType enum value
	EventTypeBounce = "bounce"

	// EventTypeComplaint is a EventType enum value
	EventTypeComplaint = "complaint"

	// EventTypeDelivery is a EventType enum value
	EventTypeDelivery = "delivery"

	// EventTypeOpen is a EventType enum value
	EventTypeOpen = "open"

	// EventTypeClick is a EventType enum value
	EventTypeClick = "click"

	// EventTypeRenderingFailure is a EventType enum value
	EventTypeRenderingFailure = "renderingFailure"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeSend,
		EventTypeReject,
		EventTypeBounce,
		EventTypeComplaint,
		EventTypeDelivery,
		EventTypeOpen,
		EventTypeClick,
		EventTypeRenderingFailure,
	}
}

const (
	// IdentityTypeEmailAddress is a IdentityType enum value
	IdentityTypeEmailAddress = "EmailAddress"

	// IdentityTypeDomain is a IdentityType enum value
	IdentityTypeDomain = "Domain"
)

// IdentityType_Values returns all elements of the IdentityType enum
func IdentityType_Values() []string {
	return []string{
		IdentityTypeEmailAddress,
		IdentityTypeDomain,
	}
}

const (
	// InvocationTypeEvent is a InvocationType enum value
	InvocationTypeEvent = "Event"

	// InvocationTypeRequestResponse is a InvocationType enum value
	InvocationTypeRequestResponse = "RequestResponse"
)

// InvocationType_Values returns all elements of the InvocationType enum
func InvocationType_Values() []string {
	return []string{
		InvocationTypeEvent,
		InvocationTypeRequestResponse,
	}
}

const (
	// NotificationTypeBounce is a NotificationType enum value
	NotificationTypeBounce = "Bounce"

	// NotificationTypeComplaint is a NotificationType enum value
	NotificationTypeComplaint = "Complaint"

	// NotificationTypeDelivery is a NotificationType enum value
	NotificationTypeDelivery = "Delivery"
)

// NotificationType_Values returns all elements of the NotificationType enum
func NotificationType_Values() []string {
	return []string{
		NotificationTypeBounce,
		NotificationTypeComplaint,
		NotificationTypeDelivery,
	}
}

const (
	// ReceiptFilterPolicyBlock is a ReceiptFilterPolicy enum value
	ReceiptFilterPolicyBlock = "Block"

	// ReceiptFilterPolicyAllow is a ReceiptFilterPolicy enum value
	ReceiptFilterPolicyAllow = "Allow"
)

// ReceiptFilterPolicy_Values returns all elements of the ReceiptFilterPolicy enum
func ReceiptFilterPolicy_Values() []string {
	return []string{
		ReceiptFilterPolicyBlock,
		ReceiptFilterPolicyAllow,
	}
}

const (
	// SNSActionEncodingUtf8 is a SNSActionEncoding enum value
	SNSActionEncodingUtf8 = "UTF-8"

	// SNSActionEncodingBase64 is a SNSActionEncoding enum value
	SNSActionEncodingBase64 = "Base64"
)

// SNSActionEncoding_Values returns all elements of the SNSActionEncoding enum
func SNSActionEncoding_Values() []string {
	return []string{
		SNSActionEncodingUtf8,
		SNSActionEncodingBase64,
	}
}

const (
	// StopScopeRuleSet is a StopScope enum value
	StopScopeRuleSet = "RuleSet"
)

// StopScope_Values returns all elements of the StopScope enum
func StopScope_Values() []string {
	return []string{
		StopScopeRuleSet,
	}
}

const (
	// TlsPolicyRequire is a TlsPolicy enum value
	TlsPolicyRequire = "Require"

	// TlsPolicyOptional is a TlsPolicy enum value
	TlsPolicyOptional = "Optional"
)

// TlsPolicy_Values returns all elements of the TlsPolicy enum
func TlsPolicy_Values() []string {
	return []string{
		TlsPolicyRequire,
		TlsPolicyOptional,
	}
}

const (
	// VerificationStatusPending is a VerificationStatus enum value
	VerificationStatusPending = "Pending"

	// VerificationStatusSuccess is a VerificationStatus enum value
	VerificationStatusSuccess = "Success"

	// VerificationStatusFailed is a VerificationStatus enum value
	VerificationStatusFailed = "Failed"

	// VerificationStatusTemporaryFailure is a VerificationStatus enum value
	VerificationStatusTemporaryFailure = "TemporaryFailure"

	// VerificationStatusNotStarted is a VerificationStatus enum value
	VerificationStatusNotStarted = "NotStarted"
)

// VerificationStatus_Values returns all elements of the VerificationStatus enum
func VerificationStatus_Values() []string {
	return []string{
		VerificationStatusPending,
		VerificationStatusSuccess,
		VerificationStatusFailed,
		VerificationStatusTemporaryFailure,
		VerificationStatusNotStarted,
	}
}
