---
title: How to contribute
kind: contrib
weight: 1
---

Thanks for your interest in contributing to the Open Policy Agent project!

{{< info >}}
Most of the discussions about OPA take place on Slack, if you haven't already,
you can [sign up here](https://slack.openpolicyagent.org/).
{{< /info >}}

## I'd like to help OPA users

Most users ask in the [#help](https://openpolicyagent.slack.com/archives/CBR63TK2A)
channel in Slack, hang out in there and see if there are any questions you
can help with.

You might also want to keep an eye on the
[OPA Discussion Board](https://github.com/orgs/open-policy-agent/discussions).

## I'd like to contribute code

If you have found a bug and would like to work on a fix, we still encourage you
file a [GitHub Issue](https://github.com/open-policy-agent/opa/issues) first
to talk about the problem and the solution you have in mind.

Similarly, if you have an idea for a new feature, we encourage you to file an
issue to discuss the feature before you start working on it too.

If you want to chat to the maintainers before opening an issue or about anything
else, head over to
[#contributors](https://openpolicyagent.slack.com/archives/C02L1TLPN59) in
Slack.

If you want to contribute code check out the
[development reference](../contrib-development/) for pointers on how to get
started.

## I'd like to help improve the documentation

Great! Please see our [documentation page](../contrib-docs) for more details.

## I have an OPA project or talk I'd like to share

Awesome! For OPA-based projects, we have our [Ecosystem page](/ecosystem/).
This is a great place to showcase your project. See
[the instructions](https://github.com/open-policy-agent/opa/tree/main/docs#opa-ecosystem)
here to get it listed.

If you have a talk or blog you'd like to share please feel free to post in:

- [#ecosystem](https://openpolicyagent.slack.com/archives/C02J6LBL6GH) in Slack.
- [Ecosystem Discussions](https://github.com/orgs/open-policy-agent/discussions/categories/ecosystem) on GitHub.

## I'm interested in something else...

Sounds interesting, we'd love to hear all about it,
[sign up for our Slack](https://slack.openpolicyagent.org/) and
drop a message in the
[#contributors](https://openpolicyagent.slack.com/archives/C02L1TLPN59)
channel.

