/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "zh_Hant_MO" locale.
 */
public class LocalizedNamesImpl_zh_Hant_MO extends LocalizedNamesImpl_zh_Hant {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AR",
        "AE",
        "OM",
        "AZ",
        "AC",
        "AL",
        "DZ",
        "AW",
        "EG",
        "ET",
        "AD",
        "AO",
        "AI",
        "AG",
        "AU",
        "BB",
        "PG",
        "BS",
        "PK",
        "PY",
        "PS",
        "BH",
        "PA",
        "BR",
        "BY",
        "BM",
        "BG",
        "KP",
        "MP",
        "BE",
        "IS",
        "BO",
        "PR",
        "BA",
        "PL",
        "BW",
        "PW",
        "BT",
        "BF",
        "BV",
        "GQ",
        "QO",
        "DK",
        "DE",
        "DG",
        "TG",
        "DM",
        "DO",
        "RU",
        "EC",
        "ER",
        "FR",
        "PF",
        "GF",
        "TF",
        "MF",
        "FO",
        "PH",
        "FI",
        "CV",
        "FK",
        "CR",
        "CO",
        "GG",
        "GD",
        "GL",
        "GE",
        "CU",
        "GP",
        "KZ",
        "HT",
        "AN",
        "SX",
        "NL",
        "BQ",
        "HM",
        "ME",
        "HN",
        "DJ",
        "KI",
        "KG",
        "CA",
        "IC",
        "GA",
        "KH",
        "CZ",
        "CM",
        "QA",
        "KM",
        "XK",
        "CI",
        "KW",
        "CC",
        "CP",
        "HR",
        "KE",
        "LV",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "RE",
        "MR",
        "MU",
        "US",
        "UM",
        "VI",
        "AS",
        "MN",
        "MS",
        "BD",
        "PE",
        "FM",
        "MA",
        "MD",
        "MC",
        "MZ",
        "MX",
        "ZA",
        "GS",
        "AQ",
        "SS",
        "KR",
        "NP",
        "NI",
        "NG",
        "NE",
        "NO",
        "PN",
        "PT",
        "BI",
        "TT",
        "JP",
        "SE",
        "CH",
        "SL",
        "CY",
        "SC",
        "SN",
        "RS",
        "EA",
        "SA",
        "LK",
        "SK",
        "SI",
        "SJ",
        "SZ",
        "SO",
        "SB",
        "TJ",
        "TW",
        "TH",
        "TZ",
        "TC",
        "TA",
        "TN",
        "TR",
        "TM",
        "TK",
        "WF",
        "VU",
        "GT",
        "VE",
        "ES",
        "EH",
        "GR",
        "ZW",
        "SG",
        "NC",
        "HU",
        "JM",
        "IQ",
        "IR",
        "IL",
        "IT",
        "IN",
        "ID",
        "GB",
        "IM",
        "IO",
        "VG",
        "VN",
        "TD",
        "GI",
        "CL",
        "CF",
        "CN",
        "MO",
        "HK",
        "BN",
        "LA",
        "GH",
        "VA",
        "FJ",
        "AM",
        "CG",
        "CD",
        "TV",
        "AT",
        "AX",
        "GM",
        "GN",
        "GW",
        "CK",
        "CW",
        "EE",
        "IE",
        "SY",
        "TL",
        "EU",
        "TO",
        "JE",
        "UG",
        "UA",
        "UY",
        "UZ",
        "LU",
        "RW",
        "JO",
        "NA",
        "NU",
        "NZ",
        "MM",
        "RO",
        "BL",
        "ST",
        "SH",
        "KN",
        "PM",
        "VC",
        "LC",
        "CX",
        "SM",
        "LS",
        "YE",
        "GY",
        "WS",
        "SV",
        "SD",
        "SR",
        "NF",
        "NR",
        "BZ",
        "BJ",
        "ZM",
        "KY",
        "GU",
        "MQ",
        "MW",
        "ML",
        "MK",
        "MY",
        "MV",
        "MT",
        "YT",
        "MH",
        "MG",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("013", "中美洲");
    namesMap.put("019", "美洲地區");
    namesMap.put("029", "加勒比");
    namesMap.put("AE", "阿拉伯聯合酋長國");
    namesMap.put("AG", "安提瓜及巴布達");
    namesMap.put("AW", "阿魯巴");
    namesMap.put("AZ", "阿塞拜疆");
    namesMap.put("BA", "波斯尼亞和黑塞哥維那");
    namesMap.put("BB", "巴巴多斯");
    namesMap.put("BL", "聖巴泰勒米");
    namesMap.put("BW", "博茨瓦納");
    namesMap.put("CD", "剛果 - 金夏沙");
    namesMap.put("CG", "剛果 - 布拉薩");
    namesMap.put("CN", "中國");
    namesMap.put("CR", "哥斯達黎加");
    namesMap.put("CV", "佛得角");
    namesMap.put("CY", "塞浦路斯");
    namesMap.put("EA", "瑟塔與梅利拉");
    namesMap.put("ER", "厄立特里亞");
    namesMap.put("ET", "埃塞俄比亞");
    namesMap.put("GA", "加蓬");
    namesMap.put("GD", "格林納達");
    namesMap.put("GE", "格魯吉亞");
    namesMap.put("GG", "格恩西島");
    namesMap.put("GM", "岡比亞");
    namesMap.put("GP", "瓜德羅普島");
    namesMap.put("GS", "南佐治亞島與南桑威奇群島");
    namesMap.put("GT", "危地馬拉");
    namesMap.put("GY", "蓋亞那");
    namesMap.put("HM", "赫德與麥當勞群島");
    namesMap.put("HN", "洪都拉斯");
    namesMap.put("IM", "英屬地曼島");
    namesMap.put("IT", "意大利");
    namesMap.put("KE", "肯雅");
    namesMap.put("KM", "科摩羅");
    namesMap.put("KN", "聖基茨和尼維斯");
    namesMap.put("LC", "聖盧西亞");
    namesMap.put("LR", "利比里亞");
    namesMap.put("LS", "萊索托");
    namesMap.put("ME", "黑山");
    namesMap.put("ML", "馬里");
    namesMap.put("MR", "毛里塔尼亞");
    namesMap.put("MS", "蒙塞拉特");
    namesMap.put("MU", "毛里裘斯");
    namesMap.put("MV", "馬爾代夫");
    namesMap.put("MZ", "莫桑比克");
    namesMap.put("NC", "新喀里多尼亞");
    namesMap.put("NE", "尼日爾");
    namesMap.put("NG", "尼日利亞");
    namesMap.put("OM", "阿曼");
    namesMap.put("PG", "巴布亞新幾內亞");
    namesMap.put("PM", "聖皮埃爾島及密克隆島");
    namesMap.put("PN", "皮特凱恩島");
    namesMap.put("QA", "卡塔爾");
    namesMap.put("RW", "盧旺達");
    namesMap.put("SA", "沙特阿拉伯");
    namesMap.put("SB", "所羅門群島");
    namesMap.put("SC", "塞舌爾");
    namesMap.put("SI", "斯洛文尼亞");
    namesMap.put("SJ", "斯瓦爾巴群島及揚馬延島");
    namesMap.put("SL", "塞拉利昂");
    namesMap.put("SO", "索馬里");
    namesMap.put("SR", "蘇里南");
    namesMap.put("ST", "聖多美普林西比");
    namesMap.put("SZ", "斯威士蘭");
    namesMap.put("TC", "特克斯和凱科斯群島");
    namesMap.put("TD", "乍得");
    namesMap.put("TF", "法屬南部地區");
    namesMap.put("TK", "托克勞");
    namesMap.put("TO", "湯加");
    namesMap.put("TT", "千里達和多巴哥");
    namesMap.put("TV", "圖瓦盧");
    namesMap.put("TZ", "坦桑尼亞");
    namesMap.put("VA", "梵蒂岡宮城");
    namesMap.put("VC", "聖文森特和格林納丁斯");
    namesMap.put("VU", "瓦努阿圖");
    namesMap.put("ZM", "贊比亞");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "013": "中美洲",
        "019": "美洲地區",
        "029": "加勒比",
        "AE": "阿拉伯聯合酋長國",
        "AG": "安提瓜及巴布達",
        "AW": "阿魯巴",
        "AZ": "阿塞拜疆",
        "BA": "波斯尼亞和黑塞哥維那",
        "BB": "巴巴多斯",
        "BL": "聖巴泰勒米",
        "BW": "博茨瓦納",
        "CD": "剛果 - 金夏沙",
        "CG": "剛果 - 布拉薩",
        "CN": "中國",
        "CR": "哥斯達黎加",
        "CV": "佛得角",
        "CY": "塞浦路斯",
        "EA": "瑟塔與梅利拉",
        "ER": "厄立特里亞",
        "ET": "埃塞俄比亞",
        "GA": "加蓬",
        "GD": "格林納達",
        "GE": "格魯吉亞",
        "GG": "格恩西島",
        "GM": "岡比亞",
        "GP": "瓜德羅普島",
        "GS": "南佐治亞島與南桑威奇群島",
        "GT": "危地馬拉",
        "GY": "蓋亞那",
        "HM": "赫德與麥當勞群島",
        "HN": "洪都拉斯",
        "IM": "英屬地曼島",
        "IT": "意大利",
        "KE": "肯雅",
        "KM": "科摩羅",
        "KN": "聖基茨和尼維斯",
        "LC": "聖盧西亞",
        "LR": "利比里亞",
        "LS": "萊索托",
        "ME": "黑山",
        "ML": "馬里",
        "MR": "毛里塔尼亞",
        "MS": "蒙塞拉特",
        "MU": "毛里裘斯",
        "MV": "馬爾代夫",
        "MZ": "莫桑比克",
        "NC": "新喀里多尼亞",
        "NE": "尼日爾",
        "NG": "尼日利亞",
        "OM": "阿曼",
        "PG": "巴布亞新幾內亞",
        "PM": "聖皮埃爾島及密克隆島",
        "PN": "皮特凱恩島",
        "QA": "卡塔爾",
        "RW": "盧旺達",
        "SA": "沙特阿拉伯",
        "SB": "所羅門群島",
        "SC": "塞舌爾",
        "SI": "斯洛文尼亞",
        "SJ": "斯瓦爾巴群島及揚馬延島",
        "SL": "塞拉利昂",
        "SO": "索馬里",
        "SR": "蘇里南",
        "ST": "聖多美普林西比",
        "SZ": "斯威士蘭",
        "TC": "特克斯和凱科斯群島",
        "TD": "乍得",
        "TF": "法屬南部地區",
        "TK": "托克勞",
        "TO": "湯加",
        "TT": "千里達和多巴哥",
        "TV": "圖瓦盧",
        "TZ": "坦桑尼亞",
        "VA": "梵蒂岡宮城",
        "VC": "聖文森特和格林納丁斯",
        "VU": "瓦努阿圖",
        "ZM": "贊比亞"
    };
  }-*/;
}
