[![Travis](https://travis-ci.org/elastic/ecs.svg?branch=master)](https://travis-ci.org/elastic/ecs)

# Elastic Common Schema (ECS)

The Elastic Common Schema (ECS) defines a common set of fields for
ingesting data into Elasticsearch. A common schema helps you correlate
data from sources like logs and metrics or IT operations
analytics and security analytics.

## Documentation

The ECS reference is published on the main Elastic documentation website.
Visit [the official ECS Reference Documentation](https://www.elastic.co/guide/en/ecs/current/index.html).

## Getting Started

Please review the [tooling usage guide](USAGE.md) to get started using the tools provided in this repo.

## Contributing

If you're looking to contribute to ECS, you're invited to look at our
[contribution guide](CONTRIBUTING.md). Substantial changes to ECS are completed
through our [RFC process](./rfcs/README.md).

## Generated artifacts

Various kinds of files or programs can be generated based on ECS.
You can learn more in [generated/README.md](generated)

## Releases of ECS

The master branch of this repository should never be considered an
official release of ECS. You can browse official releases of ECS
[here](https://github.com/elastic/ecs/releases).

The ECS team publishes improvements to the schema by following
[Semantic Versioning](https://semver.org/).
Generally major ECS releases are planned to be aligned with major Elastic Stack releases.
