// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by scripts/gocodegen.go - DO NOT EDIT.

package ecs

// The vulnerability fields describe information about a vulnerability that is
// relevant to an event.
type Vulnerability struct {
	// The classification of the vulnerability scoring system. For example
	// (https://www.first.org/cvss/)
	Classification string `ecs:"classification"`

	// The type of identifier used for this vulnerability. For example
	// (https://cve.mitre.org/about/)
	Enumeration string `ecs:"enumeration"`

	// A resource that provides additional information, context, and
	// mitigations for the identified vulnerability.
	Reference string `ecs:"reference"`

	// Scores can range from 0.0 to 10.0, with 10.0 being the most severe.
	// Base scores cover an assessment for exploitability metrics (attack
	// vector, complexity, privileges, and user interaction), impact metrics
	// (confidentiality, integrity, and availability), and scope. For example
	// (https://www.first.org/cvss/specification-document)
	ScoreBase float64 `ecs:"score.base"`

	// Scores can range from 0.0 to 10.0, with 10.0 being the most severe.
	// Temporal scores cover an assessment for code maturity, remediation
	// level, and confidence. For example
	// (https://www.first.org/cvss/specification-document)
	ScoreTemporal float64 `ecs:"score.temporal"`

	// Scores can range from 0.0 to 10.0, with 10.0 being the most severe.
	// Environmental scores cover an assessment for any modified Base metrics,
	// confidentiality, integrity, and availability requirements. For example
	// (https://www.first.org/cvss/specification-document)
	ScoreEnvironmental float64 `ecs:"score.environmental"`

	// The National Vulnerability Database (NVD) provides qualitative severity
	// rankings of "Low", "Medium", and "High" for CVSS v2.0 base score ranges
	// in addition to the severity ratings for CVSS v3.0 as they are defined in
	// the CVSS v3.0 specification.
	// CVSS is owned and managed by FIRST.Org, Inc. (FIRST), a US-based
	// non-profit organization, whose mission is to help computer security
	// incident response teams across the world. For example
	// (https://nvd.nist.gov/vuln-metrics/cvss)
	ScoreVersion string `ecs:"score.version"`

	// The type of system or architecture that the vulnerability affects. These
	// may be platform-specific (for example, Debian or SUSE) or general (for
	// example, Database or Firewall). For example
	// (https://qualysguard.qualys.com/qwebhelp/fo_portal/knowledgebase/vulnerability_categories.htm[Qualys
	// vulnerability categories])
	// This field must be an array.
	Category string `ecs:"category"`

	// The description of the vulnerability that provides additional context of
	// the vulnerability. For example
	// (https://cve.mitre.org/about/faqs.html#cve_entry_descriptions_created[Common
	// Vulnerabilities and Exposure CVE description])
	Description string `ecs:"description"`

	// The identification (ID) is the number portion of a vulnerability entry.
	// It includes a unique identification number for the vulnerability. For
	// example (https://cve.mitre.org/about/faqs.html#what_is_cve_id)[Common
	// Vulnerabilities and Exposure CVE ID]
	ID string `ecs:"id"`

	// The name of the vulnerability scanner vendor.
	ScannerVendor string `ecs:"scanner.vendor"`

	// The severity of the vulnerability can help with metrics and internal
	// prioritization regarding remediation. For example
	// (https://nvd.nist.gov/vuln-metrics/cvss)
	Severity string `ecs:"severity"`

	// The report or scan identification number.
	ReportID string `ecs:"report_id"`
}
