---
title: "Learning to solve migration issues in a realistic simulation game"
authors: rotemtam
tags: [simulation, learning, wilco]
---

### Learning new things 

One of my favorite things about software engineering, is that it's a career of continuous learning.
Every new project or challenge presents us with an opportunity to increase our knowledge and improve our skills.
Different people learn in different ways, but for me, one of the most effective ways to learn something new has always been by
doing. Sure, reading books, watching videos and immersing myself in technical documentation is foundational, but
I only feel like I really understand something after I've applied it in some practical way.

This is why I'm excited to announce that we've partnered with [Wilco](https://trywilco.com/) to create a new
kind of learning experience for Atlas users. Wilco develops a platform, built to emulate the conditions at a tech
startup, sends users on "quests" that cover everyday engineering tasks - from deploying an app to finding the root cause
of a production issue - utilizing real-life tech stacks.

When I first heard about Wilco, I was immediately intrigued by the idea of using a simulation game to
teach people about database migrations. Particularly interesting, is the possibility to present people with
opportunities to solve all kinds of issues that many engineers only hit during a serious outage when there's
very little room for error.

### Introducing Wilco

When you use Wilco, you're put in the shoes of a software engineer at a fictional startup. You're given access
to a made up chat system humoristically called "Snack" where you meet different characters that you can interact with.
You are also given access to a real GitHub repo and the means to run a real development environment on your local
machine.

![](https://atlasgo.io/uploads/images/wilco-snack-screenshot.png)
<center><i>Me, interacting with Keen, my team lead on Snack</i></center>

### The new Atlas quest on Wilco

![](https://atlasgo.io/uploads/images/wilco-cover.png)

In the first quest we're releasing today on Wilco, you will be tasked with planning a seemingly simple database
migration to support the development of a new feature in your imaginary company's app. As your team starts to
roll out the feature, you will quickly realize that there are some serious issues that must be resolved, and fast!

And now, without further ado, you can head over to [start your quest](https://www.trywilco.com/quests/data-dependent-schema-migrations)!

### What's next?

Have questions? Feedback? Feel free to reach out [on our Discord server](https://discord.gg/zZ6sWVg6NT).
