---
id: intro
title: Evaluating Atlas for your Use Case
slug: /guides/evaluation/intro
sidebar_label: Introduction
---
### Who is this guide for?

This guide is for developers, architects, and DevOps engineers who are evaluating Atlas for their use case. 
It will help you understand the core concepts of Atlas and how it can be used to manage your database schema.

### What is Atlas?

Atlas is a language-agnostic tool for managing and migrating database schemas using modern DevOps principles. 

### What's in this guide?

This guide is divided into the following sections:

1. **Installation** - How to install Atlas and verify that it is able to understand your database.
2. **Setting Up** - Setting up your project's structure for local work. 
3. **Developer Workflow** - Review working with Atlas from the end-user perspective.
4. **Setting Up CI Pipelines** - How to integrate Atlas into your CI/CD pipelines.
5. **Security Checklist** - Things you should consider for when designing deployment pipelines.
6. **Migrating  Existing Projects** - How to migrate existing projects to Atlas.

### Need help? 

If you are evaluating Atlas for commercial use, you might be eligible for free PoC support
from the team developing Atlas including a dedicated, private Slack Connect channel 
to unblock you in your research

To apply for free PoC support [Click Here](#)