// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package admin provides access to the Admin SDK API.
//
// For product documentation, see: https://developers.google.com/admin-sdk/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/admin/directory/v1"
//	...
//	ctx := context.Background()
//	adminService, err := admin.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	adminService, err := admin.NewService(ctx, option.WithScopes(admin.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	adminService, err := admin.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	adminService, err := admin.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package admin // import "google.golang.org/api/admin/directory/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "admin:directory_v1"
const apiName = "admin"
const apiVersion = "directory_v1"
const basePath = "https://admin.googleapis.com/"
const basePathTemplate = "https://admin.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://admin.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, add, edit, and permanently delete the printers that your organization
	// can use with Chrome
	AdminChromePrintersScope = "https://www.googleapis.com/auth/admin.chrome.printers"

	// See the printers that your organization can use with Chrome
	AdminChromePrintersReadonlyScope = "https://www.googleapis.com/auth/admin.chrome.printers.readonly"

	// View and manage customer related information
	AdminDirectoryCustomerScope = "https://www.googleapis.com/auth/admin.directory.customer"

	// View customer related information
	AdminDirectoryCustomerReadonlyScope = "https://www.googleapis.com/auth/admin.directory.customer.readonly"

	// View and manage your ChromeOS devices' metadata
	AdminDirectoryDeviceChromeosScope = "https://www.googleapis.com/auth/admin.directory.device.chromeos"

	// View your ChromeOS devices' metadata
	AdminDirectoryDeviceChromeosReadonlyScope = "https://www.googleapis.com/auth/admin.directory.device.chromeos.readonly"

	// View and manage your mobile devices' metadata
	AdminDirectoryDeviceMobileScope = "https://www.googleapis.com/auth/admin.directory.device.mobile"

	// Manage your mobile devices by performing administrative tasks
	AdminDirectoryDeviceMobileActionScope = "https://www.googleapis.com/auth/admin.directory.device.mobile.action"

	// View your mobile devices' metadata
	AdminDirectoryDeviceMobileReadonlyScope = "https://www.googleapis.com/auth/admin.directory.device.mobile.readonly"

	// View and manage the provisioning of domains for your customers
	AdminDirectoryDomainScope = "https://www.googleapis.com/auth/admin.directory.domain"

	// View domains related to your customers
	AdminDirectoryDomainReadonlyScope = "https://www.googleapis.com/auth/admin.directory.domain.readonly"

	// View and manage the provisioning of groups on your domain
	AdminDirectoryGroupScope = "https://www.googleapis.com/auth/admin.directory.group"

	// View and manage group subscriptions on your domain
	AdminDirectoryGroupMemberScope = "https://www.googleapis.com/auth/admin.directory.group.member"

	// View group subscriptions on your domain
	AdminDirectoryGroupMemberReadonlyScope = "https://www.googleapis.com/auth/admin.directory.group.member.readonly"

	// View groups on your domain
	AdminDirectoryGroupReadonlyScope = "https://www.googleapis.com/auth/admin.directory.group.readonly"

	// View and manage organization units on your domain
	AdminDirectoryOrgunitScope = "https://www.googleapis.com/auth/admin.directory.orgunit"

	// View organization units on your domain
	AdminDirectoryOrgunitReadonlyScope = "https://www.googleapis.com/auth/admin.directory.orgunit.readonly"

	// View and manage the provisioning of calendar resources on your domain
	AdminDirectoryResourceCalendarScope = "https://www.googleapis.com/auth/admin.directory.resource.calendar"

	// View calendar resources on your domain
	AdminDirectoryResourceCalendarReadonlyScope = "https://www.googleapis.com/auth/admin.directory.resource.calendar.readonly"

	// Manage delegated admin roles for your domain
	AdminDirectoryRolemanagementScope = "https://www.googleapis.com/auth/admin.directory.rolemanagement"

	// View delegated admin roles for your domain
	AdminDirectoryRolemanagementReadonlyScope = "https://www.googleapis.com/auth/admin.directory.rolemanagement.readonly"

	// View and manage the provisioning of users on your domain
	AdminDirectoryUserScope = "https://www.googleapis.com/auth/admin.directory.user"

	// View and manage user aliases on your domain
	AdminDirectoryUserAliasScope = "https://www.googleapis.com/auth/admin.directory.user.alias"

	// View user aliases on your domain
	AdminDirectoryUserAliasReadonlyScope = "https://www.googleapis.com/auth/admin.directory.user.alias.readonly"

	// See info about users on your domain
	AdminDirectoryUserReadonlyScope = "https://www.googleapis.com/auth/admin.directory.user.readonly"

	// Manage data access permissions for users on your domain
	AdminDirectoryUserSecurityScope = "https://www.googleapis.com/auth/admin.directory.user.security"

	// View and manage the provisioning of user schemas on your domain
	AdminDirectoryUserschemaScope = "https://www.googleapis.com/auth/admin.directory.userschema"

	// View user schemas on your domain
	AdminDirectoryUserschemaReadonlyScope = "https://www.googleapis.com/auth/admin.directory.userschema.readonly"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/admin.chrome.printers",
		"https://www.googleapis.com/auth/admin.chrome.printers.readonly",
		"https://www.googleapis.com/auth/admin.directory.customer",
		"https://www.googleapis.com/auth/admin.directory.customer.readonly",
		"https://www.googleapis.com/auth/admin.directory.device.chromeos",
		"https://www.googleapis.com/auth/admin.directory.device.chromeos.readonly",
		"https://www.googleapis.com/auth/admin.directory.device.mobile",
		"https://www.googleapis.com/auth/admin.directory.device.mobile.action",
		"https://www.googleapis.com/auth/admin.directory.device.mobile.readonly",
		"https://www.googleapis.com/auth/admin.directory.domain",
		"https://www.googleapis.com/auth/admin.directory.domain.readonly",
		"https://www.googleapis.com/auth/admin.directory.group",
		"https://www.googleapis.com/auth/admin.directory.group.member",
		"https://www.googleapis.com/auth/admin.directory.group.member.readonly",
		"https://www.googleapis.com/auth/admin.directory.group.readonly",
		"https://www.googleapis.com/auth/admin.directory.orgunit",
		"https://www.googleapis.com/auth/admin.directory.orgunit.readonly",
		"https://www.googleapis.com/auth/admin.directory.resource.calendar",
		"https://www.googleapis.com/auth/admin.directory.resource.calendar.readonly",
		"https://www.googleapis.com/auth/admin.directory.rolemanagement",
		"https://www.googleapis.com/auth/admin.directory.rolemanagement.readonly",
		"https://www.googleapis.com/auth/admin.directory.user",
		"https://www.googleapis.com/auth/admin.directory.user.alias",
		"https://www.googleapis.com/auth/admin.directory.user.alias.readonly",
		"https://www.googleapis.com/auth/admin.directory.user.readonly",
		"https://www.googleapis.com/auth/admin.directory.user.security",
		"https://www.googleapis.com/auth/admin.directory.userschema",
		"https://www.googleapis.com/auth/admin.directory.userschema.readonly",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Asps = NewAspsService(s)
	s.Channels = NewChannelsService(s)
	s.Chromeosdevices = NewChromeosdevicesService(s)
	s.Customer = NewCustomerService(s)
	s.Customers = NewCustomersService(s)
	s.DomainAliases = NewDomainAliasesService(s)
	s.Domains = NewDomainsService(s)
	s.Groups = NewGroupsService(s)
	s.Members = NewMembersService(s)
	s.Mobiledevices = NewMobiledevicesService(s)
	s.Orgunits = NewOrgunitsService(s)
	s.Privileges = NewPrivilegesService(s)
	s.Resources = NewResourcesService(s)
	s.RoleAssignments = NewRoleAssignmentsService(s)
	s.Roles = NewRolesService(s)
	s.Schemas = NewSchemasService(s)
	s.Tokens = NewTokensService(s)
	s.TwoStepVerification = NewTwoStepVerificationService(s)
	s.Users = NewUsersService(s)
	s.VerificationCodes = NewVerificationCodesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Asps *AspsService

	Channels *ChannelsService

	Chromeosdevices *ChromeosdevicesService

	Customer *CustomerService

	Customers *CustomersService

	DomainAliases *DomainAliasesService

	Domains *DomainsService

	Groups *GroupsService

	Members *MembersService

	Mobiledevices *MobiledevicesService

	Orgunits *OrgunitsService

	Privileges *PrivilegesService

	Resources *ResourcesService

	RoleAssignments *RoleAssignmentsService

	Roles *RolesService

	Schemas *SchemasService

	Tokens *TokensService

	TwoStepVerification *TwoStepVerificationService

	Users *UsersService

	VerificationCodes *VerificationCodesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAspsService(s *Service) *AspsService {
	rs := &AspsService{s: s}
	return rs
}

type AspsService struct {
	s *Service
}

func NewChannelsService(s *Service) *ChannelsService {
	rs := &ChannelsService{s: s}
	return rs
}

type ChannelsService struct {
	s *Service
}

func NewChromeosdevicesService(s *Service) *ChromeosdevicesService {
	rs := &ChromeosdevicesService{s: s}
	return rs
}

type ChromeosdevicesService struct {
	s *Service
}

func NewCustomerService(s *Service) *CustomerService {
	rs := &CustomerService{s: s}
	rs.Devices = NewCustomerDevicesService(s)
	return rs
}

type CustomerService struct {
	s *Service

	Devices *CustomerDevicesService
}

func NewCustomerDevicesService(s *Service) *CustomerDevicesService {
	rs := &CustomerDevicesService{s: s}
	rs.Chromeos = NewCustomerDevicesChromeosService(s)
	return rs
}

type CustomerDevicesService struct {
	s *Service

	Chromeos *CustomerDevicesChromeosService
}

func NewCustomerDevicesChromeosService(s *Service) *CustomerDevicesChromeosService {
	rs := &CustomerDevicesChromeosService{s: s}
	rs.Commands = NewCustomerDevicesChromeosCommandsService(s)
	return rs
}

type CustomerDevicesChromeosService struct {
	s *Service

	Commands *CustomerDevicesChromeosCommandsService
}

func NewCustomerDevicesChromeosCommandsService(s *Service) *CustomerDevicesChromeosCommandsService {
	rs := &CustomerDevicesChromeosCommandsService{s: s}
	return rs
}

type CustomerDevicesChromeosCommandsService struct {
	s *Service
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Chrome = NewCustomersChromeService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Chrome *CustomersChromeService
}

func NewCustomersChromeService(s *Service) *CustomersChromeService {
	rs := &CustomersChromeService{s: s}
	rs.PrintServers = NewCustomersChromePrintServersService(s)
	rs.Printers = NewCustomersChromePrintersService(s)
	return rs
}

type CustomersChromeService struct {
	s *Service

	PrintServers *CustomersChromePrintServersService

	Printers *CustomersChromePrintersService
}

func NewCustomersChromePrintServersService(s *Service) *CustomersChromePrintServersService {
	rs := &CustomersChromePrintServersService{s: s}
	return rs
}

type CustomersChromePrintServersService struct {
	s *Service
}

func NewCustomersChromePrintersService(s *Service) *CustomersChromePrintersService {
	rs := &CustomersChromePrintersService{s: s}
	return rs
}

type CustomersChromePrintersService struct {
	s *Service
}

func NewDomainAliasesService(s *Service) *DomainAliasesService {
	rs := &DomainAliasesService{s: s}
	return rs
}

type DomainAliasesService struct {
	s *Service
}

func NewDomainsService(s *Service) *DomainsService {
	rs := &DomainsService{s: s}
	return rs
}

type DomainsService struct {
	s *Service
}

func NewGroupsService(s *Service) *GroupsService {
	rs := &GroupsService{s: s}
	rs.Aliases = NewGroupsAliasesService(s)
	return rs
}

type GroupsService struct {
	s *Service

	Aliases *GroupsAliasesService
}

func NewGroupsAliasesService(s *Service) *GroupsAliasesService {
	rs := &GroupsAliasesService{s: s}
	return rs
}

type GroupsAliasesService struct {
	s *Service
}

func NewMembersService(s *Service) *MembersService {
	rs := &MembersService{s: s}
	return rs
}

type MembersService struct {
	s *Service
}

func NewMobiledevicesService(s *Service) *MobiledevicesService {
	rs := &MobiledevicesService{s: s}
	return rs
}

type MobiledevicesService struct {
	s *Service
}

func NewOrgunitsService(s *Service) *OrgunitsService {
	rs := &OrgunitsService{s: s}
	return rs
}

type OrgunitsService struct {
	s *Service
}

func NewPrivilegesService(s *Service) *PrivilegesService {
	rs := &PrivilegesService{s: s}
	return rs
}

type PrivilegesService struct {
	s *Service
}

func NewResourcesService(s *Service) *ResourcesService {
	rs := &ResourcesService{s: s}
	rs.Buildings = NewResourcesBuildingsService(s)
	rs.Calendars = NewResourcesCalendarsService(s)
	rs.Features = NewResourcesFeaturesService(s)
	return rs
}

type ResourcesService struct {
	s *Service

	Buildings *ResourcesBuildingsService

	Calendars *ResourcesCalendarsService

	Features *ResourcesFeaturesService
}

func NewResourcesBuildingsService(s *Service) *ResourcesBuildingsService {
	rs := &ResourcesBuildingsService{s: s}
	return rs
}

type ResourcesBuildingsService struct {
	s *Service
}

func NewResourcesCalendarsService(s *Service) *ResourcesCalendarsService {
	rs := &ResourcesCalendarsService{s: s}
	return rs
}

type ResourcesCalendarsService struct {
	s *Service
}

func NewResourcesFeaturesService(s *Service) *ResourcesFeaturesService {
	rs := &ResourcesFeaturesService{s: s}
	return rs
}

type ResourcesFeaturesService struct {
	s *Service
}

func NewRoleAssignmentsService(s *Service) *RoleAssignmentsService {
	rs := &RoleAssignmentsService{s: s}
	return rs
}

type RoleAssignmentsService struct {
	s *Service
}

func NewRolesService(s *Service) *RolesService {
	rs := &RolesService{s: s}
	return rs
}

type RolesService struct {
	s *Service
}

func NewSchemasService(s *Service) *SchemasService {
	rs := &SchemasService{s: s}
	return rs
}

type SchemasService struct {
	s *Service
}

func NewTokensService(s *Service) *TokensService {
	rs := &TokensService{s: s}
	return rs
}

type TokensService struct {
	s *Service
}

func NewTwoStepVerificationService(s *Service) *TwoStepVerificationService {
	rs := &TwoStepVerificationService{s: s}
	return rs
}

type TwoStepVerificationService struct {
	s *Service
}

func NewUsersService(s *Service) *UsersService {
	rs := &UsersService{s: s}
	rs.Aliases = NewUsersAliasesService(s)
	rs.Photos = NewUsersPhotosService(s)
	return rs
}

type UsersService struct {
	s *Service

	Aliases *UsersAliasesService

	Photos *UsersPhotosService
}

func NewUsersAliasesService(s *Service) *UsersAliasesService {
	rs := &UsersAliasesService{s: s}
	return rs
}

type UsersAliasesService struct {
	s *Service
}

func NewUsersPhotosService(s *Service) *UsersPhotosService {
	rs := &UsersPhotosService{s: s}
	return rs
}

type UsersPhotosService struct {
	s *Service
}

func NewVerificationCodesService(s *Service) *VerificationCodesService {
	rs := &VerificationCodesService{s: s}
	return rs
}

type VerificationCodesService struct {
	s *Service
}

// Alias: JSON template for Alias object in Directory API.
type Alias struct {
	Alias        string `json:"alias,omitempty"`
	Etag         string `json:"etag,omitempty"`
	Id           string `json:"id,omitempty"`
	Kind         string `json:"kind,omitempty"`
	PrimaryEmail string `json:"primaryEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Alias) MarshalJSON() ([]byte, error) {
	type NoMethod Alias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Aliases: JSON response template to list aliases in Directory API.
type Aliases struct {
	Aliases []interface{} `json:"aliases,omitempty"`
	Etag    string        `json:"etag,omitempty"`
	Kind    string        `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Aliases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aliases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Aliases) MarshalJSON() ([]byte, error) {
	type NoMethod Aliases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Asp: An application-specific password (ASP) is used with applications that
// do not accept a verification code when logging into the application on
// certain devices. The ASP access code is used instead of the login and
// password you commonly use when accessing an application through a browser.
// For more information about ASPs and how to create one, see the help center
// (https://support.google.com/a/answer/2537800#asp).
type Asp struct {
	// CodeId: The unique ID of the ASP.
	CodeId int64 `json:"codeId,omitempty"`
	// CreationTime: The time when the ASP was created. Expressed in Unix time
	// (https://en.wikipedia.org/wiki/Epoch_time) format.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// Etag: ETag of the ASP.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of the API resource. This is always `admin#directory#asp`.
	Kind string `json:"kind,omitempty"`
	// LastTimeUsed: The time when the ASP was last used. Expressed in Unix time
	// (https://en.wikipedia.org/wiki/Epoch_time) format.
	LastTimeUsed int64 `json:"lastTimeUsed,omitempty,string"`
	// Name: The name of the application that the user, represented by their
	// `userId`, entered when the ASP was created.
	Name string `json:"name,omitempty"`
	// UserKey: The unique ID of the user who issued the ASP.
	UserKey string `json:"userKey,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CodeId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Asp) MarshalJSON() ([]byte, error) {
	type NoMethod Asp
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Asps struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: A list of ASP resources.
	Items []*Asp `json:"items,omitempty"`
	// Kind: The type of the API resource. This is always
	// `admin#directory#aspList`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Asps) MarshalJSON() ([]byte, error) {
	type NoMethod Asps
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuxiliaryMessage: Auxiliary message about issues with printers or settings.
// Example: {message_type:AUXILIARY_MESSAGE_WARNING, field_mask:make_and_model,
// message:"Given printer is invalid or no longer supported."}
type AuxiliaryMessage struct {
	// AuxiliaryMessage: Human readable message in English. Example: "Given printer
	// is invalid or no longer supported."
	AuxiliaryMessage string `json:"auxiliaryMessage,omitempty"`
	// FieldMask: Field that this message concerns.
	FieldMask string `json:"fieldMask,omitempty"`
	// Severity: Message severity
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Message type unspecified.
	//   "SEVERITY_INFO" - Message of severity: info.
	//   "SEVERITY_WARNING" - Message of severity: warning.
	//   "SEVERITY_ERROR" - Message of severity: error.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuxiliaryMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuxiliaryMessage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuxiliaryMessage) MarshalJSON() ([]byte, error) {
	type NoMethod AuxiliaryMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BacklightInfo: Information about the device's backlights.
type BacklightInfo struct {
	// Brightness: Output only. Current brightness of the backlight, between 0 and
	// max_brightness.
	Brightness int64 `json:"brightness,omitempty"`
	// MaxBrightness: Output only. Maximum brightness for the backlight.
	MaxBrightness int64 `json:"maxBrightness,omitempty"`
	// Path: Output only. Path to this backlight on the system. Useful if the
	// caller needs to correlate with other information.
	Path string `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brightness") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brightness") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BacklightInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BacklightInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchChangeChromeOsDeviceStatusRequest: A request for changing the status of
// a batch of ChromeOS devices.
type BatchChangeChromeOsDeviceStatusRequest struct {
	// ChangeChromeOsDeviceStatusAction: Required. The action to take on the
	// ChromeOS device in order to change its status.
	//
	// Possible values:
	//   "CHANGE_CHROME_OS_DEVICE_STATUS_ACTION_UNSPECIFIED" - Default value. Value
	// is unused.
	//   "CHANGE_CHROME_OS_DEVICE_STATUS_ACTION_DEPROVISION" - Deprovisions a
	// ChromeOS device. If you have ChromeOS devices that are no longer being used
	// in your organization, you should deprovision them so that you’re no longer
	// managing them. Deprovisioning the device removes all policies that were on
	// the device as well as device-level printers and the ability to use the
	// device as a kiosk. Depending on the upgrade that’s associated with the
	// device this action might release the license back into the license pool;
	// which allows you to use the license on a different device.
	//   "CHANGE_CHROME_OS_DEVICE_STATUS_ACTION_DISABLE" - Disables a ChromeOS
	// device. Use this action if a user loses their device or it’s stolen, this
	// makes it such that the device is still managed, so it will still receive
	// policies, but no one can use it. Depending on the upgrade that’s
	// associated with the device this action might release the license back into
	// the license pool; which allows you to use the license on a different device.
	//   "CHANGE_CHROME_OS_DEVICE_STATUS_ACTION_REENABLE" - Reenables a ChromeOS
	// device to be used after being disabled. Reenables the device once it's no
	// longer lost or it's been recovered. This allows the device to be used again.
	// Depending on the upgrade associated with the device this might consume one
	// license from the license pool, meaning that if there aren't enough licenses
	// available the operation will fail.
	ChangeChromeOsDeviceStatusAction string `json:"changeChromeOsDeviceStatusAction,omitempty"`
	// DeprovisionReason: Optional. The reason behind a device deprovision. Must be
	// provided if 'changeChromeOsDeviceStatusAction' is set to
	// 'CHANGE_CHROME_OS_DEVICE_STATUS_ACTION_DEPROVISION'. Otherwise, omit this
	// field.
	//
	// Possible values:
	//   "DEPROVISION_REASON_UNSPECIFIED" - The deprovision reason is unknown.
	//   "DEPROVISION_REASON_SAME_MODEL_REPLACEMENT" - Same model replacement. You
	// have return materials authorization (RMA) or you are replacing a
	// malfunctioning device under warranty with the same device model.
	//   "DEPROVISION_REASON_UPGRADE" - The device was upgraded.
	//   "DEPROVISION_REASON_DOMAIN_MOVE" - The device's domain was changed.
	//   "DEPROVISION_REASON_SERVICE_EXPIRATION" - Service expired for the device.
	//   "DEPROVISION_REASON_OTHER" - The device was deprovisioned for a legacy
	// reason that is no longer supported.
	//   "DEPROVISION_REASON_DIFFERENT_MODEL_REPLACEMENT" - Different model
	// replacement. You are replacing this device with an upgraded or newer device
	// model.
	//   "DEPROVISION_REASON_RETIRING_DEVICE" - Retiring from fleet. You are
	// donating, discarding, or otherwise removing the device from use.
	//   "DEPROVISION_REASON_UPGRADE_TRANSFER" - ChromeOS Flex upgrade transfer.
	// This is a ChromeOS Flex device that you are replacing with a Chromebook
	// within a year.
	//   "DEPROVISION_REASON_NOT_REQUIRED" - A reason was not required. For
	// example, the licenses were returned to the customer's license pool.
	//   "DEPROVISION_REASON_REPAIR_CENTER" - The device was deprovisioned by the
	// Repair Service Center. Can only be set by Repair Service Center during RMA.
	DeprovisionReason string `json:"deprovisionReason,omitempty"`
	// DeviceIds: Required. List of the IDs of the ChromeOS devices to change.
	// Maximum 50.
	DeviceIds []string `json:"deviceIds,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ChangeChromeOsDeviceStatusAction") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ChangeChromeOsDeviceStatusAction") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s BatchChangeChromeOsDeviceStatusRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchChangeChromeOsDeviceStatusRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchChangeChromeOsDeviceStatusResponse: The response of changing the status
// of a batch of ChromeOS devices.
type BatchChangeChromeOsDeviceStatusResponse struct {
	// ChangeChromeOsDeviceStatusResults: The results for each of the ChromeOS
	// devices provided in the request.
	ChangeChromeOsDeviceStatusResults []*ChangeChromeOsDeviceStatusResult `json:"changeChromeOsDeviceStatusResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ChangeChromeOsDeviceStatusResults") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ChangeChromeOsDeviceStatusResults") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s BatchChangeChromeOsDeviceStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchChangeChromeOsDeviceStatusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchCreatePrintServersRequest: Request to add multiple new print servers in
// a batch.
type BatchCreatePrintServersRequest struct {
	// Requests: Required. A list of `PrintServer` resources to be created (max
	// `50` per batch).
	Requests []*CreatePrintServerRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchCreatePrintServersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreatePrintServersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BatchCreatePrintServersResponse struct {
	// Failures: A list of create failures. `PrintServer` IDs are not populated, as
	// print servers were not created.
	Failures []*PrintServerFailureInfo `json:"failures,omitempty"`
	// PrintServers: A list of successfully created print servers with their IDs
	// populated.
	PrintServers []*PrintServer `json:"printServers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Failures") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Failures") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchCreatePrintServersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreatePrintServersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchCreatePrintersRequest: Request for adding new printers in batch.
type BatchCreatePrintersRequest struct {
	// Requests: A list of Printers to be created. Max 50 at a time.
	Requests []*CreatePrinterRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchCreatePrintersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreatePrintersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchCreatePrintersResponse: Response for adding new printers in batch.
type BatchCreatePrintersResponse struct {
	// Failures: A list of create failures. Printer IDs are not populated, as
	// printer were not created.
	Failures []*FailureInfo `json:"failures,omitempty"`
	// Printers: A list of successfully created printers with their IDs populated.
	Printers []*Printer `json:"printers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Failures") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Failures") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchCreatePrintersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchCreatePrintersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDeletePrintServersRequest: Request to delete multiple existing print
// servers in a batch.
type BatchDeletePrintServersRequest struct {
	// PrintServerIds: A list of print server IDs that should be deleted (max `100`
	// per batch).
	PrintServerIds []string `json:"printServerIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrintServerIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrintServerIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeletePrintServersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeletePrintServersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BatchDeletePrintServersResponse struct {
	// FailedPrintServers: A list of update failures.
	FailedPrintServers []*PrintServerFailureInfo `json:"failedPrintServers,omitempty"`
	// PrintServerIds: A list of print server IDs that were successfully deleted.
	PrintServerIds []string `json:"printServerIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FailedPrintServers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedPrintServers") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeletePrintServersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeletePrintServersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDeletePrintersRequest: Request for deleting existing printers in batch.
type BatchDeletePrintersRequest struct {
	// PrinterIds: A list of Printer.id that should be deleted. Max 100 at a time.
	PrinterIds []string `json:"printerIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrinterIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrinterIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeletePrintersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeletePrintersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDeletePrintersResponse: Response for deleting existing printers in
// batch.
type BatchDeletePrintersResponse struct {
	// FailedPrinters: A list of update failures.
	FailedPrinters []*FailureInfo `json:"failedPrinters,omitempty"`
	// PrinterIds: A list of Printer.id that were successfully deleted.
	PrinterIds []string `json:"printerIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FailedPrinters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedPrinters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeletePrintersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeletePrintersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Building: Public API: Resources.buildings
type Building struct {
	// Address: The postal address of the building. See `PostalAddress`
	// (/my-business/reference/rest/v4/PostalAddress) for details. Note that only a
	// single address line and region code are required.
	Address *BuildingAddress `json:"address,omitempty"`
	// BuildingId: Unique identifier for the building. The maximum length is 100
	// characters.
	BuildingId string `json:"buildingId,omitempty"`
	// BuildingName: The building name as seen by users in Calendar. Must be unique
	// for the customer. For example, "NYC-CHEL". The maximum length is 100
	// characters.
	BuildingName string `json:"buildingName,omitempty"`
	// Coordinates: The geographic coordinates of the center of the building,
	// expressed as latitude and longitude in decimal degrees.
	Coordinates *BuildingCoordinates `json:"coordinates,omitempty"`
	// Description: A brief description of the building. For example, "Chelsea
	// Market".
	Description string `json:"description,omitempty"`
	// Etags: ETag of the resource.
	Etags string `json:"etags,omitempty"`
	// FloorNames: The display names for all floors in this building. The floors
	// are expected to be sorted in ascending order, from lowest floor to highest
	// floor. For example, ["B2", "B1", "L", "1", "2", "2M", "3", "PH"] Must
	// contain at least one entry.
	FloorNames []string `json:"floorNames,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Building) MarshalJSON() ([]byte, error) {
	type NoMethod Building
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuildingAddress: Public API: Resources.buildings
type BuildingAddress struct {
	// AddressLines: Unstructured address lines describing the lower levels of an
	// address.
	AddressLines []string `json:"addressLines,omitempty"`
	// AdministrativeArea: Optional. Highest administrative subdivision which is
	// used for postal addresses of a country or region.
	AdministrativeArea string `json:"administrativeArea,omitempty"`
	// LanguageCode: Optional. BCP-47 language code of the contents of this address
	// (if known).
	LanguageCode string `json:"languageCode,omitempty"`
	// Locality: Optional. Generally refers to the city/town portion of the
	// address. Examples: US city, IT comune, UK post town. In regions of the world
	// where localities are not well defined or do not fit into this structure
	// well, leave locality empty and use addressLines.
	Locality string `json:"locality,omitempty"`
	// PostalCode: Optional. Postal code of the address.
	PostalCode string `json:"postalCode,omitempty"`
	// RegionCode: Required. CLDR region code of the country/region of the address.
	RegionCode string `json:"regionCode,omitempty"`
	// Sublocality: Optional. Sublocality of the address.
	Sublocality string `json:"sublocality,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressLines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressLines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildingAddress) MarshalJSON() ([]byte, error) {
	type NoMethod BuildingAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuildingCoordinates: Public API: Resources.buildings
type BuildingCoordinates struct {
	// Latitude: Latitude in decimal degrees.
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: Longitude in decimal degrees.
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildingCoordinates) MarshalJSON() ([]byte, error) {
	type NoMethod BuildingCoordinates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *BuildingCoordinates) UnmarshalJSON(data []byte) error {
	type NoMethod BuildingCoordinates
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// Buildings: Public API: Resources.buildings
type Buildings struct {
	// Buildings: The Buildings in this page of results.
	Buildings []*Building `json:"buildings,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request to return the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Buildings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buildings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Buildings) MarshalJSON() ([]byte, error) {
	type NoMethod Buildings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ByteUsage: Represents a data capacity with some amount of current usage in
// bytes.
type ByteUsage struct {
	// CapacityBytes: Output only. The total capacity value, in bytes.
	CapacityBytes int64 `json:"capacityBytes,omitempty,string"`
	// UsedBytes: Output only. The current usage value, in bytes.
	UsedBytes int64 `json:"usedBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CapacityBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CapacityBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ByteUsage) MarshalJSON() ([]byte, error) {
	type NoMethod ByteUsage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CalendarResource: Public API: Resources.calendars
type CalendarResource struct {
	// BuildingId: Unique ID for the building a resource is located in.
	BuildingId string `json:"buildingId,omitempty"`
	// Capacity: Capacity of a resource, number of seats in a room.
	Capacity int64 `json:"capacity,omitempty"`
	// Etags: ETag of the resource.
	Etags string `json:"etags,omitempty"`
	// FeatureInstances: Instances of features for the calendar resource.
	FeatureInstances interface{} `json:"featureInstances,omitempty"`
	// FloorName: Name of the floor a resource is located on.
	FloorName string `json:"floorName,omitempty"`
	// FloorSection: Name of the section within a floor a resource is located in.
	FloorSection string `json:"floorSection,omitempty"`
	// GeneratedResourceName: The read-only auto-generated name of the calendar
	// resource which includes metadata about the resource such as building name,
	// floor, capacity, etc. For example, "NYC-2-Training Room 1A (16)".
	GeneratedResourceName string `json:"generatedResourceName,omitempty"`
	// Kind: The type of the resource. For calendar resources, the value is
	// `admin#directory#resources#calendars#CalendarResource`.
	Kind string `json:"kind,omitempty"`
	// ResourceCategory: The category of the calendar resource. Either
	// CONFERENCE_ROOM or OTHER. Legacy data is set to CATEGORY_UNKNOWN.
	ResourceCategory string `json:"resourceCategory,omitempty"`
	// ResourceDescription: Description of the resource, visible only to admins.
	ResourceDescription string `json:"resourceDescription,omitempty"`
	// ResourceEmail: The read-only email for the calendar resource. Generated as
	// part of creating a new calendar resource.
	ResourceEmail string `json:"resourceEmail,omitempty"`
	// ResourceId: The unique ID for the calendar resource.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceName: The name of the calendar resource. For example, "Training Room
	// 1A".
	ResourceName string `json:"resourceName,omitempty"`
	// ResourceType: The type of the calendar resource, intended for non-room
	// resources.
	ResourceType string `json:"resourceType,omitempty"`
	// UserVisibleDescription: Description of the resource, visible to users and
	// admins.
	UserVisibleDescription string `json:"userVisibleDescription,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BuildingId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildingId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CalendarResource) MarshalJSON() ([]byte, error) {
	type NoMethod CalendarResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CalendarResources: Public API: Resources.calendars
type CalendarResources struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: The CalendarResources in this page of results.
	Items []*CalendarResource `json:"items,omitempty"`
	// Kind: Identifies this as a collection of CalendarResources. This is always
	// `admin#directory#resources#calendars#calendarResourcesList`.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request to return the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CalendarResources) MarshalJSON() ([]byte, error) {
	type NoMethod CalendarResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChangeChromeOsDeviceStatusResult: The result of a single ChromeOS device for
// a Change state operation.
type ChangeChromeOsDeviceStatusResult struct {
	// DeviceId: The unique ID of the ChromeOS device.
	DeviceId string `json:"deviceId,omitempty"`
	// Error: The error result of the operation in case of failure.
	Error *Status `json:"error,omitempty"`
	// Response: The device could change its status successfully.
	Response *ChangeChromeOsDeviceStatusSucceeded `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChangeChromeOsDeviceStatusResult) MarshalJSON() ([]byte, error) {
	type NoMethod ChangeChromeOsDeviceStatusResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChangeChromeOsDeviceStatusSucceeded: Response for a successful ChromeOS
// device status change.
type ChangeChromeOsDeviceStatusSucceeded struct {
}

// Channel: An notification channel used to watch for resource changes.
type Channel struct {
	// Address: The address where notifications are delivered for this channel.
	Address string `json:"address,omitempty"`
	// Expiration: Date and time of notification channel expiration, expressed as a
	// Unix timestamp, in milliseconds. Optional.
	Expiration int64 `json:"expiration,omitempty,string"`
	// Id: A UUID or similar unique string that identifies this channel.
	Id string `json:"id,omitempty"`
	// Kind: Identifies this as a notification channel used to watch for changes to
	// a resource, which is `api#channel`.
	Kind string `json:"kind,omitempty"`
	// Params: Additional parameters controlling delivery channel behavior.
	// Optional. For example, `params.ttl` specifies the time-to-live in seconds
	// for the notification channel, where the default is 2 hours and the maximum
	// TTL is 2 days.
	Params map[string]string `json:"params,omitempty"`
	// Payload: A Boolean value to indicate whether payload is wanted. Optional.
	Payload bool `json:"payload,omitempty"`
	// ResourceId: An opaque ID that identifies the resource being watched on this
	// channel. Stable across different API versions.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceUri: A version-specific identifier for the watched resource.
	ResourceUri string `json:"resourceUri,omitempty"`
	// Token: An arbitrary string delivered to the target address with each
	// notification delivered over this channel. Optional.
	Token string `json:"token,omitempty"`
	// Type: The type of delivery mechanism used for this channel.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Channel) MarshalJSON() ([]byte, error) {
	type NoMethod Channel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDevice: Google Chrome devices run on the Chrome OS
// (https://support.google.com/chromeos). For more information about common API
// tasks, see the Developer's Guide
// (/admin-sdk/directory/v1/guides/manage-chrome-devices).
type ChromeOsDevice struct {
	// ActiveTimeRanges: A list of active time ranges (Read-only).
	ActiveTimeRanges []*ChromeOsDeviceActiveTimeRanges `json:"activeTimeRanges,omitempty"`
	// AnnotatedAssetId: The asset identifier as noted by an administrator or
	// specified during enrollment.
	AnnotatedAssetId string `json:"annotatedAssetId,omitempty"`
	// AnnotatedLocation: The address or location of the device as noted by the
	// administrator. Maximum length is `200` characters. Empty values are allowed.
	AnnotatedLocation string `json:"annotatedLocation,omitempty"`
	// AnnotatedUser: The user of the device as noted by the administrator. Maximum
	// length is 100 characters. Empty values are allowed.
	AnnotatedUser string `json:"annotatedUser,omitempty"`
	// AutoUpdateExpiration: (Read-only) The timestamp after which the device will
	// stop receiving Chrome updates or support. Please use "autoUpdateThrough"
	// instead.
	AutoUpdateExpiration int64 `json:"autoUpdateExpiration,omitempty,string"`
	// AutoUpdateThrough: Output only. The timestamp after which the device will
	// stop receiving Chrome updates or support.
	AutoUpdateThrough string `json:"autoUpdateThrough,omitempty"`
	// BacklightInfo: Output only. Contains backlight information for the device.
	BacklightInfo []*BacklightInfo `json:"backlightInfo,omitempty"`
	// BootMode: The boot mode for the device. The possible values are: *
	// `Verified`: The device is running a valid version of the Chrome OS. * `Dev`:
	// The devices's developer hardware switch is enabled. When booted, the device
	// has a command line shell. For an example of a developer switch, see the
	// Chromebook developer information
	// (https://www.chromium.org/chromium-os/developer-information-for-chrome-os-devices/samsung-series-5-chromebook#TOC-Developer-switch).
	BootMode string `json:"bootMode,omitempty"`
	// ChromeOsType: Output only. Chrome OS type of the device.
	//
	// Possible values:
	//   "chromeOsTypeUnspecified" - Chrome OS Type unspecified.
	//   "chromeOsFlex" - Chrome OS Type Chrome OS Flex.
	//   "chromeOs" - Chrome OS Type Chrome OS.
	ChromeOsType string `json:"chromeOsType,omitempty"`
	// CpuInfo: Information regarding CPU specs in the device.
	CpuInfo []*ChromeOsDeviceCpuInfo `json:"cpuInfo,omitempty"`
	// CpuStatusReports: Reports of CPU utilization and temperature (Read-only)
	CpuStatusReports []*ChromeOsDeviceCpuStatusReports `json:"cpuStatusReports,omitempty"`
	// DeprovisionReason: (Read-only) Deprovision reason.
	//
	// Possible values:
	//   "DEPROVISION_REASON_UNSPECIFIED" - The deprovision reason is unknown.
	//   "DEPROVISION_REASON_SAME_MODEL_REPLACEMENT" - Same model replacement. You
	// have return materials authorization (RMA) or you are replacing a
	// malfunctioning device under warranty with the same device model.
	//   "DEPROVISION_REASON_UPGRADE" - The device was upgraded.
	//   "DEPROVISION_REASON_DOMAIN_MOVE" - The device's domain was changed.
	//   "DEPROVISION_REASON_SERVICE_EXPIRATION" - Service expired for the device.
	//   "DEPROVISION_REASON_OTHER" - The device was deprovisioned for a legacy
	// reason that is no longer supported.
	//   "DEPROVISION_REASON_DIFFERENT_MODEL_REPLACEMENT" - Different model
	// replacement. You are replacing this device with an upgraded or newer device
	// model.
	//   "DEPROVISION_REASON_RETIRING_DEVICE" - Retiring from fleet. You are
	// donating, discarding, or otherwise removing the device from use.
	//   "DEPROVISION_REASON_UPGRADE_TRANSFER" - ChromeOS Flex upgrade transfer.
	// This is a ChromeOS Flex device that you are replacing with a Chromebook
	// within a year.
	//   "DEPROVISION_REASON_NOT_REQUIRED" - A reason was not required. For
	// example, the licenses were returned to the customer's license pool.
	//   "DEPROVISION_REASON_REPAIR_CENTER" - The device was deprovisioned by the
	// Repair Service Center. Can only be set by Repair Service Center during RMA.
	DeprovisionReason string `json:"deprovisionReason,omitempty"`
	// DeviceFiles: A list of device files to download (Read-only)
	DeviceFiles []*ChromeOsDeviceDeviceFiles `json:"deviceFiles,omitempty"`
	// DeviceId: The unique ID of the Chrome device.
	DeviceId string `json:"deviceId,omitempty"`
	// DeviceLicenseType: Output only. Device license type.
	//
	// Possible values:
	//   "deviceLicenseTypeUnspecified" - The license type is unknown.
	//   "enterprise" - The device is bundled with a perpetual Chrome Enterprise
	// Upgrade.
	//   "enterpriseUpgrade" - The device has an annual standalone Chrome
	// Enterprise Upgrade.
	//   "educationUpgrade" - The device has a perpetual standalone Chrome
	// Education Upgrade.
	//   "education" - The device is bundled with a perpetual Chrome Education
	// Upgrade.
	//   "kioskUpgrade" - The device has an annual Kiosk Upgrade.
	DeviceLicenseType string `json:"deviceLicenseType,omitempty"`
	// DiskSpaceUsage: Output only. How much disk space the device has available
	// and is currently using.
	DiskSpaceUsage *ByteUsage `json:"diskSpaceUsage,omitempty"`
	// DiskVolumeReports: Reports of disk space and other info about
	// mounted/connected volumes.
	DiskVolumeReports []*ChromeOsDeviceDiskVolumeReports `json:"diskVolumeReports,omitempty"`
	// DockMacAddress: (Read-only) Built-in MAC address for the docking station
	// that the device connected to. Factory sets Media access control address (MAC
	// address) assigned for use by a dock. It is reserved specifically for MAC
	// pass through device policy. The format is twelve (12) hexadecimal digits
	// without any delimiter (uppercase letters). This is only relevant for some
	// devices.
	DockMacAddress string `json:"dockMacAddress,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// EthernetMacAddress: The device's MAC address on the ethernet network
	// interface.
	EthernetMacAddress string `json:"ethernetMacAddress,omitempty"`
	// EthernetMacAddress0: (Read-only) MAC address used by the Chromebook’s
	// internal ethernet port, and for onboard network (ethernet) interface. The
	// format is twelve (12) hexadecimal digits without any delimiter (uppercase
	// letters). This is only relevant for some devices.
	EthernetMacAddress0 string `json:"ethernetMacAddress0,omitempty"`
	// ExtendedSupportEligible: Output only. Whether or not the device requires the
	// extended support opt in.
	ExtendedSupportEligible bool `json:"extendedSupportEligible,omitempty"`
	// ExtendedSupportEnabled: Output only. Whether extended support policy is
	// enabled on the device.
	ExtendedSupportEnabled bool `json:"extendedSupportEnabled,omitempty"`
	// ExtendedSupportStart: Output only. Date of the device when extended support
	// policy for automatic updates starts.
	ExtendedSupportStart string `json:"extendedSupportStart,omitempty"`
	// FanInfo: Output only. Fan information for the device.
	FanInfo []*FanInfo `json:"fanInfo,omitempty"`
	// FirmwareVersion: The Chrome device's firmware version.
	FirmwareVersion string `json:"firmwareVersion,omitempty"`
	// FirstEnrollmentTime: Date and time for the first time the device was
	// enrolled.
	FirstEnrollmentTime string `json:"firstEnrollmentTime,omitempty"`
	// Kind: The type of resource. For the Chromeosdevices resource, the value is
	// `admin#directory#chromeosdevice`.
	Kind string `json:"kind,omitempty"`
	// LastDeprovisionTimestamp: (Read-only) Date and time for the last deprovision
	// of the device.
	LastDeprovisionTimestamp string `json:"lastDeprovisionTimestamp,omitempty"`
	// LastEnrollmentTime: Date and time the device was last enrolled (Read-only)
	LastEnrollmentTime string `json:"lastEnrollmentTime,omitempty"`
	// LastKnownNetwork: Contains last known network (Read-only)
	LastKnownNetwork []*ChromeOsDeviceLastKnownNetwork `json:"lastKnownNetwork,omitempty"`
	// LastSync: Date and time the device was last synchronized with the policy
	// settings in the G Suite administrator control panel (Read-only)
	LastSync string `json:"lastSync,omitempty"`
	// MacAddress: The device's wireless MAC address. If the device does not have
	// this information, it is not included in the response.
	MacAddress string `json:"macAddress,omitempty"`
	// ManufactureDate: (Read-only) The date the device was manufactured in
	// yyyy-mm-dd format.
	ManufactureDate string `json:"manufactureDate,omitempty"`
	// Meid: The Mobile Equipment Identifier (MEID) or the International Mobile
	// Equipment Identity (IMEI) for the 3G mobile card in a mobile device. A
	// MEID/IMEI is typically used when adding a device to a wireless carrier's
	// post-pay service plan. If the device does not have this information, this
	// property is not included in the response. For more information on how to
	// export a MEID/IMEI list, see the Developer's Guide
	// (/admin-sdk/directory/v1/guides/manage-chrome-devices.html#export_meid).
	Meid string `json:"meid,omitempty"`
	// Model: The device's model information. If the device does not have this
	// information, this property is not included in the response.
	Model string `json:"model,omitempty"`
	// Notes: Notes about this device added by the administrator. This property can
	// be searched (https://support.google.com/chrome/a/answer/1698333) with the
	// list (/admin-sdk/directory/v1/reference/chromeosdevices/list) method's
	// `query` parameter. Maximum length is 500 characters. Empty values are
	// allowed.
	Notes string `json:"notes,omitempty"`
	// OrderNumber: The device's order number. Only devices directly purchased from
	// Google have an order number.
	OrderNumber string `json:"orderNumber,omitempty"`
	// OrgUnitId: The unique ID of the organizational unit. orgUnitPath is the
	// human readable version of orgUnitId. While orgUnitPath may change by
	// renaming an organizational unit within the path, orgUnitId is unchangeable
	// for one organizational unit. This property can be updated
	// (/admin-sdk/directory/v1/guides/manage-chrome-devices#move_chrome_devices_to_
	// ou) using the API. For more information about how to create an
	// organizational structure for your device, see the administration help center
	// (https://support.google.com/a/answer/182433).
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// OrgUnitPath: The full parent path with the organizational unit's name
	// associated with the device. Path names are case insensitive. If the parent
	// organizational unit is the top-level organization, it is represented as a
	// forward slash, `/`. This property can be updated
	// (/admin-sdk/directory/v1/guides/manage-chrome-devices#move_chrome_devices_to_
	// ou) using the API. For more information about how to create an
	// organizational structure for your device, see the administration help center
	// (https://support.google.com/a/answer/182433).
	OrgUnitPath string `json:"orgUnitPath,omitempty"`
	// OsUpdateStatus: The status of the OS updates for the device.
	OsUpdateStatus *OsUpdateStatus `json:"osUpdateStatus,omitempty"`
	// OsVersion: The Chrome device's operating system version.
	OsVersion string `json:"osVersion,omitempty"`
	// PlatformVersion: The Chrome device's platform version.
	PlatformVersion string `json:"platformVersion,omitempty"`
	// RecentUsers: A list of recent device users, in descending order, by last
	// login time.
	RecentUsers []*ChromeOsDeviceRecentUsers `json:"recentUsers,omitempty"`
	// ScreenshotFiles: A list of screenshot files to download. Type is always
	// "SCREENSHOT_FILE". (Read-only)
	ScreenshotFiles []*ChromeOsDeviceScreenshotFiles `json:"screenshotFiles,omitempty"`
	// SerialNumber: The Chrome device serial number entered when the device was
	// enabled. This value is the same as the Admin console's *Serial Number* in
	// the *Chrome OS Devices* tab.
	SerialNumber string `json:"serialNumber,omitempty"`
	// Status: The status of the device.
	Status string `json:"status,omitempty"`
	// SupportEndDate: Final date the device will be supported (Read-only)
	SupportEndDate string `json:"supportEndDate,omitempty"`
	// SystemRamFreeReports: Reports of amounts of available RAM memory (Read-only)
	SystemRamFreeReports []*ChromeOsDeviceSystemRamFreeReports `json:"systemRamFreeReports,omitempty"`
	// SystemRamTotal: Total RAM on the device [in bytes] (Read-only)
	SystemRamTotal int64 `json:"systemRamTotal,omitempty,string"`
	// TpmVersionInfo: Trusted Platform Module (TPM) (Read-only)
	TpmVersionInfo *ChromeOsDeviceTpmVersionInfo `json:"tpmVersionInfo,omitempty"`
	// WillAutoRenew: Determines if the device will auto renew its support after
	// the support end date. This is a read-only property.
	WillAutoRenew bool `json:"willAutoRenew,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveTimeRanges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTimeRanges") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDevice) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceActiveTimeRanges struct {
	// ActiveTime: Duration of usage in milliseconds.
	ActiveTime int64 `json:"activeTime,omitempty"`
	// Date: Date of usage
	Date string `json:"date,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceActiveTimeRanges) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceActiveTimeRanges
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDeviceCpuInfo: CPU specs for a CPU.
type ChromeOsDeviceCpuInfo struct {
	// Architecture: The CPU architecture.
	Architecture string `json:"architecture,omitempty"`
	// LogicalCpus: Information for the Logical CPUs
	LogicalCpus []*ChromeOsDeviceCpuInfoLogicalCpus `json:"logicalCpus,omitempty"`
	// MaxClockSpeedKhz: The max CPU clock speed in kHz.
	MaxClockSpeedKhz int64 `json:"maxClockSpeedKhz,omitempty"`
	// Model: The CPU model name.
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Architecture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceCpuInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceCpuInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDeviceCpuInfoLogicalCpus: Status of a single logical CPU.
type ChromeOsDeviceCpuInfoLogicalCpus struct {
	// CStates: C-States indicate the power consumption state of the CPU. For more
	// information look at documentation published by the CPU maker.
	CStates []*ChromeOsDeviceCpuInfoLogicalCpusCStates `json:"cStates,omitempty"`
	// CurrentScalingFrequencyKhz: Current frequency the CPU is running at.
	CurrentScalingFrequencyKhz int64 `json:"currentScalingFrequencyKhz,omitempty"`
	// IdleDuration: Idle time since last boot.
	IdleDuration string `json:"idleDuration,omitempty"`
	// MaxScalingFrequencyKhz: Maximum frequency the CPU is allowed to run at, by
	// policy.
	MaxScalingFrequencyKhz int64 `json:"maxScalingFrequencyKhz,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CStates") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CStates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceCpuInfoLogicalCpus) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceCpuInfoLogicalCpus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDeviceCpuInfoLogicalCpusCStates: Status of a single C-state.
// C-states are various modes the CPU can transition to in order to use more or
// less power.
type ChromeOsDeviceCpuInfoLogicalCpusCStates struct {
	// DisplayName: Name of the state.
	DisplayName string `json:"displayName,omitempty"`
	// SessionDuration: Time spent in the state since the last reboot.
	SessionDuration string `json:"sessionDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceCpuInfoLogicalCpusCStates) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceCpuInfoLogicalCpusCStates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceCpuStatusReports struct {
	// CpuTemperatureInfo: A list of CPU temperature samples.
	CpuTemperatureInfo           []*ChromeOsDeviceCpuStatusReportsCpuTemperatureInfo `json:"cpuTemperatureInfo,omitempty"`
	CpuUtilizationPercentageInfo []int64                                             `json:"cpuUtilizationPercentageInfo,omitempty"`
	// ReportTime: Date and time the report was received.
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpuTemperatureInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuTemperatureInfo") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceCpuStatusReports) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceCpuStatusReports
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceCpuStatusReportsCpuTemperatureInfo struct {
	// Label: CPU label
	Label string `json:"label,omitempty"`
	// Temperature: Temperature in Celsius degrees.
	Temperature int64 `json:"temperature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceCpuStatusReportsCpuTemperatureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceCpuStatusReportsCpuTemperatureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceDeviceFiles struct {
	// CreateTime: Date and time the file was created
	CreateTime string `json:"createTime,omitempty"`
	// DownloadUrl: File download URL
	DownloadUrl string `json:"downloadUrl,omitempty"`
	// Name: File name
	Name string `json:"name,omitempty"`
	// Type: File type
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceDeviceFiles) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceDeviceFiles
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceDiskVolumeReports struct {
	// VolumeInfo: Disk volumes
	VolumeInfo []*ChromeOsDeviceDiskVolumeReportsVolumeInfo `json:"volumeInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VolumeInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VolumeInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceDiskVolumeReports) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceDiskVolumeReports
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceDiskVolumeReportsVolumeInfo struct {
	// StorageFree: Free disk space [in bytes]
	StorageFree int64 `json:"storageFree,omitempty,string"`
	// StorageTotal: Total disk space [in bytes]
	StorageTotal int64 `json:"storageTotal,omitempty,string"`
	// VolumeId: Volume id
	VolumeId string `json:"volumeId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StorageFree") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StorageFree") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceDiskVolumeReportsVolumeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceDiskVolumeReportsVolumeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDeviceLastKnownNetwork: Information for an ip address.
type ChromeOsDeviceLastKnownNetwork struct {
	// IpAddress: The IP address.
	IpAddress string `json:"ipAddress,omitempty"`
	// WanIpAddress: The WAN IP address.
	WanIpAddress string `json:"wanIpAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceLastKnownNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceLastKnownNetwork
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDeviceRecentUsers: A list of recent device users, in descending
// order, by last login time.
type ChromeOsDeviceRecentUsers struct {
	// Email: The user's email address. This is only present if the user type is
	// `USER_TYPE_MANAGED`.
	Email string `json:"email,omitempty"`
	// Type: The type of the user.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceRecentUsers) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceRecentUsers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceScreenshotFiles struct {
	// CreateTime: Date and time the file was created
	CreateTime string `json:"createTime,omitempty"`
	// DownloadUrl: File download URL
	DownloadUrl string `json:"downloadUrl,omitempty"`
	// Name: File name
	Name string `json:"name,omitempty"`
	// Type: File type
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceScreenshotFiles) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceScreenshotFiles
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDeviceSystemRamFreeReports struct {
	// ReportTime: Date and time the report was received.
	ReportTime        string           `json:"reportTime,omitempty"`
	SystemRamFreeInfo googleapi.Int64s `json:"systemRamFreeInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReportTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReportTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceSystemRamFreeReports) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceSystemRamFreeReports
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDeviceTpmVersionInfo: Trusted Platform Module (TPM) (Read-only)
type ChromeOsDeviceTpmVersionInfo struct {
	// Family: TPM family. We use the TPM 2.0 style encoding, e.g.: TPM 1.2: "1.2"
	// -> 312e3200 TPM 2.0: "2.0" -> 322e3000
	Family string `json:"family,omitempty"`
	// FirmwareVersion: TPM firmware version.
	FirmwareVersion string `json:"firmwareVersion,omitempty"`
	// Manufacturer: TPM manufacturer code.
	Manufacturer string `json:"manufacturer,omitempty"`
	// SpecLevel: TPM specification level. See Library Specification for TPM 2.0
	// and Main Specification for TPM 1.2.
	SpecLevel string `json:"specLevel,omitempty"`
	// TpmModel: TPM model number.
	TpmModel string `json:"tpmModel,omitempty"`
	// VendorSpecific: Vendor-specific information such as Vendor ID.
	VendorSpecific string `json:"vendorSpecific,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Family") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Family") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceTpmVersionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceTpmVersionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ChromeOsDeviceAction: Data about an update to the status of a Chrome OS
// device.
type ChromeOsDeviceAction struct {
	// Action: Action to be taken on the Chrome OS device.
	Action string `json:"action,omitempty"`
	// DeprovisionReason: Only used when the action is `deprovision`. With the
	// `deprovision` action, this field is required. *Note*: The deprovision reason
	// is audited because it might have implications on licenses for perpetual
	// subscription customers.
	DeprovisionReason string `json:"deprovisionReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDeviceAction) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDeviceAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsDevices struct {
	// Chromeosdevices: A list of Chrome OS Device objects.
	Chromeosdevices []*ChromeOsDevice `json:"chromeosdevices,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Token used to access the next page of this result. To access
	// the next page, use this token's value in the `pageToken` query string of
	// this request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Chromeosdevices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chromeosdevices") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsDevices) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsDevices
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ChromeOsMoveDevicesToOu struct {
	// DeviceIds: Chrome OS devices to be moved to OU
	DeviceIds []string `json:"deviceIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ChromeOsMoveDevicesToOu) MarshalJSON() ([]byte, error) {
	type NoMethod ChromeOsMoveDevicesToOu
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreatePrintServerRequest: Request for adding a new print server.
type CreatePrintServerRequest struct {
	// Parent: Required. The unique ID
	// (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers)
	// of the customer's Google Workspace account. Format: `customers/{id}`
	Parent string `json:"parent,omitempty"`
	// PrintServer: Required. A print server to create. If you want to place the
	// print server under a specific organizational unit (OU), then populate the
	// `org_unit_id`. Otherwise the print server is created under the root OU. The
	// `org_unit_id` can be retrieved using the Directory API
	// (https://developers.google.com/admin-sdk/directory/v1/guides/manage-org-units).
	PrintServer *PrintServer `json:"printServer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreatePrintServerRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreatePrintServerRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreatePrinterRequest: Request for adding a new printer.
type CreatePrinterRequest struct {
	// Parent: Required. The name of the customer. Format: customers/{customer_id}
	Parent string `json:"parent,omitempty"`
	// Printer: Required. A printer to create. If you want to place the printer
	// under particular OU then populate printer.org_unit_id filed. Otherwise the
	// printer will be placed under root OU.
	Printer *Printer `json:"printer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreatePrinterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreatePrinterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Customer struct {
	// AlternateEmail: The customer's secondary contact email address. This email
	// address cannot be on the same domain as the `customerDomain`
	AlternateEmail string `json:"alternateEmail,omitempty"`
	// CustomerCreationTime: The customer's creation time (Readonly)
	CustomerCreationTime string `json:"customerCreationTime,omitempty"`
	// CustomerDomain: The customer's primary domain name string. Do not include
	// the `www` prefix when creating a new customer.
	CustomerDomain string `json:"customerDomain,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Id: The unique ID for the customer's Google Workspace account. (Readonly)
	Id string `json:"id,omitempty"`
	// Kind: Identifies the resource as a customer. Value:
	// `admin#directory#customer`
	Kind string `json:"kind,omitempty"`
	// Language: The customer's ISO 639-2 language code. See the Language Codes
	// (/admin-sdk/directory/v1/languages) page for the list of supported codes.
	// Valid language codes outside the supported set will be accepted by the API
	// but may lead to unexpected behavior. The default value is `en`.
	Language string `json:"language,omitempty"`
	// PhoneNumber: The customer's contact phone number in E.164
	// (https://en.wikipedia.org/wiki/E.164) format.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PostalAddress: The customer's postal address information.
	PostalAddress *CustomerPostalAddress `json:"postalAddress,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateEmail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateEmail") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Customer) MarshalJSON() ([]byte, error) {
	type NoMethod Customer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CustomerPostalAddress struct {
	// AddressLine1: A customer's physical address. The address can be composed of
	// one to three lines.
	AddressLine1 string `json:"addressLine1,omitempty"`
	// AddressLine2: Address line 2 of the address.
	AddressLine2 string `json:"addressLine2,omitempty"`
	// AddressLine3: Address line 3 of the address.
	AddressLine3 string `json:"addressLine3,omitempty"`
	// ContactName: The customer contact's name.
	ContactName string `json:"contactName,omitempty"`
	// CountryCode: This is a required property. For `countryCode` information see
	// the ISO 3166 country code elements
	// (https://www.iso.org/iso/country_codes.htm).
	CountryCode string `json:"countryCode,omitempty"`
	// Locality: Name of the locality. An example of a locality value is the city
	// of `San Francisco`.
	Locality string `json:"locality,omitempty"`
	// OrganizationName: The company or company division name.
	OrganizationName string `json:"organizationName,omitempty"`
	// PostalCode: The postal code. A postalCode example is a postal zip code such
	// as `10009`. This is in accordance with - http:
	// //portablecontacts.net/draft-spec.html#address_element.
	PostalCode string `json:"postalCode,omitempty"`
	// Region: Name of the region. An example of a region value is `NY` for the
	// state of New York.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressLine1") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressLine1") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomerPostalAddress) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerPostalAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DirectoryChromeosdevicesCommand: Information regarding a command that was
// issued to a device.
type DirectoryChromeosdevicesCommand struct {
	// CommandExpireTime: The time at which the command will expire. If the device
	// doesn't execute the command within this time the command will become
	// expired.
	CommandExpireTime string `json:"commandExpireTime,omitempty"`
	// CommandId: Unique ID of a device command.
	CommandId int64 `json:"commandId,omitempty,string"`
	// CommandResult: The result of the command execution.
	CommandResult *DirectoryChromeosdevicesCommandResult `json:"commandResult,omitempty"`
	// IssueTime: The timestamp when the command was issued by the admin.
	IssueTime string `json:"issueTime,omitempty"`
	// Payload: The payload that the command specified, if any.
	Payload string `json:"payload,omitempty"`
	// State: Indicates the command state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The command status was unspecified.
	//   "PENDING" - An unexpired command not yet sent to the client.
	//   "EXPIRED" - The command didn't get executed by the client within the
	// expected time.
	//   "CANCELLED" - The command is cancelled by admin while in PENDING.
	//   "SENT_TO_CLIENT" - The command has been sent to the client.
	//   "ACKED_BY_CLIENT" - The client has responded that it received the command.
	//   "EXECUTED_BY_CLIENT" - The client has (un)successfully executed the
	// command.
	State string `json:"state,omitempty"`
	// Type: The type of the command.
	//
	// Possible values:
	//   "COMMAND_TYPE_UNSPECIFIED" - The command type was unspecified.
	//   "REBOOT" - Reboot the device. Can be issued to Kiosk and managed guest
	// session devices, and regular devices running ChromeOS version 113 or later.
	//   "TAKE_A_SCREENSHOT" - Take a screenshot of the device. Only available if
	// the device is in Kiosk Mode.
	//   "SET_VOLUME" - Set the volume of the device. Can only be issued to Kiosk
	// and managed guest session devices.
	//   "WIPE_USERS" - Wipe all the users off of the device. Executing this
	// command in the device will remove all user profile data, but it will keep
	// device policy and enrollment.
	//   "REMOTE_POWERWASH" - Wipes the device by performing a power wash.
	// Executing this command in the device will remove all data including user
	// policies, device policies and enrollment policies. Warning: This will revert
	// the device back to a factory state with no enrollment unless the device is
	// subject to forced or auto enrollment. Use with caution, as this is an
	// irreversible action!
	//   "DEVICE_START_CRD_SESSION" - Starts a Chrome Remote Desktop session.
	//   "CAPTURE_LOGS" - Capture the system logs of a kiosk device. The logs can
	// be downloaded from the downloadUrl link present in `deviceFiles` field of
	// [chromeosdevices](https://developers.google.com/admin-sdk/directory/reference
	// /rest/v1/chromeosdevices)
	//   "FETCH_SUPPORT_PACKET" - Fetch support packet from a device remotely.
	// Support packet is a zip archive that contains various system logs and debug
	// data from a ChromeOS device. The support packet can be downloaded from the
	// downloadURL link present in the `deviceFiles` field of
	// [`chromeosdevices`](https://developers.google.com/admin-sdk/directory/referen
	// ce/rest/v1/chromeosdevices)
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommandExpireTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommandExpireTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DirectoryChromeosdevicesCommand) MarshalJSON() ([]byte, error) {
	type NoMethod DirectoryChromeosdevicesCommand
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DirectoryChromeosdevicesCommandResult: The result of executing a command.
type DirectoryChromeosdevicesCommandResult struct {
	// CommandResultPayload: The payload for the command result. The following
	// commands respond with a payload: * `DEVICE_START_CRD_SESSION`: Payload is a
	// stringified JSON object in the form: { "url": url }. The URL provides a link
	// to the Chrome Remote Desktop session.
	CommandResultPayload string `json:"commandResultPayload,omitempty"`
	// ErrorMessage: The error message with a short explanation as to why the
	// command failed. Only present if the command failed.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ExecuteTime: The time at which the command was executed or failed to
	// execute.
	ExecuteTime string `json:"executeTime,omitempty"`
	// Result: The result of the command.
	//
	// Possible values:
	//   "COMMAND_RESULT_TYPE_UNSPECIFIED" - The command result was unspecified.
	//   "IGNORED" - The command was ignored as obsolete.
	//   "FAILURE" - The command could not be executed successfully.
	//   "SUCCESS" - The command was successfully executed.
	Result string `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommandResultPayload") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommandResultPayload") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DirectoryChromeosdevicesCommandResult) MarshalJSON() ([]byte, error) {
	type NoMethod DirectoryChromeosdevicesCommandResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DirectoryChromeosdevicesIssueCommandRequest: A request for issuing a
// command.
type DirectoryChromeosdevicesIssueCommandRequest struct {
	// CommandType: The type of command.
	//
	// Possible values:
	//   "COMMAND_TYPE_UNSPECIFIED" - The command type was unspecified.
	//   "REBOOT" - Reboot the device. Can be issued to Kiosk and managed guest
	// session devices, and regular devices running ChromeOS version 113 or later.
	//   "TAKE_A_SCREENSHOT" - Take a screenshot of the device. Only available if
	// the device is in Kiosk Mode.
	//   "SET_VOLUME" - Set the volume of the device. Can only be issued to Kiosk
	// and managed guest session devices.
	//   "WIPE_USERS" - Wipe all the users off of the device. Executing this
	// command in the device will remove all user profile data, but it will keep
	// device policy and enrollment.
	//   "REMOTE_POWERWASH" - Wipes the device by performing a power wash.
	// Executing this command in the device will remove all data including user
	// policies, device policies and enrollment policies. Warning: This will revert
	// the device back to a factory state with no enrollment unless the device is
	// subject to forced or auto enrollment. Use with caution, as this is an
	// irreversible action!
	//   "DEVICE_START_CRD_SESSION" - Starts a Chrome Remote Desktop session.
	//   "CAPTURE_LOGS" - Capture the system logs of a kiosk device. The logs can
	// be downloaded from the downloadUrl link present in `deviceFiles` field of
	// [chromeosdevices](https://developers.google.com/admin-sdk/directory/reference
	// /rest/v1/chromeosdevices)
	//   "FETCH_SUPPORT_PACKET" - Fetch support packet from a device remotely.
	// Support packet is a zip archive that contains various system logs and debug
	// data from a ChromeOS device. The support packet can be downloaded from the
	// downloadURL link present in the `deviceFiles` field of
	// [`chromeosdevices`](https://developers.google.com/admin-sdk/directory/referen
	// ce/rest/v1/chromeosdevices)
	CommandType string `json:"commandType,omitempty"`
	// Payload: The payload for the command, provide it only if command supports
	// it. The following commands support adding payload: * `SET_VOLUME`: Payload
	// is a stringified JSON object in the form: { "volume": 50 }. The volume has
	// to be an integer in the range [0,100]. * `DEVICE_START_CRD_SESSION`: Payload
	// is optionally a stringified JSON object in the form: { "ackedUserPresence":
	// true, "crdSessionType": string }. `ackedUserPresence` is a boolean. By
	// default, `ackedUserPresence` is set to `false`. To start a Chrome Remote
	// Desktop session for an active device, set `ackedUserPresence` to `true`.
	// `crdSessionType` can only select from values `private` (which grants the
	// remote admin exclusive control of the ChromeOS device) or `shared` (which
	// allows the admin and the local user to share control of the ChromeOS
	// device). If not set, `crdSessionType` defaults to `shared`. * `REBOOT`:
	// Payload is a stringified JSON object in the form: {
	// "user_session_delay_seconds": 300 }. The `user_session_delay_seconds` is the
	// amount of seconds to wait before rebooting the device if a user is logged
	// in. It has to be an integer in the range [0,300]. When payload is not
	// present for reboot, 0 delay is the default. Note: This only applies if an
	// actual user is logged in, including a Guest. If the device is in the login
	// screen or in Kiosk mode the value is not respected and the device
	// immediately reboots. * `FETCH_SUPPORT_PACKET`: Payload is optionally a
	// stringified JSON object in the form: {"supportPacketDetails":{
	// "issueCaseId": optional_support_case_id_string, "issueDescription":
	// optional_issue_description_string, "requestedDataCollectors": []}} The list
	// of available `data_collector_enums` are as following: Chrome System
	// Information (1), Crash IDs (2), Memory Details (3), UI Hierarchy (4),
	// Additional ChromeOS Platform Logs (5), Device Event (6), Intel WiFi NICs
	// Debug Dump (7), Touch Events (8), Lacros (9), Lacros System Information
	// (10), ChromeOS Flex Logs (11), DBus Details (12), ChromeOS Network Routes
	// (13), ChromeOS Shill (Connection Manager) Logs (14), Policies (15), ChromeOS
	// System State and Logs (16), ChromeOS System Logs (17), ChromeOS Chrome User
	// Logs (18), ChromeOS Bluetooth (19), ChromeOS Connected Input Devices (20),
	// ChromeOS Traffic Counters (21), ChromeOS Virtual Keyboard (22), ChromeOS
	// Network Health (23). See more details in help article
	// (https://support.google.com/chrome/a?p=remote-log).
	Payload string `json:"payload,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommandType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommandType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DirectoryChromeosdevicesIssueCommandRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DirectoryChromeosdevicesIssueCommandRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DirectoryChromeosdevicesIssueCommandResponse: A response for issuing a
// command.
type DirectoryChromeosdevicesIssueCommandResponse struct {
	// CommandId: The unique ID of the issued command, used to retrieve the command
	// status.
	CommandId int64 `json:"commandId,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommandId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommandId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DirectoryChromeosdevicesIssueCommandResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DirectoryChromeosdevicesIssueCommandResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DomainAlias struct {
	// CreationTime: The creation time of the domain alias. (Read-only).
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DomainAliasName: The domain alias name.
	DomainAliasName string `json:"domainAliasName,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// ParentDomainName: The parent domain name that the domain alias is associated
	// with. This can either be a primary or secondary domain name within a
	// customer.
	ParentDomainName string `json:"parentDomainName,omitempty"`
	// Verified: Indicates the verification state of a domain alias. (Read-only)
	Verified bool `json:"verified,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainAlias) MarshalJSON() ([]byte, error) {
	type NoMethod DomainAlias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DomainAliases struct {
	// DomainAliases: A list of domain alias objects.
	DomainAliases []*DomainAlias `json:"domainAliases,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DomainAliases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DomainAliases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainAliases) MarshalJSON() ([]byte, error) {
	type NoMethod DomainAliases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Domains struct {
	// CreationTime: Creation time of the domain. Expressed in Unix time
	// (https://en.wikipedia.org/wiki/Epoch_time) format. (Read-only).
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DomainAliases: A list of domain alias objects. (Read-only)
	DomainAliases []*DomainAlias `json:"domainAliases,omitempty"`
	// DomainName: The domain name of the customer.
	DomainName string `json:"domainName,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// IsPrimary: Indicates if the domain is a primary domain (Read-only).
	IsPrimary bool `json:"isPrimary,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// Verified: Indicates the verification state of a domain. (Read-only).
	Verified bool `json:"verified,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Domains) MarshalJSON() ([]byte, error) {
	type NoMethod Domains
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Domains2 struct {
	// Domains: A list of domain objects.
	Domains []*Domains `json:"domains,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Domains") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domains") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Domains2) MarshalJSON() ([]byte, error) {
	type NoMethod Domains2
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// FailureInfo: Info about failures
type FailureInfo struct {
	// ErrorCode: Canonical code for why the update failed to apply.
	//
	// Possible values:
	//   "OK" - Not an error; returned on success. HTTP Mapping: 200 OK
	//   "CANCELLED" - The operation was cancelled, typically by the caller. HTTP
	// Mapping: 499 Client Closed Request
	//   "UNKNOWN" - Unknown error. For example, this error may be returned when a
	// `Status` value received from another address space belongs to an error space
	// that is not known in this address space. Also errors raised by APIs that do
	// not return enough error information may be converted to this error. HTTP
	// Mapping: 500 Internal Server Error
	//   "INVALID_ARGUMENT" - The client specified an invalid argument. Note that
	// this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
	// arguments that are problematic regardless of the state of the system (e.g.,
	// a malformed file name). HTTP Mapping: 400 Bad Request
	//   "DEADLINE_EXCEEDED" - The deadline expired before the operation could
	// complete. For operations that change the state of the system, this error may
	// be returned even if the operation has completed successfully. For example, a
	// successful response from a server could have been delayed long enough for
	// the deadline to expire. HTTP Mapping: 504 Gateway Timeout
	//   "NOT_FOUND" - Some requested entity (e.g., file or directory) was not
	// found. Note to server developers: if a request is denied for an entire class
	// of users, such as gradual feature rollout or undocumented allowlist,
	// `NOT_FOUND` may be used. If a request is denied for some users within a
	// class of users, such as user-based access control, `PERMISSION_DENIED` must
	// be used. HTTP Mapping: 404 Not Found
	//   "ALREADY_EXISTS" - The entity that a client attempted to create (e.g.,
	// file or directory) already exists. HTTP Mapping: 409 Conflict
	//   "PERMISSION_DENIED" - The caller does not have permission to execute the
	// specified operation. `PERMISSION_DENIED` must not be used for rejections
	// caused by exhausting some resource (use `RESOURCE_EXHAUSTED` instead for
	// those errors). `PERMISSION_DENIED` must not be used if the caller can not be
	// identified (use `UNAUTHENTICATED` instead for those errors). This error code
	// does not imply the request is valid or the requested entity exists or
	// satisfies other pre-conditions. HTTP Mapping: 403 Forbidden
	//   "UNAUTHENTICATED" - The request does not have valid authentication
	// credentials for the operation. HTTP Mapping: 401 Unauthorized
	//   "RESOURCE_EXHAUSTED" - Some resource has been exhausted, perhaps a
	// per-user quota, or perhaps the entire file system is out of space. HTTP
	// Mapping: 429 Too Many Requests
	//   "FAILED_PRECONDITION" - The operation was rejected because the system is
	// not in a state required for the operation's execution. For example, the
	// directory to be deleted is non-empty, an rmdir operation is applied to a
	// non-directory, etc. Service implementors can use the following guidelines to
	// decide between `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`: (a) Use
	// `UNAVAILABLE` if the client can retry just the failing call. (b) Use
	// `ABORTED` if the client should retry at a higher level. For example, when a
	// client-specified test-and-set fails, indicating the client should restart a
	// read-modify-write sequence. (c) Use `FAILED_PRECONDITION` if the client
	// should not retry until the system state has been explicitly fixed. For
	// example, if an "rmdir" fails because the directory is non-empty,
	// `FAILED_PRECONDITION` should be returned since the client should not retry
	// unless the files are deleted from the directory. HTTP Mapping: 400 Bad
	// Request
	//   "ABORTED" - The operation was aborted, typically due to a concurrency
	// issue such as a sequencer check failure or transaction abort. See the
	// guidelines above for deciding between `FAILED_PRECONDITION`, `ABORTED`, and
	// `UNAVAILABLE`. HTTP Mapping: 409 Conflict
	//   "OUT_OF_RANGE" - The operation was attempted past the valid range. E.g.,
	// seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this error
	// indicates a problem that may be fixed if the system state changes. For
	// example, a 32-bit file system will generate `INVALID_ARGUMENT` if asked to
	// read at an offset that is not in the range [0,2^32-1], but it will generate
	// `OUT_OF_RANGE` if asked to read from an offset past the current file size.
	// There is a fair bit of overlap between `FAILED_PRECONDITION` and
	// `OUT_OF_RANGE`. We recommend using `OUT_OF_RANGE` (the more specific error)
	// when it applies so that callers who are iterating through a space can easily
	// look for an `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping:
	// 400 Bad Request
	//   "UNIMPLEMENTED" - The operation is not implemented or is not
	// supported/enabled in this service. HTTP Mapping: 501 Not Implemented
	//   "INTERNAL" - Internal errors. This means that some invariants expected by
	// the underlying system have been broken. This error code is reserved for
	// serious errors. HTTP Mapping: 500 Internal Server Error
	//   "UNAVAILABLE" - The service is currently unavailable. This is most likely
	// a transient condition, which can be corrected by retrying with a backoff.
	// Note that it is not always safe to retry non-idempotent operations. See the
	// guidelines above for deciding between `FAILED_PRECONDITION`, `ABORTED`, and
	// `UNAVAILABLE`. HTTP Mapping: 503 Service Unavailable
	//   "DATA_LOSS" - Unrecoverable data loss or corruption. HTTP Mapping: 500
	// Internal Server Error
	ErrorCode string `json:"errorCode,omitempty"`
	// ErrorMessage: Failure reason message.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// Printer: Failed printer.
	Printer *Printer `json:"printer,omitempty"`
	// PrinterId: Id of a failed printer.
	PrinterId string `json:"printerId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FailureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FailureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FanInfo: Information about the device's fan.
type FanInfo struct {
	// SpeedRpm: Output only. Fan speed in RPM.
	SpeedRpm int64 `json:"speedRpm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpeedRpm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpeedRpm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FanInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FanInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Feature: JSON template for Feature object in Directory API.
type Feature struct {
	// Etags: ETag of the resource.
	Etags string `json:"etags,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// Name: The name of the feature.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etags") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etags") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Feature) MarshalJSON() ([]byte, error) {
	type NoMethod Feature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FeatureInstance: JSON template for a feature instance.
type FeatureInstance struct {
	// Feature: The feature that this is an instance of. A calendar resource may
	// have multiple instances of a feature.
	Feature *Feature `json:"feature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Feature") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Feature") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureInstance) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FeatureRename struct {
	// NewName: New name of the feature.
	NewName string `json:"newName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewName") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureRename) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureRename
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Features: Public API: Resources.features
type Features struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Features: The Features in this page of results.
	Features []*Feature `json:"features,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request to return the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Features) MarshalJSON() ([]byte, error) {
	type NoMethod Features
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Group: Google Groups provide your users the ability to send messages to
// groups of people using the group's email address. For more information about
// common tasks, see the Developer's Guide
// (https://developers.google.com/admin-sdk/directory/v1/guides/manage-groups).
// For information about other types of groups, see the Cloud Identity Groups
// API documentation (https://cloud.google.com/identity/docs/groups). Note: The
// user calling the API (or being impersonated by a service account) must have
// an assigned role
// (https://developers.google.com/admin-sdk/directory/v1/guides/manage-roles)
// that includes Admin API Groups permissions, such as Super Admin or Groups
// Admin.
type Group struct {
	// AdminCreated: Read-only. Value is `true` if this group was created by an
	// administrator rather than a user.
	AdminCreated bool `json:"adminCreated,omitempty"`
	// Aliases: Read-only. The list of a group's alias email addresses. To add,
	// update, or remove a group's aliases, use the `groups.aliases` methods. If
	// edited in a group's POST or PUT request, the edit is ignored.
	Aliases []string `json:"aliases,omitempty"`
	// Description: An extended description to help users determine the purpose of
	// a group. For example, you can include information about who should join the
	// group, the types of messages to send to the group, links to FAQs about the
	// group, or related groups. Maximum length is `4,096` characters.
	Description string `json:"description,omitempty"`
	// DirectMembersCount: The number of users that are direct members of the
	// group. If a group is a member (child) of this group (the parent), members of
	// the child group are not counted in the `directMembersCount` property of the
	// parent group.
	DirectMembersCount int64 `json:"directMembersCount,omitempty,string"`
	// Email: The group's email address. If your account has multiple domains,
	// select the appropriate domain for the email address. The `email` must be
	// unique. This property is required when creating a group. Group email
	// addresses are subject to the same character usage rules as usernames, see
	// the help center (https://support.google.com/a/answer/9193374) for details.
	Email string `json:"email,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Id: Read-only. The unique ID of a group. A group `id` can be used as a group
	// request URI's `groupKey`.
	Id string `json:"id,omitempty"`
	// Kind: The type of the API resource. For Groups resources, the value is
	// `admin#directory#group`.
	Kind string `json:"kind,omitempty"`
	// Name: The group's display name.
	Name string `json:"name,omitempty"`
	// NonEditableAliases: Read-only. The list of the group's non-editable alias
	// email addresses that are outside of the account's primary domain or
	// subdomains. These are functioning email addresses used by the group. This is
	// a read-only property returned in the API's response for a group. If edited
	// in a group's POST or PUT request, the edit is ignored.
	NonEditableAliases []string `json:"nonEditableAliases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdminCreated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminCreated") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Group) MarshalJSON() ([]byte, error) {
	type NoMethod Group
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GroupAlias: The Directory API manages aliases, which are alternative email
// addresses.
type GroupAlias struct {
	// Alias: The alias email address.
	Alias string `json:"alias,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Id: The unique ID of the group.
	Id string `json:"id,omitempty"`
	// Kind: The type of the API resource. For Alias resources, the value is
	// `admin#directory#alias`.
	Kind string `json:"kind,omitempty"`
	// PrimaryEmail: The primary email address of the group.
	PrimaryEmail string `json:"primaryEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GroupAlias) MarshalJSON() ([]byte, error) {
	type NoMethod GroupAlias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Groups struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Groups: A list of group objects.
	Groups []*Group `json:"groups,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Token used to access next page of this result.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Groups) MarshalJSON() ([]byte, error) {
	type NoMethod Groups
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListPrintServersResponse struct {
	// NextPageToken: A token that can be sent as `page_token` in a request to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PrintServers: List of print servers.
	PrintServers []*PrintServer `json:"printServers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPrintServersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPrintServersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPrinterModelsResponse: Response for listing allowed printer models.
type ListPrinterModelsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PrinterModels: Printer models that are currently allowed to be configured
	// for ChromeOs. Some printers may be added or removed over time.
	PrinterModels []*PrinterModel `json:"printerModels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPrinterModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPrinterModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPrintersResponse: Response for listing printers.
type ListPrintersResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Printers: List of printers. If `org_unit_id` was given in the request, then
	// only printers visible for this OU will be returned. If `org_unit_id` was not
	// given in the request, then all printers will be returned.
	Printers []*Printer `json:"printers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPrintersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPrintersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Member: A Google Groups member can be a user or another group. This member
// can be inside or outside of your account's domains. For more information
// about common group member tasks, see the Developer's Guide
// (/admin-sdk/directory/v1/guides/manage-group-members).
type Member struct {
	// DeliverySettings: Defines mail delivery preferences of member. This field is
	// only supported by `insert`, `update`, and `get` methods.
	DeliverySettings string `json:"delivery_settings,omitempty"`
	// Email: The member's email address. A member can be a user or another group.
	// This property is required when adding a member to a group. The `email` must
	// be unique and cannot be an alias of another group. If the email address is
	// changed, the API automatically reflects the email address changes.
	Email string `json:"email,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Id: The unique ID of the group member. A member `id` can be used as a member
	// request URI's `memberKey`.
	Id string `json:"id,omitempty"`
	// Kind: The type of the API resource. For Members resources, the value is
	// `admin#directory#member`.
	Kind string `json:"kind,omitempty"`
	// Role: The member's role in a group. The API returns an error for cycles in
	// group memberships. For example, if `group1` is a member of `group2`,
	// `group2` cannot be a member of `group1`. For more information about a
	// member's role, see the administration help center
	// (https://support.google.com/a/answer/167094).
	Role string `json:"role,omitempty"`
	// Status: Status of member (Immutable)
	Status string `json:"status,omitempty"`
	// Type: The type of group member.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeliverySettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeliverySettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Member) MarshalJSON() ([]byte, error) {
	type NoMethod Member
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Members struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// Members: A list of member objects.
	Members []*Member `json:"members,omitempty"`
	// NextPageToken: Token used to access next page of this result.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Members) MarshalJSON() ([]byte, error) {
	type NoMethod Members
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MembersHasMember: JSON template for Has Member response in Directory API.
type MembersHasMember struct {
	// IsMember: Output only. Identifies whether the given user is a member of the
	// group. Membership can be direct or nested.
	IsMember bool `json:"isMember,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IsMember") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsMember") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MembersHasMember) MarshalJSON() ([]byte, error) {
	type NoMethod MembersHasMember
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MobileDevice: Google Workspace Mobile Management includes Android, Google
// Sync (https://support.google.com/a/answer/135937), and iOS devices. For more
// information about common group mobile device API tasks, see the Developer's
// Guide (/admin-sdk/directory/v1/guides/manage-mobile-devices.html).
type MobileDevice struct {
	// AdbStatus: Adb (USB debugging) enabled or disabled on device (Read-only)
	AdbStatus bool `json:"adbStatus,omitempty"`
	// Applications: The list of applications installed on an Android mobile
	// device. It is not applicable to Google Sync and iOS devices. The list
	// includes any Android applications that access Google Workspace data. When
	// updating an applications list, it is important to note that updates replace
	// the existing list. If the Android device has two existing applications and
	// the API updates the list with five applications, the is now the updated list
	// of five applications.
	Applications []*MobileDeviceApplications `json:"applications,omitempty"`
	// BasebandVersion: The device's baseband version.
	BasebandVersion string `json:"basebandVersion,omitempty"`
	// BootloaderVersion: Mobile Device Bootloader version (Read-only)
	BootloaderVersion string `json:"bootloaderVersion,omitempty"`
	// Brand: Mobile Device Brand (Read-only)
	Brand string `json:"brand,omitempty"`
	// BuildNumber: The device's operating system build number.
	BuildNumber string `json:"buildNumber,omitempty"`
	// DefaultLanguage: The default locale used on the device.
	DefaultLanguage string `json:"defaultLanguage,omitempty"`
	// DeveloperOptionsStatus: Developer options enabled or disabled on device
	// (Read-only)
	DeveloperOptionsStatus bool `json:"developerOptionsStatus,omitempty"`
	// DeviceCompromisedStatus: The compromised device status.
	DeviceCompromisedStatus string `json:"deviceCompromisedStatus,omitempty"`
	// DeviceId: The serial number for a Google Sync mobile device. For Android and
	// iOS devices, this is a software generated unique identifier.
	DeviceId string `json:"deviceId,omitempty"`
	// DevicePasswordStatus: DevicePasswordStatus (Read-only)
	DevicePasswordStatus string `json:"devicePasswordStatus,omitempty"`
	// Email: The list of the owner's email addresses. If your application needs
	// the current list of user emails, use the get
	// (/admin-sdk/directory/v1/reference/mobiledevices/get.html) method. For
	// additional information, see the retrieve a user
	// (/admin-sdk/directory/v1/guides/manage-users#get_user) method.
	Email []string `json:"email,omitempty"`
	// EncryptionStatus: Mobile Device Encryption Status (Read-only)
	EncryptionStatus string `json:"encryptionStatus,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// FirstSync: Date and time the device was first synchronized with the policy
	// settings in the G Suite administrator control panel (Read-only)
	FirstSync string `json:"firstSync,omitempty"`
	// Hardware: Mobile Device Hardware (Read-only)
	Hardware string `json:"hardware,omitempty"`
	// HardwareId: The IMEI/MEID unique identifier for Android hardware. It is not
	// applicable to Google Sync devices. When adding an Android mobile device,
	// this is an optional property. When updating one of these devices, this is a
	// read-only property.
	HardwareId string `json:"hardwareId,omitempty"`
	// Imei: The device's IMEI number.
	Imei string `json:"imei,omitempty"`
	// KernelVersion: The device's kernel version.
	KernelVersion string `json:"kernelVersion,omitempty"`
	// Kind: The type of the API resource. For Mobiledevices resources, the value
	// is `admin#directory#mobiledevice`.
	Kind string `json:"kind,omitempty"`
	// LastSync: Date and time the device was last synchronized with the policy
	// settings in the G Suite administrator control panel (Read-only)
	LastSync string `json:"lastSync,omitempty"`
	// ManagedAccountIsOnOwnerProfile: Boolean indicating if this account is on
	// owner/primary profile or not.
	ManagedAccountIsOnOwnerProfile bool `json:"managedAccountIsOnOwnerProfile,omitempty"`
	// Manufacturer: Mobile Device manufacturer (Read-only)
	Manufacturer string `json:"manufacturer,omitempty"`
	// Meid: The device's MEID number.
	Meid string `json:"meid,omitempty"`
	// Model: The mobile device's model name, for example Nexus S. This property
	// can be updated
	// (/admin-sdk/directory/v1/reference/mobiledevices/update.html). For more
	// information, see the Developer's Guide
	// (/admin-sdk/directory/v1/guides/manage-mobile=devices#update_mobile_device).
	Model string `json:"model,omitempty"`
	// Name: The list of the owner's user names. If your application needs the
	// current list of device owner names, use the get
	// (/admin-sdk/directory/v1/reference/mobiledevices/get.html) method. For more
	// information about retrieving mobile device user information, see the
	// Developer's Guide (/admin-sdk/directory/v1/guides/manage-users#get_user).
	Name []string `json:"name,omitempty"`
	// NetworkOperator: Mobile Device mobile or network operator (if available)
	// (Read-only)
	NetworkOperator string `json:"networkOperator,omitempty"`
	// Os: The mobile device's operating system, for example IOS 4.3 or Android
	// 2.3.5. This property can be updated
	// (/admin-sdk/directory/v1/reference/mobiledevices/update.html). For more
	// information, see the Developer's Guide
	// (/admin-sdk/directory/v1/guides/manage-mobile-devices#update_mobile_device).
	Os string `json:"os,omitempty"`
	// OtherAccountsInfo: The list of accounts added on device (Read-only)
	OtherAccountsInfo []string `json:"otherAccountsInfo,omitempty"`
	// Privilege: DMAgentPermission (Read-only)
	Privilege string `json:"privilege,omitempty"`
	// ReleaseVersion: Mobile Device release version version (Read-only)
	ReleaseVersion string `json:"releaseVersion,omitempty"`
	// ResourceId: The unique ID the API service uses to identify the mobile
	// device.
	ResourceId string `json:"resourceId,omitempty"`
	// SecurityPatchLevel: Mobile Device Security patch level (Read-only)
	SecurityPatchLevel int64 `json:"securityPatchLevel,omitempty,string"`
	// SerialNumber: The device's serial number.
	SerialNumber string `json:"serialNumber,omitempty"`
	// Status: The device's status.
	Status string `json:"status,omitempty"`
	// SupportsWorkProfile: Work profile supported on device (Read-only)
	SupportsWorkProfile bool `json:"supportsWorkProfile,omitempty"`
	// Type: The type of mobile device.
	Type string `json:"type,omitempty"`
	// UnknownSourcesStatus: Unknown sources enabled or disabled on device
	// (Read-only)
	UnknownSourcesStatus bool `json:"unknownSourcesStatus,omitempty"`
	// UserAgent: Gives information about the device such as `os` version. This
	// property can be updated
	// (/admin-sdk/directory/v1/reference/mobiledevices/update.html). For more
	// information, see the Developer's Guide
	// (/admin-sdk/directory/v1/guides/manage-mobile-devices#update_mobile_device).
	UserAgent string `json:"userAgent,omitempty"`
	// WifiMacAddress: The device's MAC address on Wi-Fi networks.
	WifiMacAddress string `json:"wifiMacAddress,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdbStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdbStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MobileDevice) MarshalJSON() ([]byte, error) {
	type NoMethod MobileDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type MobileDeviceApplications struct {
	// DisplayName: The application's display name. An example is `Browser`.
	DisplayName string `json:"displayName,omitempty"`
	// PackageName: The application's package name. An example is
	// `com.android.browser`.
	PackageName string `json:"packageName,omitempty"`
	// Permission: The list of permissions of this application. These can be either
	// a standard Android permission or one defined by the application, and are
	// found in an application's Android manifest
	// (https://developer.android.com/guide/topics/manifest/uses-permission-element.html).
	// Examples of a Calendar application's permissions are `READ_CALENDAR`, or
	// `MANAGE_ACCOUNTS`.
	Permission []string `json:"permission,omitempty"`
	// VersionCode: The application's version code. An example is `13`.
	VersionCode int64 `json:"versionCode,omitempty"`
	// VersionName: The application's version name. An example is `3.2-140714`.
	VersionName string `json:"versionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MobileDeviceApplications) MarshalJSON() ([]byte, error) {
	type NoMethod MobileDeviceApplications
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type MobileDeviceAction struct {
	// Action: The action to be performed on the device.
	Action string `json:"action,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MobileDeviceAction) MarshalJSON() ([]byte, error) {
	type NoMethod MobileDeviceAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type MobileDevices struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// Mobiledevices: A list of Mobile Device objects.
	Mobiledevices []*MobileDevice `json:"mobiledevices,omitempty"`
	// NextPageToken: Token used to access next page of this result.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MobileDevices) MarshalJSON() ([]byte, error) {
	type NoMethod MobileDevices
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrgUnit: Managing your account's organizational units allows you to
// configure your users' access to services and custom settings. For more
// information about common organizational unit tasks, see the Developer's
// Guide (/admin-sdk/directory/v1/guides/manage-org-units.html). The customer's
// organizational unit hierarchy is limited to 35 levels of depth.
type OrgUnit struct {
	// BlockInheritance: Determines if a sub-organizational unit can inherit the
	// settings of the parent organization. The default value is `false`, meaning a
	// sub-organizational unit inherits the settings of the nearest parent
	// organizational unit. This field is deprecated. Setting it to `true` is no
	// longer supported and can have _unintended consequences_. For more
	// information about inheritance and users in an organization structure, see
	// the administration help center
	// (https://support.google.com/a/answer/4352075).
	BlockInheritance bool `json:"blockInheritance,omitempty"`
	// Description: Description of the organizational unit.
	Description string `json:"description,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of the API resource. For Orgunits resources, the value is
	// `admin#directory#orgUnit`.
	Kind string `json:"kind,omitempty"`
	// Name: The organizational unit's path name. For example, an organizational
	// unit's name within the /corp/support/sales_support parent path is
	// sales_support. Required.
	Name string `json:"name,omitempty"`
	// OrgUnitId: The unique ID of the organizational unit.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// OrgUnitPath: The full path to the organizational unit. The `orgUnitPath` is
	// a derived property. When listed, it is derived from `parentOrgunitPath` and
	// organizational unit's `name`. For example, for an organizational unit named
	// 'apps' under parent organization '/engineering', the orgUnitPath is
	// '/engineering/apps'. In order to edit an `orgUnitPath`, either update the
	// name of the organization or the `parentOrgunitPath`. A user's organizational
	// unit determines which Google Workspace services the user has access to. If
	// the user is moved to a new organization, the user's access changes. For more
	// information about organization structures, see the administration help
	// center (https://support.google.com/a/answer/4352075). For more information
	// about moving a user to a different organization, see Update a user
	// (/admin-sdk/directory/v1/guides/manage-users.html#update_user).
	OrgUnitPath string `json:"orgUnitPath,omitempty"`
	// ParentOrgUnitId: The unique ID of the parent organizational unit. Required,
	// unless `parentOrgUnitPath` is set.
	ParentOrgUnitId string `json:"parentOrgUnitId,omitempty"`
	// ParentOrgUnitPath: The organizational unit's parent path. For example,
	// /corp/sales is the parent path for /corp/sales/sales_support organizational
	// unit. Required, unless `parentOrgUnitId` is set.
	ParentOrgUnitPath string `json:"parentOrgUnitPath,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlockInheritance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockInheritance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrgUnit) MarshalJSON() ([]byte, error) {
	type NoMethod OrgUnit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OrgUnits struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of the API resource. For Org Unit resources, the type is
	// `admin#directory#orgUnits`.
	Kind string `json:"kind,omitempty"`
	// OrganizationUnits: A list of organizational unit objects.
	OrganizationUnits []*OrgUnit `json:"organizationUnits,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrgUnits) MarshalJSON() ([]byte, error) {
	type NoMethod OrgUnits
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OsUpdateStatus: Contains information regarding the current OS update status.
type OsUpdateStatus struct {
	// RebootTime: Date and time of the last reboot.
	RebootTime string `json:"rebootTime,omitempty"`
	// State: The update state of an OS update.
	//
	// Possible values:
	//   "updateStateUnspecified" - The update state is unspecified.
	//   "updateStateNotStarted" - There is an update pending but it hasn't
	// started.
	//   "updateStateDownloadInProgress" - The pending update is being downloaded.
	//   "updateStateNeedReboot" - The device is ready to install the update, but
	// must reboot.
	State string `json:"state,omitempty"`
	// TargetKioskAppVersion: New required platform version from the pending
	// updated kiosk app.
	TargetKioskAppVersion string `json:"targetKioskAppVersion,omitempty"`
	// TargetOsVersion: New platform version of the OS image being downloaded and
	// applied. It is only set when update status is
	// UPDATE_STATUS_DOWNLOAD_IN_PROGRESS or UPDATE_STATUS_NEED_REBOOT. Note this
	// could be a dummy "0.0.0.0" for UPDATE_STATUS_NEED_REBOOT for some edge
	// cases, e.g. update engine is restarted without a reboot.
	TargetOsVersion string `json:"targetOsVersion,omitempty"`
	// UpdateCheckTime: Date and time of the last update check.
	UpdateCheckTime string `json:"updateCheckTime,omitempty"`
	// UpdateTime: Date and time of the last successful OS update.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RebootTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RebootTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OsUpdateStatus) MarshalJSON() ([]byte, error) {
	type NoMethod OsUpdateStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrintServer: Configuration for a print server.
type PrintServer struct {
	// CreateTime: Output only. Time when the print server was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Editable. Description of the print server (as shown in the
	// Admin console).
	Description string `json:"description,omitempty"`
	// DisplayName: Editable. Display name of the print server (as shown in the
	// Admin console).
	DisplayName string `json:"displayName,omitempty"`
	// Id: Immutable. ID of the print server. Leave empty when creating.
	Id string `json:"id,omitempty"`
	// Name: Immutable. Resource name of the print server. Leave empty when
	// creating. Format: `customers/{customer.id}/printServers/{print_server.id}`
	Name string `json:"name,omitempty"`
	// OrgUnitId: ID of the organization unit (OU) that owns this print server.
	// This value can only be set when the print server is initially created. If
	// it's not populated, the print server is placed under the root OU. The
	// `org_unit_id` can be retrieved using the Directory API
	// (/admin-sdk/directory/reference/rest/v1/orgunits).
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// Uri: Editable. Print server URI.
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrintServer) MarshalJSON() ([]byte, error) {
	type NoMethod PrintServer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrintServerFailureInfo: Info about failures
type PrintServerFailureInfo struct {
	// ErrorCode: Canonical code for why the update failed to apply.
	//
	// Possible values:
	//   "OK" - Not an error; returned on success. HTTP Mapping: 200 OK
	//   "CANCELLED" - The operation was cancelled, typically by the caller. HTTP
	// Mapping: 499 Client Closed Request
	//   "UNKNOWN" - Unknown error. For example, this error may be returned when a
	// `Status` value received from another address space belongs to an error space
	// that is not known in this address space. Also errors raised by APIs that do
	// not return enough error information may be converted to this error. HTTP
	// Mapping: 500 Internal Server Error
	//   "INVALID_ARGUMENT" - The client specified an invalid argument. Note that
	// this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
	// arguments that are problematic regardless of the state of the system (e.g.,
	// a malformed file name). HTTP Mapping: 400 Bad Request
	//   "DEADLINE_EXCEEDED" - The deadline expired before the operation could
	// complete. For operations that change the state of the system, this error may
	// be returned even if the operation has completed successfully. For example, a
	// successful response from a server could have been delayed long enough for
	// the deadline to expire. HTTP Mapping: 504 Gateway Timeout
	//   "NOT_FOUND" - Some requested entity (e.g., file or directory) was not
	// found. Note to server developers: if a request is denied for an entire class
	// of users, such as gradual feature rollout or undocumented allowlist,
	// `NOT_FOUND` may be used. If a request is denied for some users within a
	// class of users, such as user-based access control, `PERMISSION_DENIED` must
	// be used. HTTP Mapping: 404 Not Found
	//   "ALREADY_EXISTS" - The entity that a client attempted to create (e.g.,
	// file or directory) already exists. HTTP Mapping: 409 Conflict
	//   "PERMISSION_DENIED" - The caller does not have permission to execute the
	// specified operation. `PERMISSION_DENIED` must not be used for rejections
	// caused by exhausting some resource (use `RESOURCE_EXHAUSTED` instead for
	// those errors). `PERMISSION_DENIED` must not be used if the caller can not be
	// identified (use `UNAUTHENTICATED` instead for those errors). This error code
	// does not imply the request is valid or the requested entity exists or
	// satisfies other pre-conditions. HTTP Mapping: 403 Forbidden
	//   "UNAUTHENTICATED" - The request does not have valid authentication
	// credentials for the operation. HTTP Mapping: 401 Unauthorized
	//   "RESOURCE_EXHAUSTED" - Some resource has been exhausted, perhaps a
	// per-user quota, or perhaps the entire file system is out of space. HTTP
	// Mapping: 429 Too Many Requests
	//   "FAILED_PRECONDITION" - The operation was rejected because the system is
	// not in a state required for the operation's execution. For example, the
	// directory to be deleted is non-empty, an rmdir operation is applied to a
	// non-directory, etc. Service implementors can use the following guidelines to
	// decide between `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`: (a) Use
	// `UNAVAILABLE` if the client can retry just the failing call. (b) Use
	// `ABORTED` if the client should retry at a higher level. For example, when a
	// client-specified test-and-set fails, indicating the client should restart a
	// read-modify-write sequence. (c) Use `FAILED_PRECONDITION` if the client
	// should not retry until the system state has been explicitly fixed. For
	// example, if an "rmdir" fails because the directory is non-empty,
	// `FAILED_PRECONDITION` should be returned since the client should not retry
	// unless the files are deleted from the directory. HTTP Mapping: 400 Bad
	// Request
	//   "ABORTED" - The operation was aborted, typically due to a concurrency
	// issue such as a sequencer check failure or transaction abort. See the
	// guidelines above for deciding between `FAILED_PRECONDITION`, `ABORTED`, and
	// `UNAVAILABLE`. HTTP Mapping: 409 Conflict
	//   "OUT_OF_RANGE" - The operation was attempted past the valid range. E.g.,
	// seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this error
	// indicates a problem that may be fixed if the system state changes. For
	// example, a 32-bit file system will generate `INVALID_ARGUMENT` if asked to
	// read at an offset that is not in the range [0,2^32-1], but it will generate
	// `OUT_OF_RANGE` if asked to read from an offset past the current file size.
	// There is a fair bit of overlap between `FAILED_PRECONDITION` and
	// `OUT_OF_RANGE`. We recommend using `OUT_OF_RANGE` (the more specific error)
	// when it applies so that callers who are iterating through a space can easily
	// look for an `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping:
	// 400 Bad Request
	//   "UNIMPLEMENTED" - The operation is not implemented or is not
	// supported/enabled in this service. HTTP Mapping: 501 Not Implemented
	//   "INTERNAL" - Internal errors. This means that some invariants expected by
	// the underlying system have been broken. This error code is reserved for
	// serious errors. HTTP Mapping: 500 Internal Server Error
	//   "UNAVAILABLE" - The service is currently unavailable. This is most likely
	// a transient condition, which can be corrected by retrying with a backoff.
	// Note that it is not always safe to retry non-idempotent operations. See the
	// guidelines above for deciding between `FAILED_PRECONDITION`, `ABORTED`, and
	// `UNAVAILABLE`. HTTP Mapping: 503 Service Unavailable
	//   "DATA_LOSS" - Unrecoverable data loss or corruption. HTTP Mapping: 500
	// Internal Server Error
	ErrorCode string `json:"errorCode,omitempty"`
	// ErrorMessage: Failure reason message.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// PrintServer: Failed print server.
	PrintServer *PrintServer `json:"printServer,omitempty"`
	// PrintServerId: ID of a failed print server.
	PrintServerId string `json:"printServerId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrintServerFailureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PrintServerFailureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Printer: Printer configuration.
type Printer struct {
	// AuxiliaryMessages: Output only. Auxiliary messages about issues with the
	// printer configuration if any.
	AuxiliaryMessages []*AuxiliaryMessage `json:"auxiliaryMessages,omitempty"`
	// CreateTime: Output only. Time when printer was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Editable. Description of printer.
	Description string `json:"description,omitempty"`
	// DisplayName: Editable. Name of printer.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Id of the printer. (During printer creation leave empty)
	Id string `json:"id,omitempty"`
	// MakeAndModel: Editable. Make and model of printer. e.g. Lexmark MS610de
	// Value must be in format as seen in ListPrinterModels response.
	MakeAndModel string `json:"makeAndModel,omitempty"`
	// Name: The resource name of the Printer object, in the format
	// customers/{customer-id}/printers/{printer-id} (During printer creation leave
	// empty)
	Name string `json:"name,omitempty"`
	// OrgUnitId: Organization Unit that owns this printer (Only can be set during
	// Printer creation)
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// Uri: Editable. Printer URI.
	Uri string `json:"uri,omitempty"`
	// UseDriverlessConfig: Editable. flag to use driverless configuration or not.
	// If it's set to be true, make_and_model can be ignored
	UseDriverlessConfig bool `json:"useDriverlessConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuxiliaryMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuxiliaryMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Printer) MarshalJSON() ([]byte, error) {
	type NoMethod Printer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrinterModel: Printer manufacturer and model
type PrinterModel struct {
	// DisplayName: Display name. eq. "Brother MFC-8840D"
	DisplayName string `json:"displayName,omitempty"`
	// MakeAndModel: Make and model as represented in "make_and_model" field in
	// Printer object. eq. "brother mfc-8840d"
	MakeAndModel string `json:"makeAndModel,omitempty"`
	// Manufacturer: Manufacturer. eq. "Brother"
	Manufacturer string `json:"manufacturer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrinterModel) MarshalJSON() ([]byte, error) {
	type NoMethod PrinterModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Privilege struct {
	// ChildPrivileges: A list of child privileges. Privileges for a service form a
	// tree. Each privilege can have a list of child privileges; this list is empty
	// for a leaf privilege.
	ChildPrivileges []*Privilege `json:"childPrivileges,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// IsOuScopable: If the privilege can be restricted to an organization unit.
	IsOuScopable bool `json:"isOuScopable,omitempty"`
	// Kind: The type of the API resource. This is always
	// `admin#directory#privilege`.
	Kind string `json:"kind,omitempty"`
	// PrivilegeName: The name of the privilege.
	PrivilegeName string `json:"privilegeName,omitempty"`
	// ServiceId: The obfuscated ID of the service this privilege is for. This
	// value is returned with `Privileges.list()`
	// (/admin-sdk/directory/v1/reference/privileges/list).
	ServiceId string `json:"serviceId,omitempty"`
	// ServiceName: The name of the service this privilege is for.
	ServiceName string `json:"serviceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChildPrivileges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChildPrivileges") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Privilege) MarshalJSON() ([]byte, error) {
	type NoMethod Privilege
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Privileges struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: A list of Privilege resources.
	Items []*Privilege `json:"items,omitempty"`
	// Kind: The type of the API resource. This is always
	// `admin#directory#privileges`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Privileges) MarshalJSON() ([]byte, error) {
	type NoMethod Privileges
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Role struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// IsSuperAdminRole: Returns `true` if the role is a super admin role.
	IsSuperAdminRole bool `json:"isSuperAdminRole,omitempty"`
	// IsSystemRole: Returns `true` if this is a pre-defined system role.
	IsSystemRole bool `json:"isSystemRole,omitempty"`
	// Kind: The type of the API resource. This is always `admin#directory#role`.
	Kind string `json:"kind,omitempty"`
	// RoleDescription: A short description of the role.
	RoleDescription string `json:"roleDescription,omitempty"`
	// RoleId: ID of the role.
	RoleId int64 `json:"roleId,omitempty,string"`
	// RoleName: Name of the role.
	RoleName string `json:"roleName,omitempty"`
	// RolePrivileges: The set of privileges that are granted to this role.
	RolePrivileges []*RoleRolePrivileges `json:"rolePrivileges,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Role) MarshalJSON() ([]byte, error) {
	type NoMethod Role
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RoleRolePrivileges struct {
	// PrivilegeName: The name of the privilege.
	PrivilegeName string `json:"privilegeName,omitempty"`
	// ServiceId: The obfuscated ID of the service this privilege is for. This
	// value is returned with `Privileges.list()`
	// (/admin-sdk/directory/v1/reference/privileges/list).
	ServiceId string `json:"serviceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrivilegeName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrivilegeName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RoleRolePrivileges) MarshalJSON() ([]byte, error) {
	type NoMethod RoleRolePrivileges
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RoleAssignment: Defines an assignment of a role.
type RoleAssignment struct {
	// AssignedTo: The unique ID of the entity this role is assigned to—either
	// the `user_id` of a user, the `group_id` of a group, or the `uniqueId` of a
	// service account as defined in Identity and Access Management (IAM)
	// (https://cloud.google.com/iam/docs/reference/rest/v1/projects.serviceAccounts).
	AssignedTo string `json:"assignedTo,omitempty"`
	// AssigneeType: Output only. The type of the assignee (`USER` or `GROUP`).
	//
	// Possible values:
	//   "user" - An individual user within the domain.
	//   "group" - A group within the domain.
	AssigneeType string `json:"assigneeType,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of the API resource. This is always
	// `admin#directory#roleAssignment`.
	Kind string `json:"kind,omitempty"`
	// OrgUnitId: If the role is restricted to an organization unit, this contains
	// the ID for the organization unit the exercise of this role is restricted to.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// RoleAssignmentId: ID of this roleAssignment.
	RoleAssignmentId int64 `json:"roleAssignmentId,omitempty,string"`
	// RoleId: The ID of the role that is assigned.
	RoleId int64 `json:"roleId,omitempty,string"`
	// ScopeType: The scope in which this role is assigned.
	ScopeType string `json:"scopeType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssignedTo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssignedTo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RoleAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod RoleAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RoleAssignments struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: A list of RoleAssignment resources.
	Items []*RoleAssignment `json:"items,omitempty"`
	// Kind: The type of the API resource. This is always
	// `admin#directory#roleAssignments`.
	Kind          string `json:"kind,omitempty"`
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RoleAssignments) MarshalJSON() ([]byte, error) {
	type NoMethod RoleAssignments
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Roles struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: A list of Role resources.
	Items []*Role `json:"items,omitempty"`
	// Kind: The type of the API resource. This is always `admin#directory#roles`.
	Kind          string `json:"kind,omitempty"`
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Roles) MarshalJSON() ([]byte, error) {
	type NoMethod Roles
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schema: The type of API resource. For Schema resources, this is always
// `admin#directory#schema`.
type Schema struct {
	// DisplayName: Display name for the schema.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: The ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Fields: A list of fields in the schema.
	Fields []*SchemaFieldSpec `json:"fields,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// SchemaId: The unique identifier of the schema (Read-only)
	SchemaId string `json:"schemaId,omitempty"`
	// SchemaName: The schema's name. Each `schema_name` must be unique within a
	// customer. Reusing a name results in a `409: Entity already exists` error.
	SchemaName string `json:"schemaName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schema) MarshalJSON() ([]byte, error) {
	type NoMethod Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaFieldSpec: You can use schemas to add custom fields to user profiles.
// You can use these fields to store information such as the projects your
// users work on, their physical locations, their hire dates, or whatever else
// fits your business needs. For more information, see Custom User Fields
// (/admin-sdk/directory/v1/guides/manage-schemas).
type SchemaFieldSpec struct {
	// DisplayName: Display Name of the field.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: The ETag of the field.
	Etag string `json:"etag,omitempty"`
	// FieldId: The unique identifier of the field (Read-only)
	FieldId string `json:"fieldId,omitempty"`
	// FieldName: The name of the field.
	FieldName string `json:"fieldName,omitempty"`
	// FieldType: The type of the field.
	FieldType string `json:"fieldType,omitempty"`
	// Indexed: Boolean specifying whether the field is indexed or not. Default:
	// `true`.
	//
	// Default: true
	Indexed *bool `json:"indexed,omitempty"`
	// Kind: The kind of resource this is. For schema fields this is always
	// `admin#directory#schema#fieldspec`.
	Kind string `json:"kind,omitempty"`
	// MultiValued: A boolean specifying whether this is a multi-valued field or
	// not. Default: `false`.
	MultiValued bool `json:"multiValued,omitempty"`
	// NumericIndexingSpec: Indexing spec for a numeric field. By default, only
	// exact match queries will be supported for numeric fields. Setting the
	// `numericIndexingSpec` allows range queries to be supported.
	NumericIndexingSpec *SchemaFieldSpecNumericIndexingSpec `json:"numericIndexingSpec,omitempty"`
	// ReadAccessType: Specifies who can view values of this field. See Retrieve
	// users as a non-administrator
	// (/admin-sdk/directory/v1/guides/manage-users#retrieve_users_non_admin) for
	// more information. Note: It may take up to 24 hours for changes to this field
	// to be reflected.
	ReadAccessType string `json:"readAccessType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaFieldSpec) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaFieldSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SchemaFieldSpecNumericIndexingSpec: Indexing spec for a numeric field. By
// default, only exact match queries will be supported for numeric fields.
// Setting the `numericIndexingSpec` allows range queries to be supported.
type SchemaFieldSpecNumericIndexingSpec struct {
	// MaxValue: Maximum value of this field. This is meant to be indicative rather
	// than enforced. Values outside this range will still be indexed, but search
	// may not be as performant.
	MaxValue float64 `json:"maxValue,omitempty"`
	// MinValue: Minimum value of this field. This is meant to be indicative rather
	// than enforced. Values outside this range will still be indexed, but search
	// may not be as performant.
	MinValue float64 `json:"minValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SchemaFieldSpecNumericIndexingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod SchemaFieldSpecNumericIndexingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *SchemaFieldSpecNumericIndexingSpec) UnmarshalJSON(data []byte) error {
	type NoMethod SchemaFieldSpecNumericIndexingSpec
	var s1 struct {
		MaxValue gensupport.JSONFloat64 `json:"maxValue"`
		MinValue gensupport.JSONFloat64 `json:"minValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxValue = float64(s1.MaxValue)
	s.MinValue = float64(s1.MinValue)
	return nil
}

// Schemas: JSON response template for List Schema operation in Directory API.
type Schemas struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// Schemas: A list of UserSchema objects.
	Schemas []*Schema `json:"schemas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schemas) MarshalJSON() ([]byte, error) {
	type NoMethod Schemas
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Token: JSON template for token resource in Directory API.
type Token struct {
	// Anonymous: Whether the application is registered with Google. The value is
	// `true` if the application has an anonymous Client ID.
	Anonymous bool `json:"anonymous,omitempty"`
	// ClientId: The Client ID of the application the token is issued to.
	ClientId string `json:"clientId,omitempty"`
	// DisplayText: The displayable name of the application the token is issued to.
	DisplayText string `json:"displayText,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of the API resource. This is always `admin#directory#token`.
	Kind string `json:"kind,omitempty"`
	// NativeApp: Whether the token is issued to an installed application. The
	// value is `true` if the application is installed to a desktop or mobile
	// device.
	NativeApp bool `json:"nativeApp,omitempty"`
	// Scopes: A list of authorization scopes the application is granted.
	Scopes []string `json:"scopes,omitempty"`
	// UserKey: The unique ID of the user that issued the token.
	UserKey string `json:"userKey,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Anonymous") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Anonymous") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Token) MarshalJSON() ([]byte, error) {
	type NoMethod Token
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Tokens: JSON response template for List tokens operation in Directory API.
type Tokens struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: A list of Token resources.
	Items []*Token `json:"items,omitempty"`
	// Kind: The type of the API resource. This is always
	// `admin#directory#tokenList`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Tokens) MarshalJSON() ([]byte, error) {
	type NoMethod Tokens
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// User: The Directory API allows you to create and manage your account's
// users, user aliases, and user Google profile photos. For more information
// about common tasks, see the User Accounts Developer's Guide
// (/admin-sdk/directory/v1/guides/manage-users.html) and the User Aliases
// Developer's Guide (/admin-sdk/directory/v1/guides/manage-user-aliases.html).
type User struct {
	// Addresses: The list of the user's addresses. The maximum allowed data size
	// for this field is 10KB.
	Addresses interface{} `json:"addresses,omitempty"`
	// AgreedToTerms: Output only. This property is `true` if the user has
	// completed an initial login and accepted the Terms of Service agreement.
	AgreedToTerms bool `json:"agreedToTerms,omitempty"`
	// Aliases: Output only. The list of the user's alias email addresses.
	Aliases []string `json:"aliases,omitempty"`
	// Archived: Indicates if user is archived.
	Archived bool `json:"archived,omitempty"`
	// ChangePasswordAtNextLogin: Indicates if the user is forced to change their
	// password at next login. This setting doesn't apply when the user signs in
	// via a third-party identity provider
	// (https://support.google.com/a/answer/60224).
	ChangePasswordAtNextLogin bool `json:"changePasswordAtNextLogin,omitempty"`
	// CreationTime: User's G Suite account creation time. (Read-only)
	CreationTime string `json:"creationTime,omitempty"`
	// CustomSchemas: Custom fields of the user. The key is a `schema_name` and its
	// values are `'field_name': 'field_value'`.
	CustomSchemas map[string]googleapi.RawMessage `json:"customSchemas,omitempty"`
	// CustomerId: Output only. The customer ID to retrieve all account users
	// (/admin-sdk/directory/v1/guides/manage-users.html#get_all_users). You can
	// use the alias `my_customer` to represent your account's `customerId`. As a
	// reseller administrator, you can use the resold customer account's
	// `customerId`. To get a `customerId`, use the account's primary domain in the
	// `domain` parameter of a users.list
	// (/admin-sdk/directory/v1/reference/users/list) request.
	CustomerId   string `json:"customerId,omitempty"`
	DeletionTime string `json:"deletionTime,omitempty"`
	// Emails: The list of the user's email addresses. The maximum allowed data
	// size for this field is 10KB. This excludes
	// `publicKeyEncryptionCertificates`.
	Emails interface{} `json:"emails,omitempty"`
	// Etag: Output only. ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// ExternalIds: The list of external IDs for the user, such as an employee or
	// network ID. The maximum allowed data size for this field is 2KB.
	ExternalIds interface{} `json:"externalIds,omitempty"`
	// Gender: The user's gender. The maximum allowed data size for this field is
	// 1KB.
	Gender interface{} `json:"gender,omitempty"`
	// HashFunction: Stores the hash format of the `password` property. The
	// following `hashFunction` values are allowed: * `MD5` - Accepts simple
	// hex-encoded values. * `SHA-1` - Accepts simple hex-encoded values. * `crypt`
	// - Compliant with the C crypt library
	// (https://en.wikipedia.org/wiki/Crypt_%28C%29). Supports the DES, MD5 (hash
	// prefix `$1$`), SHA-256 (hash prefix `$5$`), and SHA-512 (hash prefix `$6$`)
	// hash algorithms. If rounds are specified as part of the prefix, they must be
	// 10,000 or fewer.
	HashFunction string `json:"hashFunction,omitempty"`
	// Id: The unique ID for the user. A user `id` can be used as a user request
	// URI's `userKey`.
	Id string `json:"id,omitempty"`
	// Ims: The list of the user's Instant Messenger (IM) accounts. A user account
	// can have multiple ims properties. But, only one of these ims properties can
	// be the primary IM contact. The maximum allowed data size for this field is
	// 2KB.
	Ims interface{} `json:"ims,omitempty"`
	// IncludeInGlobalAddressList: Indicates if the user's profile is visible in
	// the Google Workspace global address list when the contact sharing feature is
	// enabled for the domain. For more information about excluding user profiles,
	// see the administration help center
	// (https://support.google.com/a/answer/1285988).
	IncludeInGlobalAddressList bool `json:"includeInGlobalAddressList,omitempty"`
	// IpWhitelisted: If `true`, the user's IP address is subject to a deprecated
	// IP address `allowlist` (https://support.google.com/a/answer/60752)
	// configuration.
	IpWhitelisted bool `json:"ipWhitelisted,omitempty"`
	// IsAdmin: Output only. Indicates a user with super admininistrator
	// privileges. The `isAdmin` property can only be edited in the Make a user an
	// administrator (/admin-sdk/directory/v1/guides/manage-users.html#make_admin)
	// operation ( makeAdmin
	// (/admin-sdk/directory/v1/reference/users/makeAdmin.html) method). If edited
	// in the user insert (/admin-sdk/directory/v1/reference/users/insert.html) or
	// update (/admin-sdk/directory/v1/reference/users/update.html) methods, the
	// edit is ignored by the API service.
	IsAdmin bool `json:"isAdmin,omitempty"`
	// IsDelegatedAdmin: Output only. Indicates if the user is a delegated
	// administrator. Delegated administrators are supported by the API but cannot
	// create or undelete users, or make users administrators. These requests are
	// ignored by the API service. Roles and privileges for administrators are
	// assigned using the Admin console
	// (https://support.google.com/a/answer/33325).
	IsDelegatedAdmin bool `json:"isDelegatedAdmin,omitempty"`
	// IsEnforcedIn2Sv: Output only. Is 2-step verification enforced (Read-only)
	IsEnforcedIn2Sv bool `json:"isEnforcedIn2Sv,omitempty"`
	// IsEnrolledIn2Sv: Output only. Is enrolled in 2-step verification (Read-only)
	IsEnrolledIn2Sv bool `json:"isEnrolledIn2Sv,omitempty"`
	// IsMailboxSetup: Output only. Indicates if the user's Google mailbox is
	// created. This property is only applicable if the user has been assigned a
	// Gmail license.
	IsMailboxSetup bool `json:"isMailboxSetup,omitempty"`
	// Keywords: The list of the user's keywords. The maximum allowed data size for
	// this field is 1KB.
	Keywords interface{} `json:"keywords,omitempty"`
	// Kind: Output only. The type of the API resource. For Users resources, the
	// value is `admin#directory#user`.
	Kind string `json:"kind,omitempty"`
	// Languages: The user's languages. The maximum allowed data size for this
	// field is 1KB.
	Languages interface{} `json:"languages,omitempty"`
	// LastLoginTime: User's last login time. (Read-only)
	LastLoginTime string `json:"lastLoginTime,omitempty"`
	// Locations: The user's locations. The maximum allowed data size for this
	// field is 10KB.
	Locations interface{} `json:"locations,omitempty"`
	// Name: Holds the given and family names of the user, and the read-only
	// `fullName` value. The maximum number of characters in the `givenName` and in
	// the `familyName` values is 60. In addition, name values support
	// unicode/UTF-8 characters, and can contain spaces, letters (a-z), numbers
	// (0-9), dashes (-), forward slashes (/), and periods (.). For more
	// information about character usage rules, see the administration help center
	// (https://support.google.com/a/answer/9193374). Maximum allowed data size for
	// this field is 1KB.
	Name *UserName `json:"name,omitempty"`
	// NonEditableAliases: Output only. The list of the user's non-editable alias
	// email addresses. These are typically outside the account's primary domain or
	// sub-domain.
	NonEditableAliases []string `json:"nonEditableAliases,omitempty"`
	// Notes: Notes for the user.
	Notes interface{} `json:"notes,omitempty"`
	// OrgUnitPath: The full path of the parent organization associated with the
	// user. If the parent organization is the top-level, it is represented as a
	// forward slash (`/`).
	OrgUnitPath string `json:"orgUnitPath,omitempty"`
	// Organizations: The list of organizations the user belongs to. The maximum
	// allowed data size for this field is 10KB.
	Organizations interface{} `json:"organizations,omitempty"`
	// Password: User's password
	Password string `json:"password,omitempty"`
	// Phones: The list of the user's phone numbers. The maximum allowed data size
	// for this field is 1KB.
	Phones interface{} `json:"phones,omitempty"`
	// PosixAccounts: The list of POSIX
	// (https://www.opengroup.org/austin/papers/posix_faq.html) account information
	// for the user.
	PosixAccounts interface{} `json:"posixAccounts,omitempty"`
	// PrimaryEmail: The user's primary email address. This property is required in
	// a request to create a user account. The `primaryEmail` must be unique and
	// cannot be an alias of another user.
	PrimaryEmail string `json:"primaryEmail,omitempty"`
	// RecoveryEmail: Recovery email of the user.
	RecoveryEmail string `json:"recoveryEmail,omitempty"`
	// RecoveryPhone: Recovery phone of the user. The phone number must be in the
	// E.164 format, starting with the plus sign (+). Example: *+16506661212*.
	RecoveryPhone string `json:"recoveryPhone,omitempty"`
	// Relations: The list of the user's relationships to other users. The maximum
	// allowed data size for this field is 2KB.
	Relations interface{} `json:"relations,omitempty"`
	// SshPublicKeys: A list of SSH public keys.
	SshPublicKeys interface{} `json:"sshPublicKeys,omitempty"`
	// Suspended: Indicates if user is suspended.
	Suspended bool `json:"suspended,omitempty"`
	// SuspensionReason: Output only. Has the reason a user account is suspended
	// either by the administrator or by Google at the time of suspension. The
	// property is returned only if the `suspended` property is `true`.
	SuspensionReason string `json:"suspensionReason,omitempty"`
	// ThumbnailPhotoEtag: Output only. ETag of the user's photo (Read-only)
	ThumbnailPhotoEtag string `json:"thumbnailPhotoEtag,omitempty"`
	// ThumbnailPhotoUrl: Output only. The URL of the user's profile photo. The URL
	// might be temporary or private.
	ThumbnailPhotoUrl string `json:"thumbnailPhotoUrl,omitempty"`
	// Websites: The user's websites. The maximum allowed data size for this field
	// is 2KB.
	Websites interface{} `json:"websites,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Addresses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Addresses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s User) MarshalJSON() ([]byte, error) {
	type NoMethod User
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserAbout: JSON template for About (notes) of a user in Directory API.
type UserAbout struct {
	// ContentType: About entry can have a type which indicates the content type.
	// It can either be plain or html. By default, notes contents are assumed to
	// contain plain text.
	ContentType string `json:"contentType,omitempty"`
	// Value: Actual value of notes.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserAbout) MarshalJSON() ([]byte, error) {
	type NoMethod UserAbout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserAddress: JSON template for address.
type UserAddress struct {
	// Country: Country.
	Country string `json:"country,omitempty"`
	// CountryCode: Country code.
	CountryCode string `json:"countryCode,omitempty"`
	// CustomType: Custom type.
	CustomType string `json:"customType,omitempty"`
	// ExtendedAddress: Extended Address.
	ExtendedAddress string `json:"extendedAddress,omitempty"`
	// Formatted: Formatted address.
	Formatted string `json:"formatted,omitempty"`
	// Locality: Locality.
	Locality string `json:"locality,omitempty"`
	// PoBox: Other parts of address.
	PoBox string `json:"poBox,omitempty"`
	// PostalCode: Postal code.
	PostalCode string `json:"postalCode,omitempty"`
	// Primary: If this is user's primary address. Only one entry could be marked
	// as primary.
	Primary bool `json:"primary,omitempty"`
	// Region: Region.
	Region string `json:"region,omitempty"`
	// SourceIsStructured: User supplied address was structured. Structured
	// addresses are NOT supported at this time. You might be able to write
	// structured addresses but any values will eventually be clobbered.
	SourceIsStructured bool `json:"sourceIsStructured,omitempty"`
	// StreetAddress: Street.
	StreetAddress string `json:"streetAddress,omitempty"`
	// Type: Each entry can have a type which indicates standard values of that
	// entry. For example address could be of home work etc. In addition to the
	// standard type an entry can have a custom type and can take any value. Such
	// type should have the CUSTOM value as type and also have a customType value.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Country") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Country") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserAddress) MarshalJSON() ([]byte, error) {
	type NoMethod UserAddress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserAlias: The Directory API manages aliases, which are alternative email
// addresses.
type UserAlias struct {
	// Alias: The alias email address.
	Alias string `json:"alias,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Id: The unique ID for the user.
	Id string `json:"id,omitempty"`
	// Kind: The type of the API resource. For Alias resources, the value is
	// `admin#directory#alias`.
	Kind string `json:"kind,omitempty"`
	// PrimaryEmail: The user's primary email address.
	PrimaryEmail string `json:"primaryEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserAlias) MarshalJSON() ([]byte, error) {
	type NoMethod UserAlias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserEmail: JSON template for an email.
type UserEmail struct {
	// Address: Email id of the user.
	Address string `json:"address,omitempty"`
	// CustomType: Custom Type.
	CustomType string `json:"customType,omitempty"`
	// Primary: If this is user's primary email. Only one entry could be marked as
	// primary.
	Primary bool `json:"primary,omitempty"`
	// PublicKeyEncryptionCertificates: Public Key Encryption Certificates. Current
	// limit: 1 per email address, and 5 per user.
	PublicKeyEncryptionCertificates *UserEmailPublicKeyEncryptionCertificates `json:"public_key_encryption_certificates,omitempty"`
	// Type: Each entry can have a type which indicates standard types of that
	// entry. For example email could be of home, work etc. In addition to the
	// standard type, an entry can have a custom type and can take any value Such
	// types should have the CUSTOM value as type and also have a customType value.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserEmail) MarshalJSON() ([]byte, error) {
	type NoMethod UserEmail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserEmailPublicKeyEncryptionCertificates: Public Key Encryption
// Certificates. Current limit: 1 per email address, and 5 per user.
type UserEmailPublicKeyEncryptionCertificates struct {
	// Certificate: X.509 encryption certificate in `PEM` format. Must only be an
	// end-entity (leaf) certificate.
	Certificate string `json:"certificate,omitempty"`
	// IsDefault: Whether this is the default certificate for the given email
	// address.
	IsDefault bool `json:"is_default,omitempty"`
	// State: Denotes the certificate's state in its lifecycle. Possible values are
	// `not_yet_validated`, `valid`, `invalid`, `expired`, and `revoked`.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Certificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Certificate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserEmailPublicKeyEncryptionCertificates) MarshalJSON() ([]byte, error) {
	type NoMethod UserEmailPublicKeyEncryptionCertificates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserExternalId: JSON template for an externalId entry.
type UserExternalId struct {
	// CustomType: Custom type.
	CustomType string `json:"customType,omitempty"`
	// Type: The type of the Id.
	Type string `json:"type,omitempty"`
	// Value: The value of the id.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserExternalId) MarshalJSON() ([]byte, error) {
	type NoMethod UserExternalId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UserGender struct {
	// AddressMeAs: AddressMeAs. A human-readable string containing the proper way
	// to refer to the profile owner by humans for example he/him/his or
	// they/them/their.
	AddressMeAs string `json:"addressMeAs,omitempty"`
	// CustomGender: Custom gender.
	CustomGender string `json:"customGender,omitempty"`
	// Type: Gender.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddressMeAs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddressMeAs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserGender) MarshalJSON() ([]byte, error) {
	type NoMethod UserGender
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserIm: JSON template for instant messenger of an user.
type UserIm struct {
	// CustomProtocol: Custom protocol.
	CustomProtocol string `json:"customProtocol,omitempty"`
	// CustomType: Custom type.
	CustomType string `json:"customType,omitempty"`
	// Im: Instant messenger id.
	Im string `json:"im,omitempty"`
	// Primary: If this is user's primary im. Only one entry could be marked as
	// primary.
	Primary bool `json:"primary,omitempty"`
	// Protocol: Protocol used in the instant messenger. It should be one of the
	// values from ImProtocolTypes map. Similar to type it can take a CUSTOM value
	// and specify the custom name in customProtocol field.
	Protocol string `json:"protocol,omitempty"`
	// Type: Each entry can have a type which indicates standard types of that
	// entry. For example instant messengers could be of home work etc. In addition
	// to the standard type an entry can have a custom type and can take any value.
	// Such types should have the CUSTOM value as type and also have a customType
	// value.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomProtocol") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomProtocol") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserIm) MarshalJSON() ([]byte, error) {
	type NoMethod UserIm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserKeyword: JSON template for a keyword entry.
type UserKeyword struct {
	// CustomType: Custom Type.
	CustomType string `json:"customType,omitempty"`
	// Type: Each entry can have a type which indicates standard type of that
	// entry. For example keyword could be of type occupation or outlook. In
	// addition to the standard type an entry can have a custom type and can give
	// it any name. Such types should have the CUSTOM value as type and also have a
	// customType value.
	Type string `json:"type,omitempty"`
	// Value: Keyword.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserKeyword) MarshalJSON() ([]byte, error) {
	type NoMethod UserKeyword
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserLanguage: JSON template for a language entry.
type UserLanguage struct {
	// CustomLanguage: Other language. User can provide their own language name if
	// there is no corresponding ISO 639 language code. If this is set,
	// `languageCode` can't be set.
	CustomLanguage string `json:"customLanguage,omitempty"`
	// LanguageCode: ISO 639 string representation of a language. See Language
	// Codes (/admin-sdk/directory/v1/languages) for the list of supported codes.
	// Valid language codes outside the supported set will be accepted by the API
	// but may lead to unexpected behavior. Illegal values cause `SchemaException`.
	// If this is set, `customLanguage` can't be set.
	LanguageCode string `json:"languageCode,omitempty"`
	// Preference: Optional. If present, controls whether the specified
	// `languageCode` is the user's preferred language. If `customLanguage` is set,
	// this can't be set. Allowed values are `preferred` and `not_preferred`.
	Preference string `json:"preference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod UserLanguage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserLocation: JSON template for a location entry.
type UserLocation struct {
	// Area: Textual location. This is most useful for display purposes to
	// concisely describe the location. For example 'Mountain View, CA', 'Near
	// Seattle', 'US-NYC-9TH 9A209A.''
	Area string `json:"area,omitempty"`
	// BuildingId: Building Identifier.
	BuildingId string `json:"buildingId,omitempty"`
	// CustomType: Custom Type.
	CustomType string `json:"customType,omitempty"`
	// DeskCode: Most specific textual code of individual desk location.
	DeskCode string `json:"deskCode,omitempty"`
	// FloorName: Floor name/number.
	FloorName string `json:"floorName,omitempty"`
	// FloorSection: Floor section. More specific location within the floor. For
	// example if a floor is divided into sections 'A', 'B' and 'C' this field
	// would identify one of those values.
	FloorSection string `json:"floorSection,omitempty"`
	// Type: Each entry can have a type which indicates standard types of that
	// entry. For example location could be of types default and desk. In addition
	// to standard type an entry can have a custom type and can give it any name.
	// Such types should have 'custom' as type and also have a customType value.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Area") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Area") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserLocation) MarshalJSON() ([]byte, error) {
	type NoMethod UserLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UserMakeAdmin struct {
	// Status: Indicates the administrator status of the user.
	Status bool `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserMakeAdmin) MarshalJSON() ([]byte, error) {
	type NoMethod UserMakeAdmin
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UserName struct {
	// DisplayName: The user's display name. Limit: 256 characters.
	DisplayName string `json:"displayName,omitempty"`
	// FamilyName: The user's last name. Required when creating a user account.
	FamilyName string `json:"familyName,omitempty"`
	// FullName: The user's full name formed by concatenating the first and last
	// name values.
	FullName string `json:"fullName,omitempty"`
	// GivenName: The user's first name. Required when creating a user account.
	GivenName string `json:"givenName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserName) MarshalJSON() ([]byte, error) {
	type NoMethod UserName
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserOrganization: JSON template for an organization entry.
type UserOrganization struct {
	// CostCenter: The cost center of the users department.
	CostCenter string `json:"costCenter,omitempty"`
	// CustomType: Custom type.
	CustomType string `json:"customType,omitempty"`
	// Department: Department within the organization.
	Department string `json:"department,omitempty"`
	// Description: Description of the organization.
	Description string `json:"description,omitempty"`
	// Domain: The domain to which the organization belongs to.
	Domain string `json:"domain,omitempty"`
	// FullTimeEquivalent: The full-time equivalent millipercent within the
	// organization (100000 = 100%).
	FullTimeEquivalent int64 `json:"fullTimeEquivalent,omitempty"`
	// Location: Location of the organization. This need not be fully qualified
	// address.
	Location string `json:"location,omitempty"`
	// Name: Name of the organization
	Name string `json:"name,omitempty"`
	// Primary: If it user's primary organization.
	Primary bool `json:"primary,omitempty"`
	// Symbol: Symbol of the organization.
	Symbol string `json:"symbol,omitempty"`
	// Title: Title (designation) of the user in the organization.
	Title string `json:"title,omitempty"`
	// Type: Each entry can have a type which indicates standard types of that
	// entry. For example organization could be of school work etc. In addition to
	// the standard type an entry can have a custom type and can give it any name.
	// Such types should have the CUSTOM value as type and also have a CustomType
	// value.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CostCenter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CostCenter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserOrganization) MarshalJSON() ([]byte, error) {
	type NoMethod UserOrganization
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserPhone: JSON template for a phone entry.
type UserPhone struct {
	// CustomType: Custom Type.
	CustomType string `json:"customType,omitempty"`
	// Primary: If this is user's primary phone or not.
	Primary bool `json:"primary,omitempty"`
	// Type: Each entry can have a type which indicates standard types of that
	// entry. For example phone could be of home_fax work mobile etc. In addition
	// to the standard type an entry can have a custom type and can give it any
	// name. Such types should have the CUSTOM value as type and also have a
	// customType value.
	Type string `json:"type,omitempty"`
	// Value: Phone number.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserPhone) MarshalJSON() ([]byte, error) {
	type NoMethod UserPhone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UserPhoto struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Height: Height of the photo in pixels.
	Height int64 `json:"height,omitempty"`
	// Id: The ID the API uses to uniquely identify the user.
	Id string `json:"id,omitempty"`
	// Kind: The type of the API resource. For Photo resources, this is
	// `admin#directory#user#photo`.
	Kind string `json:"kind,omitempty"`
	// MimeType: The MIME type of the photo. Allowed values are `JPEG`, `PNG`,
	// `GIF`, `BMP`, `TIFF`, and web-safe base64 encoding.
	MimeType string `json:"mimeType,omitempty"`
	// PhotoData: The user photo's upload data in web-safe Base64
	// (https://en.wikipedia.org/wiki/Base64#URL_applications) format in bytes.
	// This means: * The slash (/) character is replaced with the underscore (_)
	// character. * The plus sign (+) character is replaced with the hyphen (-)
	// character. * The equals sign (=) character is replaced with the asterisk
	// (*). * For padding, the period (.) character is used instead of the RFC-4648
	// baseURL definition which uses the equals sign (=) for padding. This is done
	// to simplify URL-parsing. * Whatever the size of the photo being uploaded,
	// the API downsizes it to 96x96 pixels.
	PhotoData string `json:"photoData,omitempty"`
	// PrimaryEmail: The user's primary email address.
	PrimaryEmail string `json:"primaryEmail,omitempty"`
	// Width: Width of the photo in pixels.
	Width int64 `json:"width,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserPhoto) MarshalJSON() ([]byte, error) {
	type NoMethod UserPhoto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserPosixAccount: JSON template for a POSIX account entry.
type UserPosixAccount struct {
	// AccountId: A POSIX account field identifier.
	AccountId string `json:"accountId,omitempty"`
	// Gecos: The GECOS (user information) for this account.
	Gecos string `json:"gecos,omitempty"`
	// Gid: The default group ID.
	Gid uint64 `json:"gid,omitempty,string"`
	// HomeDirectory: The path to the home directory for this account.
	HomeDirectory string `json:"homeDirectory,omitempty"`
	// OperatingSystemType: The operating system type for this account.
	OperatingSystemType string `json:"operatingSystemType,omitempty"`
	// Primary: If this is user's primary account within the SystemId.
	Primary bool `json:"primary,omitempty"`
	// Shell: The path to the login shell for this account.
	Shell string `json:"shell,omitempty"`
	// SystemId: System identifier for which account Username or Uid apply to.
	SystemId string `json:"systemId,omitempty"`
	// Uid: The POSIX compliant user ID.
	Uid uint64 `json:"uid,omitempty,string"`
	// Username: The username of the account.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserPosixAccount) MarshalJSON() ([]byte, error) {
	type NoMethod UserPosixAccount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserRelation: JSON template for a relation entry.
type UserRelation struct {
	// CustomType: Custom Type.
	CustomType string `json:"customType,omitempty"`
	// Type: The relation of the user. Some of the possible values are mother
	// father sister brother manager assistant partner.
	Type string `json:"type,omitempty"`
	// Value: The name of the relation.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserRelation) MarshalJSON() ([]byte, error) {
	type NoMethod UserRelation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserSshPublicKey: JSON template for a POSIX account entry.
type UserSshPublicKey struct {
	// ExpirationTimeUsec: An expiration time in microseconds since epoch.
	ExpirationTimeUsec int64 `json:"expirationTimeUsec,omitempty,string"`
	// Fingerprint: A SHA-256 fingerprint of the SSH public key. (Read-only)
	Fingerprint string `json:"fingerprint,omitempty"`
	// Key: An SSH public key.
	Key string `json:"key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpirationTimeUsec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpirationTimeUsec") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserSshPublicKey) MarshalJSON() ([]byte, error) {
	type NoMethod UserSshPublicKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UserUndelete struct {
	// OrgUnitPath: OrgUnit of User
	OrgUnitPath string `json:"orgUnitPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OrgUnitPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OrgUnitPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserUndelete) MarshalJSON() ([]byte, error) {
	type NoMethod UserUndelete
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserWebsite: JSON template for a website entry.
type UserWebsite struct {
	// CustomType: Custom Type.
	CustomType string `json:"customType,omitempty"`
	// Primary: If this is user's primary website or not.
	Primary bool `json:"primary,omitempty"`
	// Type: Each entry can have a type which indicates standard types of that
	// entry. For example website could be of home work blog etc. In addition to
	// the standard type an entry can have a custom type and can give it any name.
	// Such types should have the CUSTOM value as type and also have a customType
	// value.
	Type string `json:"type,omitempty"`
	// Value: Website.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserWebsite) MarshalJSON() ([]byte, error) {
	type NoMethod UserWebsite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Users struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: Kind of resource this is.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Token used to access next page of this result.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TriggerEvent: Event that triggered this response (only used in case of Push
	// Response)
	TriggerEvent string `json:"trigger_event,omitempty"`
	// Users: A list of user objects.
	Users []*User `json:"users,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Users) MarshalJSON() ([]byte, error) {
	type NoMethod Users
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerificationCode: The Directory API allows you to view, generate, and
// invalidate backup verification codes for a user.
type VerificationCode struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of the resource. This is always
	// `admin#directory#verificationCode`.
	Kind string `json:"kind,omitempty"`
	// UserId: The obfuscated unique ID of the user.
	UserId string `json:"userId,omitempty"`
	// VerificationCode: A current verification code for the user. Invalidated or
	// used verification codes are not returned as part of the result.
	VerificationCode string `json:"verificationCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerificationCode) MarshalJSON() ([]byte, error) {
	type NoMethod VerificationCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerificationCodes: JSON response template for list verification codes
// operation in Directory API.
type VerificationCodes struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: A list of verification code resources.
	Items []*VerificationCode `json:"items,omitempty"`
	// Kind: The type of the resource. This is always
	// `admin#directory#verificationCodesList`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerificationCodes) MarshalJSON() ([]byte, error) {
	type NoMethod VerificationCodes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AspsDeleteCall struct {
	s          *Service
	userKey    string
	codeId     int64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an ASP issued by a user.
//
//   - codeId: The unique ID of the ASP to be deleted.
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *AspsService) Delete(userKey string, codeId int64) *AspsDeleteCall {
	c := &AspsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.codeId = codeId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AspsDeleteCall) Fields(s ...googleapi.Field) *AspsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AspsDeleteCall) Context(ctx context.Context) *AspsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AspsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AspsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/asps/{codeId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
		"codeId":  strconv.FormatInt(c.codeId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.asps.delete" call.
func (c *AspsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type AspsGetCall struct {
	s            *Service
	userKey      string
	codeId       int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about an ASP issued by a user.
//
//   - codeId: The unique ID of the ASP.
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *AspsService) Get(userKey string, codeId int64) *AspsGetCall {
	c := &AspsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.codeId = codeId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AspsGetCall) Fields(s ...googleapi.Field) *AspsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AspsGetCall) IfNoneMatch(entityTag string) *AspsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AspsGetCall) Context(ctx context.Context) *AspsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AspsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AspsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/asps/{codeId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
		"codeId":  strconv.FormatInt(c.codeId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.asps.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Asp.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AspsGetCall) Do(opts ...googleapi.CallOption) (*Asp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Asp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AspsListCall struct {
	s            *Service
	userKey      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the ASPs issued by a user.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *AspsService) List(userKey string) *AspsListCall {
	c := &AspsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AspsListCall) Fields(s ...googleapi.Field) *AspsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AspsListCall) IfNoneMatch(entityTag string) *AspsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AspsListCall) Context(ctx context.Context) *AspsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AspsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AspsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/asps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.asps.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Asps.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AspsListCall) Do(opts ...googleapi.CallOption) (*Asps, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Asps{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ChannelsStopCall struct {
	s          *Service
	channel    *Channel
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Stop: Stops watching resources through this channel.
func (r *ChannelsService) Stop(channel *Channel) *ChannelsStopCall {
	c := &ChannelsStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.channel = channel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChannelsStopCall) Fields(s ...googleapi.Field) *ChannelsStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChannelsStopCall) Context(ctx context.Context) *ChannelsStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChannelsStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChannelsStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.channel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory_v1/channels/stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.channels.stop" call.
func (c *ChannelsStopCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type ChromeosdevicesActionCall struct {
	s                    *Service
	customerId           string
	resourceId           string
	chromeosdeviceaction *ChromeOsDeviceAction
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Action: Use BatchChangeChromeOsDeviceStatus
// (/admin-sdk/directory/reference/rest/v1/customer.devices.chromeos/batchChange
// Status) instead. Takes an action that affects a Chrome OS Device. This
// includes deprovisioning, disabling, and re-enabling devices. *Warning:* *
// Deprovisioning a device will stop device policy syncing and remove
// device-level printers. After a device is deprovisioned, it must be wiped
// before it can be re-enrolled. * Lost or stolen devices should use the
// disable action. * Re-enabling a disabled device will consume a device
// license. If you do not have sufficient licenses available when completing
// the re-enable action, you will receive an error. For more information about
// deprovisioning and disabling devices, visit the help center
// (https://support.google.com/chrome/a/answer/3523633).
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - resourceId: The unique ID of the device. The `resourceId`s are returned in
//     the response from the chromeosdevices.list
//     (/admin-sdk/directory/v1/reference/chromeosdevices/list) method.
func (r *ChromeosdevicesService) Action(customerId string, resourceId string, chromeosdeviceaction *ChromeOsDeviceAction) *ChromeosdevicesActionCall {
	c := &ChromeosdevicesActionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.resourceId = resourceId
	c.chromeosdeviceaction = chromeosdeviceaction
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChromeosdevicesActionCall) Fields(s ...googleapi.Field) *ChromeosdevicesActionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChromeosdevicesActionCall) Context(ctx context.Context) *ChromeosdevicesActionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChromeosdevicesActionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChromeosdevicesActionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.chromeosdeviceaction)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos/{resourceId}/action")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.chromeosdevices.action" call.
func (c *ChromeosdevicesActionCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type ChromeosdevicesGetCall struct {
	s            *Service
	customerId   string
	deviceId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a Chrome OS device's properties.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - deviceId: The unique ID of the device. The `deviceId`s are returned in the
//     response from the chromeosdevices.list
//     (/admin-sdk/directory/v1/reference/chromeosdevices/list) method.
func (r *ChromeosdevicesService) Get(customerId string, deviceId string) *ChromeosdevicesGetCall {
	c := &ChromeosdevicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.deviceId = deviceId
	return c
}

// Projection sets the optional parameter "projection": Determines whether the
// response contains the full list of properties or only a subset.
//
// Possible values:
//
//	"BASIC" - Includes only the basic metadata fields (e.g., deviceId,
//
// serialNumber, status, and user)
//
//	"FULL" - Includes all metadata fields
func (c *ChromeosdevicesGetCall) Projection(projection string) *ChromeosdevicesGetCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChromeosdevicesGetCall) Fields(s ...googleapi.Field) *ChromeosdevicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ChromeosdevicesGetCall) IfNoneMatch(entityTag string) *ChromeosdevicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChromeosdevicesGetCall) Context(ctx context.Context) *ChromeosdevicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChromeosdevicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChromeosdevicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"deviceId":   c.deviceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.chromeosdevices.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ChromeOsDevice.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ChromeosdevicesGetCall) Do(opts ...googleapi.CallOption) (*ChromeOsDevice, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ChromeOsDevice{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ChromeosdevicesListCall struct {
	s            *Service
	customerId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a paginated list of Chrome OS devices within an account.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
func (r *ChromeosdevicesService) List(customerId string) *ChromeosdevicesListCall {
	c := &ChromeosdevicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	return c
}

// IncludeChildOrgunits sets the optional parameter "includeChildOrgunits":
// Return devices from all child orgunits, as well as the specified org unit.
// If this is set to true, 'orgUnitPath' must be provided.
func (c *ChromeosdevicesListCall) IncludeChildOrgunits(includeChildOrgunits bool) *ChromeosdevicesListCall {
	c.urlParams_.Set("includeChildOrgunits", fmt.Sprint(includeChildOrgunits))
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return. Value should not exceed 300.
func (c *ChromeosdevicesListCall) MaxResults(maxResults int64) *ChromeosdevicesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Device property to use for
// sorting results.
//
// Possible values:
//
//	"annotatedLocation" - Chrome device location as annotated by the
//
// administrator.
//
//	"annotatedUser" - Chromebook user as annotated by administrator.
//	"lastSync" - The date and time the Chrome device was last synchronized
//
// with the policy settings in the Admin console.
//
//	"notes" - Chrome device notes as annotated by the administrator.
//	"serialNumber" - The Chrome device serial number entered when the device
//
// was enabled.
//
//	"status" - Chrome device status. For more information, see the <a
//
// [chromeosdevices](/admin-sdk/directory/v1/reference/chromeosdevices.html).
func (c *ChromeosdevicesListCall) OrderBy(orderBy string) *ChromeosdevicesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitPath sets the optional parameter "orgUnitPath": The full path of the
// organizational unit (minus the leading `/`) or its unique ID.
func (c *ChromeosdevicesListCall) OrgUnitPath(orgUnitPath string) *ChromeosdevicesListCall {
	c.urlParams_.Set("orgUnitPath", orgUnitPath)
	return c
}

// PageToken sets the optional parameter "pageToken": The `pageToken` query
// parameter is used to request the next page of query results. The follow-on
// request's `pageToken` query parameter is the `nextPageToken` from your
// previous response.
func (c *ChromeosdevicesListCall) PageToken(pageToken string) *ChromeosdevicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Projection sets the optional parameter "projection": Determines whether the
// response contains the full list of properties or only a subset.
//
// Possible values:
//
//	"BASIC" - Includes only the basic metadata fields (e.g., deviceId,
//
// serialNumber, status, and user)
//
//	"FULL" - Includes all metadata fields
func (c *ChromeosdevicesListCall) Projection(projection string) *ChromeosdevicesListCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Query sets the optional parameter "query": Search string in the format given
// at https://developers.google.com/admin-sdk/directory/v1/list-query-operators
func (c *ChromeosdevicesListCall) Query(query string) *ChromeosdevicesListCall {
	c.urlParams_.Set("query", query)
	return c
}

// SortOrder sets the optional parameter "sortOrder": Whether to return results
// in ascending or descending order. Must be used with the `orderBy` parameter.
//
// Possible values:
//
//	"ASCENDING" - Ascending order.
//	"DESCENDING" - Descending order.
func (c *ChromeosdevicesListCall) SortOrder(sortOrder string) *ChromeosdevicesListCall {
	c.urlParams_.Set("sortOrder", sortOrder)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChromeosdevicesListCall) Fields(s ...googleapi.Field) *ChromeosdevicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ChromeosdevicesListCall) IfNoneMatch(entityTag string) *ChromeosdevicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChromeosdevicesListCall) Context(ctx context.Context) *ChromeosdevicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChromeosdevicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChromeosdevicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.chromeosdevices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ChromeOsDevices.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ChromeosdevicesListCall) Do(opts ...googleapi.CallOption) (*ChromeOsDevices, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ChromeOsDevices{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ChromeosdevicesListCall) Pages(ctx context.Context, f func(*ChromeOsDevices) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ChromeosdevicesMoveDevicesToOuCall struct {
	s                       *Service
	customerId              string
	chromeosmovedevicestoou *ChromeOsMoveDevicesToOu
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// MoveDevicesToOu: Moves or inserts multiple Chrome OS devices to an
// organizational unit. You can move up to 50 devices at once.
//
// - customerId: Immutable. ID of the Google Workspace account.
// - orgUnitPath: Full path of the target organizational unit or its ID.
func (r *ChromeosdevicesService) MoveDevicesToOu(customerId string, orgUnitPath string, chromeosmovedevicestoou *ChromeOsMoveDevicesToOu) *ChromeosdevicesMoveDevicesToOuCall {
	c := &ChromeosdevicesMoveDevicesToOuCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.urlParams_.Set("orgUnitPath", orgUnitPath)
	c.chromeosmovedevicestoou = chromeosmovedevicestoou
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChromeosdevicesMoveDevicesToOuCall) Fields(s ...googleapi.Field) *ChromeosdevicesMoveDevicesToOuCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChromeosdevicesMoveDevicesToOuCall) Context(ctx context.Context) *ChromeosdevicesMoveDevicesToOuCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChromeosdevicesMoveDevicesToOuCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChromeosdevicesMoveDevicesToOuCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.chromeosmovedevicestoou)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos/moveDevicesToOu")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.chromeosdevices.moveDevicesToOu" call.
func (c *ChromeosdevicesMoveDevicesToOuCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type ChromeosdevicesPatchCall struct {
	s              *Service
	customerId     string
	deviceId       string
	chromeosdevice *ChromeOsDevice
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Updates a device's updatable properties, such as `annotatedUser`,
// `annotatedLocation`, `notes`, `orgUnitPath`, or `annotatedAssetId`. This
// method supports patch semantics
// (/admin-sdk/directory/v1/guides/performance#patch).
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - deviceId: The unique ID of the device. The `deviceId`s are returned in the
//     response from the chromeosdevices.list
//     (/admin-sdk/v1/reference/chromeosdevices/list) method.
func (r *ChromeosdevicesService) Patch(customerId string, deviceId string, chromeosdevice *ChromeOsDevice) *ChromeosdevicesPatchCall {
	c := &ChromeosdevicesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.deviceId = deviceId
	c.chromeosdevice = chromeosdevice
	return c
}

// Projection sets the optional parameter "projection": Determines whether the
// response contains the full list of properties or only a subset.
//
// Possible values:
//
//	"BASIC" - Includes only the basic metadata fields (e.g., deviceId,
//
// serialNumber, status, and user)
//
//	"FULL" - Includes all metadata fields
func (c *ChromeosdevicesPatchCall) Projection(projection string) *ChromeosdevicesPatchCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChromeosdevicesPatchCall) Fields(s ...googleapi.Field) *ChromeosdevicesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChromeosdevicesPatchCall) Context(ctx context.Context) *ChromeosdevicesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChromeosdevicesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChromeosdevicesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.chromeosdevice)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"deviceId":   c.deviceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.chromeosdevices.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *ChromeOsDevice.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ChromeosdevicesPatchCall) Do(opts ...googleapi.CallOption) (*ChromeOsDevice, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ChromeOsDevice{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ChromeosdevicesUpdateCall struct {
	s              *Service
	customerId     string
	deviceId       string
	chromeosdevice *ChromeOsDevice
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Update: Updates a device's updatable properties, such as `annotatedUser`,
// `annotatedLocation`, `notes`, `orgUnitPath`, or `annotatedAssetId`.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - deviceId: The unique ID of the device. The `deviceId`s are returned in the
//     response from the chromeosdevices.list
//     (/admin-sdk/v1/reference/chromeosdevices/list) method.
func (r *ChromeosdevicesService) Update(customerId string, deviceId string, chromeosdevice *ChromeOsDevice) *ChromeosdevicesUpdateCall {
	c := &ChromeosdevicesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.deviceId = deviceId
	c.chromeosdevice = chromeosdevice
	return c
}

// Projection sets the optional parameter "projection": Determines whether the
// response contains the full list of properties or only a subset.
//
// Possible values:
//
//	"BASIC" - Includes only the basic metadata fields (e.g., deviceId,
//
// serialNumber, status, and user)
//
//	"FULL" - Includes all metadata fields
func (c *ChromeosdevicesUpdateCall) Projection(projection string) *ChromeosdevicesUpdateCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChromeosdevicesUpdateCall) Fields(s ...googleapi.Field) *ChromeosdevicesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChromeosdevicesUpdateCall) Context(ctx context.Context) *ChromeosdevicesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChromeosdevicesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChromeosdevicesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.chromeosdevice)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"deviceId":   c.deviceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.chromeosdevices.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *ChromeOsDevice.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ChromeosdevicesUpdateCall) Do(opts ...googleapi.CallOption) (*ChromeOsDevice, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ChromeOsDevice{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomerDevicesChromeosBatchChangeStatusCall struct {
	s                                      *Service
	customerId                             string
	batchchangechromeosdevicestatusrequest *BatchChangeChromeOsDeviceStatusRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// BatchChangeStatus: Changes the status of a batch of ChromeOS devices. For
// more information about changing a ChromeOS device state Repair, repurpose,
// or retire ChromeOS devices
// (https://support.google.com/chrome/a/answer/3523633).
//
// - customerId: Immutable ID of the Google Workspace account.
func (r *CustomerDevicesChromeosService) BatchChangeStatus(customerId string, batchchangechromeosdevicestatusrequest *BatchChangeChromeOsDeviceStatusRequest) *CustomerDevicesChromeosBatchChangeStatusCall {
	c := &CustomerDevicesChromeosBatchChangeStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.batchchangechromeosdevicestatusrequest = batchchangechromeosdevicestatusrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomerDevicesChromeosBatchChangeStatusCall) Fields(s ...googleapi.Field) *CustomerDevicesChromeosBatchChangeStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomerDevicesChromeosBatchChangeStatusCall) Context(ctx context.Context) *CustomerDevicesChromeosBatchChangeStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomerDevicesChromeosBatchChangeStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomerDevicesChromeosBatchChangeStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchchangechromeosdevicestatusrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos:batchChangeStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customer.devices.chromeos.batchChangeStatus" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchChangeChromeOsDeviceStatusResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomerDevicesChromeosBatchChangeStatusCall) Do(opts ...googleapi.CallOption) (*BatchChangeChromeOsDeviceStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchChangeChromeOsDeviceStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomerDevicesChromeosIssueCommandCall struct {
	s                                           *Service
	customerId                                  string
	deviceId                                    string
	directorychromeosdevicesissuecommandrequest *DirectoryChromeosdevicesIssueCommandRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// IssueCommand: Issues a command for the device to execute.
//
// - customerId: Immutable. ID of the Google Workspace account.
// - deviceId: Immutable. ID of Chrome OS Device.
func (r *CustomerDevicesChromeosService) IssueCommand(customerId string, deviceId string, directorychromeosdevicesissuecommandrequest *DirectoryChromeosdevicesIssueCommandRequest) *CustomerDevicesChromeosIssueCommandCall {
	c := &CustomerDevicesChromeosIssueCommandCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.deviceId = deviceId
	c.directorychromeosdevicesissuecommandrequest = directorychromeosdevicesissuecommandrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomerDevicesChromeosIssueCommandCall) Fields(s ...googleapi.Field) *CustomerDevicesChromeosIssueCommandCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomerDevicesChromeosIssueCommandCall) Context(ctx context.Context) *CustomerDevicesChromeosIssueCommandCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomerDevicesChromeosIssueCommandCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomerDevicesChromeosIssueCommandCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.directorychromeosdevicesissuecommandrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}:issueCommand")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"deviceId":   c.deviceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customer.devices.chromeos.issueCommand" call.
// Any non-2xx status code is an error. Response headers are in either
// *DirectoryChromeosdevicesIssueCommandResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomerDevicesChromeosIssueCommandCall) Do(opts ...googleapi.CallOption) (*DirectoryChromeosdevicesIssueCommandResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DirectoryChromeosdevicesIssueCommandResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomerDevicesChromeosCommandsGetCall struct {
	s            *Service
	customerId   string
	deviceId     string
	commandId    int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets command data a specific command issued to the device.
//
// - commandId: Immutable. ID of Chrome OS Device Command.
// - customerId: Immutable. ID of the Google Workspace account.
// - deviceId: Immutable. ID of Chrome OS Device.
func (r *CustomerDevicesChromeosCommandsService) Get(customerId string, deviceId string, commandId int64) *CustomerDevicesChromeosCommandsGetCall {
	c := &CustomerDevicesChromeosCommandsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.deviceId = deviceId
	c.commandId = commandId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomerDevicesChromeosCommandsGetCall) Fields(s ...googleapi.Field) *CustomerDevicesChromeosCommandsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomerDevicesChromeosCommandsGetCall) IfNoneMatch(entityTag string) *CustomerDevicesChromeosCommandsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomerDevicesChromeosCommandsGetCall) Context(ctx context.Context) *CustomerDevicesChromeosCommandsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomerDevicesChromeosCommandsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomerDevicesChromeosCommandsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}/commands/{commandId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"deviceId":   c.deviceId,
		"commandId":  strconv.FormatInt(c.commandId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customer.devices.chromeos.commands.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DirectoryChromeosdevicesCommand.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomerDevicesChromeosCommandsGetCall) Do(opts ...googleapi.CallOption) (*DirectoryChromeosdevicesCommand, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DirectoryChromeosdevicesCommand{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersGetCall struct {
	s            *Service
	customerKey  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a customer.
//
// - customerKey: Id of the customer to be retrieved.
func (r *CustomersService) Get(customerKey string) *CustomersGetCall {
	c := &CustomersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerKey = customerKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersGetCall) Fields(s ...googleapi.Field) *CustomersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersGetCall) IfNoneMatch(entityTag string) *CustomersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersGetCall) Context(ctx context.Context) *CustomersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customers/{customerKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerKey": c.customerKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.customers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Customer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersGetCall) Do(opts ...googleapi.CallOption) (*Customer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Customer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersPatchCall struct {
	s           *Service
	customerKey string
	customer    *Customer
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Patches a customer.
//
// - customerKey: Id of the customer to be updated.
func (r *CustomersService) Patch(customerKey string, customer *Customer) *CustomersPatchCall {
	c := &CustomersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerKey = customerKey
	c.customer = customer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersPatchCall) Fields(s ...googleapi.Field) *CustomersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersPatchCall) Context(ctx context.Context) *CustomersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.customer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customers/{customerKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerKey": c.customerKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.customers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Customer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersPatchCall) Do(opts ...googleapi.CallOption) (*Customer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Customer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersUpdateCall struct {
	s           *Service
	customerKey string
	customer    *Customer
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates a customer.
//
// - customerKey: Id of the customer to be updated.
func (r *CustomersService) Update(customerKey string, customer *Customer) *CustomersUpdateCall {
	c := &CustomersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerKey = customerKey
	c.customer = customer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersUpdateCall) Fields(s ...googleapi.Field) *CustomersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersUpdateCall) Context(ctx context.Context) *CustomersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.customer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customers/{customerKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerKey": c.customerKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.customers.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Customer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersUpdateCall) Do(opts ...googleapi.CallOption) (*Customer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Customer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintServersBatchCreatePrintServersCall struct {
	s                              *Service
	parent                         string
	batchcreateprintserversrequest *BatchCreatePrintServersRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// BatchCreatePrintServers: Creates multiple print servers.
//
//   - parent: The unique ID
//     (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers)
//     of the customer's Google Workspace account. Format: `customers/{id}`.
func (r *CustomersChromePrintServersService) BatchCreatePrintServers(parent string, batchcreateprintserversrequest *BatchCreatePrintServersRequest) *CustomersChromePrintServersBatchCreatePrintServersCall {
	c := &CustomersChromePrintServersBatchCreatePrintServersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchcreateprintserversrequest = batchcreateprintserversrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintServersBatchCreatePrintServersCall) Fields(s ...googleapi.Field) *CustomersChromePrintServersBatchCreatePrintServersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintServersBatchCreatePrintServersCall) Context(ctx context.Context) *CustomersChromePrintServersBatchCreatePrintServersCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintServersBatchCreatePrintServersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintServersBatchCreatePrintServersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchcreateprintserversrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printServers:batchCreatePrintServers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printServers.batchCreatePrintServers" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchCreatePrintServersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersChromePrintServersBatchCreatePrintServersCall) Do(opts ...googleapi.CallOption) (*BatchCreatePrintServersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchCreatePrintServersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintServersBatchDeletePrintServersCall struct {
	s                              *Service
	parent                         string
	batchdeleteprintserversrequest *BatchDeletePrintServersRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// BatchDeletePrintServers: Deletes multiple print servers.
//
//   - parent: The unique ID
//     (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers)
//     of the customer's Google Workspace account. Format:
//     `customers/{customer.id}`.
func (r *CustomersChromePrintServersService) BatchDeletePrintServers(parent string, batchdeleteprintserversrequest *BatchDeletePrintServersRequest) *CustomersChromePrintServersBatchDeletePrintServersCall {
	c := &CustomersChromePrintServersBatchDeletePrintServersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchdeleteprintserversrequest = batchdeleteprintserversrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintServersBatchDeletePrintServersCall) Fields(s ...googleapi.Field) *CustomersChromePrintServersBatchDeletePrintServersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintServersBatchDeletePrintServersCall) Context(ctx context.Context) *CustomersChromePrintServersBatchDeletePrintServersCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintServersBatchDeletePrintServersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintServersBatchDeletePrintServersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchdeleteprintserversrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printServers:batchDeletePrintServers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printServers.batchDeletePrintServers" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchDeletePrintServersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersChromePrintServersBatchDeletePrintServersCall) Do(opts ...googleapi.CallOption) (*BatchDeletePrintServersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchDeletePrintServersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintServersCreateCall struct {
	s           *Service
	parent      string
	printserver *PrintServer
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a print server.
//
//   - parent: The unique ID
//     (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers)
//     of the customer's Google Workspace account. Format: `customers/{id}`.
func (r *CustomersChromePrintServersService) Create(parent string, printserver *PrintServer) *CustomersChromePrintServersCreateCall {
	c := &CustomersChromePrintServersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.printserver = printserver
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintServersCreateCall) Fields(s ...googleapi.Field) *CustomersChromePrintServersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintServersCreateCall) Context(ctx context.Context) *CustomersChromePrintServersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintServersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintServersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.printserver)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printServers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printServers.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *PrintServer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintServersCreateCall) Do(opts ...googleapi.CallOption) (*PrintServer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PrintServer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintServersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a print server.
//
//   - name: The name of the print server to be deleted. Format:
//     `customers/{customer.id}/chrome/printServers/{print_server.id}`.
func (r *CustomersChromePrintServersService) Delete(name string) *CustomersChromePrintServersDeleteCall {
	c := &CustomersChromePrintServersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintServersDeleteCall) Fields(s ...googleapi.Field) *CustomersChromePrintServersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintServersDeleteCall) Context(ctx context.Context) *CustomersChromePrintServersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintServersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintServersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printServers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintServersDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintServersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a print server's configuration.
//
//   - name: The unique ID
//     (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers)
//     of the customer's Google Workspace account. Format: `customers/{id}`.
func (r *CustomersChromePrintServersService) Get(name string) *CustomersChromePrintServersGetCall {
	c := &CustomersChromePrintServersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintServersGetCall) Fields(s ...googleapi.Field) *CustomersChromePrintServersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersChromePrintServersGetCall) IfNoneMatch(entityTag string) *CustomersChromePrintServersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintServersGetCall) Context(ctx context.Context) *CustomersChromePrintServersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintServersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintServersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printServers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PrintServer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintServersGetCall) Do(opts ...googleapi.CallOption) (*PrintServer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PrintServer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintServersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists print server configurations.
//
//   - parent: The unique ID
//     (https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers)
//     of the customer's Google Workspace account. Format: `customers/{id}`.
func (r *CustomersChromePrintServersService) List(parent string) *CustomersChromePrintServersListCall {
	c := &CustomersChromePrintServersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Search query in Common
// Expression Language syntax (https://github.com/google/cel-spec). Supported
// filters are `display_name`, `description`, and `uri`. Example:
// `printServer.displayName=='marketing-queue'`.
func (c *CustomersChromePrintServersListCall) Filter(filter string) *CustomersChromePrintServersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Sort order for results.
// Supported values are `display_name`, `description`, or `create_time`.
// Default order is ascending, but descending order can be returned by
// appending "desc" to the `order_by` field. For instance,
// `orderBy=='description desc'` returns the print servers sorted by
// description in descending order.
func (c *CustomersChromePrintServersListCall) OrderBy(orderBy string) *CustomersChromePrintServersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": If `org_unit_id` is
// present in the request, only print servers owned or inherited by the
// organizational unit (OU) are returned. If the `PrintServer` resource's
// `org_unit_id` matches the one in the request, the OU owns the server. If
// `org_unit_id` is not specified in the request, all print servers are
// returned or filtered against.
func (c *CustomersChromePrintServersListCall) OrgUnitId(orgUnitId string) *CustomersChromePrintServersListCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// objects to return (default `100`, max `100`). The service might return fewer
// than this value.
func (c *CustomersChromePrintServersListCall) PageSize(pageSize int64) *CustomersChromePrintServersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A generated token to
// paginate results (the `next_page_token` from a previous call).
func (c *CustomersChromePrintServersListCall) PageToken(pageToken string) *CustomersChromePrintServersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintServersListCall) Fields(s ...googleapi.Field) *CustomersChromePrintServersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersChromePrintServersListCall) IfNoneMatch(entityTag string) *CustomersChromePrintServersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintServersListCall) Context(ctx context.Context) *CustomersChromePrintServersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintServersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintServersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printServers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printServers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPrintServersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersChromePrintServersListCall) Do(opts ...googleapi.CallOption) (*ListPrintServersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPrintServersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersChromePrintServersListCall) Pages(ctx context.Context, f func(*ListPrintServersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersChromePrintServersPatchCall struct {
	s           *Service
	name        string
	printserver *PrintServer
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates a print server's configuration.
//
//   - name: Immutable. Resource name of the print server. Leave empty when
//     creating. Format: `customers/{customer.id}/printServers/{print_server.id}`.
func (r *CustomersChromePrintServersService) Patch(name string, printserver *PrintServer) *CustomersChromePrintServersPatchCall {
	c := &CustomersChromePrintServersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.printserver = printserver
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update. Some fields are read-only and cannot be updated. Values for
// unspecified fields are patched.
func (c *CustomersChromePrintServersPatchCall) UpdateMask(updateMask string) *CustomersChromePrintServersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintServersPatchCall) Fields(s ...googleapi.Field) *CustomersChromePrintServersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintServersPatchCall) Context(ctx context.Context) *CustomersChromePrintServersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintServersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintServersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.printserver)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printServers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *PrintServer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintServersPatchCall) Do(opts ...googleapi.CallOption) (*PrintServer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PrintServer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintersBatchCreatePrintersCall struct {
	s                          *Service
	parent                     string
	batchcreateprintersrequest *BatchCreatePrintersRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// BatchCreatePrinters: Creates printers under given Organization Unit.
//
// - parent: The name of the customer. Format: customers/{customer_id}.
func (r *CustomersChromePrintersService) BatchCreatePrinters(parent string, batchcreateprintersrequest *BatchCreatePrintersRequest) *CustomersChromePrintersBatchCreatePrintersCall {
	c := &CustomersChromePrintersBatchCreatePrintersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchcreateprintersrequest = batchcreateprintersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersBatchCreatePrintersCall) Fields(s ...googleapi.Field) *CustomersChromePrintersBatchCreatePrintersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersBatchCreatePrintersCall) Context(ctx context.Context) *CustomersChromePrintersBatchCreatePrintersCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersBatchCreatePrintersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersBatchCreatePrintersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchcreateprintersrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printers:batchCreatePrinters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.batchCreatePrinters" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchCreatePrintersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersChromePrintersBatchCreatePrintersCall) Do(opts ...googleapi.CallOption) (*BatchCreatePrintersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchCreatePrintersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintersBatchDeletePrintersCall struct {
	s                          *Service
	parent                     string
	batchdeleteprintersrequest *BatchDeletePrintersRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// BatchDeletePrinters: Deletes printers in batch.
//
// - parent: The name of the customer. Format: customers/{customer_id}.
func (r *CustomersChromePrintersService) BatchDeletePrinters(parent string, batchdeleteprintersrequest *BatchDeletePrintersRequest) *CustomersChromePrintersBatchDeletePrintersCall {
	c := &CustomersChromePrintersBatchDeletePrintersCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchdeleteprintersrequest = batchdeleteprintersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersBatchDeletePrintersCall) Fields(s ...googleapi.Field) *CustomersChromePrintersBatchDeletePrintersCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersBatchDeletePrintersCall) Context(ctx context.Context) *CustomersChromePrintersBatchDeletePrintersCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersBatchDeletePrintersCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersBatchDeletePrintersCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchdeleteprintersrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printers:batchDeletePrinters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.batchDeletePrinters" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchDeletePrintersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersChromePrintersBatchDeletePrintersCall) Do(opts ...googleapi.CallOption) (*BatchDeletePrintersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchDeletePrintersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintersCreateCall struct {
	s          *Service
	parent     string
	printer    *Printer
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a printer under given Organization Unit.
//
// - parent: The name of the customer. Format: customers/{customer_id}.
func (r *CustomersChromePrintersService) Create(parent string, printer *Printer) *CustomersChromePrintersCreateCall {
	c := &CustomersChromePrintersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.printer = printer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersCreateCall) Fields(s ...googleapi.Field) *CustomersChromePrintersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersCreateCall) Context(ctx context.Context) *CustomersChromePrintersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.printer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Printer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintersCreateCall) Do(opts ...googleapi.CallOption) (*Printer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Printer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Printer`.
//
//   - name: The name of the printer to be updated. Format:
//     customers/{customer_id}/chrome/printers/{printer_id}.
func (r *CustomersChromePrintersService) Delete(name string) *CustomersChromePrintersDeleteCall {
	c := &CustomersChromePrintersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersDeleteCall) Fields(s ...googleapi.Field) *CustomersChromePrintersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersDeleteCall) Context(ctx context.Context) *CustomersChromePrintersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintersDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a `Printer` resource (printer's config).
//
//   - name: The name of the printer to retrieve. Format:
//     customers/{customer_id}/chrome/printers/{printer_id}.
func (r *CustomersChromePrintersService) Get(name string) *CustomersChromePrintersGetCall {
	c := &CustomersChromePrintersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersGetCall) Fields(s ...googleapi.Field) *CustomersChromePrintersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersChromePrintersGetCall) IfNoneMatch(entityTag string) *CustomersChromePrintersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersGetCall) Context(ctx context.Context) *CustomersChromePrintersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Printer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintersGetCall) Do(opts ...googleapi.CallOption) (*Printer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Printer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type CustomersChromePrintersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List printers configs.
//
//   - parent: The name of the customer who owns this collection of printers.
//     Format: customers/{customer_id}.
func (r *CustomersChromePrintersService) List(parent string) *CustomersChromePrintersListCall {
	c := &CustomersChromePrintersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Search query. Search syntax is
// shared between this api and Admin Console printers pages.
func (c *CustomersChromePrintersListCall) Filter(filter string) *CustomersChromePrintersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The order to sort results by.
// Must be one of display_name, description, make_and_model, or create_time.
// Default order is ascending, but descending order can be returned by
// appending "desc" to the order_by field. For instance, "description desc"
// will return the printers sorted by description in descending order.
func (c *CustomersChromePrintersListCall) OrderBy(orderBy string) *CustomersChromePrintersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": Organization Unit that we
// want to list the printers for. When org_unit is not present in the request
// then all printers of the customer are returned (or filtered). When org_unit
// is present in the request then only printers available to this OU will be
// returned (owned or inherited). You may see if printer is owned or inherited
// for this OU by looking at Printer.org_unit_id.
func (c *CustomersChromePrintersListCall) OrgUnitId(orgUnitId string) *CustomersChromePrintersListCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// objects to return. The service may return fewer than this value.
func (c *CustomersChromePrintersListCall) PageSize(pageSize int64) *CustomersChromePrintersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous call.
func (c *CustomersChromePrintersListCall) PageToken(pageToken string) *CustomersChromePrintersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersListCall) Fields(s ...googleapi.Field) *CustomersChromePrintersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersChromePrintersListCall) IfNoneMatch(entityTag string) *CustomersChromePrintersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersListCall) Context(ctx context.Context) *CustomersChromePrintersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPrintersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersChromePrintersListCall) Do(opts ...googleapi.CallOption) (*ListPrintersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPrintersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersChromePrintersListCall) Pages(ctx context.Context, f func(*ListPrintersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersChromePrintersListPrinterModelsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListPrinterModels: Lists the supported printer models.
//
//   - parent: The name of the customer who owns this collection of printers.
//     Format: customers/{customer_id}.
func (r *CustomersChromePrintersService) ListPrinterModels(parent string) *CustomersChromePrintersListPrinterModelsCall {
	c := &CustomersChromePrintersListPrinterModelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filer to list only models by a
// given manufacturer in format: "manufacturer:Brother". Search syntax is
// shared between this api and Admin Console printers pages.
func (c *CustomersChromePrintersListPrinterModelsCall) Filter(filter string) *CustomersChromePrintersListPrinterModelsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// objects to return. The service may return fewer than this value.
func (c *CustomersChromePrintersListPrinterModelsCall) PageSize(pageSize int64) *CustomersChromePrintersListPrinterModelsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous call.
func (c *CustomersChromePrintersListPrinterModelsCall) PageToken(pageToken string) *CustomersChromePrintersListPrinterModelsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersListPrinterModelsCall) Fields(s ...googleapi.Field) *CustomersChromePrintersListPrinterModelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersChromePrintersListPrinterModelsCall) IfNoneMatch(entityTag string) *CustomersChromePrintersListPrinterModelsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersListPrinterModelsCall) Context(ctx context.Context) *CustomersChromePrintersListPrinterModelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersListPrinterModelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersListPrinterModelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+parent}/chrome/printers:listPrinterModels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.listPrinterModels" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPrinterModelsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersChromePrintersListPrinterModelsCall) Do(opts ...googleapi.CallOption) (*ListPrinterModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPrinterModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersChromePrintersListPrinterModelsCall) Pages(ctx context.Context, f func(*ListPrinterModelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersChromePrintersPatchCall struct {
	s          *Service
	name       string
	printer    *Printer
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a `Printer` resource.
//
//   - name: The resource name of the Printer object, in the format
//     customers/{customer-id}/printers/{printer-id} (During printer creation
//     leave empty).
func (r *CustomersChromePrintersService) Patch(name string, printer *Printer) *CustomersChromePrintersPatchCall {
	c := &CustomersChromePrintersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.printer = printer
	return c
}

// ClearMask sets the optional parameter "clearMask": The list of fields to be
// cleared. Note, some of the fields are read only and cannot be updated.
// Values for not specified fields will be patched.
func (c *CustomersChromePrintersPatchCall) ClearMask(clearMask string) *CustomersChromePrintersPatchCall {
	c.urlParams_.Set("clearMask", clearMask)
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. Note, some of the fields are read only and cannot be updated.
// Values for not specified fields will be patched.
func (c *CustomersChromePrintersPatchCall) UpdateMask(updateMask string) *CustomersChromePrintersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersChromePrintersPatchCall) Fields(s ...googleapi.Field) *CustomersChromePrintersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersChromePrintersPatchCall) Context(ctx context.Context) *CustomersChromePrintersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersChromePrintersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersChromePrintersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.printer)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.customers.chrome.printers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Printer.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersChromePrintersPatchCall) Do(opts ...googleapi.CallOption) (*Printer, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Printer{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DomainAliasesDeleteCall struct {
	s               *Service
	customer        string
	domainAliasName string
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Delete: Deletes a domain Alias of the customer.
//
// - customer: Immutable ID of the Google Workspace account.
// - domainAliasName: Name of domain alias to be retrieved.
func (r *DomainAliasesService) Delete(customer string, domainAliasName string) *DomainAliasesDeleteCall {
	c := &DomainAliasesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.domainAliasName = domainAliasName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainAliasesDeleteCall) Fields(s ...googleapi.Field) *DomainAliasesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainAliasesDeleteCall) Context(ctx context.Context) *DomainAliasesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainAliasesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainAliasesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domainaliases/{domainAliasName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":        c.customer,
		"domainAliasName": c.domainAliasName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domainAliases.delete" call.
func (c *DomainAliasesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type DomainAliasesGetCall struct {
	s               *Service
	customer        string
	domainAliasName string
	urlParams_      gensupport.URLParams
	ifNoneMatch_    string
	ctx_            context.Context
	header_         http.Header
}

// Get: Retrieves a domain alias of the customer.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
//   - domainAliasName: Name of domain alias to be retrieved.
func (r *DomainAliasesService) Get(customer string, domainAliasName string) *DomainAliasesGetCall {
	c := &DomainAliasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.domainAliasName = domainAliasName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainAliasesGetCall) Fields(s ...googleapi.Field) *DomainAliasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DomainAliasesGetCall) IfNoneMatch(entityTag string) *DomainAliasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainAliasesGetCall) Context(ctx context.Context) *DomainAliasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainAliasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainAliasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domainaliases/{domainAliasName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":        c.customer,
		"domainAliasName": c.domainAliasName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domainAliases.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DomainAlias.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DomainAliasesGetCall) Do(opts ...googleapi.CallOption) (*DomainAlias, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DomainAlias{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DomainAliasesInsertCall struct {
	s           *Service
	customer    string
	domainalias *DomainAlias
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Insert: Inserts a domain alias of the customer.
//
// - customer: Immutable ID of the Google Workspace account.
func (r *DomainAliasesService) Insert(customer string, domainalias *DomainAlias) *DomainAliasesInsertCall {
	c := &DomainAliasesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.domainalias = domainalias
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainAliasesInsertCall) Fields(s ...googleapi.Field) *DomainAliasesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainAliasesInsertCall) Context(ctx context.Context) *DomainAliasesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainAliasesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainAliasesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.domainalias)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domainaliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domainAliases.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *DomainAlias.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DomainAliasesInsertCall) Do(opts ...googleapi.CallOption) (*DomainAlias, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DomainAlias{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DomainAliasesListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the domain aliases of the customer.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
func (r *DomainAliasesService) List(customer string) *DomainAliasesListCall {
	c := &DomainAliasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// ParentDomainName sets the optional parameter "parentDomainName": Name of the
// parent domain for which domain aliases are to be fetched.
func (c *DomainAliasesListCall) ParentDomainName(parentDomainName string) *DomainAliasesListCall {
	c.urlParams_.Set("parentDomainName", parentDomainName)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainAliasesListCall) Fields(s ...googleapi.Field) *DomainAliasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DomainAliasesListCall) IfNoneMatch(entityTag string) *DomainAliasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainAliasesListCall) Context(ctx context.Context) *DomainAliasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainAliasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainAliasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domainaliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domainAliases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *DomainAliases.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DomainAliasesListCall) Do(opts ...googleapi.CallOption) (*DomainAliases, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DomainAliases{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DomainsDeleteCall struct {
	s          *Service
	customer   string
	domainName string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a domain of the customer.
//
// - customer: Immutable ID of the Google Workspace account.
// - domainName: Name of domain to be deleted.
func (r *DomainsService) Delete(customer string, domainName string) *DomainsDeleteCall {
	c := &DomainsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.domainName = domainName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainsDeleteCall) Fields(s ...googleapi.Field) *DomainsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainsDeleteCall) Context(ctx context.Context) *DomainsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domains/{domainName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"domainName": c.domainName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domains.delete" call.
func (c *DomainsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type DomainsGetCall struct {
	s            *Service
	customer     string
	domainName   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a domain of the customer.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
//   - domainName: Name of domain to be retrieved.
func (r *DomainsService) Get(customer string, domainName string) *DomainsGetCall {
	c := &DomainsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.domainName = domainName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainsGetCall) Fields(s ...googleapi.Field) *DomainsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DomainsGetCall) IfNoneMatch(entityTag string) *DomainsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainsGetCall) Context(ctx context.Context) *DomainsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domains/{domainName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"domainName": c.domainName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domains.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Domains.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DomainsGetCall) Do(opts ...googleapi.CallOption) (*Domains, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Domains{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DomainsInsertCall struct {
	s          *Service
	customer   string
	domains    *Domains
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Inserts a domain of the customer.
//
// - customer: Immutable ID of the Google Workspace account.
func (r *DomainsService) Insert(customer string, domains *Domains) *DomainsInsertCall {
	c := &DomainsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.domains = domains
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainsInsertCall) Fields(s ...googleapi.Field) *DomainsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainsInsertCall) Context(ctx context.Context) *DomainsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.domains)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domains")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domains.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Domains.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DomainsInsertCall) Do(opts ...googleapi.CallOption) (*Domains, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Domains{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type DomainsListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the domains of the customer.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
func (r *DomainsService) List(customer string) *DomainsListCall {
	c := &DomainsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DomainsListCall) Fields(s ...googleapi.Field) *DomainsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DomainsListCall) IfNoneMatch(entityTag string) *DomainsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DomainsListCall) Context(ctx context.Context) *DomainsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DomainsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DomainsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/domains")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.domains.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Domains2.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DomainsListCall) Do(opts ...googleapi.CallOption) (*Domains2, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Domains2{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GroupsDeleteCall struct {
	s          *Service
	groupKey   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a group.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *GroupsService) Delete(groupKey string) *GroupsDeleteCall {
	c := &GroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsDeleteCall) Fields(s ...googleapi.Field) *GroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsDeleteCall) Context(ctx context.Context) *GroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.delete" call.
func (c *GroupsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type GroupsGetCall struct {
	s            *Service
	groupKey     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a group's properties.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *GroupsService) Get(groupKey string) *GroupsGetCall {
	c := &GroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsGetCall) Fields(s ...googleapi.Field) *GroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsGetCall) IfNoneMatch(entityTag string) *GroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsGetCall) Context(ctx context.Context) *GroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Group.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsGetCall) Do(opts ...googleapi.CallOption) (*Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GroupsInsertCall struct {
	s          *Service
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a group.
func (r *GroupsService) Insert(group *Group) *GroupsInsertCall {
	c := &GroupsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.group = group
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsInsertCall) Fields(s ...googleapi.Field) *GroupsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsInsertCall) Context(ctx context.Context) *GroupsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Group.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsInsertCall) Do(opts ...googleapi.CallOption) (*Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GroupsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves all groups of a domain or of a user given a userKey
// (paginated).
func (r *GroupsService) List() *GroupsListCall {
	c := &GroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Customer sets the optional parameter "customer": The unique ID for the
// customer's Google Workspace account. In case of a multi-domain account, to
// fetch all groups for a customer, use this field instead of `domain`. You can
// also use the `my_customer` alias to represent your account's `customerId`.
// The `customerId` is also returned as part of the Users
// (/admin-sdk/directory/v1/reference/users) resource. You must provide either
// the `customer` or the `domain` parameter.
func (c *GroupsListCall) Customer(customer string) *GroupsListCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Domain sets the optional parameter "domain": The domain name. Use this field
// to get groups from only one domain. To return all domains for a customer
// account, use the `customer` query parameter instead.
func (c *GroupsListCall) Domain(domain string) *GroupsListCall {
	c.urlParams_.Set("domain", domain)
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return. Max allowed value is 200.
func (c *GroupsListCall) MaxResults(maxResults int64) *GroupsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Column to use for sorting
// results
//
// Possible values:
//
//	"email" - Email of the group.
func (c *GroupsListCall) OrderBy(orderBy string) *GroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list
func (c *GroupsListCall) PageToken(pageToken string) *GroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Query string search. Should be of
// the form "". Complete documentation is at https:
// //developers.google.com/admin-sdk/directory/v1/guides/search-groups
func (c *GroupsListCall) Query(query string) *GroupsListCall {
	c.urlParams_.Set("query", query)
	return c
}

// SortOrder sets the optional parameter "sortOrder": Whether to return results
// in ascending or descending order. Only of use when orderBy is also used
//
// Possible values:
//
//	"ASCENDING" - Ascending order.
//	"DESCENDING" - Descending order.
func (c *GroupsListCall) SortOrder(sortOrder string) *GroupsListCall {
	c.urlParams_.Set("sortOrder", sortOrder)
	return c
}

// UserKey sets the optional parameter "userKey": Email or immutable ID of the
// user if only those groups are to be listed, the given user is a member of.
// If it's an ID, it should match with the ID of the user object. Cannot be
// used with the `customer` parameter.
func (c *GroupsListCall) UserKey(userKey string) *GroupsListCall {
	c.urlParams_.Set("userKey", userKey)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsListCall) Fields(s ...googleapi.Field) *GroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsListCall) IfNoneMatch(entityTag string) *GroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsListCall) Context(ctx context.Context) *GroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Groups.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsListCall) Do(opts ...googleapi.CallOption) (*Groups, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Groups{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsListCall) Pages(ctx context.Context, f func(*Groups) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type GroupsPatchCall struct {
	s          *Service
	groupKey   string
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a group's properties. This method supports patch semantics
// (/admin-sdk/directory/v1/guides/performance#patch).
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *GroupsService) Patch(groupKey string, group *Group) *GroupsPatchCall {
	c := &GroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.group = group
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsPatchCall) Fields(s ...googleapi.Field) *GroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsPatchCall) Context(ctx context.Context) *GroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Group.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsPatchCall) Do(opts ...googleapi.CallOption) (*Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GroupsUpdateCall struct {
	s          *Service
	groupKey   string
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a group's properties.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *GroupsService) Update(groupKey string, group *Group) *GroupsUpdateCall {
	c := &GroupsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.group = group
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsUpdateCall) Fields(s ...googleapi.Field) *GroupsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsUpdateCall) Context(ctx context.Context) *GroupsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Group.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsUpdateCall) Do(opts ...googleapi.CallOption) (*Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GroupsAliasesDeleteCall struct {
	s          *Service
	groupKey   string
	alias      string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes an alias.
//
//   - alias: The alias to be removed.
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *GroupsAliasesService) Delete(groupKey string, alias string) *GroupsAliasesDeleteCall {
	c := &GroupsAliasesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.alias = alias
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsAliasesDeleteCall) Fields(s ...googleapi.Field) *GroupsAliasesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsAliasesDeleteCall) Context(ctx context.Context) *GroupsAliasesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsAliasesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsAliasesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/aliases/{alias}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
		"alias":    c.alias,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.aliases.delete" call.
func (c *GroupsAliasesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type GroupsAliasesInsertCall struct {
	s          *Service
	groupKey   string
	alias      *Alias
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Adds an alias for the group.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *GroupsAliasesService) Insert(groupKey string, alias *Alias) *GroupsAliasesInsertCall {
	c := &GroupsAliasesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.alias = alias
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsAliasesInsertCall) Fields(s ...googleapi.Field) *GroupsAliasesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsAliasesInsertCall) Context(ctx context.Context) *GroupsAliasesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsAliasesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsAliasesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.alias)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/aliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.aliases.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alias.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsAliasesInsertCall) Do(opts ...googleapi.CallOption) (*Alias, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alias{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type GroupsAliasesListCall struct {
	s            *Service
	groupKey     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all aliases for a group.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *GroupsAliasesService) List(groupKey string) *GroupsAliasesListCall {
	c := &GroupsAliasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *GroupsAliasesListCall) Fields(s ...googleapi.Field) *GroupsAliasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *GroupsAliasesListCall) IfNoneMatch(entityTag string) *GroupsAliasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *GroupsAliasesListCall) Context(ctx context.Context) *GroupsAliasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *GroupsAliasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsAliasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/aliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.groups.aliases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Aliases.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *GroupsAliasesListCall) Do(opts ...googleapi.CallOption) (*Aliases, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Aliases{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MembersDeleteCall struct {
	s          *Service
	groupKey   string
	memberKey  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a member from a group.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
//   - memberKey: Identifies the group member in the API request. A group member
//     can be a user or another group. The value can be the member's (group or
//     user) primary email address, alias, or unique ID.
func (r *MembersService) Delete(groupKey string, memberKey string) *MembersDeleteCall {
	c := &MembersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.memberKey = memberKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MembersDeleteCall) Fields(s ...googleapi.Field) *MembersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MembersDeleteCall) Context(ctx context.Context) *MembersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MembersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MembersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/members/{memberKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey":  c.groupKey,
		"memberKey": c.memberKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.members.delete" call.
func (c *MembersDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type MembersGetCall struct {
	s            *Service
	groupKey     string
	memberKey    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a group member's properties.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
//   - memberKey: Identifies the group member in the API request. A group member
//     can be a user or another group. The value can be the member's (group or
//     user) primary email address, alias, or unique ID.
func (r *MembersService) Get(groupKey string, memberKey string) *MembersGetCall {
	c := &MembersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.memberKey = memberKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MembersGetCall) Fields(s ...googleapi.Field) *MembersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *MembersGetCall) IfNoneMatch(entityTag string) *MembersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MembersGetCall) Context(ctx context.Context) *MembersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MembersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MembersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/members/{memberKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey":  c.groupKey,
		"memberKey": c.memberKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.members.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Member.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MembersGetCall) Do(opts ...googleapi.CallOption) (*Member, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Member{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MembersHasMemberCall struct {
	s            *Service
	groupKey     string
	memberKey    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// HasMember: Checks whether the given user is a member of the group.
// Membership can be direct or nested, but if nested, the `memberKey` and
// `groupKey` must be entities in the same domain or an `Invalid input` error
// is returned. To check for nested memberships that include entities outside
// of the group's domain, use the `checkTransitiveMembership()`
// (https://cloud.google.com/identity/docs/reference/rest/v1/groups.memberships/checkTransitiveMembership)
// method in the Cloud Identity Groups API.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
//   - memberKey: Identifies the user member in the API request. The value can be
//     the user's primary email address, alias, or unique ID.
func (r *MembersService) HasMember(groupKey string, memberKey string) *MembersHasMemberCall {
	c := &MembersHasMemberCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.memberKey = memberKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MembersHasMemberCall) Fields(s ...googleapi.Field) *MembersHasMemberCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *MembersHasMemberCall) IfNoneMatch(entityTag string) *MembersHasMemberCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MembersHasMemberCall) Context(ctx context.Context) *MembersHasMemberCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MembersHasMemberCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MembersHasMemberCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/hasMember/{memberKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey":  c.groupKey,
		"memberKey": c.memberKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.members.hasMember" call.
// Any non-2xx status code is an error. Response headers are in either
// *MembersHasMember.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *MembersHasMemberCall) Do(opts ...googleapi.CallOption) (*MembersHasMember, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MembersHasMember{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MembersInsertCall struct {
	s          *Service
	groupKey   string
	member     *Member
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Adds a user to the specified group.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *MembersService) Insert(groupKey string, member *Member) *MembersInsertCall {
	c := &MembersInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.member = member
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MembersInsertCall) Fields(s ...googleapi.Field) *MembersInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MembersInsertCall) Context(ctx context.Context) *MembersInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MembersInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MembersInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.member)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/members")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.members.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Member.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MembersInsertCall) Do(opts ...googleapi.CallOption) (*Member, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Member{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MembersListCall struct {
	s            *Service
	groupKey     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a paginated list of all members in a group. This method
// times out after 60 minutes. For more information, see Troubleshoot error
// codes
// (https://developers.google.com/admin-sdk/directory/v1/guides/troubleshoot-error-codes).
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
func (r *MembersService) List(groupKey string) *MembersListCall {
	c := &MembersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	return c
}

// IncludeDerivedMembership sets the optional parameter
// "includeDerivedMembership": Whether to list indirect memberships. Default:
// false.
func (c *MembersListCall) IncludeDerivedMembership(includeDerivedMembership bool) *MembersListCall {
	c.urlParams_.Set("includeDerivedMembership", fmt.Sprint(includeDerivedMembership))
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return. Max allowed value is 200.
func (c *MembersListCall) MaxResults(maxResults int64) *MembersListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list.
func (c *MembersListCall) PageToken(pageToken string) *MembersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Roles sets the optional parameter "roles": The `roles` query parameter
// allows you to retrieve group members by role. Allowed values are `OWNER`,
// `MANAGER`, and `MEMBER`.
func (c *MembersListCall) Roles(roles string) *MembersListCall {
	c.urlParams_.Set("roles", roles)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MembersListCall) Fields(s ...googleapi.Field) *MembersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *MembersListCall) IfNoneMatch(entityTag string) *MembersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MembersListCall) Context(ctx context.Context) *MembersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MembersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MembersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/members")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey": c.groupKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.members.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Members.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MembersListCall) Do(opts ...googleapi.CallOption) (*Members, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Members{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MembersListCall) Pages(ctx context.Context, f func(*Members) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type MembersPatchCall struct {
	s          *Service
	groupKey   string
	memberKey  string
	member     *Member
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the membership properties of a user in the specified group.
// This method supports patch semantics
// (/admin-sdk/directory/v1/guides/performance#patch).
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
//   - memberKey: Identifies the group member in the API request. A group member
//     can be a user or another group. The value can be the member's (group or
//     user) primary email address, alias, or unique ID.
func (r *MembersService) Patch(groupKey string, memberKey string, member *Member) *MembersPatchCall {
	c := &MembersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.memberKey = memberKey
	c.member = member
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MembersPatchCall) Fields(s ...googleapi.Field) *MembersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MembersPatchCall) Context(ctx context.Context) *MembersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MembersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MembersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.member)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/members/{memberKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey":  c.groupKey,
		"memberKey": c.memberKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.members.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Member.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MembersPatchCall) Do(opts ...googleapi.CallOption) (*Member, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Member{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MembersUpdateCall struct {
	s          *Service
	groupKey   string
	memberKey  string
	member     *Member
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates the membership of a user in the specified group.
//
//   - groupKey: Identifies the group in the API request. The value can be the
//     group's email address, group alias, or the unique group ID.
//   - memberKey: Identifies the group member in the API request. A group member
//     can be a user or another group. The value can be the member's (group or
//     user) primary email address, alias, or unique ID.
func (r *MembersService) Update(groupKey string, memberKey string, member *Member) *MembersUpdateCall {
	c := &MembersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.groupKey = groupKey
	c.memberKey = memberKey
	c.member = member
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MembersUpdateCall) Fields(s ...googleapi.Field) *MembersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MembersUpdateCall) Context(ctx context.Context) *MembersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MembersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MembersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.member)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/groups/{groupKey}/members/{memberKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"groupKey":  c.groupKey,
		"memberKey": c.memberKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.members.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Member.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MembersUpdateCall) Do(opts ...googleapi.CallOption) (*Member, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Member{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MobiledevicesActionCall struct {
	s                  *Service
	customerId         string
	resourceId         string
	mobiledeviceaction *MobileDeviceAction
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Action: Takes an action that affects a mobile device. For example, remotely
// wiping a device.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - resourceId: The unique ID the API service uses to identify the mobile
//     device.
func (r *MobiledevicesService) Action(customerId string, resourceId string, mobiledeviceaction *MobileDeviceAction) *MobiledevicesActionCall {
	c := &MobiledevicesActionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.resourceId = resourceId
	c.mobiledeviceaction = mobiledeviceaction
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MobiledevicesActionCall) Fields(s ...googleapi.Field) *MobiledevicesActionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MobiledevicesActionCall) Context(ctx context.Context) *MobiledevicesActionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MobiledevicesActionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MobiledevicesActionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.mobiledeviceaction)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/mobile/{resourceId}/action")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.mobiledevices.action" call.
func (c *MobiledevicesActionCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type MobiledevicesDeleteCall struct {
	s          *Service
	customerId string
	resourceId string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a mobile device.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - resourceId: The unique ID the API service uses to identify the mobile
//     device.
func (r *MobiledevicesService) Delete(customerId string, resourceId string) *MobiledevicesDeleteCall {
	c := &MobiledevicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.resourceId = resourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MobiledevicesDeleteCall) Fields(s ...googleapi.Field) *MobiledevicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MobiledevicesDeleteCall) Context(ctx context.Context) *MobiledevicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MobiledevicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MobiledevicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/mobile/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.mobiledevices.delete" call.
func (c *MobiledevicesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type MobiledevicesGetCall struct {
	s            *Service
	customerId   string
	resourceId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a mobile device's properties.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - resourceId: The unique ID the API service uses to identify the mobile
//     device.
func (r *MobiledevicesService) Get(customerId string, resourceId string) *MobiledevicesGetCall {
	c := &MobiledevicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.resourceId = resourceId
	return c
}

// Projection sets the optional parameter "projection": Restrict information
// returned to a set of selected fields.
//
// Possible values:
//
//	"BASIC" - Includes only the basic metadata fields (e.g., deviceId, model,
//
// status, type, and status)
//
//	"FULL" - Includes all metadata fields
func (c *MobiledevicesGetCall) Projection(projection string) *MobiledevicesGetCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MobiledevicesGetCall) Fields(s ...googleapi.Field) *MobiledevicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *MobiledevicesGetCall) IfNoneMatch(entityTag string) *MobiledevicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MobiledevicesGetCall) Context(ctx context.Context) *MobiledevicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MobiledevicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MobiledevicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/mobile/{resourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"resourceId": c.resourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.mobiledevices.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MobileDevice.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MobiledevicesGetCall) Do(opts ...googleapi.CallOption) (*MobileDevice, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MobileDevice{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type MobiledevicesListCall struct {
	s            *Service
	customerId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a paginated list of all user-owned mobile devices for an
// account. To retrieve a list that includes company-owned devices, use the
// Cloud Identity Devices API
// (https://cloud.google.com/identity/docs/concepts/overview-devices) instead.
// This method times out after 60 minutes. For more information, see
// Troubleshoot error codes
// (https://developers.google.com/admin-sdk/directory/v1/guides/troubleshoot-error-codes).
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
func (r *MobiledevicesService) List(customerId string) *MobiledevicesListCall {
	c := &MobiledevicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return. Max allowed value is 100.
func (c *MobiledevicesListCall) MaxResults(maxResults int64) *MobiledevicesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Device property to use for
// sorting results.
//
// Possible values:
//
//	"deviceId" - The serial number for a Google Sync mobile device. For
//
// Android devices, this is a software generated unique identifier.
//
//	"email" - The device owner's email address.
//	"lastSync" - Last policy settings sync date time of the device.
//	"model" - The mobile device's model.
//	"name" - The device owner's user name.
//	"os" - The device's operating system.
//	"status" - The device status.
//	"type" - Type of the device.
func (c *MobiledevicesListCall) OrderBy(orderBy string) *MobiledevicesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list
func (c *MobiledevicesListCall) PageToken(pageToken string) *MobiledevicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Projection sets the optional parameter "projection": Restrict information
// returned to a set of selected fields.
//
// Possible values:
//
//	"BASIC" - Includes only the basic metadata fields (e.g., deviceId, model,
//
// status, type, and status)
//
//	"FULL" - Includes all metadata fields
func (c *MobiledevicesListCall) Projection(projection string) *MobiledevicesListCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Query sets the optional parameter "query": Search string in the format given
// at https://developers.google.com/admin-sdk/directory/v1/search-operators
func (c *MobiledevicesListCall) Query(query string) *MobiledevicesListCall {
	c.urlParams_.Set("query", query)
	return c
}

// SortOrder sets the optional parameter "sortOrder": Whether to return results
// in ascending or descending order. Must be used with the `orderBy` parameter.
//
// Possible values:
//
//	"ASCENDING" - Ascending order.
//	"DESCENDING" - Descending order.
func (c *MobiledevicesListCall) SortOrder(sortOrder string) *MobiledevicesListCall {
	c.urlParams_.Set("sortOrder", sortOrder)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MobiledevicesListCall) Fields(s ...googleapi.Field) *MobiledevicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *MobiledevicesListCall) IfNoneMatch(entityTag string) *MobiledevicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MobiledevicesListCall) Context(ctx context.Context) *MobiledevicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MobiledevicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MobiledevicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/devices/mobile")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.mobiledevices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *MobileDevices.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *MobiledevicesListCall) Do(opts ...googleapi.CallOption) (*MobileDevices, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MobileDevices{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MobiledevicesListCall) Pages(ctx context.Context, f func(*MobileDevices) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrgunitsDeleteCall struct {
	s           *Service
	customerId  string
	orgUnitPath string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Removes an organizational unit.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - orgUnitPath: The full path of the organizational unit (minus the leading
//     `/`) or its unique ID.
func (r *OrgunitsService) Delete(customerId string, orgUnitPath string) *OrgunitsDeleteCall {
	c := &OrgunitsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.orgUnitPath = orgUnitPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgunitsDeleteCall) Fields(s ...googleapi.Field) *OrgunitsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgunitsDeleteCall) Context(ctx context.Context) *OrgunitsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgunitsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgunitsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId":  c.customerId,
		"orgUnitPath": c.orgUnitPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.orgunits.delete" call.
func (c *OrgunitsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type OrgunitsGetCall struct {
	s            *Service
	customerId   string
	orgUnitPath  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves an organizational unit.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - orgUnitPath: The full path of the organizational unit (minus the leading
//     `/`) or its unique ID.
func (r *OrgunitsService) Get(customerId string, orgUnitPath string) *OrgunitsGetCall {
	c := &OrgunitsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.orgUnitPath = orgUnitPath
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgunitsGetCall) Fields(s ...googleapi.Field) *OrgunitsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrgunitsGetCall) IfNoneMatch(entityTag string) *OrgunitsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgunitsGetCall) Context(ctx context.Context) *OrgunitsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgunitsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgunitsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId":  c.customerId,
		"orgUnitPath": c.orgUnitPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.orgunits.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *OrgUnit.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrgunitsGetCall) Do(opts ...googleapi.CallOption) (*OrgUnit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrgUnit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrgunitsInsertCall struct {
	s          *Service
	customerId string
	orgunit    *OrgUnit
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Adds an organizational unit.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
func (r *OrgunitsService) Insert(customerId string, orgunit *OrgUnit) *OrgunitsInsertCall {
	c := &OrgunitsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.orgunit = orgunit
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgunitsInsertCall) Fields(s ...googleapi.Field) *OrgunitsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgunitsInsertCall) Context(ctx context.Context) *OrgunitsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgunitsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgunitsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.orgunit)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/orgunits")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.orgunits.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *OrgUnit.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrgunitsInsertCall) Do(opts ...googleapi.CallOption) (*OrgUnit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrgUnit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrgunitsListCall struct {
	s            *Service
	customerId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of all organizational units for an account.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
func (r *OrgunitsService) List(customerId string) *OrgunitsListCall {
	c := &OrgunitsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	return c
}

// OrgUnitPath sets the optional parameter "orgUnitPath": The full path to the
// organizational unit or its unique ID. Returns the children of the specified
// organizational unit.
func (c *OrgunitsListCall) OrgUnitPath(orgUnitPath string) *OrgunitsListCall {
	c.urlParams_.Set("orgUnitPath", orgUnitPath)
	return c
}

// Type sets the optional parameter "type": Whether to return all
// sub-organizations or just immediate children.
//
// Possible values:
//
//	"all" - All sub-organizational units.
//	"children" - Immediate children only (default).
//	"allIncludingParent" - All sub-organizational units and the specified
//
// organizational unit (root if not specified).
func (c *OrgunitsListCall) Type(type_ string) *OrgunitsListCall {
	c.urlParams_.Set("type", type_)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgunitsListCall) Fields(s ...googleapi.Field) *OrgunitsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrgunitsListCall) IfNoneMatch(entityTag string) *OrgunitsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgunitsListCall) Context(ctx context.Context) *OrgunitsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgunitsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgunitsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/orgunits")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.orgunits.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *OrgUnits.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrgunitsListCall) Do(opts ...googleapi.CallOption) (*OrgUnits, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrgUnits{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrgunitsPatchCall struct {
	s           *Service
	customerId  string
	orgUnitPath string
	orgunit     *OrgUnit
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates an organizational unit. This method supports patch semantics
// (/admin-sdk/directory/v1/guides/performance#patch)
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - orgUnitPath: The full path of the organizational unit (minus the leading
//     `/`) or its unique ID.
func (r *OrgunitsService) Patch(customerId string, orgUnitPath string, orgunit *OrgUnit) *OrgunitsPatchCall {
	c := &OrgunitsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.orgUnitPath = orgUnitPath
	c.orgunit = orgunit
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgunitsPatchCall) Fields(s ...googleapi.Field) *OrgunitsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgunitsPatchCall) Context(ctx context.Context) *OrgunitsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgunitsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgunitsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.orgunit)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId":  c.customerId,
		"orgUnitPath": c.orgUnitPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.orgunits.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *OrgUnit.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrgunitsPatchCall) Do(opts ...googleapi.CallOption) (*OrgUnit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrgUnit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type OrgunitsUpdateCall struct {
	s           *Service
	customerId  string
	orgUnitPath string
	orgunit     *OrgUnit
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates an organizational unit.
//
//   - customerId: The unique ID for the customer's Google Workspace account. As
//     an account administrator, you can also use the `my_customer` alias to
//     represent your account's `customerId`. The `customerId` is also returned
//     as part of the Users resource (/admin-sdk/directory/v1/reference/users).
//   - orgUnitPath: The full path of the organizational unit (minus the leading
//     `/`) or its unique ID.
func (r *OrgunitsService) Update(customerId string, orgUnitPath string, orgunit *OrgUnit) *OrgunitsUpdateCall {
	c := &OrgunitsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.orgUnitPath = orgUnitPath
	c.orgunit = orgunit
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrgunitsUpdateCall) Fields(s ...googleapi.Field) *OrgunitsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrgunitsUpdateCall) Context(ctx context.Context) *OrgunitsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrgunitsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrgunitsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.orgunit)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId":  c.customerId,
		"orgUnitPath": c.orgUnitPath,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.orgunits.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *OrgUnit.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrgunitsUpdateCall) Do(opts ...googleapi.CallOption) (*OrgUnit, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OrgUnit{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type PrivilegesListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a paginated list of all privileges for a customer.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
func (r *PrivilegesService) List(customer string) *PrivilegesListCall {
	c := &PrivilegesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PrivilegesListCall) Fields(s ...googleapi.Field) *PrivilegesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PrivilegesListCall) IfNoneMatch(entityTag string) *PrivilegesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PrivilegesListCall) Context(ctx context.Context) *PrivilegesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PrivilegesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PrivilegesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roles/ALL/privileges")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.privileges.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Privileges.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *PrivilegesListCall) Do(opts ...googleapi.CallOption) (*Privileges, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Privileges{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesBuildingsDeleteCall struct {
	s          *Service
	customer   string
	buildingId string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a building.
//
//   - buildingId: The id of the building to delete.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesBuildingsService) Delete(customer string, buildingId string) *ResourcesBuildingsDeleteCall {
	c := &ResourcesBuildingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.buildingId = buildingId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesBuildingsDeleteCall) Fields(s ...googleapi.Field) *ResourcesBuildingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesBuildingsDeleteCall) Context(ctx context.Context) *ResourcesBuildingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesBuildingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesBuildingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"buildingId": c.buildingId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.buildings.delete" call.
func (c *ResourcesBuildingsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type ResourcesBuildingsGetCall struct {
	s            *Service
	customer     string
	buildingId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a building.
//
//   - buildingId: The unique ID of the building to retrieve.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesBuildingsService) Get(customer string, buildingId string) *ResourcesBuildingsGetCall {
	c := &ResourcesBuildingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.buildingId = buildingId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesBuildingsGetCall) Fields(s ...googleapi.Field) *ResourcesBuildingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesBuildingsGetCall) IfNoneMatch(entityTag string) *ResourcesBuildingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesBuildingsGetCall) Context(ctx context.Context) *ResourcesBuildingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesBuildingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesBuildingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"buildingId": c.buildingId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.buildings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Building.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesBuildingsGetCall) Do(opts ...googleapi.CallOption) (*Building, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Building{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesBuildingsInsertCall struct {
	s          *Service
	customer   string
	building   *Building
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Inserts a building.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesBuildingsService) Insert(customer string, building *Building) *ResourcesBuildingsInsertCall {
	c := &ResourcesBuildingsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.building = building
	return c
}

// CoordinatesSource sets the optional parameter "coordinatesSource": Source
// from which Building.coordinates are derived.
//
// Possible values:
//
//	"CLIENT_SPECIFIED" - Building.coordinates are set to the coordinates
//
// included in the request.
//
//	"RESOLVED_FROM_ADDRESS" - Building.coordinates are automatically populated
//
// based on the postal address.
//
//	"SOURCE_UNSPECIFIED" (default) - Defaults to `RESOLVED_FROM_ADDRESS` if
//
// postal address is provided. Otherwise, defaults to `CLIENT_SPECIFIED` if
// coordinates are provided.
func (c *ResourcesBuildingsInsertCall) CoordinatesSource(coordinatesSource string) *ResourcesBuildingsInsertCall {
	c.urlParams_.Set("coordinatesSource", coordinatesSource)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesBuildingsInsertCall) Fields(s ...googleapi.Field) *ResourcesBuildingsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesBuildingsInsertCall) Context(ctx context.Context) *ResourcesBuildingsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesBuildingsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesBuildingsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.building)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/buildings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.buildings.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Building.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesBuildingsInsertCall) Do(opts ...googleapi.CallOption) (*Building, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Building{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesBuildingsListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of buildings for an account.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesBuildingsService) List(customer string) *ResourcesBuildingsListCall {
	c := &ResourcesBuildingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return.
func (c *ResourcesBuildingsListCall) MaxResults(maxResults int64) *ResourcesBuildingsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the next
// page in the list.
func (c *ResourcesBuildingsListCall) PageToken(pageToken string) *ResourcesBuildingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesBuildingsListCall) Fields(s ...googleapi.Field) *ResourcesBuildingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesBuildingsListCall) IfNoneMatch(entityTag string) *ResourcesBuildingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesBuildingsListCall) Context(ctx context.Context) *ResourcesBuildingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesBuildingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesBuildingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/buildings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.buildings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Buildings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesBuildingsListCall) Do(opts ...googleapi.CallOption) (*Buildings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Buildings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ResourcesBuildingsListCall) Pages(ctx context.Context, f func(*Buildings) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ResourcesBuildingsPatchCall struct {
	s          *Service
	customer   string
	buildingId string
	building   *Building
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Patches a building.
//
//   - buildingId: The id of the building to update.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesBuildingsService) Patch(customer string, buildingId string, building *Building) *ResourcesBuildingsPatchCall {
	c := &ResourcesBuildingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.buildingId = buildingId
	c.building = building
	return c
}

// CoordinatesSource sets the optional parameter "coordinatesSource": Source
// from which Building.coordinates are derived.
//
// Possible values:
//
//	"CLIENT_SPECIFIED" - Building.coordinates are set to the coordinates
//
// included in the request.
//
//	"RESOLVED_FROM_ADDRESS" - Building.coordinates are automatically populated
//
// based on the postal address.
//
//	"SOURCE_UNSPECIFIED" (default) - Defaults to `RESOLVED_FROM_ADDRESS` if
//
// postal address is provided. Otherwise, defaults to `CLIENT_SPECIFIED` if
// coordinates are provided.
func (c *ResourcesBuildingsPatchCall) CoordinatesSource(coordinatesSource string) *ResourcesBuildingsPatchCall {
	c.urlParams_.Set("coordinatesSource", coordinatesSource)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesBuildingsPatchCall) Fields(s ...googleapi.Field) *ResourcesBuildingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesBuildingsPatchCall) Context(ctx context.Context) *ResourcesBuildingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesBuildingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesBuildingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.building)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"buildingId": c.buildingId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.buildings.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Building.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesBuildingsPatchCall) Do(opts ...googleapi.CallOption) (*Building, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Building{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesBuildingsUpdateCall struct {
	s          *Service
	customer   string
	buildingId string
	building   *Building
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a building.
//
//   - buildingId: The id of the building to update.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesBuildingsService) Update(customer string, buildingId string, building *Building) *ResourcesBuildingsUpdateCall {
	c := &ResourcesBuildingsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.buildingId = buildingId
	c.building = building
	return c
}

// CoordinatesSource sets the optional parameter "coordinatesSource": Source
// from which Building.coordinates are derived.
//
// Possible values:
//
//	"CLIENT_SPECIFIED" - Building.coordinates are set to the coordinates
//
// included in the request.
//
//	"RESOLVED_FROM_ADDRESS" - Building.coordinates are automatically populated
//
// based on the postal address.
//
//	"SOURCE_UNSPECIFIED" (default) - Defaults to `RESOLVED_FROM_ADDRESS` if
//
// postal address is provided. Otherwise, defaults to `CLIENT_SPECIFIED` if
// coordinates are provided.
func (c *ResourcesBuildingsUpdateCall) CoordinatesSource(coordinatesSource string) *ResourcesBuildingsUpdateCall {
	c.urlParams_.Set("coordinatesSource", coordinatesSource)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesBuildingsUpdateCall) Fields(s ...googleapi.Field) *ResourcesBuildingsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesBuildingsUpdateCall) Context(ctx context.Context) *ResourcesBuildingsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesBuildingsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesBuildingsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.building)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"buildingId": c.buildingId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.buildings.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Building.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesBuildingsUpdateCall) Do(opts ...googleapi.CallOption) (*Building, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Building{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesCalendarsDeleteCall struct {
	s                  *Service
	customer           string
	calendarResourceId string
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Delete: Deletes a calendar resource.
//
//   - calendarResourceId: The unique ID of the calendar resource to delete.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesCalendarsService) Delete(customer string, calendarResourceId string) *ResourcesCalendarsDeleteCall {
	c := &ResourcesCalendarsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.calendarResourceId = calendarResourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesCalendarsDeleteCall) Fields(s ...googleapi.Field) *ResourcesCalendarsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesCalendarsDeleteCall) Context(ctx context.Context) *ResourcesCalendarsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesCalendarsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesCalendarsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":           c.customer,
		"calendarResourceId": c.calendarResourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.calendars.delete" call.
func (c *ResourcesCalendarsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type ResourcesCalendarsGetCall struct {
	s                  *Service
	customer           string
	calendarResourceId string
	urlParams_         gensupport.URLParams
	ifNoneMatch_       string
	ctx_               context.Context
	header_            http.Header
}

// Get: Retrieves a calendar resource.
//
//   - calendarResourceId: The unique ID of the calendar resource to retrieve.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesCalendarsService) Get(customer string, calendarResourceId string) *ResourcesCalendarsGetCall {
	c := &ResourcesCalendarsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.calendarResourceId = calendarResourceId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesCalendarsGetCall) Fields(s ...googleapi.Field) *ResourcesCalendarsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesCalendarsGetCall) IfNoneMatch(entityTag string) *ResourcesCalendarsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesCalendarsGetCall) Context(ctx context.Context) *ResourcesCalendarsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesCalendarsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesCalendarsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":           c.customer,
		"calendarResourceId": c.calendarResourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.calendars.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *CalendarResource.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ResourcesCalendarsGetCall) Do(opts ...googleapi.CallOption) (*CalendarResource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CalendarResource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesCalendarsInsertCall struct {
	s                *Service
	customer         string
	calendarresource *CalendarResource
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Insert: Inserts a calendar resource.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesCalendarsService) Insert(customer string, calendarresource *CalendarResource) *ResourcesCalendarsInsertCall {
	c := &ResourcesCalendarsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.calendarresource = calendarresource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesCalendarsInsertCall) Fields(s ...googleapi.Field) *ResourcesCalendarsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesCalendarsInsertCall) Context(ctx context.Context) *ResourcesCalendarsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesCalendarsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesCalendarsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.calendarresource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/calendars")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.calendars.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *CalendarResource.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ResourcesCalendarsInsertCall) Do(opts ...googleapi.CallOption) (*CalendarResource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CalendarResource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesCalendarsListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of calendar resources for an account.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesCalendarsService) List(customer string) *ResourcesCalendarsListCall {
	c := &ResourcesCalendarsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return.
func (c *ResourcesCalendarsListCall) MaxResults(maxResults int64) *ResourcesCalendarsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Field(s) to sort results by
// in either ascending or descending order. Supported fields include
// `resourceId`, `resourceName`, `capacity`, `buildingId`, and `floorName`. If
// no order is specified, defaults to ascending. Should be of the form "field
// [asc|desc], field [asc|desc], ...". For example `buildingId, capacity desc`
// would return results sorted first by `buildingId` in ascending order then by
// `capacity` in descending order.
func (c *ResourcesCalendarsListCall) OrderBy(orderBy string) *ResourcesCalendarsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the next
// page in the list.
func (c *ResourcesCalendarsListCall) PageToken(pageToken string) *ResourcesCalendarsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": String query used to filter
// results. Should be of the form "field operator value" where field can be any
// of supported fields and operators can be any of supported operations.
// Operators include '=' for exact match, '!=' for mismatch and ':' for prefix
// match or HAS match where applicable. For prefix match, the value should
// always be followed by a *. Logical operators NOT and AND are supported (in
// this order of precedence). Supported fields include `generatedResourceName`,
// `name`, `buildingId`, `floor_name`, `capacity`,
// `featureInstances.feature.name`, `resourceEmail`, `resourceCategory`. For
// example `buildingId=US-NYC-9TH AND featureInstances.feature.name:Phone`.
func (c *ResourcesCalendarsListCall) Query(query string) *ResourcesCalendarsListCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesCalendarsListCall) Fields(s ...googleapi.Field) *ResourcesCalendarsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesCalendarsListCall) IfNoneMatch(entityTag string) *ResourcesCalendarsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesCalendarsListCall) Context(ctx context.Context) *ResourcesCalendarsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesCalendarsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesCalendarsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/calendars")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.calendars.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *CalendarResources.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ResourcesCalendarsListCall) Do(opts ...googleapi.CallOption) (*CalendarResources, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CalendarResources{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ResourcesCalendarsListCall) Pages(ctx context.Context, f func(*CalendarResources) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ResourcesCalendarsPatchCall struct {
	s                  *Service
	customer           string
	calendarResourceId string
	calendarresource   *CalendarResource
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Patches a calendar resource.
//
//   - calendarResourceId: The unique ID of the calendar resource to update.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesCalendarsService) Patch(customer string, calendarResourceId string, calendarresource *CalendarResource) *ResourcesCalendarsPatchCall {
	c := &ResourcesCalendarsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.calendarResourceId = calendarResourceId
	c.calendarresource = calendarresource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesCalendarsPatchCall) Fields(s ...googleapi.Field) *ResourcesCalendarsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesCalendarsPatchCall) Context(ctx context.Context) *ResourcesCalendarsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesCalendarsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesCalendarsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.calendarresource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":           c.customer,
		"calendarResourceId": c.calendarResourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.calendars.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *CalendarResource.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ResourcesCalendarsPatchCall) Do(opts ...googleapi.CallOption) (*CalendarResource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CalendarResource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesCalendarsUpdateCall struct {
	s                  *Service
	customer           string
	calendarResourceId string
	calendarresource   *CalendarResource
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Update: Updates a calendar resource. This method supports patch semantics,
// meaning you only need to include the fields you wish to update. Fields that
// are not present in the request will be preserved.
//
//   - calendarResourceId: The unique ID of the calendar resource to update.
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesCalendarsService) Update(customer string, calendarResourceId string, calendarresource *CalendarResource) *ResourcesCalendarsUpdateCall {
	c := &ResourcesCalendarsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.calendarResourceId = calendarResourceId
	c.calendarresource = calendarresource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesCalendarsUpdateCall) Fields(s ...googleapi.Field) *ResourcesCalendarsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesCalendarsUpdateCall) Context(ctx context.Context) *ResourcesCalendarsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesCalendarsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesCalendarsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.calendarresource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":           c.customer,
		"calendarResourceId": c.calendarResourceId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.calendars.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *CalendarResource.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ResourcesCalendarsUpdateCall) Do(opts ...googleapi.CallOption) (*CalendarResource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CalendarResource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesFeaturesDeleteCall struct {
	s          *Service
	customer   string
	featureKey string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a feature.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
//   - featureKey: The unique ID of the feature to delete.
func (r *ResourcesFeaturesService) Delete(customer string, featureKey string) *ResourcesFeaturesDeleteCall {
	c := &ResourcesFeaturesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.featureKey = featureKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesFeaturesDeleteCall) Fields(s ...googleapi.Field) *ResourcesFeaturesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesFeaturesDeleteCall) Context(ctx context.Context) *ResourcesFeaturesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesFeaturesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesFeaturesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/features/{featureKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"featureKey": c.featureKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.features.delete" call.
func (c *ResourcesFeaturesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type ResourcesFeaturesGetCall struct {
	s            *Service
	customer     string
	featureKey   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a feature.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
//   - featureKey: The unique ID of the feature to retrieve.
func (r *ResourcesFeaturesService) Get(customer string, featureKey string) *ResourcesFeaturesGetCall {
	c := &ResourcesFeaturesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.featureKey = featureKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesFeaturesGetCall) Fields(s ...googleapi.Field) *ResourcesFeaturesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesFeaturesGetCall) IfNoneMatch(entityTag string) *ResourcesFeaturesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesFeaturesGetCall) Context(ctx context.Context) *ResourcesFeaturesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesFeaturesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesFeaturesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/features/{featureKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"featureKey": c.featureKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.features.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Feature.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesFeaturesGetCall) Do(opts ...googleapi.CallOption) (*Feature, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Feature{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesFeaturesInsertCall struct {
	s          *Service
	customer   string
	feature    *Feature
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Inserts a feature.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesFeaturesService) Insert(customer string, feature *Feature) *ResourcesFeaturesInsertCall {
	c := &ResourcesFeaturesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.feature = feature
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesFeaturesInsertCall) Fields(s ...googleapi.Field) *ResourcesFeaturesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesFeaturesInsertCall) Context(ctx context.Context) *ResourcesFeaturesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesFeaturesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesFeaturesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.feature)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/features")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.features.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Feature.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesFeaturesInsertCall) Do(opts ...googleapi.CallOption) (*Feature, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Feature{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesFeaturesListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of features for an account.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
func (r *ResourcesFeaturesService) List(customer string) *ResourcesFeaturesListCall {
	c := &ResourcesFeaturesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return.
func (c *ResourcesFeaturesListCall) MaxResults(maxResults int64) *ResourcesFeaturesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the next
// page in the list.
func (c *ResourcesFeaturesListCall) PageToken(pageToken string) *ResourcesFeaturesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesFeaturesListCall) Fields(s ...googleapi.Field) *ResourcesFeaturesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ResourcesFeaturesListCall) IfNoneMatch(entityTag string) *ResourcesFeaturesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesFeaturesListCall) Context(ctx context.Context) *ResourcesFeaturesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesFeaturesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesFeaturesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/features")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.features.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Features.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesFeaturesListCall) Do(opts ...googleapi.CallOption) (*Features, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Features{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ResourcesFeaturesListCall) Pages(ctx context.Context, f func(*Features) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ResourcesFeaturesPatchCall struct {
	s          *Service
	customer   string
	featureKey string
	feature    *Feature
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Patches a feature.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
//   - featureKey: The unique ID of the feature to update.
func (r *ResourcesFeaturesService) Patch(customer string, featureKey string, feature *Feature) *ResourcesFeaturesPatchCall {
	c := &ResourcesFeaturesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.featureKey = featureKey
	c.feature = feature
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesFeaturesPatchCall) Fields(s ...googleapi.Field) *ResourcesFeaturesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesFeaturesPatchCall) Context(ctx context.Context) *ResourcesFeaturesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesFeaturesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesFeaturesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.feature)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/features/{featureKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"featureKey": c.featureKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.features.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Feature.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesFeaturesPatchCall) Do(opts ...googleapi.CallOption) (*Feature, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Feature{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ResourcesFeaturesRenameCall struct {
	s             *Service
	customer      string
	oldName       string
	featurerename *FeatureRename
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Rename: Renames a feature.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
//   - oldName: The unique ID of the feature to rename.
func (r *ResourcesFeaturesService) Rename(customer string, oldName string, featurerename *FeatureRename) *ResourcesFeaturesRenameCall {
	c := &ResourcesFeaturesRenameCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.oldName = oldName
	c.featurerename = featurerename
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesFeaturesRenameCall) Fields(s ...googleapi.Field) *ResourcesFeaturesRenameCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesFeaturesRenameCall) Context(ctx context.Context) *ResourcesFeaturesRenameCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesFeaturesRenameCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesFeaturesRenameCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.featurerename)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/features/{oldName}/rename")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
		"oldName":  c.oldName,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.features.rename" call.
func (c *ResourcesFeaturesRenameCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type ResourcesFeaturesUpdateCall struct {
	s          *Service
	customer   string
	featureKey string
	feature    *Feature
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a feature.
//
//   - customer: The unique ID for the customer's Google Workspace account. As an
//     account administrator, you can also use the `my_customer` alias to
//     represent your account's customer ID.
//   - featureKey: The unique ID of the feature to update.
func (r *ResourcesFeaturesService) Update(customer string, featureKey string, feature *Feature) *ResourcesFeaturesUpdateCall {
	c := &ResourcesFeaturesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.featureKey = featureKey
	c.feature = feature
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ResourcesFeaturesUpdateCall) Fields(s ...googleapi.Field) *ResourcesFeaturesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ResourcesFeaturesUpdateCall) Context(ctx context.Context) *ResourcesFeaturesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ResourcesFeaturesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ResourcesFeaturesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.feature)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/resources/features/{featureKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":   c.customer,
		"featureKey": c.featureKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.resources.features.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Feature.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ResourcesFeaturesUpdateCall) Do(opts ...googleapi.CallOption) (*Feature, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Feature{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type RoleAssignmentsDeleteCall struct {
	s                *Service
	customer         string
	roleAssignmentId string
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Delete: Deletes a role assignment.
//
// - customer: Immutable ID of the Google Workspace account.
// - roleAssignmentId: Immutable ID of the role assignment.
func (r *RoleAssignmentsService) Delete(customer string, roleAssignmentId string) *RoleAssignmentsDeleteCall {
	c := &RoleAssignmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.roleAssignmentId = roleAssignmentId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoleAssignmentsDeleteCall) Fields(s ...googleapi.Field) *RoleAssignmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoleAssignmentsDeleteCall) Context(ctx context.Context) *RoleAssignmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoleAssignmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoleAssignmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roleassignments/{roleAssignmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":         c.customer,
		"roleAssignmentId": c.roleAssignmentId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roleAssignments.delete" call.
func (c *RoleAssignmentsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type RoleAssignmentsGetCall struct {
	s                *Service
	customer         string
	roleAssignmentId string
	urlParams_       gensupport.URLParams
	ifNoneMatch_     string
	ctx_             context.Context
	header_          http.Header
}

// Get: Retrieves a role assignment.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
//   - roleAssignmentId: Immutable ID of the role assignment.
func (r *RoleAssignmentsService) Get(customer string, roleAssignmentId string) *RoleAssignmentsGetCall {
	c := &RoleAssignmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.roleAssignmentId = roleAssignmentId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoleAssignmentsGetCall) Fields(s ...googleapi.Field) *RoleAssignmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RoleAssignmentsGetCall) IfNoneMatch(entityTag string) *RoleAssignmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoleAssignmentsGetCall) Context(ctx context.Context) *RoleAssignmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoleAssignmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoleAssignmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roleassignments/{roleAssignmentId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer":         c.customer,
		"roleAssignmentId": c.roleAssignmentId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roleAssignments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RoleAssignment.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RoleAssignmentsGetCall) Do(opts ...googleapi.CallOption) (*RoleAssignment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RoleAssignment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type RoleAssignmentsInsertCall struct {
	s              *Service
	customer       string
	roleassignment *RoleAssignment
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Insert: Creates a role assignment.
//
// - customer: Immutable ID of the Google Workspace account.
func (r *RoleAssignmentsService) Insert(customer string, roleassignment *RoleAssignment) *RoleAssignmentsInsertCall {
	c := &RoleAssignmentsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.roleassignment = roleassignment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoleAssignmentsInsertCall) Fields(s ...googleapi.Field) *RoleAssignmentsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoleAssignmentsInsertCall) Context(ctx context.Context) *RoleAssignmentsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoleAssignmentsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoleAssignmentsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.roleassignment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roleassignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roleAssignments.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *RoleAssignment.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RoleAssignmentsInsertCall) Do(opts ...googleapi.CallOption) (*RoleAssignment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RoleAssignment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type RoleAssignmentsListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a paginated list of all roleAssignments.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
func (r *RoleAssignmentsService) List(customer string) *RoleAssignmentsListCall {
	c := &RoleAssignmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// IncludeIndirectRoleAssignments sets the optional parameter
// "includeIndirectRoleAssignments": When set to `true`, fetches indirect role
// assignments (i.e. role assignment via a group) as well as direct ones.
// Defaults to `false`. You must specify `user_key` or the indirect role
// assignments will not be included.
func (c *RoleAssignmentsListCall) IncludeIndirectRoleAssignments(includeIndirectRoleAssignments bool) *RoleAssignmentsListCall {
	c.urlParams_.Set("includeIndirectRoleAssignments", fmt.Sprint(includeIndirectRoleAssignments))
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return.
func (c *RoleAssignmentsListCall) MaxResults(maxResults int64) *RoleAssignmentsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the next
// page in the list.
func (c *RoleAssignmentsListCall) PageToken(pageToken string) *RoleAssignmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// RoleId sets the optional parameter "roleId": Immutable ID of a role. If
// included in the request, returns only role assignments containing this role
// ID.
func (c *RoleAssignmentsListCall) RoleId(roleId string) *RoleAssignmentsListCall {
	c.urlParams_.Set("roleId", roleId)
	return c
}

// UserKey sets the optional parameter "userKey": The primary email address,
// alias email address, or unique user or group ID. If included in the request,
// returns role assignments only for this user or group.
func (c *RoleAssignmentsListCall) UserKey(userKey string) *RoleAssignmentsListCall {
	c.urlParams_.Set("userKey", userKey)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoleAssignmentsListCall) Fields(s ...googleapi.Field) *RoleAssignmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RoleAssignmentsListCall) IfNoneMatch(entityTag string) *RoleAssignmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoleAssignmentsListCall) Context(ctx context.Context) *RoleAssignmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoleAssignmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoleAssignmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roleassignments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roleAssignments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *RoleAssignments.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RoleAssignmentsListCall) Do(opts ...googleapi.CallOption) (*RoleAssignments, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RoleAssignments{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RoleAssignmentsListCall) Pages(ctx context.Context, f func(*RoleAssignments) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RolesDeleteCall struct {
	s          *Service
	customer   string
	roleId     string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a role.
//
// - customer: Immutable ID of the Google Workspace account.
// - roleId: Immutable ID of the role.
func (r *RolesService) Delete(customer string, roleId string) *RolesDeleteCall {
	c := &RolesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.roleId = roleId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RolesDeleteCall) Fields(s ...googleapi.Field) *RolesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RolesDeleteCall) Context(ctx context.Context) *RolesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RolesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RolesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roles/{roleId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
		"roleId":   c.roleId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roles.delete" call.
func (c *RolesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type RolesGetCall struct {
	s            *Service
	customer     string
	roleId       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a role.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
//   - roleId: Immutable ID of the role.
func (r *RolesService) Get(customer string, roleId string) *RolesGetCall {
	c := &RolesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.roleId = roleId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RolesGetCall) Fields(s ...googleapi.Field) *RolesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RolesGetCall) IfNoneMatch(entityTag string) *RolesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RolesGetCall) Context(ctx context.Context) *RolesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RolesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RolesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roles/{roleId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
		"roleId":   c.roleId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Role.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RolesGetCall) Do(opts ...googleapi.CallOption) (*Role, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Role{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type RolesInsertCall struct {
	s          *Service
	customer   string
	role       *Role
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a role.
//
// - customer: Immutable ID of the Google Workspace account.
func (r *RolesService) Insert(customer string, role *Role) *RolesInsertCall {
	c := &RolesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.role = role
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RolesInsertCall) Fields(s ...googleapi.Field) *RolesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RolesInsertCall) Context(ctx context.Context) *RolesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RolesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RolesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.role)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roles.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Role.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RolesInsertCall) Do(opts ...googleapi.CallOption) (*Role, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Role{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type RolesListCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a paginated list of all the roles in a domain.
//
//   - customer: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
func (r *RolesService) List(customer string) *RolesListCall {
	c := &RolesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return.
func (c *RolesListCall) MaxResults(maxResults int64) *RolesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the next
// page in the list.
func (c *RolesListCall) PageToken(pageToken string) *RolesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RolesListCall) Fields(s ...googleapi.Field) *RolesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RolesListCall) IfNoneMatch(entityTag string) *RolesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RolesListCall) Context(ctx context.Context) *RolesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RolesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RolesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Roles.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RolesListCall) Do(opts ...googleapi.CallOption) (*Roles, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Roles{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RolesListCall) Pages(ctx context.Context, f func(*Roles) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RolesPatchCall struct {
	s          *Service
	customer   string
	roleId     string
	role       *Role
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Patches a role.
//
// - customer: Immutable ID of the Google Workspace account.
// - roleId: Immutable ID of the role.
func (r *RolesService) Patch(customer string, roleId string, role *Role) *RolesPatchCall {
	c := &RolesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.roleId = roleId
	c.role = role
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RolesPatchCall) Fields(s ...googleapi.Field) *RolesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RolesPatchCall) Context(ctx context.Context) *RolesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RolesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RolesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.role)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roles/{roleId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
		"roleId":   c.roleId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roles.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Role.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RolesPatchCall) Do(opts ...googleapi.CallOption) (*Role, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Role{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type RolesUpdateCall struct {
	s          *Service
	customer   string
	roleId     string
	role       *Role
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a role.
//
// - customer: Immutable ID of the Google Workspace account.
// - roleId: Immutable ID of the role.
func (r *RolesService) Update(customer string, roleId string, role *Role) *RolesUpdateCall {
	c := &RolesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	c.roleId = roleId
	c.role = role
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RolesUpdateCall) Fields(s ...googleapi.Field) *RolesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RolesUpdateCall) Context(ctx context.Context) *RolesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RolesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RolesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.role)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customer}/roles/{roleId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
		"roleId":   c.roleId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.roles.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Role.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RolesUpdateCall) Do(opts ...googleapi.CallOption) (*Role, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Role{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type SchemasDeleteCall struct {
	s          *Service
	customerId string
	schemaKey  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a schema.
//
// - customerId: Immutable ID of the Google Workspace account.
// - schemaKey: Name or immutable ID of the schema.
func (r *SchemasService) Delete(customerId string, schemaKey string) *SchemasDeleteCall {
	c := &SchemasDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.schemaKey = schemaKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SchemasDeleteCall) Fields(s ...googleapi.Field) *SchemasDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SchemasDeleteCall) Context(ctx context.Context) *SchemasDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SchemasDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SchemasDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"schemaKey":  c.schemaKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.schemas.delete" call.
func (c *SchemasDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type SchemasGetCall struct {
	s            *Service
	customerId   string
	schemaKey    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a schema.
//
//   - customerId: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
//   - schemaKey: Name or immutable ID of the schema.
func (r *SchemasService) Get(customerId string, schemaKey string) *SchemasGetCall {
	c := &SchemasGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.schemaKey = schemaKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SchemasGetCall) Fields(s ...googleapi.Field) *SchemasGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SchemasGetCall) IfNoneMatch(entityTag string) *SchemasGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SchemasGetCall) Context(ctx context.Context) *SchemasGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SchemasGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SchemasGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"schemaKey":  c.schemaKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.schemas.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Schema.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SchemasGetCall) Do(opts ...googleapi.CallOption) (*Schema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Schema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type SchemasInsertCall struct {
	s          *Service
	customerId string
	schema     *Schema
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a schema.
//
// - customerId: Immutable ID of the Google Workspace account.
func (r *SchemasService) Insert(customerId string, schema *Schema) *SchemasInsertCall {
	c := &SchemasInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.schema = schema
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SchemasInsertCall) Fields(s ...googleapi.Field) *SchemasInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SchemasInsertCall) Context(ctx context.Context) *SchemasInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SchemasInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SchemasInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.schema)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/schemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.schemas.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Schema.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SchemasInsertCall) Do(opts ...googleapi.CallOption) (*Schema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Schema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type SchemasListCall struct {
	s            *Service
	customerId   string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves all schemas for a customer.
//
//   - customerId: The unique ID for the customer's Google Workspace account. In
//     case of a multi-domain account, to fetch all groups for a customer, use
//     this field instead of `domain`. You can also use the `my_customer` alias
//     to represent your account's `customerId`. The `customerId` is also
//     returned as part of the Users (/admin-sdk/directory/v1/reference/users)
//     resource. You must provide either the `customer` or the `domain`
//     parameter.
func (r *SchemasService) List(customerId string) *SchemasListCall {
	c := &SchemasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SchemasListCall) Fields(s ...googleapi.Field) *SchemasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SchemasListCall) IfNoneMatch(entityTag string) *SchemasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SchemasListCall) Context(ctx context.Context) *SchemasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SchemasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SchemasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/schemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.schemas.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Schemas.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SchemasListCall) Do(opts ...googleapi.CallOption) (*Schemas, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Schemas{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type SchemasPatchCall struct {
	s          *Service
	customerId string
	schemaKey  string
	schema     *Schema
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Patches a schema.
//
// - customerId: Immutable ID of the Google Workspace account.
// - schemaKey: Name or immutable ID of the schema.
func (r *SchemasService) Patch(customerId string, schemaKey string, schema *Schema) *SchemasPatchCall {
	c := &SchemasPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.schemaKey = schemaKey
	c.schema = schema
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SchemasPatchCall) Fields(s ...googleapi.Field) *SchemasPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SchemasPatchCall) Context(ctx context.Context) *SchemasPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SchemasPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SchemasPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.schema)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"schemaKey":  c.schemaKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.schemas.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Schema.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SchemasPatchCall) Do(opts ...googleapi.CallOption) (*Schema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Schema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type SchemasUpdateCall struct {
	s          *Service
	customerId string
	schemaKey  string
	schema     *Schema
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a schema.
//
// - customerId: Immutable ID of the Google Workspace account.
// - schemaKey: Name or immutable ID of the schema.
func (r *SchemasService) Update(customerId string, schemaKey string, schema *Schema) *SchemasUpdateCall {
	c := &SchemasUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customerId = customerId
	c.schemaKey = schemaKey
	c.schema = schema
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SchemasUpdateCall) Fields(s ...googleapi.Field) *SchemasUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SchemasUpdateCall) Context(ctx context.Context) *SchemasUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SchemasUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SchemasUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.schema)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customerId": c.customerId,
		"schemaKey":  c.schemaKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.schemas.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Schema.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SchemasUpdateCall) Do(opts ...googleapi.CallOption) (*Schema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Schema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TokensDeleteCall struct {
	s          *Service
	userKey    string
	clientId   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes all access tokens issued by a user for an application.
//
//   - clientId: The Client ID of the application the token is issued to.
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *TokensService) Delete(userKey string, clientId string) *TokensDeleteCall {
	c := &TokensDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.clientId = clientId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TokensDeleteCall) Fields(s ...googleapi.Field) *TokensDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TokensDeleteCall) Context(ctx context.Context) *TokensDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TokensDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TokensDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/tokens/{clientId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey":  c.userKey,
		"clientId": c.clientId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.tokens.delete" call.
func (c *TokensDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type TokensGetCall struct {
	s            *Service
	userKey      string
	clientId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about an access token issued by a user.
//
//   - clientId: The Client ID of the application the token is issued to.
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *TokensService) Get(userKey string, clientId string) *TokensGetCall {
	c := &TokensGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.clientId = clientId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TokensGetCall) Fields(s ...googleapi.Field) *TokensGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TokensGetCall) IfNoneMatch(entityTag string) *TokensGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TokensGetCall) Context(ctx context.Context) *TokensGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TokensGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TokensGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/tokens/{clientId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey":  c.userKey,
		"clientId": c.clientId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.tokens.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Token.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TokensGetCall) Do(opts ...googleapi.CallOption) (*Token, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Token{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TokensListCall struct {
	s            *Service
	userKey      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the set of tokens specified user has issued to 3rd party
// applications.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *TokensService) List(userKey string) *TokensListCall {
	c := &TokensListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TokensListCall) Fields(s ...googleapi.Field) *TokensListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TokensListCall) IfNoneMatch(entityTag string) *TokensListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TokensListCall) Context(ctx context.Context) *TokensListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TokensListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TokensListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/tokens")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.tokens.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Tokens.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TokensListCall) Do(opts ...googleapi.CallOption) (*Tokens, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Tokens{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type TwoStepVerificationTurnOffCall struct {
	s          *Service
	userKey    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// TurnOff: Turns off 2-Step Verification for user.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *TwoStepVerificationService) TurnOff(userKey string) *TwoStepVerificationTurnOffCall {
	c := &TwoStepVerificationTurnOffCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TwoStepVerificationTurnOffCall) Fields(s ...googleapi.Field) *TwoStepVerificationTurnOffCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TwoStepVerificationTurnOffCall) Context(ctx context.Context) *TwoStepVerificationTurnOffCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TwoStepVerificationTurnOffCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TwoStepVerificationTurnOffCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/twoStepVerification/turnOff")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.twoStepVerification.turnOff" call.
func (c *TwoStepVerificationTurnOffCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type UsersDeleteCall struct {
	s          *Service
	userKey    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a user.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersService) Delete(userKey string) *UsersDeleteCall {
	c := &UsersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersDeleteCall) Fields(s ...googleapi.Field) *UsersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersDeleteCall) Context(ctx context.Context) *UsersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.delete" call.
func (c *UsersDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type UsersGetCall struct {
	s            *Service
	userKey      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a user.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersService) Get(userKey string) *UsersGetCall {
	c := &UsersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// CustomFieldMask sets the optional parameter "customFieldMask": A
// comma-separated list of schema names. All fields from these schemas are
// fetched. This should only be set when `projection=custom`.
func (c *UsersGetCall) CustomFieldMask(customFieldMask string) *UsersGetCall {
	c.urlParams_.Set("customFieldMask", customFieldMask)
	return c
}

// Projection sets the optional parameter "projection": What subset of fields
// to fetch for this user.
//
// Possible values:
//
//	"basic" (default) - Do not include any custom fields for the user.
//	"custom" - Include custom fields from schemas requested in
//
// `customFieldMask`.
//
//	"full" - Include all fields associated with this user.
func (c *UsersGetCall) Projection(projection string) *UsersGetCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// ViewType sets the optional parameter "viewType": Whether to fetch the
// administrator-only or domain-wide public view of the user. For more
// information, see Retrieve a user as a non-administrator
// (/admin-sdk/directory/v1/guides/manage-users#retrieve_users_non_admin).
//
// Possible values:
//
//	"admin_view" (default) - Results include both administrator-only and
//
// domain-public fields for the user.
//
//	"domain_public" - Results only include fields for the user that are
//
// publicly visible to other users in the domain.
func (c *UsersGetCall) ViewType(viewType string) *UsersGetCall {
	c.urlParams_.Set("viewType", viewType)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersGetCall) Fields(s ...googleapi.Field) *UsersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UsersGetCall) IfNoneMatch(entityTag string) *UsersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersGetCall) Context(ctx context.Context) *UsersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *User.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersGetCall) Do(opts ...googleapi.CallOption) (*User, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &User{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersInsertCall struct {
	s          *Service
	user       *User
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a user. Mutate calls immediately following user creation
// might sometimes fail as the user isn't fully created due to propagation
// delay in our backends. Check the error details for the "User creation is not
// complete" message to see if this is the case. Retrying the calls after some
// time can help in this case. If `resolveConflictAccount` is set to `true`, a
// `202` response code means that a conflicting unmanaged account exists and
// was invited to join the organization. A `409` response code means that a
// conflicting account exists so the user wasn't created based on the handling
// unmanaged user accounts (https://support.google.com/a/answer/11112794)
// option selected.
func (r *UsersService) Insert(user *User) *UsersInsertCall {
	c := &UsersInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.user = user
	return c
}

// ResolveConflictAccount sets the optional parameter "resolveConflictAccount":
// If set to `true`, the option selected for handling unmanaged user accounts
// (https://support.google.com/a/answer/11112794) will apply. Default: `false`
func (c *UsersInsertCall) ResolveConflictAccount(resolveConflictAccount bool) *UsersInsertCall {
	c.urlParams_.Set("resolveConflictAccount", fmt.Sprint(resolveConflictAccount))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersInsertCall) Fields(s ...googleapi.Field) *UsersInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersInsertCall) Context(ctx context.Context) *UsersInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.user)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *User.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersInsertCall) Do(opts ...googleapi.CallOption) (*User, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &User{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a paginated list of either deleted users or all users in a
// domain.
func (r *UsersService) List() *UsersListCall {
	c := &UsersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// CustomFieldMask sets the optional parameter "customFieldMask": A
// comma-separated list of schema names. All fields from these schemas are
// fetched. This should only be set when `projection=custom`.
func (c *UsersListCall) CustomFieldMask(customFieldMask string) *UsersListCall {
	c.urlParams_.Set("customFieldMask", customFieldMask)
	return c
}

// Customer sets the optional parameter "customer": The unique ID for the
// customer's Google Workspace account. In case of a multi-domain account, to
// fetch all users for a customer, use this field instead of `domain`. You can
// also use the `my_customer` alias to represent your account's `customerId`.
// The `customerId` is also returned as part of the Users
// (/admin-sdk/directory/v1/reference/users) resource. You must provide either
// the `customer` or the `domain` parameter.
func (c *UsersListCall) Customer(customer string) *UsersListCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Domain sets the optional parameter "domain": The domain name. Use this field
// to get users from only one domain. To return all domains for a customer
// account, use the `customer` query parameter instead. Either the `customer`
// or the `domain` parameter must be provided.
func (c *UsersListCall) Domain(domain string) *UsersListCall {
	c.urlParams_.Set("domain", domain)
	return c
}

// Event sets the optional parameter "event": Event on which subscription is
// intended (if subscribing)
//
// Possible values:
//
//	"add" - User Created Event
//	"delete" - User Deleted Event
//	"makeAdmin" - User Admin Status Change Event
//	"undelete" - User Undeleted Event
//	"update" - User Updated Event
func (c *UsersListCall) Event(event string) *UsersListCall {
	c.urlParams_.Set("event", event)
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return.
func (c *UsersListCall) MaxResults(maxResults int64) *UsersListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Property to use for sorting
// results.
//
// Possible values:
//
//	"email" - Primary email of the user.
//	"familyName" - User's family name.
//	"givenName" - User's given name.
func (c *UsersListCall) OrderBy(orderBy string) *UsersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list
func (c *UsersListCall) PageToken(pageToken string) *UsersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Projection sets the optional parameter "projection": What subset of fields
// to fetch for this user.
//
// Possible values:
//
//	"basic" (default) - Do not include any custom fields for the user.
//	"custom" - Include custom fields from schemas requested in
//
// `customFieldMask`.
//
//	"full" - Include all fields associated with this user.
func (c *UsersListCall) Projection(projection string) *UsersListCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Query sets the optional parameter "query": Query string for searching user
// fields. For more information on constructing user queries, see Search for
// Users (/admin-sdk/directory/v1/guides/search-users).
func (c *UsersListCall) Query(query string) *UsersListCall {
	c.urlParams_.Set("query", query)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If set to `true`,
// retrieves the list of deleted users. (Default: `false`)
func (c *UsersListCall) ShowDeleted(showDeleted string) *UsersListCall {
	c.urlParams_.Set("showDeleted", showDeleted)
	return c
}

// SortOrder sets the optional parameter "sortOrder": Whether to return results
// in ascending or descending order, ignoring case.
//
// Possible values:
//
//	"ASCENDING" - Ascending order.
//	"DESCENDING" - Descending order.
func (c *UsersListCall) SortOrder(sortOrder string) *UsersListCall {
	c.urlParams_.Set("sortOrder", sortOrder)
	return c
}

// ViewType sets the optional parameter "viewType": Whether to fetch the
// administrator-only or domain-wide public view of the user. For more
// information, see Retrieve a user as a non-administrator
// (/admin-sdk/directory/v1/guides/manage-users#retrieve_users_non_admin).
//
// Possible values:
//
//	"admin_view" (default) - Results include both administrator-only and
//
// domain-public fields for the user.
//
//	"domain_public" - Results only include fields for the user that are
//
// publicly visible to other users in the domain.
func (c *UsersListCall) ViewType(viewType string) *UsersListCall {
	c.urlParams_.Set("viewType", viewType)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersListCall) Fields(s ...googleapi.Field) *UsersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UsersListCall) IfNoneMatch(entityTag string) *UsersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersListCall) Context(ctx context.Context) *UsersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Users.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersListCall) Do(opts ...googleapi.CallOption) (*Users, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Users{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *UsersListCall) Pages(ctx context.Context, f func(*Users) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type UsersMakeAdminCall struct {
	s             *Service
	userKey       string
	usermakeadmin *UserMakeAdmin
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// MakeAdmin: Makes a user a super administrator.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersService) MakeAdmin(userKey string, usermakeadmin *UserMakeAdmin) *UsersMakeAdminCall {
	c := &UsersMakeAdminCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.usermakeadmin = usermakeadmin
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersMakeAdminCall) Fields(s ...googleapi.Field) *UsersMakeAdminCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersMakeAdminCall) Context(ctx context.Context) *UsersMakeAdminCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersMakeAdminCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersMakeAdminCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.usermakeadmin)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/makeAdmin")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.makeAdmin" call.
func (c *UsersMakeAdminCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type UsersPatchCall struct {
	s          *Service
	userKey    string
	user       *User
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a user using patch semantics. The update method should be
// used instead, because it also supports patch semantics and has better
// performance. If you're mapping an external identity to a Google identity,
// use the `update`
// (https://developers.google.com/admin-sdk/directory/v1/reference/users/update)
// method instead of the `patch` method. This method is unable to clear fields
// that contain repeated objects (`addresses`, `phones`, etc). Use the update
// method instead.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersService) Patch(userKey string, user *User) *UsersPatchCall {
	c := &UsersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.user = user
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersPatchCall) Fields(s ...googleapi.Field) *UsersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersPatchCall) Context(ctx context.Context) *UsersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.user)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *User.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersPatchCall) Do(opts ...googleapi.CallOption) (*User, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &User{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersSignOutCall struct {
	s          *Service
	userKey    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// SignOut: Signs a user out of all web and device sessions and reset their
// sign-in cookies. User will have to sign in by authenticating again.
//
//   - userKey: Identifies the target user in the API request. The value can be
//     the user's primary email address, alias email address, or unique user ID.
func (r *UsersService) SignOut(userKey string) *UsersSignOutCall {
	c := &UsersSignOutCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersSignOutCall) Fields(s ...googleapi.Field) *UsersSignOutCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersSignOutCall) Context(ctx context.Context) *UsersSignOutCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersSignOutCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersSignOutCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/signOut")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.signOut" call.
func (c *UsersSignOutCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type UsersUndeleteCall struct {
	s            *Service
	userKey      string
	userundelete *UserUndelete
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Undelete: Undeletes a deleted user.
//
// - userKey: The immutable id of the user.
func (r *UsersService) Undelete(userKey string, userundelete *UserUndelete) *UsersUndeleteCall {
	c := &UsersUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.userundelete = userundelete
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersUndeleteCall) Fields(s ...googleapi.Field) *UsersUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersUndeleteCall) Context(ctx context.Context) *UsersUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.userundelete)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.undelete" call.
func (c *UsersUndeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type UsersUpdateCall struct {
	s          *Service
	userKey    string
	user       *User
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a user. This method supports patch semantics, meaning that
// you only need to include the fields you wish to update. Fields that are not
// present in the request will be preserved, and fields set to `null` will be
// cleared. For repeating fields that contain arrays, individual items in the
// array can't be patched piecemeal; they must be supplied in the request body
// with the desired values for all items. See the user accounts guide
// (https://developers.google.com/admin-sdk/directory/v1/guides/manage-users#update_user)
// for more information.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersService) Update(userKey string, user *User) *UsersUpdateCall {
	c := &UsersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.user = user
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersUpdateCall) Fields(s ...googleapi.Field) *UsersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersUpdateCall) Context(ctx context.Context) *UsersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.user)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *User.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersUpdateCall) Do(opts ...googleapi.CallOption) (*User, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &User{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersWatchCall struct {
	s          *Service
	channel    *Channel
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Watch: Watches for changes in users list.
func (r *UsersService) Watch(channel *Channel) *UsersWatchCall {
	c := &UsersWatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.channel = channel
	return c
}

// CustomFieldMask sets the optional parameter "customFieldMask":
// Comma-separated list of schema names. All fields from these schemas are
// fetched. This should only be set when projection=custom.
func (c *UsersWatchCall) CustomFieldMask(customFieldMask string) *UsersWatchCall {
	c.urlParams_.Set("customFieldMask", customFieldMask)
	return c
}

// Customer sets the optional parameter "customer": Immutable ID of the Google
// Workspace account. In case of multi-domain, to fetch all users for a
// customer, fill this field instead of domain.
func (c *UsersWatchCall) Customer(customer string) *UsersWatchCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Domain sets the optional parameter "domain": Name of the domain. Fill this
// field to get users from only this domain. To return all users in a
// multi-domain fill customer field instead."
func (c *UsersWatchCall) Domain(domain string) *UsersWatchCall {
	c.urlParams_.Set("domain", domain)
	return c
}

// Event sets the optional parameter "event": Events to watch for.
//
// Possible values:
//
//	"add" - User Created Event
//	"delete" - User Deleted Event
//	"makeAdmin" - User Admin Status Change Event
//	"undelete" - User Undeleted Event
//	"update" - User Updated Event
func (c *UsersWatchCall) Event(event string) *UsersWatchCall {
	c.urlParams_.Set("event", event)
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to return.
func (c *UsersWatchCall) MaxResults(maxResults int64) *UsersWatchCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Column to use for sorting
// results
//
// Possible values:
//
//	"email" - Primary email of the user.
//	"familyName" - User's family name.
//	"givenName" - User's given name.
func (c *UsersWatchCall) OrderBy(orderBy string) *UsersWatchCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list
func (c *UsersWatchCall) PageToken(pageToken string) *UsersWatchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Projection sets the optional parameter "projection": What subset of fields
// to fetch for this user.
//
// Possible values:
//
//	"basic" (default) - Do not include any custom fields for the user.
//	"custom" - Include custom fields from schemas mentioned in
//
// customFieldMask.
//
//	"full" - Include all fields associated with this user.
func (c *UsersWatchCall) Projection(projection string) *UsersWatchCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// Query sets the optional parameter "query": Query string search. Should be of
// the form "". Complete documentation is at https:
// //developers.google.com/admin-sdk/directory/v1/guides/search-users
func (c *UsersWatchCall) Query(query string) *UsersWatchCall {
	c.urlParams_.Set("query", query)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If set to true,
// retrieves the list of deleted users. (Default: false)
func (c *UsersWatchCall) ShowDeleted(showDeleted string) *UsersWatchCall {
	c.urlParams_.Set("showDeleted", showDeleted)
	return c
}

// SortOrder sets the optional parameter "sortOrder": Whether to return results
// in ascending or descending order.
//
// Possible values:
//
//	"ASCENDING" - Ascending order.
//	"DESCENDING" - Descending order.
func (c *UsersWatchCall) SortOrder(sortOrder string) *UsersWatchCall {
	c.urlParams_.Set("sortOrder", sortOrder)
	return c
}

// ViewType sets the optional parameter "viewType": Whether to fetch the
// administrator-only or domain-wide public view of the user. For more
// information, see Retrieve a user as a non-administrator
// (/admin-sdk/directory/v1/guides/manage-users#retrieve_users_non_admin).
//
// Possible values:
//
//	"admin_view" (default) - Results include both administrator-only and
//
// domain-public fields.
//
//	"domain_public" - Results only include fields for the user that are
//
// publicly visible to other users in the domain.
func (c *UsersWatchCall) ViewType(viewType string) *UsersWatchCall {
	c.urlParams_.Set("viewType", viewType)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersWatchCall) Fields(s ...googleapi.Field) *UsersWatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersWatchCall) Context(ctx context.Context) *UsersWatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersWatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersWatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.channel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/watch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.watch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Channel.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersWatchCall) Do(opts ...googleapi.CallOption) (*Channel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Channel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersAliasesDeleteCall struct {
	s          *Service
	userKey    string
	alias      string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes an alias.
//
//   - alias: The alias to be removed.
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersAliasesService) Delete(userKey string, alias string) *UsersAliasesDeleteCall {
	c := &UsersAliasesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.alias = alias
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersAliasesDeleteCall) Fields(s ...googleapi.Field) *UsersAliasesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersAliasesDeleteCall) Context(ctx context.Context) *UsersAliasesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersAliasesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersAliasesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/aliases/{alias}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
		"alias":   c.alias,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.aliases.delete" call.
func (c *UsersAliasesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type UsersAliasesInsertCall struct {
	s          *Service
	userKey    string
	alias      *Alias
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Adds an alias.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersAliasesService) Insert(userKey string, alias *Alias) *UsersAliasesInsertCall {
	c := &UsersAliasesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.alias = alias
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersAliasesInsertCall) Fields(s ...googleapi.Field) *UsersAliasesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersAliasesInsertCall) Context(ctx context.Context) *UsersAliasesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersAliasesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersAliasesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.alias)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/aliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.aliases.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Alias.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersAliasesInsertCall) Do(opts ...googleapi.CallOption) (*Alias, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Alias{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersAliasesListCall struct {
	s            *Service
	userKey      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all aliases for a user.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersAliasesService) List(userKey string) *UsersAliasesListCall {
	c := &UsersAliasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Event sets the optional parameter "event": Events to watch for.
//
// Possible values:
//
//	"add" - Alias Created Event
//	"delete" - Alias Deleted Event
func (c *UsersAliasesListCall) Event(event string) *UsersAliasesListCall {
	c.urlParams_.Set("event", event)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersAliasesListCall) Fields(s ...googleapi.Field) *UsersAliasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UsersAliasesListCall) IfNoneMatch(entityTag string) *UsersAliasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersAliasesListCall) Context(ctx context.Context) *UsersAliasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersAliasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersAliasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/aliases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.aliases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Aliases.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersAliasesListCall) Do(opts ...googleapi.CallOption) (*Aliases, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Aliases{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersAliasesWatchCall struct {
	s          *Service
	userKey    string
	channel    *Channel
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Watch: Watches for changes in users list.
//
// - userKey: Email or immutable ID of the user.
func (r *UsersAliasesService) Watch(userKey string, channel *Channel) *UsersAliasesWatchCall {
	c := &UsersAliasesWatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.channel = channel
	return c
}

// Event sets the optional parameter "event": Events to watch for.
//
// Possible values:
//
//	"add" - Alias Created Event
//	"delete" - Alias Deleted Event
func (c *UsersAliasesWatchCall) Event(event string) *UsersAliasesWatchCall {
	c.urlParams_.Set("event", event)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersAliasesWatchCall) Fields(s ...googleapi.Field) *UsersAliasesWatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersAliasesWatchCall) Context(ctx context.Context) *UsersAliasesWatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersAliasesWatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersAliasesWatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.channel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/aliases/watch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.aliases.watch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Channel.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersAliasesWatchCall) Do(opts ...googleapi.CallOption) (*Channel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Channel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersPhotosDeleteCall struct {
	s          *Service
	userKey    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes the user's photo.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersPhotosService) Delete(userKey string) *UsersPhotosDeleteCall {
	c := &UsersPhotosDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersPhotosDeleteCall) Fields(s ...googleapi.Field) *UsersPhotosDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersPhotosDeleteCall) Context(ctx context.Context) *UsersPhotosDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersPhotosDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersPhotosDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/photos/thumbnail")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.photos.delete" call.
func (c *UsersPhotosDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type UsersPhotosGetCall struct {
	s            *Service
	userKey      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the user's photo.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersPhotosService) Get(userKey string) *UsersPhotosGetCall {
	c := &UsersPhotosGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersPhotosGetCall) Fields(s ...googleapi.Field) *UsersPhotosGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UsersPhotosGetCall) IfNoneMatch(entityTag string) *UsersPhotosGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersPhotosGetCall) Context(ctx context.Context) *UsersPhotosGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersPhotosGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersPhotosGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/photos/thumbnail")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.photos.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserPhoto.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersPhotosGetCall) Do(opts ...googleapi.CallOption) (*UserPhoto, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserPhoto{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersPhotosPatchCall struct {
	s          *Service
	userKey    string
	userphoto  *UserPhoto
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Adds a photo for the user. This method supports patch semantics
// (/admin-sdk/directory/v1/guides/performance#patch).
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersPhotosService) Patch(userKey string, userphoto *UserPhoto) *UsersPhotosPatchCall {
	c := &UsersPhotosPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.userphoto = userphoto
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersPhotosPatchCall) Fields(s ...googleapi.Field) *UsersPhotosPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersPhotosPatchCall) Context(ctx context.Context) *UsersPhotosPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersPhotosPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersPhotosPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.userphoto)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/photos/thumbnail")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.photos.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserPhoto.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersPhotosPatchCall) Do(opts ...googleapi.CallOption) (*UserPhoto, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserPhoto{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type UsersPhotosUpdateCall struct {
	s          *Service
	userKey    string
	userphoto  *UserPhoto
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Adds a photo for the user.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *UsersPhotosService) Update(userKey string, userphoto *UserPhoto) *UsersPhotosUpdateCall {
	c := &UsersPhotosUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.userphoto = userphoto
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersPhotosUpdateCall) Fields(s ...googleapi.Field) *UsersPhotosUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersPhotosUpdateCall) Context(ctx context.Context) *UsersPhotosUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersPhotosUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersPhotosUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.userphoto)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/photos/thumbnail")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.users.photos.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *UserPhoto.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersPhotosUpdateCall) Do(opts ...googleapi.CallOption) (*UserPhoto, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UserPhoto{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type VerificationCodesGenerateCall struct {
	s          *Service
	userKey    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Generate: Generates new backup verification codes for the user.
//
// - userKey: Email or immutable ID of the user.
func (r *VerificationCodesService) Generate(userKey string) *VerificationCodesGenerateCall {
	c := &VerificationCodesGenerateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *VerificationCodesGenerateCall) Fields(s ...googleapi.Field) *VerificationCodesGenerateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *VerificationCodesGenerateCall) Context(ctx context.Context) *VerificationCodesGenerateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *VerificationCodesGenerateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VerificationCodesGenerateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/verificationCodes/generate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.verificationCodes.generate" call.
func (c *VerificationCodesGenerateCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type VerificationCodesInvalidateCall struct {
	s          *Service
	userKey    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Invalidate: Invalidates the current backup verification codes for the user.
//
// - userKey: Email or immutable ID of the user.
func (r *VerificationCodesService) Invalidate(userKey string) *VerificationCodesInvalidateCall {
	c := &VerificationCodesInvalidateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *VerificationCodesInvalidateCall) Fields(s ...googleapi.Field) *VerificationCodesInvalidateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *VerificationCodesInvalidateCall) Context(ctx context.Context) *VerificationCodesInvalidateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *VerificationCodesInvalidateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VerificationCodesInvalidateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/verificationCodes/invalidate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.verificationCodes.invalidate" call.
func (c *VerificationCodesInvalidateCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
}

type VerificationCodesListCall struct {
	s            *Service
	userKey      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the current set of valid backup verification codes for the
// specified user.
//
//   - userKey: Identifies the user in the API request. The value can be the
//     user's primary email address, alias email address, or unique user ID.
func (r *VerificationCodesService) List(userKey string) *VerificationCodesListCall {
	c := &VerificationCodesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *VerificationCodesListCall) Fields(s ...googleapi.Field) *VerificationCodesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *VerificationCodesListCall) IfNoneMatch(entityTag string) *VerificationCodesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *VerificationCodesListCall) Context(ctx context.Context) *VerificationCodesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *VerificationCodesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *VerificationCodesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/directory/v1/users/{userKey}/verificationCodes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "directory.verificationCodes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *VerificationCodes.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *VerificationCodesListCall) Do(opts ...googleapi.CallOption) (*VerificationCodes, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &VerificationCodes{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
