package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DomainsClient is the webSite Management Client
type DomainsClient struct {
	BaseClient
}

// NewDomainsClient creates an instance of the DomainsClient client.
func NewDomainsClient(subscriptionID string) DomainsClient {
	return NewDomainsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDomainsClientWithBaseURI creates an instance of the DomainsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDomainsClientWithBaseURI(baseURI string, subscriptionID string) DomainsClient {
	return DomainsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckAvailability check if a domain is available for registration.
// Parameters:
// identifier - name of the domain.
func (client DomainsClient) CheckAvailability(ctx context.Context, identifier NameIdentifier) (result DomainAvailablilityCheckResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.CheckAvailability")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CheckAvailabilityPreparer(ctx, identifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CheckAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CheckAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CheckAvailability", resp, "Failure responding to request")
		return
	}

	return
}

// CheckAvailabilityPreparer prepares the CheckAvailability request.
func (client DomainsClient) CheckAvailabilityPreparer(ctx context.Context, identifier NameIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/checkDomainAvailability", pathParameters),
		autorest.WithJSON(identifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckAvailabilitySender sends the CheckAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) CheckAvailabilitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckAvailabilityResponder handles the response to the CheckAvailability request. The method always
// closes the http.Response Body.
func (client DomainsClient) CheckAvailabilityResponder(resp *http.Response) (result DomainAvailablilityCheckResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates or updates a domain.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of the domain.
// domain - domain registration information.
func (client DomainsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, domainName string, domain Domain) (result DomainsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: domainName,
			Constraints: []validation.Constraint{{Target: "domainName", Name: validation.Pattern, Rule: `[a-zA-Z0-9][a-zA-Z0-9\.-]+`, Chain: nil}}},
		{TargetValue: domain,
			Constraints: []validation.Constraint{{Target: "domain.DomainProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactAdmin", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactAdmin.AddressMailing", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
						}},
						{Target: "domain.DomainProperties.ContactAdmin.Email", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "domain.DomainProperties.ContactAdmin.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "domain.DomainProperties.ContactAdmin.NameLast", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "domain.DomainProperties.ContactAdmin.Phone", Name: validation.Null, Rule: true, Chain: nil},
					}},
					{Target: "domain.DomainProperties.ContactBilling", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactBilling.AddressMailing", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactBilling.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "domain.DomainProperties.ContactBilling.Email", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactBilling.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactBilling.NameLast", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactBilling.Phone", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "domain.DomainProperties.ContactRegistrant", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "domain.DomainProperties.ContactRegistrant.Email", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactRegistrant.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactRegistrant.NameLast", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactRegistrant.Phone", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "domain.DomainProperties.ContactTech", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactTech.AddressMailing", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactTech.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "domain.DomainProperties.ContactTech.Email", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactTech.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactTech.NameLast", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactTech.Phone", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "domain.DomainProperties.Consent", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, domainName, domain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdate", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client DomainsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, domainName string, domain Domain) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", pathParameters),
		autorest.WithJSON(domain),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) CreateOrUpdateSender(req *http.Request) (future DomainsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client DomainsClient) (d Domain, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.DomainsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.DomainsCreateOrUpdateFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		d.Response.Response, err = future.GetResult(sender)
		if d.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.DomainsCreateOrUpdateFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
			d, err = client.CreateOrUpdateResponder(d.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.DomainsCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client DomainsClient) CreateOrUpdateResponder(resp *http.Response) (result Domain, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateOwnershipIdentifier creates an ownership identifier for a domain or updates identifier details for an
// existing identifer
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of domain.
// name - name of identifier.
// domainOwnershipIdentifier - a JSON representation of the domain ownership properties.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (result DomainOwnershipIdentifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.CreateOrUpdateOwnershipIdentifier")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "CreateOrUpdateOwnershipIdentifier", err.Error())
	}

	req, err := client.CreateOrUpdateOwnershipIdentifierPreparer(ctx, resourceGroupName, domainName, name, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdateOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdateOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdateOwnershipIdentifier", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateOwnershipIdentifierPreparer prepares the CreateOrUpdateOwnershipIdentifier request.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifierPreparer(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateOwnershipIdentifierSender sends the CreateOrUpdateOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateOwnershipIdentifierResponder handles the response to the CreateOrUpdateOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifierResponder(resp *http.Response) (result DomainOwnershipIdentifier, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a domain.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of the domain.
// forceHardDeleteDomain - specify <code>true</code> to delete the domain immediately. The default is
// <code>false</code> which deletes the domain after 24 hours.
func (client DomainsClient) Delete(ctx context.Context, resourceGroupName string, domainName string, forceHardDeleteDomain *bool) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, domainName, forceHardDeleteDomain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client DomainsClient) DeletePreparer(ctx context.Context, resourceGroupName string, domainName string, forceHardDeleteDomain *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if forceHardDeleteDomain != nil {
		queryParameters["forceHardDeleteDomain"] = autorest.Encode("query", *forceHardDeleteDomain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client DomainsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteOwnershipIdentifier delete ownership identifier for domain
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of domain.
// name - name of identifier.
func (client DomainsClient) DeleteOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.DeleteOwnershipIdentifier")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "DeleteOwnershipIdentifier", err.Error())
	}

	req, err := client.DeleteOwnershipIdentifierPreparer(ctx, resourceGroupName, domainName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "DeleteOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "DeleteOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "DeleteOwnershipIdentifier", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteOwnershipIdentifierPreparer prepares the DeleteOwnershipIdentifier request.
func (client DomainsClient) DeleteOwnershipIdentifierPreparer(ctx context.Context, resourceGroupName string, domainName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteOwnershipIdentifierSender sends the DeleteOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) DeleteOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteOwnershipIdentifierResponder handles the response to the DeleteOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) DeleteOwnershipIdentifierResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get a domain.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of the domain.
func (client DomainsClient) Get(ctx context.Context, resourceGroupName string, domainName string) (result Domain, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client DomainsClient) GetPreparer(ctx context.Context, resourceGroupName string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DomainsClient) GetResponder(resp *http.Response) (result Domain, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetControlCenterSsoRequest generate a single sign-on request for the domain management portal.
func (client DomainsClient) GetControlCenterSsoRequest(ctx context.Context) (result DomainControlCenterSsoRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.GetControlCenterSsoRequest")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetControlCenterSsoRequestPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetControlCenterSsoRequest", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetControlCenterSsoRequestSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetControlCenterSsoRequest", resp, "Failure sending request")
		return
	}

	result, err = client.GetControlCenterSsoRequestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetControlCenterSsoRequest", resp, "Failure responding to request")
		return
	}

	return
}

// GetControlCenterSsoRequestPreparer prepares the GetControlCenterSsoRequest request.
func (client DomainsClient) GetControlCenterSsoRequestPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/generateSsoRequest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetControlCenterSsoRequestSender sends the GetControlCenterSsoRequest request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) GetControlCenterSsoRequestSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetControlCenterSsoRequestResponder handles the response to the GetControlCenterSsoRequest request. The method always
// closes the http.Response Body.
func (client DomainsClient) GetControlCenterSsoRequestResponder(resp *http.Response) (result DomainControlCenterSsoRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOwnershipIdentifier get ownership identifier for domain
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of domain.
// name - name of identifier.
func (client DomainsClient) GetOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string) (result DomainOwnershipIdentifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.GetOwnershipIdentifier")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "GetOwnershipIdentifier", err.Error())
	}

	req, err := client.GetOwnershipIdentifierPreparer(ctx, resourceGroupName, domainName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.GetOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetOwnershipIdentifier", resp, "Failure responding to request")
		return
	}

	return
}

// GetOwnershipIdentifierPreparer prepares the GetOwnershipIdentifier request.
func (client DomainsClient) GetOwnershipIdentifierPreparer(ctx context.Context, resourceGroupName string, domainName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOwnershipIdentifierSender sends the GetOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) GetOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetOwnershipIdentifierResponder handles the response to the GetOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) GetOwnershipIdentifierResponder(resp *http.Response) (result DomainOwnershipIdentifier, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all domains in a subscription.
func (client DomainsClient) List(ctx context.Context) (result DomainCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.List")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "List", resp, "Failure sending request")
		return
	}

	result.dc, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.dc.hasNextLink() && result.dc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client DomainsClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/domains", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListResponder(resp *http.Response) (result DomainCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client DomainsClient) listNextResults(ctx context.Context, lastResults DomainCollection) (result DomainCollection, err error) {
	req, err := lastResults.domainCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client DomainsClient) ListComplete(ctx context.Context) (result DomainCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListByResourceGroup get all domains in a resource group.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
func (client DomainsClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result DomainCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.dc, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.dc.hasNextLink() && result.dc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client DomainsClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListByResourceGroupResponder(resp *http.Response) (result DomainCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client DomainsClient) listByResourceGroupNextResults(ctx context.Context, lastResults DomainCollection) (result DomainCollection, err error) {
	req, err := lastResults.domainCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client DomainsClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result DomainCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListOwnershipIdentifiers lists domain ownership identifiers.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of domain.
func (client DomainsClient) ListOwnershipIdentifiers(ctx context.Context, resourceGroupName string, domainName string) (result DomainOwnershipIdentifierCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.ListOwnershipIdentifiers")
		defer func() {
			sc := -1
			if result.doic.Response.Response != nil {
				sc = result.doic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "ListOwnershipIdentifiers", err.Error())
	}

	result.fn = client.listOwnershipIdentifiersNextResults
	req, err := client.ListOwnershipIdentifiersPreparer(ctx, resourceGroupName, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOwnershipIdentifiersSender(req)
	if err != nil {
		result.doic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", resp, "Failure sending request")
		return
	}

	result.doic, err = client.ListOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", resp, "Failure responding to request")
		return
	}
	if result.doic.hasNextLink() && result.doic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListOwnershipIdentifiersPreparer prepares the ListOwnershipIdentifiers request.
func (client DomainsClient) ListOwnershipIdentifiersPreparer(ctx context.Context, resourceGroupName string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOwnershipIdentifiersSender sends the ListOwnershipIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListOwnershipIdentifiersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListOwnershipIdentifiersResponder handles the response to the ListOwnershipIdentifiers request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListOwnershipIdentifiersResponder(resp *http.Response) (result DomainOwnershipIdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listOwnershipIdentifiersNextResults retrieves the next set of results, if any.
func (client DomainsClient) listOwnershipIdentifiersNextResults(ctx context.Context, lastResults DomainOwnershipIdentifierCollection) (result DomainOwnershipIdentifierCollection, err error) {
	req, err := lastResults.domainOwnershipIdentifierCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listOwnershipIdentifiersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listOwnershipIdentifiersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "listOwnershipIdentifiersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListOwnershipIdentifiersComplete enumerates all values, automatically crossing page boundaries as required.
func (client DomainsClient) ListOwnershipIdentifiersComplete(ctx context.Context, resourceGroupName string, domainName string) (result DomainOwnershipIdentifierCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.ListOwnershipIdentifiers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListOwnershipIdentifiers(ctx, resourceGroupName, domainName)
	return
}

// ListRecommendations get domain name recommendations based on keywords.
// Parameters:
// parameters - search parameters for domain name recommendations.
func (client DomainsClient) ListRecommendations(ctx context.Context, parameters DomainRecommendationSearchParameters) (result NameIdentifierCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.ListRecommendations")
		defer func() {
			sc := -1
			if result.nic.Response.Response != nil {
				sc = result.nic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listRecommendationsNextResults
	req, err := client.ListRecommendationsPreparer(ctx, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRecommendationsSender(req)
	if err != nil {
		result.nic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", resp, "Failure sending request")
		return
	}

	result.nic, err = client.ListRecommendationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", resp, "Failure responding to request")
		return
	}
	if result.nic.hasNextLink() && result.nic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListRecommendationsPreparer prepares the ListRecommendations request.
func (client DomainsClient) ListRecommendationsPreparer(ctx context.Context, parameters DomainRecommendationSearchParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/listDomainRecommendations", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRecommendationsSender sends the ListRecommendations request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListRecommendationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListRecommendationsResponder handles the response to the ListRecommendations request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListRecommendationsResponder(resp *http.Response) (result NameIdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listRecommendationsNextResults retrieves the next set of results, if any.
func (client DomainsClient) listRecommendationsNextResults(ctx context.Context, lastResults NameIdentifierCollection) (result NameIdentifierCollection, err error) {
	req, err := lastResults.nameIdentifierCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listRecommendationsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListRecommendationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "listRecommendationsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListRecommendationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "listRecommendationsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListRecommendationsComplete enumerates all values, automatically crossing page boundaries as required.
func (client DomainsClient) ListRecommendationsComplete(ctx context.Context, parameters DomainRecommendationSearchParameters) (result NameIdentifierCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.ListRecommendations")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListRecommendations(ctx, parameters)
	return
}

// Renew renew a domain.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of the domain.
func (client DomainsClient) Renew(ctx context.Context, resourceGroupName string, domainName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.Renew")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "Renew", err.Error())
	}

	req, err := client.RenewPreparer(ctx, resourceGroupName, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Renew", nil, "Failure preparing request")
		return
	}

	resp, err := client.RenewSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Renew", resp, "Failure sending request")
		return
	}

	result, err = client.RenewResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Renew", resp, "Failure responding to request")
		return
	}

	return
}

// RenewPreparer prepares the Renew request.
func (client DomainsClient) RenewPreparer(ctx context.Context, resourceGroupName string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/renew", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RenewSender sends the Renew request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) RenewSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RenewResponder handles the response to the Renew request. The method always
// closes the http.Response Body.
func (client DomainsClient) RenewResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update creates or updates a domain.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of the domain.
// domain - domain registration information.
func (client DomainsClient) Update(ctx context.Context, resourceGroupName string, domainName string, domain DomainPatchResource) (result Domain, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: domainName,
			Constraints: []validation.Constraint{{Target: "domainName", Name: validation.Pattern, Rule: `[a-zA-Z0-9][a-zA-Z0-9\.-]+`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, domainName, domain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client DomainsClient) UpdatePreparer(ctx context.Context, resourceGroupName string, domainName string, domain DomainPatchResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", pathParameters),
		autorest.WithJSON(domain),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client DomainsClient) UpdateResponder(resp *http.Response) (result Domain, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateOwnershipIdentifier creates an ownership identifier for a domain or updates identifier details for an existing
// identifer
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// domainName - name of domain.
// name - name of identifier.
// domainOwnershipIdentifier - a JSON representation of the domain ownership properties.
func (client DomainsClient) UpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (result DomainOwnershipIdentifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainsClient.UpdateOwnershipIdentifier")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DomainsClient", "UpdateOwnershipIdentifier", err.Error())
	}

	req, err := client.UpdateOwnershipIdentifierPreparer(ctx, resourceGroupName, domainName, name, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "UpdateOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "UpdateOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "UpdateOwnershipIdentifier", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateOwnershipIdentifierPreparer prepares the UpdateOwnershipIdentifier request.
func (client DomainsClient) UpdateOwnershipIdentifierPreparer(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateOwnershipIdentifierSender sends the UpdateOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) UpdateOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateOwnershipIdentifierResponder handles the response to the UpdateOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) UpdateOwnershipIdentifierResponder(resp *http.Response) (result DomainOwnershipIdentifier, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
