// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { Fragment } from "react";
import { PageHeader } from "mds";
import ObjectManagerButton from "../ObjectManager/ObjectManagerButton";
import DarkModeActivator from "../DarkModeActivator/DarkModeActivator";

interface IPageHeaderWrapper {
  label: React.ReactNode;
  middleComponent?: React.ReactNode;
  actions?: React.ReactNode;
}

const PageHeaderWrapper = ({
  label,
  actions,
  middleComponent,
}: IPageHeaderWrapper) => {
  return (
    <PageHeader
      label={label}
      actions={
        <Fragment>
          {actions}
          <DarkModeActivator />
          <ObjectManagerButton />
        </Fragment>
      }
      middleComponent={middleComponent}
    />
  );
};

export default PageHeaderWrapper;
