// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ReleaseMetadata release metadata
//
// swagger:model releaseMetadata
type ReleaseMetadata struct {

	// assets url
	AssetsURL string `json:"assets_url,omitempty"`

	// author
	Author *ReleaseAuthor `json:"author,omitempty"`

	// created at
	CreatedAt string `json:"created_at,omitempty"`

	// draft
	Draft bool `json:"draft,omitempty"`

	// html url
	HTMLURL string `json:"html_url,omitempty"`

	// id
	ID int64 `json:"id,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// node id
	NodeID string `json:"node_id,omitempty"`

	// prerelease
	Prerelease bool `json:"prerelease,omitempty"`

	// published at
	PublishedAt string `json:"published_at,omitempty"`

	// tag name
	TagName string `json:"tag_name,omitempty"`

	// tarball url
	TarballURL string `json:"tarball_url,omitempty"`

	// target commitish
	TargetCommitish string `json:"target_commitish,omitempty"`

	// upload url
	UploadURL string `json:"upload_url,omitempty"`

	// url
	URL string `json:"url,omitempty"`

	// zipball url
	ZipballURL string `json:"zipball_url,omitempty"`
}

// Validate validates this release metadata
func (m *ReleaseMetadata) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReleaseMetadata) validateAuthor(formats strfmt.Registry) error {
	if swag.IsZero(m.Author) { // not required
		return nil
	}

	if m.Author != nil {
		if err := m.Author.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("author")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("author")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this release metadata based on the context it is used
func (m *ReleaseMetadata) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAuthor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ReleaseMetadata) contextValidateAuthor(ctx context.Context, formats strfmt.Registry) error {

	if m.Author != nil {

		if swag.IsZero(m.Author) { // not required
			return nil
		}

		if err := m.Author.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("author")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("author")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ReleaseMetadata) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ReleaseMetadata) UnmarshalBinary(b []byte) error {
	var res ReleaseMetadata
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
