/*
 * Copyright (c) 2020-2024 Estonian Information System Authority
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

export type CreateProperties = {
  active?: boolean,
  index?: number,
  openerTabId?: number,
  pinned?: boolean,
  selected?: boolean,
  url?: string,
  windowId?: number,
};

export type CreateCallback = (tab: object /* Tab */) => void;

export default interface Tabs {

  /**
   * A special ID value given to tabs that are not browser tabs (for example, tabs in devtools windows).
   */
  TAB_ID_NONE: number;

  /**
   * Creates a new tab.
   *
   * @see https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/API/tabs/create
   */
  create: (
    createProperties: CreateProperties,
    callback?: CreateCallback
  ) => Promise<object /* Tab */>;

  /**
   * Sends a single message from the extension's background scripts (or other privileged scripts,
   * such as popup scripts or options page scripts) to any content scripts or extension pages/iframes
   * that belong to the extension and are running in the specified tab.
   *
   * @see https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/API/tabs/sendMessage
   */
  sendMessage: (
    tabId: number,
    message: object,
    options?: {
      frameId: number;
    }
  ) => Promise<object | void>;
}
