/*
 * Copyright (c) 2020-2024 Estonian Information System Authority
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

export interface NativeAuthenticateRequest {
  command: "authenticate"

  arguments: {
    /**
     * A base64-encoded cryptographic nonce, generated by the server, with at least 256 bits of entropy
     */
    challengeNonce: string;

    /**
     * The origin of the website which initiated the authentication
     *
     * The origin comes from the postMessage API's sender object.
     */
    origin: string;

    /**
     * A two-letter ISO 639-1 language code.
     *
     * If translations exist for the given language, then the user interface will be displayed in this language.
     */
    lang?: string;
  }
}

export interface NativeGetSigningCertificateRequest {
  command: "get-signing-certificate"

  arguments: {
    /**
     * The origin of the website which initiated the authentication
     *
     * The origin comes from the postMessage API's sender object.
     */
    origin: string;

    /**
     * A two-letter ISO 639-1 language code.
     *
     * If translations exist for the given language, then the user interface will be displayed in this language.
     */
    lang?: string;
  }
}

export interface NativeSignRequest {
  command: "sign"

  arguments: {
    /**
     * The Base64-encoded DER-encoded signing certificate of the eID user
     */
    certificate: string;

    /**
     * The Base64-encoded document hash
     */
    hash: string;

    /**
     * The hash function
     *
     * Allowed hash function values are SHA-224, SHA-256, SHA-384, SHA-512, SHA3-224, SHA3-256, SHA3-384, SHA3-512,
     * and the hash function has to be supported by the card (see the hashFunction member of supportedSignatureAlgorithms array elements
     * in the get-signing-certificate command output).
     *
     * The document hash length has to match the hash function output length
     * and the hash function has to be supported by the electronic ID signing implementation.
     */
    hashFunction: string;

    /**
     * The origin of the website which initiated the authentication
     *
     * The origin comes from the postMessage API's sender object.
     */
    origin: string;

    /**
     * A two-letter ISO 639-1 language code.
     *
     * If translations exist for the given language, then the user interface will be displayed in this language.
     */
    lang?: string;
  }
}

export interface NativeQuitRequest {
  command: "quit";

  arguments: Record<string, never>; // Empty object
}

export type NativeRequest
  = NativeAuthenticateRequest
  | NativeGetSigningCertificateRequest
  | NativeSignRequest
  | NativeQuitRequest;
