/*
 * Nudm_UECM
 *
 * Nudm Context Management Service
 *
 * API version: 1.0.1
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package Nudm_UEContextManagement

import (
	"crypto/tls"
	"net/http"

	"golang.org/x/net/http2"
)

// APIClient manages communication with the Nudm_UECM API v1.0.1
// In most cases there should be only one, shared, APIClient.
type APIClient struct {
	cfg    *Configuration
	common service // Reuse a single struct instead of allocating one for each service on the heap.

	// API Services
	AMF3GppAccessRegistrationInfoRetrievalApi              *AMF3GppAccessRegistrationInfoRetrievalApiService
	AMFNon3GPPAccessRegistrationInfoRetrievalApi           *AMFNon3GPPAccessRegistrationInfoRetrievalApiService
	AMFRegistrationFor3GPPAccessApi                        *AMFRegistrationFor3GPPAccessApiService
	AMFRegistrationForNon3GPPAccessApi                     *AMFRegistrationForNon3GPPAccessApiService
	ParameterUpdateInTheAMFRegistrationFor3GPPAccessApi    *ParameterUpdateInTheAMFRegistrationFor3GPPAccessApiService
	ParameterUpdateInTheAMFRegistrationForNon3GPPAccessApi *ParameterUpdateInTheAMFRegistrationForNon3GPPAccessApiService
	SMFDeregistrationApi                                   *SMFDeregistrationApiService
	SMFRegistrationApi                                     *SMFRegistrationApiService
	SMSF3GPPAccessRegistrationInfoRetrievalApi             *SMSF3GPPAccessRegistrationInfoRetrievalApiService
	SMSFDeregistrationFor3GPPAccessApi                     *SMSFDeregistrationFor3GPPAccessApiService
	SMSFDeregistrationForNon3GPPAccessApi                  *SMSFDeregistrationForNon3GPPAccessApiService
	SMSFNon3GPPAccessRegistrationInfoRetrievalApi          *SMSFNon3GPPAccessRegistrationInfoRetrievalApiService
	SMSFRegistrationFor3GPPAccessApi                       *SMSFRegistrationFor3GPPAccessApiService
	SMSFRegistrationForNon3GPPAccessApi                    *SMSFRegistrationForNon3GPPAccessApiService
	DeregistrationNotificationCallbackApi                  *DeregistrationNotificationCallbackApiService
}

type service struct {
	client *APIClient
}

// NewAPIClient creates a new API client. Requires a userAgent string describing your application.
// optionally a custom http.Client to allow for advanced features such as caching.
func NewAPIClient(cfg *Configuration) *APIClient {
	if cfg.httpClient == nil {
		cfg.httpClient = http.DefaultClient
		cfg.httpClient.Transport = &http2.Transport{
			TLSClientConfig: &tls.Config{InsecureSkipVerify: true},
		}
	}

	c := &APIClient{}
	c.cfg = cfg
	c.common.client = c

	// API Services
	c.AMF3GppAccessRegistrationInfoRetrievalApi = (*AMF3GppAccessRegistrationInfoRetrievalApiService)(&c.common)
	c.AMFNon3GPPAccessRegistrationInfoRetrievalApi = (*AMFNon3GPPAccessRegistrationInfoRetrievalApiService)(&c.common)
	c.AMFRegistrationFor3GPPAccessApi = (*AMFRegistrationFor3GPPAccessApiService)(&c.common)
	c.AMFRegistrationForNon3GPPAccessApi = (*AMFRegistrationForNon3GPPAccessApiService)(&c.common)
	c.ParameterUpdateInTheAMFRegistrationFor3GPPAccessApi = (*ParameterUpdateInTheAMFRegistrationFor3GPPAccessApiService)(&c.common)
	c.ParameterUpdateInTheAMFRegistrationForNon3GPPAccessApi = (*ParameterUpdateInTheAMFRegistrationForNon3GPPAccessApiService)(&c.common)
	c.SMFDeregistrationApi = (*SMFDeregistrationApiService)(&c.common)
	c.SMFRegistrationApi = (*SMFRegistrationApiService)(&c.common)
	c.SMSF3GPPAccessRegistrationInfoRetrievalApi = (*SMSF3GPPAccessRegistrationInfoRetrievalApiService)(&c.common)
	c.SMSFDeregistrationFor3GPPAccessApi = (*SMSFDeregistrationFor3GPPAccessApiService)(&c.common)
	c.SMSFDeregistrationForNon3GPPAccessApi = (*SMSFDeregistrationForNon3GPPAccessApiService)(&c.common)
	c.SMSFNon3GPPAccessRegistrationInfoRetrievalApi = (*SMSFNon3GPPAccessRegistrationInfoRetrievalApiService)(&c.common)
	c.SMSFRegistrationFor3GPPAccessApi = (*SMSFRegistrationFor3GPPAccessApiService)(&c.common)
	c.SMSFRegistrationForNon3GPPAccessApi = (*SMSFRegistrationForNon3GPPAccessApiService)(&c.common)
	c.DeregistrationNotificationCallbackApi = (*DeregistrationNotificationCallbackApiService)(&c.common)

	return c
}
