// Code generated by vfsgen; DO NOT EDIT.

package test_migrations

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	pathpkg "path"
	"time"
)

// MigrationFiles statically implements the virtual filesystem provided to vfsgen.
var MigrationFiles = func() http.FileSystem {
	fs := vfsgen۰FS{
		"/": &vfsgen۰DirInfo{
			name:    "/",
			modTime: time.Time{},
		},
		"/idempotent": &vfsgen۰DirInfo{
			name:    "idempotent",
			modTime: time.Time{},
		},
		"/idempotent/1-toc-run_second.sql": &vfsgen۰FileInfo{
			name:    "1-toc-run_second.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x69\x64\x65\x6d\x70\x6f\x74\x65\x6e\x74\x20\x32\x27\x29\x3b"),
		},
		"/idempotent/2-toc-run_first.sql": &vfsgen۰FileInfo{
			name:    "2-toc-run_first.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x69\x64\x65\x6d\x70\x6f\x74\x65\x6e\x74\x20\x31\x27\x29\x3b"),
		},
		"/preinstall": &vfsgen۰DirInfo{
			name:    "preinstall",
			modTime: time.Time{},
		},
		"/preinstall/001-setup.sql": &vfsgen۰FileInfo{
			name:    "001-setup.sql",
			modTime: time.Time{},
			content: []byte("\x43\x52\x45\x41\x54\x45\x20\x54\x41\x42\x4c\x45\x20\x6c\x6f\x67\x20\x28\x6d\x73\x67\x20\x54\x45\x58\x54\x2c\x20\x69\x64\x20\x73\x65\x72\x69\x61\x6c\x29\x3b\x0a\x0a\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x73\x65\x74\x75\x70\x27\x29\x3b"),
		},
		"/versions": &vfsgen۰DirInfo{
			name:    "versions",
			modTime: time.Time{},
		},
		"/versions/dev": &vfsgen۰DirInfo{
			name:    "dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.1.0-dev": &vfsgen۰DirInfo{
			name:    "0.1.0-dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.1.0-dev/1-migration.sql": &vfsgen۰FileInfo{
			name:    "1-migration.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x2e\x30\x27\x29\x3b"),
		},
		"/versions/dev/0.10.0-dev": &vfsgen۰DirInfo{
			name:    "0.10.0-dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.10.0-dev/1-migr_98_at.sql": &vfsgen۰FileInfo{
			name:    "1-migr_98_at.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x30\x2e\x30\x3d\x31\x27\x29\x3b\x0a"),
		},
		"/versions/dev/0.10.0-dev/2-1_mig.sql": &vfsgen۰FileInfo{
			name:    "2-1_mig.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x30\x2e\x30\x3d\x32\x27\x29\x3b\x0a"),
		},
		"/versions/dev/0.10.1-dev": &vfsgen۰DirInfo{
			name:    "0.10.1-dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.10.1-dev/1-migr_98_at.sql": &vfsgen۰FileInfo{
			name:    "1-migr_98_at.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x30\x2e\x31\x3d\x31\x27\x29\x3b\x0a"),
		},
		"/versions/dev/0.10.1-dev/2-1_mig.sql": &vfsgen۰FileInfo{
			name:    "2-1_mig.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x30\x2e\x31\x3d\x32\x27\x29\x3b\x0a"),
		},
		"/versions/dev/0.10.2-beta.dev": &vfsgen۰DirInfo{
			name:    "0.10.2-beta.dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.10.2-beta.dev/1-migr_98_at.sql": &vfsgen۰FileInfo{
			name:    "1-migr_98_at.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x30\x2e\x32\x2d\x62\x65\x74\x61\x3d\x31\x27\x29\x3b\x0a"),
		},
		"/versions/dev/0.11.0-dev": &vfsgen۰DirInfo{
			name:    "0.11.0-dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.11.0-dev/1-migr_98_at.sql": &vfsgen۰FileInfo{
			name:    "1-migr_98_at.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x31\x2e\x30\x3d\x31\x27\x29\x3b\x0a"),
		},
		"/versions/dev/0.11.0-dev/2-1_mig.sql": &vfsgen۰FileInfo{
			name:    "2-1_mig.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x31\x30\x2e\x30\x3d\x32\x27\x29\x3b\x0a\x53\x45\x4c\x45\x43\x54\x20\x31\x30\x2f\x30\x3b\x20\x2d\x2d\x77\x69\x6c\x6c\x20\x67\x65\x6e\x65\x72\x61\x74\x65\x20\x65\x72\x72\x6f\x72\x0a"),
		},
		"/versions/dev/0.2.0-dev": &vfsgen۰DirInfo{
			name:    "0.2.0-dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.2.0-dev/1-migration.sql": &vfsgen۰FileInfo{
			name:    "1-migration.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x32\x2e\x30\x27\x29\x3b"),
		},
		"/versions/dev/0.9.0-dev": &vfsgen۰DirInfo{
			name:    "0.9.0-dev",
			modTime: time.Time{},
		},
		"/versions/dev/0.9.0-dev/1-migration.sql": &vfsgen۰FileInfo{
			name:    "1-migration.sql",
			modTime: time.Time{},
			content: []byte("\x49\x4e\x53\x45\x52\x54\x20\x49\x4e\x54\x4f\x20\x6c\x6f\x67\x20\x56\x41\x4c\x55\x45\x53\x28\x27\x6d\x69\x67\x72\x61\x74\x69\x6f\x6e\x20\x30\x2e\x39\x2e\x30\x27\x29\x3b\x0a"),
		},
	}
	fs["/"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/idempotent"].(os.FileInfo),
		fs["/preinstall"].(os.FileInfo),
		fs["/versions"].(os.FileInfo),
	}
	fs["/idempotent"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/idempotent/1-toc-run_second.sql"].(os.FileInfo),
		fs["/idempotent/2-toc-run_first.sql"].(os.FileInfo),
	}
	fs["/preinstall"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/preinstall/001-setup.sql"].(os.FileInfo),
	}
	fs["/versions"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev"].(os.FileInfo),
	}
	fs["/versions/dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.1.0-dev"].(os.FileInfo),
		fs["/versions/dev/0.10.0-dev"].(os.FileInfo),
		fs["/versions/dev/0.10.1-dev"].(os.FileInfo),
		fs["/versions/dev/0.10.2-beta.dev"].(os.FileInfo),
		fs["/versions/dev/0.11.0-dev"].(os.FileInfo),
		fs["/versions/dev/0.2.0-dev"].(os.FileInfo),
		fs["/versions/dev/0.9.0-dev"].(os.FileInfo),
	}
	fs["/versions/dev/0.1.0-dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.1.0-dev/1-migration.sql"].(os.FileInfo),
	}
	fs["/versions/dev/0.10.0-dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.10.0-dev/1-migr_98_at.sql"].(os.FileInfo),
		fs["/versions/dev/0.10.0-dev/2-1_mig.sql"].(os.FileInfo),
	}
	fs["/versions/dev/0.10.1-dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.10.1-dev/1-migr_98_at.sql"].(os.FileInfo),
		fs["/versions/dev/0.10.1-dev/2-1_mig.sql"].(os.FileInfo),
	}
	fs["/versions/dev/0.10.2-beta.dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.10.2-beta.dev/1-migr_98_at.sql"].(os.FileInfo),
	}
	fs["/versions/dev/0.11.0-dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.11.0-dev/1-migr_98_at.sql"].(os.FileInfo),
		fs["/versions/dev/0.11.0-dev/2-1_mig.sql"].(os.FileInfo),
	}
	fs["/versions/dev/0.2.0-dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.2.0-dev/1-migration.sql"].(os.FileInfo),
	}
	fs["/versions/dev/0.9.0-dev"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/versions/dev/0.9.0-dev/1-migration.sql"].(os.FileInfo),
	}

	return fs
}()

type vfsgen۰FS map[string]interface{}

func (fs vfsgen۰FS) Open(path string) (http.File, error) {
	path = pathpkg.Clean("/" + path)
	f, ok := fs[path]
	if !ok {
		return nil, &os.PathError{Op: "open", Path: path, Err: os.ErrNotExist}
	}

	switch f := f.(type) {
	case *vfsgen۰FileInfo:
		return &vfsgen۰File{
			vfsgen۰FileInfo: f,
			Reader:          bytes.NewReader(f.content),
		}, nil
	case *vfsgen۰DirInfo:
		return &vfsgen۰Dir{
			vfsgen۰DirInfo: f,
		}, nil
	default:
		// This should never happen because we generate only the above types.
		panic(fmt.Sprintf("unexpected type %T", f))
	}
}

// We already imported "compress/gzip" and "io/ioutil", but ended up not using them. Avoid unused import error.
var _ = gzip.Reader{}
var _ = ioutil.Discard

// vfsgen۰FileInfo is a static definition of an uncompressed file (because it's not worth gzip compressing).
type vfsgen۰FileInfo struct {
	name    string
	modTime time.Time
	content []byte
}

func (f *vfsgen۰FileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰FileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰FileInfo) NotWorthGzipCompressing() {}

func (f *vfsgen۰FileInfo) Name() string       { return f.name }
func (f *vfsgen۰FileInfo) Size() int64        { return int64(len(f.content)) }
func (f *vfsgen۰FileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰FileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰FileInfo) IsDir() bool        { return false }
func (f *vfsgen۰FileInfo) Sys() interface{}   { return nil }

// vfsgen۰File is an opened file instance.
type vfsgen۰File struct {
	*vfsgen۰FileInfo
	*bytes.Reader
}

func (f *vfsgen۰File) Close() error {
	return nil
}

// vfsgen۰DirInfo is a static definition of a directory.
type vfsgen۰DirInfo struct {
	name    string
	modTime time.Time
	entries []os.FileInfo
}

func (d *vfsgen۰DirInfo) Read([]byte) (int, error) {
	return 0, fmt.Errorf("cannot Read from directory %s", d.name)
}
func (d *vfsgen۰DirInfo) Close() error               { return nil }
func (d *vfsgen۰DirInfo) Stat() (os.FileInfo, error) { return d, nil }

func (d *vfsgen۰DirInfo) Name() string       { return d.name }
func (d *vfsgen۰DirInfo) Size() int64        { return 0 }
func (d *vfsgen۰DirInfo) Mode() os.FileMode  { return 0755 | os.ModeDir }
func (d *vfsgen۰DirInfo) ModTime() time.Time { return d.modTime }
func (d *vfsgen۰DirInfo) IsDir() bool        { return true }
func (d *vfsgen۰DirInfo) Sys() interface{}   { return nil }

// vfsgen۰Dir is an opened dir instance.
type vfsgen۰Dir struct {
	*vfsgen۰DirInfo
	pos int // Position within entries for Seek and Readdir.
}

func (d *vfsgen۰Dir) Seek(offset int64, whence int) (int64, error) {
	if offset == 0 && whence == io.SeekStart {
		d.pos = 0
		return 0, nil
	}
	return 0, fmt.Errorf("unsupported Seek in directory %s", d.name)
}

func (d *vfsgen۰Dir) Readdir(count int) ([]os.FileInfo, error) {
	if d.pos >= len(d.entries) && count > 0 {
		return nil, io.EOF
	}
	if count <= 0 || count > len(d.entries)-d.pos {
		count = len(d.entries) - d.pos
	}
	e := d.entries[d.pos : d.pos+count]
	d.pos += count
	return e, nil
}
