%{
// Copyright (c) 2014 The parser Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.
		
// Initial yacc source generated by ebnf2y[1]
// at 2014-07-25 14:37:06.973454437 +0200 CEST
//
//  $ ebnf2y -o nquads.y -pkg parser parser.ebnf
//
// CAUTION: If this file is a Go source file (*.go), it was generated
// automatically by '$ go tool yacc' from a *.y file - DO NOT EDIT in that case!
// 
//   [1]: http://modernc.org/ebnf2y

package parser

import (
	"net/url"
)

%}

%union {
	glabel    *GraphLabel
	object    *Object
	pos       Pos
	predicate *Predicate
	subject   *Subject
	val       string
}

%token	daccent dot eol illegal iriref label langtag str

%type	<val>	iriref label langtag str

%type	<glabel>	GraphLabel
%type	<object>	Literal Literal1 Literal11 Object
%type	<predicate>	Predicate
%type	<subject>	Subject

%start	Start

%%

GraphLabel:
	iriref
	{
		$$ = &GraphLabel{$<pos>1, IRIRef, $1}
		u, err := url.Parse($1)
		if err != nil {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, err.Error())
			break
		}

		if !u.IsAbs() {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, "graph name URI must be absolute")
		}
	}
|	label
	{
		$$ = &GraphLabel{$<pos>1, BlankNodeLabel, $1}
	}
|	str
	{
		yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, "graph name may not be a simple literal")
		return 1
	}
|	str langtag
	{
		yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, "graph name may not be a language tagged literal")
		return 1
	}
|	str daccent
	{
		yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, "graph name may not be a datatyped literal")
		return 1
	}

Literal:
	str Literal1
	{
		switch {
		case $2 == nil:
			$$ = &Object{Pos: $<pos>1, Tag: Literal, Value: $1}
		default:
			x := $2
			x.Pos, x.Tag, x.Value = $<pos>1, Literal, $1
			$$ = x
		}
	}

Literal1:
	{
		$$ = nil
	}
|	Literal11

Literal11:
	daccent iriref
	{
		$$ = &Object{Pos: $<pos>2, Tag2: IRIRef, Value2: $2}
		u, err := url.Parse($2)
		if err != nil {
			yylex.(*lexer).error($<pos>2.Line, $<pos>2.Col, err.Error())
			break
		}

		if !u.IsAbs() {
			yylex.(*lexer).error($<pos>2.Line, $<pos>2.Col, "bad IRI : relative IRI not allowed in datatype")
		}
	}
|	langtag
	{
		$$ = &Object{Pos: $<pos>1, Tag2: LangTag, Value2: $1}
	}

Object:
	iriref
	{
		$$ = &Object{Pos: $<pos>1, Tag: IRIRef, Value: $1}
		u, err := url.Parse($1)
		if err != nil {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, err.Error())
			break
		}

		if !u.IsAbs() {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, "bad IRI : relative IRI not allowed in object")
		}
	}
|	label
	{
		$$ = &Object{Pos: $<pos>1, Tag: BlankNodeLabel, Value: $1}
	}
|	Literal

Predicate:
	iriref
	{
		$$ = &Predicate{$<pos>1, $1}
		u, err := url.Parse($1)
		if err != nil {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, err.Error())
			break
		}

		if !u.IsAbs() {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, "bad IRI : relative IRI not allowed in predicate")
		}
	}

SourceFile:
	SourceFile1 SourceFile2 SourceFile3

SourceFile1:
|	Statement

SourceFile2:
|	SourceFile2 eol Statement

SourceFile3:
|	eol

Start:
	SourceFile

Statement:
	Subject Predicate Object dot
	{
		lx := yylex.(*lexer)
		lx.ast = append(lx.ast, &Statement{$1.Pos, $1, $2, $3, nil})
	}
|	Subject Predicate Object GraphLabel dot
	{
		lx := yylex.(*lexer)
		lx.ast = append(lx.ast, &Statement{$1.Pos, $1, $2, $3, $4})
	}
|	Subject Predicate Object GraphLabel Statement1
	{
		yylex.(*lexer).error($<pos>5.Line, $<pos>5.Col, "n-quads does not have a fifth element")
		return 1
	}

Statement1:
	iriref
|	label
|	str

Subject:
	iriref
	{
		$$ = &Subject{$<pos>1, IRIRef, $1}
		u, err := url.Parse($1)
		if err != nil {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, err.Error())
			break
		}

		if !u.IsAbs() {
			yylex.(*lexer).error($<pos>1.Line, $<pos>1.Col, "bad IRI : relative IRI not allowed in subject")
		}
	}
|	label
	{
		$$ = &Subject{$<pos>1, BlankNodeLabel, $1}
	}

%%
