//$file${Cont::.::dpp.h} #####################################################
//
// Model: dpp.qm
// File:  C:/qp_lab/qpcpp/examples/win32/dpp-comp/cont/dpp.h
//
// This code has been generated by QM tool (https://state-machine.com/qm).
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This program is open source software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published
// by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
// for more details.
//
//$endhead${Cont::.::dpp.h} ##################################################
#ifndef dpp_h
#define dpp_h

namespace DPP {

enum DPPSignals {
    EAT_SIG = QP::Q_USER_SIG, // published by Table to let a philosopher eat
    DONE_SIG,       // published by Philosopher when done eating
    PAUSE_SIG,      // published by BSP to pause the application
    SERVE_SIG,      // published by BSP to serve re-start serving forks
    TEST_SIG,       // published by BSP to test the application
    MAX_PUB_SIG,    // the last published signal

    HUNGRY_SIG,     // posted direclty to Table from hungry Philo
    TIMEOUT_SIG,    // used by the component time events
    MAX_SIG         // the last signal
};

class Philo; // forward declaration

} // namespace DPP

enum {
    N_PHILO = 5 // number of Philos
};

//$declare${Cont::CompTimeEvt} ###############################################
namespace DPP {

//${Cont::CompTimeEvt} .......................................................
class CompTimeEvt : public QP::QTimeEvt {
public:
    QP::QHsm * m_comp;

public:
    CompTimeEvt(
        QP::QActive * act,
        QP::QHsm * comp,
        enum_t const sig,
        uint_fast8_t const tickRate);
    void dispatchToComp() const {
        m_comp->dispatch(this);
    }
};

} // namespace DPP//$enddecl${Cont::CompTimeEvt} ###############################################

//$declare${Cont::AO_Table} ##################################################
namespace DPP {

extern QP::QActive * const AO_Table;

} // namespace DPP//$enddecl${Cont::AO_Table} ##################################################

//$declare${Comp::Philo} #####################################################
namespace DPP {

//${Comp::Philo} .............................................................
class Philo : public QP::QHsm {
private:
    CompTimeEvt m_timeEvt;

public:
    Philo();

protected:
    static QP::QState initial(Philo * const me, QP::QEvt const * const e);
    static QP::QState thinking(Philo * const me, QP::QEvt const * const e);
    static QP::QState hungry(Philo * const me, QP::QEvt const * const e);
    static QP::QState eating(Philo * const me, QP::QEvt const * const e);
};

} // namespace DPP//$enddecl${Comp::Philo} #####################################################

//$declare${Cont::TableEvt} ##################################################
namespace DPP {

//${Cont::TableEvt} ..........................................................
class TableEvt : public QP::QEvt {
public:
    DPP::Philo * philo;
};

} // namespace DPP//$enddecl${Cont::TableEvt} ##################################################

#endif // dpp_h