//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package uavionix

import (
	"fmt"
	"strconv"
	"strings"
)

// Transceiver RF control flags for ADS-B transponder dynamic reports
type UAVIONIX_ADSB_OUT_RF_SELECT uint64

const (
	UAVIONIX_ADSB_OUT_RF_SELECT_STANDBY    UAVIONIX_ADSB_OUT_RF_SELECT = 0
	UAVIONIX_ADSB_OUT_RF_SELECT_RX_ENABLED UAVIONIX_ADSB_OUT_RF_SELECT = 1
	UAVIONIX_ADSB_OUT_RF_SELECT_TX_ENABLED UAVIONIX_ADSB_OUT_RF_SELECT = 2
)

var labels_UAVIONIX_ADSB_OUT_RF_SELECT = map[UAVIONIX_ADSB_OUT_RF_SELECT]string{
	UAVIONIX_ADSB_OUT_RF_SELECT_STANDBY:    "UAVIONIX_ADSB_OUT_RF_SELECT_STANDBY",
	UAVIONIX_ADSB_OUT_RF_SELECT_RX_ENABLED: "UAVIONIX_ADSB_OUT_RF_SELECT_RX_ENABLED",
	UAVIONIX_ADSB_OUT_RF_SELECT_TX_ENABLED: "UAVIONIX_ADSB_OUT_RF_SELECT_TX_ENABLED",
}

var values_UAVIONIX_ADSB_OUT_RF_SELECT = map[string]UAVIONIX_ADSB_OUT_RF_SELECT{
	"UAVIONIX_ADSB_OUT_RF_SELECT_STANDBY":    UAVIONIX_ADSB_OUT_RF_SELECT_STANDBY,
	"UAVIONIX_ADSB_OUT_RF_SELECT_RX_ENABLED": UAVIONIX_ADSB_OUT_RF_SELECT_RX_ENABLED,
	"UAVIONIX_ADSB_OUT_RF_SELECT_TX_ENABLED": UAVIONIX_ADSB_OUT_RF_SELECT_TX_ENABLED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UAVIONIX_ADSB_OUT_RF_SELECT) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 3; i++ {
		mask := UAVIONIX_ADSB_OUT_RF_SELECT(1 << i)
		if e&mask == mask {
			names = append(names, labels_UAVIONIX_ADSB_OUT_RF_SELECT[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UAVIONIX_ADSB_OUT_RF_SELECT) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask UAVIONIX_ADSB_OUT_RF_SELECT
	for _, label := range labels {
		if value, ok := values_UAVIONIX_ADSB_OUT_RF_SELECT[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= UAVIONIX_ADSB_OUT_RF_SELECT(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e UAVIONIX_ADSB_OUT_RF_SELECT) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
