//autogenerated:yes
//nolint:revive,misspell,govet,lll
package storm32

// Message reporting the current status of a gimbal manager. This message should be broadcast at a low regular rate (e.g. 1 Hz, may be increase momentarily to e.g. 5 Hz for a period of 1 sec after a change).
type MessageStorm32GimbalManagerStatus struct {
	// Gimbal ID (component ID or 1-6 for non-MAVLink gimbal) that this gimbal manager is responsible for.
	GimbalId uint8
	// Client who is currently supervisor (0 = none).
	Supervisor MAV_STORM32_GIMBAL_MANAGER_CLIENT `mavenum:"uint8"`
	// Gimbal device flags currently applied. Same flags as reported by GIMBAL_DEVICE_ATTITUDE_STATUS.
	DeviceFlags GIMBAL_DEVICE_FLAGS `mavenum:"uint16"`
	// Gimbal manager flags currently applied.
	ManagerFlags MAV_STORM32_GIMBAL_MANAGER_FLAGS `mavenum:"uint16"`
	// Profile currently applied (0 = default).
	Profile MAV_STORM32_GIMBAL_MANAGER_PROFILE `mavenum:"uint8"`
}

// GetID implements the message.Message interface.
func (*MessageStorm32GimbalManagerStatus) GetID() uint32 {
	return 60011
}
