//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package storm32

import (
	"fmt"
	"strconv"
)

// Enumeration of possible shot modes.
type MAV_QSHOT_MODE uint64

const (
	// Undefined shot mode. Can be used to determine if qshots should be used or not.
	MAV_QSHOT_MODE_UNDEFINED MAV_QSHOT_MODE = 0
	// Start normal gimbal operation. Is usually used to return back from a shot.
	MAV_QSHOT_MODE_DEFAULT MAV_QSHOT_MODE = 1
	// Load and keep safe gimbal position and stop stabilization.
	MAV_QSHOT_MODE_GIMBAL_RETRACT MAV_QSHOT_MODE = 2
	// Load neutral gimbal position and keep it while stabilizing.
	MAV_QSHOT_MODE_GIMBAL_NEUTRAL MAV_QSHOT_MODE = 3
	// Start mission with gimbal control.
	MAV_QSHOT_MODE_GIMBAL_MISSION MAV_QSHOT_MODE = 4
	// Start RC gimbal control.
	MAV_QSHOT_MODE_GIMBAL_RC_CONTROL MAV_QSHOT_MODE = 5
	// Start gimbal tracking the point specified by Lat, Lon, Alt.
	MAV_QSHOT_MODE_POI_TARGETING MAV_QSHOT_MODE = 6
	// Start gimbal tracking the system with specified system ID.
	MAV_QSHOT_MODE_SYSID_TARGETING MAV_QSHOT_MODE = 7
	// Start 2-point cable cam quick shot.
	MAV_QSHOT_MODE_CABLECAM_2POINT MAV_QSHOT_MODE = 8
	// Start gimbal tracking the home location.
	MAV_QSHOT_MODE_HOME_TARGETING MAV_QSHOT_MODE = 9
)

var labels_MAV_QSHOT_MODE = map[MAV_QSHOT_MODE]string{
	MAV_QSHOT_MODE_UNDEFINED:         "MAV_QSHOT_MODE_UNDEFINED",
	MAV_QSHOT_MODE_DEFAULT:           "MAV_QSHOT_MODE_DEFAULT",
	MAV_QSHOT_MODE_GIMBAL_RETRACT:    "MAV_QSHOT_MODE_GIMBAL_RETRACT",
	MAV_QSHOT_MODE_GIMBAL_NEUTRAL:    "MAV_QSHOT_MODE_GIMBAL_NEUTRAL",
	MAV_QSHOT_MODE_GIMBAL_MISSION:    "MAV_QSHOT_MODE_GIMBAL_MISSION",
	MAV_QSHOT_MODE_GIMBAL_RC_CONTROL: "MAV_QSHOT_MODE_GIMBAL_RC_CONTROL",
	MAV_QSHOT_MODE_POI_TARGETING:     "MAV_QSHOT_MODE_POI_TARGETING",
	MAV_QSHOT_MODE_SYSID_TARGETING:   "MAV_QSHOT_MODE_SYSID_TARGETING",
	MAV_QSHOT_MODE_CABLECAM_2POINT:   "MAV_QSHOT_MODE_CABLECAM_2POINT",
	MAV_QSHOT_MODE_HOME_TARGETING:    "MAV_QSHOT_MODE_HOME_TARGETING",
}

var values_MAV_QSHOT_MODE = map[string]MAV_QSHOT_MODE{
	"MAV_QSHOT_MODE_UNDEFINED":         MAV_QSHOT_MODE_UNDEFINED,
	"MAV_QSHOT_MODE_DEFAULT":           MAV_QSHOT_MODE_DEFAULT,
	"MAV_QSHOT_MODE_GIMBAL_RETRACT":    MAV_QSHOT_MODE_GIMBAL_RETRACT,
	"MAV_QSHOT_MODE_GIMBAL_NEUTRAL":    MAV_QSHOT_MODE_GIMBAL_NEUTRAL,
	"MAV_QSHOT_MODE_GIMBAL_MISSION":    MAV_QSHOT_MODE_GIMBAL_MISSION,
	"MAV_QSHOT_MODE_GIMBAL_RC_CONTROL": MAV_QSHOT_MODE_GIMBAL_RC_CONTROL,
	"MAV_QSHOT_MODE_POI_TARGETING":     MAV_QSHOT_MODE_POI_TARGETING,
	"MAV_QSHOT_MODE_SYSID_TARGETING":   MAV_QSHOT_MODE_SYSID_TARGETING,
	"MAV_QSHOT_MODE_CABLECAM_2POINT":   MAV_QSHOT_MODE_CABLECAM_2POINT,
	"MAV_QSHOT_MODE_HOME_TARGETING":    MAV_QSHOT_MODE_HOME_TARGETING,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_QSHOT_MODE) MarshalText() ([]byte, error) {
	if name, ok := labels_MAV_QSHOT_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_QSHOT_MODE) UnmarshalText(text []byte) error {
	if value, ok := values_MAV_QSHOT_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_QSHOT_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_QSHOT_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
