//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
	"strings"
)

// CONTROL_STATUS flags.
type GCS_CONTROL_STATUS_FLAGS uint64

const (
	// If set, this CONTROL_STATUS publishes the controlling GCS for the whole system. If unset, the CONTROL_STATUS indicates the controlling GCS for just the component emitting the message. Note that to request control of the system a GCS should send MAV_CMD_REQUEST_OPERATOR_CONTROL to the component emitting CONTROL_STATUS with this flag set.
	GCS_CONTROL_STATUS_FLAGS_SYSTEM_MANAGER GCS_CONTROL_STATUS_FLAGS = 1
	// Takeover allowed (requests for control will be granted). If not set requests for control will be rejected, but the controlling GCS will be notified (and may release control or allow takeover).
	GCS_CONTROL_STATUS_FLAGS_TAKEOVER_ALLOWED GCS_CONTROL_STATUS_FLAGS = 2
)

var labels_GCS_CONTROL_STATUS_FLAGS = map[GCS_CONTROL_STATUS_FLAGS]string{
	GCS_CONTROL_STATUS_FLAGS_SYSTEM_MANAGER:   "GCS_CONTROL_STATUS_FLAGS_SYSTEM_MANAGER",
	GCS_CONTROL_STATUS_FLAGS_TAKEOVER_ALLOWED: "GCS_CONTROL_STATUS_FLAGS_TAKEOVER_ALLOWED",
}

var values_GCS_CONTROL_STATUS_FLAGS = map[string]GCS_CONTROL_STATUS_FLAGS{
	"GCS_CONTROL_STATUS_FLAGS_SYSTEM_MANAGER":   GCS_CONTROL_STATUS_FLAGS_SYSTEM_MANAGER,
	"GCS_CONTROL_STATUS_FLAGS_TAKEOVER_ALLOWED": GCS_CONTROL_STATUS_FLAGS_TAKEOVER_ALLOWED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GCS_CONTROL_STATUS_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 2; i++ {
		mask := GCS_CONTROL_STATUS_FLAGS(1 << i)
		if e&mask == mask {
			names = append(names, labels_GCS_CONTROL_STATUS_FLAGS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GCS_CONTROL_STATUS_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask GCS_CONTROL_STATUS_FLAGS
	for _, label := range labels {
		if value, ok := values_GCS_CONTROL_STATUS_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= GCS_CONTROL_STATUS_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e GCS_CONTROL_STATUS_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
