//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Information about a camera. Can be requested with a MAV_CMD_REQUEST_MESSAGE command.
type MessageCameraInformation struct {
	// Timestamp (time since system boot).
	TimeBootMs uint32
	// Name of the camera vendor
	VendorName [32]uint8
	// Name of the camera model
	ModelName [32]uint8
	// Version of the camera firmware, encoded as: (Dev &amp; 0xff) &lt;&lt; 24 | (Patch &amp; 0xff) &lt;&lt; 16 | (Minor &amp; 0xff) &lt;&lt; 8 | (Major &amp; 0xff). Use 0 if not known.
	FirmwareVersion uint32
	// Focal length. Use NaN if not known.
	FocalLength float32
	// Image sensor size horizontal. Use NaN if not known.
	SensorSizeH float32
	// Image sensor size vertical. Use NaN if not known.
	SensorSizeV float32
	// Horizontal image resolution. Use 0 if not known.
	ResolutionH uint16
	// Vertical image resolution. Use 0 if not known.
	ResolutionV uint16
	// Reserved for a lens ID.  Use 0 if not known.
	LensId uint8
	// Bitmap of camera capability flags.
	Flags CAMERA_CAP_FLAGS `mavenum:"uint32"`
	// Camera definition version (iteration).  Use 0 if not known.
	CamDefinitionVersion uint16
	// Camera definition URI (if any, otherwise only basic functions will be available). HTTP- (http://) and MAVLink FTP- (mavlinkftp://) formatted URIs are allowed (and both must be supported by any GCS that implements the Camera Protocol). The definition file may be xz compressed, which will be indicated by the file extension .xml.xz (a GCS that implements the protocol must support decompressing the file). The string needs to be zero terminated.  Use a zero-length string if not known.
	CamDefinitionUri string `mavlen:"140"`
	// Gimbal id of a gimbal associated with this camera. This is the component id of the gimbal device, or 1-6 for non mavlink gimbals. Use 0 if no gimbal is associated with the camera.
	GimbalDeviceId uint8 `mavext:"true"`
	// Camera id of a non-MAVLink camera attached to an autopilot (1-6).  0 if the component is a MAVLink camera (with its own component id).
	CameraDeviceId uint8 `mavext:"true"`
}

// GetID implements the message.Message interface.
func (*MessageCameraInformation) GetID() uint32 {
	return 259
}
