//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Video stream encodings
type VIDEO_STREAM_ENCODING uint64

const (
	// Stream encoding is unknown
	VIDEO_STREAM_ENCODING_UNKNOWN VIDEO_STREAM_ENCODING = 0
	// Stream encoding is H.264
	VIDEO_STREAM_ENCODING_H264 VIDEO_STREAM_ENCODING = 1
	// Stream encoding is H.265
	VIDEO_STREAM_ENCODING_H265 VIDEO_STREAM_ENCODING = 2
)

var labels_VIDEO_STREAM_ENCODING = map[VIDEO_STREAM_ENCODING]string{
	VIDEO_STREAM_ENCODING_UNKNOWN: "VIDEO_STREAM_ENCODING_UNKNOWN",
	VIDEO_STREAM_ENCODING_H264:    "VIDEO_STREAM_ENCODING_H264",
	VIDEO_STREAM_ENCODING_H265:    "VIDEO_STREAM_ENCODING_H265",
}

var values_VIDEO_STREAM_ENCODING = map[string]VIDEO_STREAM_ENCODING{
	"VIDEO_STREAM_ENCODING_UNKNOWN": VIDEO_STREAM_ENCODING_UNKNOWN,
	"VIDEO_STREAM_ENCODING_H264":    VIDEO_STREAM_ENCODING_H264,
	"VIDEO_STREAM_ENCODING_H265":    VIDEO_STREAM_ENCODING_H265,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e VIDEO_STREAM_ENCODING) MarshalText() ([]byte, error) {
	if name, ok := labels_VIDEO_STREAM_ENCODING[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *VIDEO_STREAM_ENCODING) UnmarshalText(text []byte) error {
	if value, ok := values_VIDEO_STREAM_ENCODING[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = VIDEO_STREAM_ENCODING(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e VIDEO_STREAM_ENCODING) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
