//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Generalized UAVCAN node health
type UAVCAN_NODE_HEALTH uint64

const (
	// The node is functioning properly.
	UAVCAN_NODE_HEALTH_OK UAVCAN_NODE_HEALTH = 0
	// A critical parameter went out of range or the node has encountered a minor failure.
	UAVCAN_NODE_HEALTH_WARNING UAVCAN_NODE_HEALTH = 1
	// The node has encountered a major failure.
	UAVCAN_NODE_HEALTH_ERROR UAVCAN_NODE_HEALTH = 2
	// The node has suffered a fatal malfunction.
	UAVCAN_NODE_HEALTH_CRITICAL UAVCAN_NODE_HEALTH = 3
)

var labels_UAVCAN_NODE_HEALTH = map[UAVCAN_NODE_HEALTH]string{
	UAVCAN_NODE_HEALTH_OK:       "UAVCAN_NODE_HEALTH_OK",
	UAVCAN_NODE_HEALTH_WARNING:  "UAVCAN_NODE_HEALTH_WARNING",
	UAVCAN_NODE_HEALTH_ERROR:    "UAVCAN_NODE_HEALTH_ERROR",
	UAVCAN_NODE_HEALTH_CRITICAL: "UAVCAN_NODE_HEALTH_CRITICAL",
}

var values_UAVCAN_NODE_HEALTH = map[string]UAVCAN_NODE_HEALTH{
	"UAVCAN_NODE_HEALTH_OK":       UAVCAN_NODE_HEALTH_OK,
	"UAVCAN_NODE_HEALTH_WARNING":  UAVCAN_NODE_HEALTH_WARNING,
	"UAVCAN_NODE_HEALTH_ERROR":    UAVCAN_NODE_HEALTH_ERROR,
	"UAVCAN_NODE_HEALTH_CRITICAL": UAVCAN_NODE_HEALTH_CRITICAL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UAVCAN_NODE_HEALTH) MarshalText() ([]byte, error) {
	if name, ok := labels_UAVCAN_NODE_HEALTH[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UAVCAN_NODE_HEALTH) UnmarshalText(text []byte) error {
	if value, ok := values_UAVCAN_NODE_HEALTH[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = UAVCAN_NODE_HEALTH(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e UAVCAN_NODE_HEALTH) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
