//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

type NAV_VTOL_LAND_OPTIONS uint64

const (
	// Default autopilot landing behaviour.
	NAV_VTOL_LAND_OPTIONS_DEFAULT NAV_VTOL_LAND_OPTIONS = 0
	// Descend in fixed wing mode, transitioning to multicopter mode for vertical landing when close to the ground.
	// The fixed wing descent pattern is at the discretion of the vehicle (e.g. transition altitude, loiter direction, radius, and speed, etc.).
	NAV_VTOL_LAND_OPTIONS_FW_DESCENT NAV_VTOL_LAND_OPTIONS = 1
	// Land in multicopter mode on reaching the landing coordinates (the whole landing is by "hover descent").
	NAV_VTOL_LAND_OPTIONS_HOVER_DESCENT NAV_VTOL_LAND_OPTIONS = 2
)

var labels_NAV_VTOL_LAND_OPTIONS = map[NAV_VTOL_LAND_OPTIONS]string{
	NAV_VTOL_LAND_OPTIONS_DEFAULT:       "NAV_VTOL_LAND_OPTIONS_DEFAULT",
	NAV_VTOL_LAND_OPTIONS_FW_DESCENT:    "NAV_VTOL_LAND_OPTIONS_FW_DESCENT",
	NAV_VTOL_LAND_OPTIONS_HOVER_DESCENT: "NAV_VTOL_LAND_OPTIONS_HOVER_DESCENT",
}

var values_NAV_VTOL_LAND_OPTIONS = map[string]NAV_VTOL_LAND_OPTIONS{
	"NAV_VTOL_LAND_OPTIONS_DEFAULT":       NAV_VTOL_LAND_OPTIONS_DEFAULT,
	"NAV_VTOL_LAND_OPTIONS_FW_DESCENT":    NAV_VTOL_LAND_OPTIONS_FW_DESCENT,
	"NAV_VTOL_LAND_OPTIONS_HOVER_DESCENT": NAV_VTOL_LAND_OPTIONS_HOVER_DESCENT,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e NAV_VTOL_LAND_OPTIONS) MarshalText() ([]byte, error) {
	if name, ok := labels_NAV_VTOL_LAND_OPTIONS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *NAV_VTOL_LAND_OPTIONS) UnmarshalText(text []byte) error {
	if value, ok := values_NAV_VTOL_LAND_OPTIONS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = NAV_VTOL_LAND_OPTIONS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e NAV_VTOL_LAND_OPTIONS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
