//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Bitmask of (optional) autopilot capabilities (64 bit). If a bit is set, the autopilot supports this capability.
type MAV_PROTOCOL_CAPABILITY uint64

const (
	// Autopilot supports the MISSION_ITEM float message type.
	// Note that MISSION_ITEM is deprecated, and autopilots should use MISSION_INT instead.
	MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT MAV_PROTOCOL_CAPABILITY = 1
	// Autopilot supports the new param float message type.
	MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT MAV_PROTOCOL_CAPABILITY = 2
	// Autopilot supports MISSION_ITEM_INT scaled integer message type.
	// Note that this flag must always be set if missions are supported, because missions must always use MISSION_ITEM_INT (rather than MISSION_ITEM, which is deprecated).
	MAV_PROTOCOL_CAPABILITY_MISSION_INT MAV_PROTOCOL_CAPABILITY = 4
	// Autopilot supports COMMAND_INT scaled integer message type.
	MAV_PROTOCOL_CAPABILITY_COMMAND_INT MAV_PROTOCOL_CAPABILITY = 8
	// Parameter protocol uses byte-wise encoding of parameter values into param_value (float) fields: https://mavlink.io/en/services/parameter.html#parameter-encoding.
	// Note that either this flag or MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST should be set if the parameter protocol is supported.
	MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE MAV_PROTOCOL_CAPABILITY = 16
	// Autopilot supports the File Transfer Protocol v1: https://mavlink.io/en/services/ftp.html.
	MAV_PROTOCOL_CAPABILITY_FTP MAV_PROTOCOL_CAPABILITY = 32
	// Autopilot supports commanding attitude offboard.
	MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET MAV_PROTOCOL_CAPABILITY = 64
	// Autopilot supports commanding position and velocity targets in local NED frame.
	MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED MAV_PROTOCOL_CAPABILITY = 128
	// Autopilot supports commanding position and velocity targets in global scaled integers.
	MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT MAV_PROTOCOL_CAPABILITY = 256
	// Autopilot supports terrain protocol / data handling.
	MAV_PROTOCOL_CAPABILITY_TERRAIN MAV_PROTOCOL_CAPABILITY = 512
	// Reserved for future use.
	MAV_PROTOCOL_CAPABILITY_RESERVED3 MAV_PROTOCOL_CAPABILITY = 1024
	// Autopilot supports the MAV_CMD_DO_FLIGHTTERMINATION command (flight termination).
	MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION MAV_PROTOCOL_CAPABILITY = 2048
	// Autopilot supports onboard compass calibration.
	MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION MAV_PROTOCOL_CAPABILITY = 4096
	// Autopilot supports MAVLink version 2.
	MAV_PROTOCOL_CAPABILITY_MAVLINK2 MAV_PROTOCOL_CAPABILITY = 8192
	// Autopilot supports mission fence protocol.
	MAV_PROTOCOL_CAPABILITY_MISSION_FENCE MAV_PROTOCOL_CAPABILITY = 16384
	// Autopilot supports mission rally point protocol.
	MAV_PROTOCOL_CAPABILITY_MISSION_RALLY MAV_PROTOCOL_CAPABILITY = 32768
	// Reserved for future use.
	MAV_PROTOCOL_CAPABILITY_RESERVED2 MAV_PROTOCOL_CAPABILITY = 65536
	// Parameter protocol uses C-cast of parameter values to set the param_value (float) fields: https://mavlink.io/en/services/parameter.html#parameter-encoding.
	// Note that either this flag or MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE should be set if the parameter protocol is supported.
	MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST MAV_PROTOCOL_CAPABILITY = 131072
	// This component implements/is a gimbal manager. This means the GIMBAL_MANAGER_INFORMATION, and other messages can be requested.
	MAV_PROTOCOL_CAPABILITY_COMPONENT_IMPLEMENTS_GIMBAL_MANAGER MAV_PROTOCOL_CAPABILITY = 262144
	// Component supports locking control to a particular GCS independent of its system (via MAV_CMD_REQUEST_OPERATOR_CONTROL).
	MAV_PROTOCOL_CAPABILITY_COMPONENT_ACCEPTS_GCS_CONTROL MAV_PROTOCOL_CAPABILITY = 524288
)

var labels_MAV_PROTOCOL_CAPABILITY = map[MAV_PROTOCOL_CAPABILITY]string{
	MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT:                       "MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT",
	MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT:                         "MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT",
	MAV_PROTOCOL_CAPABILITY_MISSION_INT:                         "MAV_PROTOCOL_CAPABILITY_MISSION_INT",
	MAV_PROTOCOL_CAPABILITY_COMMAND_INT:                         "MAV_PROTOCOL_CAPABILITY_COMMAND_INT",
	MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE:               "MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE",
	MAV_PROTOCOL_CAPABILITY_FTP:                                 "MAV_PROTOCOL_CAPABILITY_FTP",
	MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET:                 "MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET",
	MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED:       "MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED",
	MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT:      "MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT",
	MAV_PROTOCOL_CAPABILITY_TERRAIN:                             "MAV_PROTOCOL_CAPABILITY_TERRAIN",
	MAV_PROTOCOL_CAPABILITY_RESERVED3:                           "MAV_PROTOCOL_CAPABILITY_RESERVED3",
	MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION:                  "MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION",
	MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION:                 "MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION",
	MAV_PROTOCOL_CAPABILITY_MAVLINK2:                            "MAV_PROTOCOL_CAPABILITY_MAVLINK2",
	MAV_PROTOCOL_CAPABILITY_MISSION_FENCE:                       "MAV_PROTOCOL_CAPABILITY_MISSION_FENCE",
	MAV_PROTOCOL_CAPABILITY_MISSION_RALLY:                       "MAV_PROTOCOL_CAPABILITY_MISSION_RALLY",
	MAV_PROTOCOL_CAPABILITY_RESERVED2:                           "MAV_PROTOCOL_CAPABILITY_RESERVED2",
	MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST:                 "MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST",
	MAV_PROTOCOL_CAPABILITY_COMPONENT_IMPLEMENTS_GIMBAL_MANAGER: "MAV_PROTOCOL_CAPABILITY_COMPONENT_IMPLEMENTS_GIMBAL_MANAGER",
	MAV_PROTOCOL_CAPABILITY_COMPONENT_ACCEPTS_GCS_CONTROL:       "MAV_PROTOCOL_CAPABILITY_COMPONENT_ACCEPTS_GCS_CONTROL",
}

var values_MAV_PROTOCOL_CAPABILITY = map[string]MAV_PROTOCOL_CAPABILITY{
	"MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT":                       MAV_PROTOCOL_CAPABILITY_MISSION_FLOAT,
	"MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT":                         MAV_PROTOCOL_CAPABILITY_PARAM_FLOAT,
	"MAV_PROTOCOL_CAPABILITY_MISSION_INT":                         MAV_PROTOCOL_CAPABILITY_MISSION_INT,
	"MAV_PROTOCOL_CAPABILITY_COMMAND_INT":                         MAV_PROTOCOL_CAPABILITY_COMMAND_INT,
	"MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE":               MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_BYTEWISE,
	"MAV_PROTOCOL_CAPABILITY_FTP":                                 MAV_PROTOCOL_CAPABILITY_FTP,
	"MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET":                 MAV_PROTOCOL_CAPABILITY_SET_ATTITUDE_TARGET,
	"MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED":       MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_LOCAL_NED,
	"MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT":      MAV_PROTOCOL_CAPABILITY_SET_POSITION_TARGET_GLOBAL_INT,
	"MAV_PROTOCOL_CAPABILITY_TERRAIN":                             MAV_PROTOCOL_CAPABILITY_TERRAIN,
	"MAV_PROTOCOL_CAPABILITY_RESERVED3":                           MAV_PROTOCOL_CAPABILITY_RESERVED3,
	"MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION":                  MAV_PROTOCOL_CAPABILITY_FLIGHT_TERMINATION,
	"MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION":                 MAV_PROTOCOL_CAPABILITY_COMPASS_CALIBRATION,
	"MAV_PROTOCOL_CAPABILITY_MAVLINK2":                            MAV_PROTOCOL_CAPABILITY_MAVLINK2,
	"MAV_PROTOCOL_CAPABILITY_MISSION_FENCE":                       MAV_PROTOCOL_CAPABILITY_MISSION_FENCE,
	"MAV_PROTOCOL_CAPABILITY_MISSION_RALLY":                       MAV_PROTOCOL_CAPABILITY_MISSION_RALLY,
	"MAV_PROTOCOL_CAPABILITY_RESERVED2":                           MAV_PROTOCOL_CAPABILITY_RESERVED2,
	"MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST":                 MAV_PROTOCOL_CAPABILITY_PARAM_ENCODE_C_CAST,
	"MAV_PROTOCOL_CAPABILITY_COMPONENT_IMPLEMENTS_GIMBAL_MANAGER": MAV_PROTOCOL_CAPABILITY_COMPONENT_IMPLEMENTS_GIMBAL_MANAGER,
	"MAV_PROTOCOL_CAPABILITY_COMPONENT_ACCEPTS_GCS_CONTROL":       MAV_PROTOCOL_CAPABILITY_COMPONENT_ACCEPTS_GCS_CONTROL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_PROTOCOL_CAPABILITY) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 20; i++ {
		mask := MAV_PROTOCOL_CAPABILITY(1 << i)
		if e&mask == mask {
			names = append(names, labels_MAV_PROTOCOL_CAPABILITY[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_PROTOCOL_CAPABILITY) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MAV_PROTOCOL_CAPABILITY
	for _, label := range labels {
		if value, ok := values_MAV_PROTOCOL_CAPABILITY[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MAV_PROTOCOL_CAPABILITY(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_PROTOCOL_CAPABILITY) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
