//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Mode properties.
type MAV_MODE_PROPERTY uint64

const (
	// If set, this mode is an advanced mode.
	// For example a rate-controlled manual mode might be advanced, whereas a position-controlled manual mode is not.
	// A GCS can optionally use this flag to configure the UI for its intended users.
	MAV_MODE_PROPERTY_ADVANCED MAV_MODE_PROPERTY = 1
	// If set, this mode should not be added to the list of selectable modes.
	// The mode might still be selected by the FC directly (for example as part of a failsafe).
	MAV_MODE_PROPERTY_NOT_USER_SELECTABLE MAV_MODE_PROPERTY = 2
	// If set, this mode is automatically controlled (it may use but does not require a manual controller).
	// If unset the mode is a assumed to require user input (be a manual mode).
	MAV_MODE_PROPERTY_AUTO_MODE MAV_MODE_PROPERTY = 4
)

var labels_MAV_MODE_PROPERTY = map[MAV_MODE_PROPERTY]string{
	MAV_MODE_PROPERTY_ADVANCED:            "MAV_MODE_PROPERTY_ADVANCED",
	MAV_MODE_PROPERTY_NOT_USER_SELECTABLE: "MAV_MODE_PROPERTY_NOT_USER_SELECTABLE",
	MAV_MODE_PROPERTY_AUTO_MODE:           "MAV_MODE_PROPERTY_AUTO_MODE",
}

var values_MAV_MODE_PROPERTY = map[string]MAV_MODE_PROPERTY{
	"MAV_MODE_PROPERTY_ADVANCED":            MAV_MODE_PROPERTY_ADVANCED,
	"MAV_MODE_PROPERTY_NOT_USER_SELECTABLE": MAV_MODE_PROPERTY_NOT_USER_SELECTABLE,
	"MAV_MODE_PROPERTY_AUTO_MODE":           MAV_MODE_PROPERTY_AUTO_MODE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_MODE_PROPERTY) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 3; i++ {
		mask := MAV_MODE_PROPERTY(1 << i)
		if e&mask == mask {
			names = append(names, labels_MAV_MODE_PROPERTY[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_MODE_PROPERTY) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MAV_MODE_PROPERTY
	for _, label := range labels {
		if value, ok := values_MAV_MODE_PROPERTY[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MAV_MODE_PROPERTY(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_MODE_PROPERTY) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
