//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Bitmap of options for the MAV_CMD_DO_REPOSITION
type MAV_DO_REPOSITION_FLAGS uint64

const (
	// The aircraft should immediately transition into guided. This should not be set for follow me applications
	MAV_DO_REPOSITION_FLAGS_CHANGE_MODE MAV_DO_REPOSITION_FLAGS = 1
)

var labels_MAV_DO_REPOSITION_FLAGS = map[MAV_DO_REPOSITION_FLAGS]string{
	MAV_DO_REPOSITION_FLAGS_CHANGE_MODE: "MAV_DO_REPOSITION_FLAGS_CHANGE_MODE",
}

var values_MAV_DO_REPOSITION_FLAGS = map[string]MAV_DO_REPOSITION_FLAGS{
	"MAV_DO_REPOSITION_FLAGS_CHANGE_MODE": MAV_DO_REPOSITION_FLAGS_CHANGE_MODE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_DO_REPOSITION_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 1; i++ {
		mask := MAV_DO_REPOSITION_FLAGS(1 << i)
		if e&mask == mask {
			names = append(names, labels_MAV_DO_REPOSITION_FLAGS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_DO_REPOSITION_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MAV_DO_REPOSITION_FLAGS
	for _, label := range labels {
		if value, ok := values_MAV_DO_REPOSITION_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MAV_DO_REPOSITION_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_DO_REPOSITION_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
