//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Battery mode. Note, the normal operation mode (i.e. when flying) should be reported as MAV_BATTERY_MODE_UNKNOWN to allow message trimming in normal flight.
type MAV_BATTERY_MODE uint64

const (
	// Battery mode not supported/unknown battery mode/normal operation.
	MAV_BATTERY_MODE_UNKNOWN MAV_BATTERY_MODE = 0
	// Battery is auto discharging (towards storage level).
	MAV_BATTERY_MODE_AUTO_DISCHARGING MAV_BATTERY_MODE = 1
	// Battery in hot-swap mode (current limited to prevent spikes that might damage sensitive electrical circuits).
	MAV_BATTERY_MODE_HOT_SWAP MAV_BATTERY_MODE = 2
)

var labels_MAV_BATTERY_MODE = map[MAV_BATTERY_MODE]string{
	MAV_BATTERY_MODE_UNKNOWN:          "MAV_BATTERY_MODE_UNKNOWN",
	MAV_BATTERY_MODE_AUTO_DISCHARGING: "MAV_BATTERY_MODE_AUTO_DISCHARGING",
	MAV_BATTERY_MODE_HOT_SWAP:         "MAV_BATTERY_MODE_HOT_SWAP",
}

var values_MAV_BATTERY_MODE = map[string]MAV_BATTERY_MODE{
	"MAV_BATTERY_MODE_UNKNOWN":          MAV_BATTERY_MODE_UNKNOWN,
	"MAV_BATTERY_MODE_AUTO_DISCHARGING": MAV_BATTERY_MODE_AUTO_DISCHARGING,
	"MAV_BATTERY_MODE_HOT_SWAP":         MAV_BATTERY_MODE_HOT_SWAP,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_BATTERY_MODE) MarshalText() ([]byte, error) {
	if name, ok := labels_MAV_BATTERY_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_BATTERY_MODE) UnmarshalText(text []byte) error {
	if value, ok := values_MAV_BATTERY_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_BATTERY_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_BATTERY_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
