//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Camera sources for MAV_CMD_SET_CAMERA_SOURCE
type CAMERA_SOURCE uint64

const (
	// Default camera source.
	CAMERA_SOURCE_DEFAULT CAMERA_SOURCE = 0
	// RGB camera source.
	CAMERA_SOURCE_RGB CAMERA_SOURCE = 1
	// IR camera source.
	CAMERA_SOURCE_IR CAMERA_SOURCE = 2
	// NDVI camera source.
	CAMERA_SOURCE_NDVI CAMERA_SOURCE = 3
)

var labels_CAMERA_SOURCE = map[CAMERA_SOURCE]string{
	CAMERA_SOURCE_DEFAULT: "CAMERA_SOURCE_DEFAULT",
	CAMERA_SOURCE_RGB:     "CAMERA_SOURCE_RGB",
	CAMERA_SOURCE_IR:      "CAMERA_SOURCE_IR",
	CAMERA_SOURCE_NDVI:    "CAMERA_SOURCE_NDVI",
}

var values_CAMERA_SOURCE = map[string]CAMERA_SOURCE{
	"CAMERA_SOURCE_DEFAULT": CAMERA_SOURCE_DEFAULT,
	"CAMERA_SOURCE_RGB":     CAMERA_SOURCE_RGB,
	"CAMERA_SOURCE_IR":      CAMERA_SOURCE_IR,
	"CAMERA_SOURCE_NDVI":    CAMERA_SOURCE_NDVI,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e CAMERA_SOURCE) MarshalText() ([]byte, error) {
	if name, ok := labels_CAMERA_SOURCE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *CAMERA_SOURCE) UnmarshalText(text []byte) error {
	if value, ok := values_CAMERA_SOURCE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = CAMERA_SOURCE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e CAMERA_SOURCE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
