//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Bitmap to indicate which dimensions should be ignored by the vehicle: a value of 0b00000000 indicates that none of the setpoint dimensions should be ignored.
type ATTITUDE_TARGET_TYPEMASK uint64

const (
	// Ignore body roll rate
	ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE ATTITUDE_TARGET_TYPEMASK = 1
	// Ignore body pitch rate
	ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE ATTITUDE_TARGET_TYPEMASK = 2
	// Ignore body yaw rate
	ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE ATTITUDE_TARGET_TYPEMASK = 4
	// Use 3D body thrust setpoint instead of throttle
	ATTITUDE_TARGET_TYPEMASK_THRUST_BODY_SET ATTITUDE_TARGET_TYPEMASK = 32
	// Ignore throttle
	ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE ATTITUDE_TARGET_TYPEMASK = 64
	// Ignore attitude
	ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE ATTITUDE_TARGET_TYPEMASK = 128
)

var labels_ATTITUDE_TARGET_TYPEMASK = map[ATTITUDE_TARGET_TYPEMASK]string{
	ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE:  "ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE",
	ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE: "ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE",
	ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE:   "ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE",
	ATTITUDE_TARGET_TYPEMASK_THRUST_BODY_SET:        "ATTITUDE_TARGET_TYPEMASK_THRUST_BODY_SET",
	ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE:        "ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE",
	ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE:        "ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE",
}

var values_ATTITUDE_TARGET_TYPEMASK = map[string]ATTITUDE_TARGET_TYPEMASK{
	"ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE":  ATTITUDE_TARGET_TYPEMASK_BODY_ROLL_RATE_IGNORE,
	"ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE": ATTITUDE_TARGET_TYPEMASK_BODY_PITCH_RATE_IGNORE,
	"ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE":   ATTITUDE_TARGET_TYPEMASK_BODY_YAW_RATE_IGNORE,
	"ATTITUDE_TARGET_TYPEMASK_THRUST_BODY_SET":        ATTITUDE_TARGET_TYPEMASK_THRUST_BODY_SET,
	"ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE":        ATTITUDE_TARGET_TYPEMASK_THROTTLE_IGNORE,
	"ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE":        ATTITUDE_TARGET_TYPEMASK_ATTITUDE_IGNORE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e ATTITUDE_TARGET_TYPEMASK) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 6; i++ {
		mask := ATTITUDE_TARGET_TYPEMASK(1 << i)
		if e&mask == mask {
			names = append(names, labels_ATTITUDE_TARGET_TYPEMASK[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *ATTITUDE_TARGET_TYPEMASK) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask ATTITUDE_TARGET_TYPEMASK
	for _, label := range labels {
		if value, ok := values_ATTITUDE_TARGET_TYPEMASK[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= ATTITUDE_TARGET_TYPEMASK(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e ATTITUDE_TARGET_TYPEMASK) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
