//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// These flags indicate status such as data validity of each data source. Set = data valid
type ADSB_FLAGS uint64

const (
	ADSB_FLAGS_VALID_COORDS            ADSB_FLAGS = 1
	ADSB_FLAGS_VALID_ALTITUDE          ADSB_FLAGS = 2
	ADSB_FLAGS_VALID_HEADING           ADSB_FLAGS = 4
	ADSB_FLAGS_VALID_VELOCITY          ADSB_FLAGS = 8
	ADSB_FLAGS_VALID_CALLSIGN          ADSB_FLAGS = 16
	ADSB_FLAGS_VALID_SQUAWK            ADSB_FLAGS = 32
	ADSB_FLAGS_SIMULATED               ADSB_FLAGS = 64
	ADSB_FLAGS_VERTICAL_VELOCITY_VALID ADSB_FLAGS = 128
	ADSB_FLAGS_BARO_VALID              ADSB_FLAGS = 256
	ADSB_FLAGS_SOURCE_UAT              ADSB_FLAGS = 32768
)

var labels_ADSB_FLAGS = map[ADSB_FLAGS]string{
	ADSB_FLAGS_VALID_COORDS:            "ADSB_FLAGS_VALID_COORDS",
	ADSB_FLAGS_VALID_ALTITUDE:          "ADSB_FLAGS_VALID_ALTITUDE",
	ADSB_FLAGS_VALID_HEADING:           "ADSB_FLAGS_VALID_HEADING",
	ADSB_FLAGS_VALID_VELOCITY:          "ADSB_FLAGS_VALID_VELOCITY",
	ADSB_FLAGS_VALID_CALLSIGN:          "ADSB_FLAGS_VALID_CALLSIGN",
	ADSB_FLAGS_VALID_SQUAWK:            "ADSB_FLAGS_VALID_SQUAWK",
	ADSB_FLAGS_SIMULATED:               "ADSB_FLAGS_SIMULATED",
	ADSB_FLAGS_VERTICAL_VELOCITY_VALID: "ADSB_FLAGS_VERTICAL_VELOCITY_VALID",
	ADSB_FLAGS_BARO_VALID:              "ADSB_FLAGS_BARO_VALID",
	ADSB_FLAGS_SOURCE_UAT:              "ADSB_FLAGS_SOURCE_UAT",
}

var values_ADSB_FLAGS = map[string]ADSB_FLAGS{
	"ADSB_FLAGS_VALID_COORDS":            ADSB_FLAGS_VALID_COORDS,
	"ADSB_FLAGS_VALID_ALTITUDE":          ADSB_FLAGS_VALID_ALTITUDE,
	"ADSB_FLAGS_VALID_HEADING":           ADSB_FLAGS_VALID_HEADING,
	"ADSB_FLAGS_VALID_VELOCITY":          ADSB_FLAGS_VALID_VELOCITY,
	"ADSB_FLAGS_VALID_CALLSIGN":          ADSB_FLAGS_VALID_CALLSIGN,
	"ADSB_FLAGS_VALID_SQUAWK":            ADSB_FLAGS_VALID_SQUAWK,
	"ADSB_FLAGS_SIMULATED":               ADSB_FLAGS_SIMULATED,
	"ADSB_FLAGS_VERTICAL_VELOCITY_VALID": ADSB_FLAGS_VERTICAL_VELOCITY_VALID,
	"ADSB_FLAGS_BARO_VALID":              ADSB_FLAGS_BARO_VALID,
	"ADSB_FLAGS_SOURCE_UAT":              ADSB_FLAGS_SOURCE_UAT,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e ADSB_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 10; i++ {
		mask := ADSB_FLAGS(1 << i)
		if e&mask == mask {
			names = append(names, labels_ADSB_FLAGS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *ADSB_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask ADSB_FLAGS
	for _, label := range labels {
		if value, ok := values_ADSB_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= ADSB_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e ADSB_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
