//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package avssuas

import (
	"fmt"
	"strconv"
)

type MAV_AVSS_COMMAND_FAILURE_REASON uint64

const (
	// AVSS defined command failure reason. PRS not steady.
	PRS_NOT_STEADY MAV_AVSS_COMMAND_FAILURE_REASON = 1
	// AVSS defined command failure reason. PRS DTM not armed.
	PRS_DTM_NOT_ARMED MAV_AVSS_COMMAND_FAILURE_REASON = 2
	// AVSS defined command failure reason. PRS OTM not armed.
	PRS_OTM_NOT_ARMED MAV_AVSS_COMMAND_FAILURE_REASON = 3
)

var labels_MAV_AVSS_COMMAND_FAILURE_REASON = map[MAV_AVSS_COMMAND_FAILURE_REASON]string{
	PRS_NOT_STEADY:    "PRS_NOT_STEADY",
	PRS_DTM_NOT_ARMED: "PRS_DTM_NOT_ARMED",
	PRS_OTM_NOT_ARMED: "PRS_OTM_NOT_ARMED",
}

var values_MAV_AVSS_COMMAND_FAILURE_REASON = map[string]MAV_AVSS_COMMAND_FAILURE_REASON{
	"PRS_NOT_STEADY":    PRS_NOT_STEADY,
	"PRS_DTM_NOT_ARMED": PRS_DTM_NOT_ARMED,
	"PRS_OTM_NOT_ARMED": PRS_OTM_NOT_ARMED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_AVSS_COMMAND_FAILURE_REASON) MarshalText() ([]byte, error) {
	if name, ok := labels_MAV_AVSS_COMMAND_FAILURE_REASON[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_AVSS_COMMAND_FAILURE_REASON) UnmarshalText(text []byte) error {
	if value, ok := values_MAV_AVSS_COMMAND_FAILURE_REASON[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_AVSS_COMMAND_FAILURE_REASON(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_AVSS_COMMAND_FAILURE_REASON) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
