//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package avssuas

import (
	"fmt"
	"strconv"
)

type AVSS_HORSEFLY_OPERATION_MODE uint64

const (
	// In manual control mode
	MODE_HORSEFLY_MANUAL_CTRL AVSS_HORSEFLY_OPERATION_MODE = 0
	// In auto takeoff mode
	MODE_HORSEFLY_AUTO_TAKEOFF AVSS_HORSEFLY_OPERATION_MODE = 1
	// In auto landing mode
	MODE_HORSEFLY_AUTO_LANDING AVSS_HORSEFLY_OPERATION_MODE = 2
	// In go home mode
	MODE_HORSEFLY_NAVI_GO_HOME AVSS_HORSEFLY_OPERATION_MODE = 3
	// In drop mode
	MODE_HORSEFLY_DROP AVSS_HORSEFLY_OPERATION_MODE = 4
)

var labels_AVSS_HORSEFLY_OPERATION_MODE = map[AVSS_HORSEFLY_OPERATION_MODE]string{
	MODE_HORSEFLY_MANUAL_CTRL:  "MODE_HORSEFLY_MANUAL_CTRL",
	MODE_HORSEFLY_AUTO_TAKEOFF: "MODE_HORSEFLY_AUTO_TAKEOFF",
	MODE_HORSEFLY_AUTO_LANDING: "MODE_HORSEFLY_AUTO_LANDING",
	MODE_HORSEFLY_NAVI_GO_HOME: "MODE_HORSEFLY_NAVI_GO_HOME",
	MODE_HORSEFLY_DROP:         "MODE_HORSEFLY_DROP",
}

var values_AVSS_HORSEFLY_OPERATION_MODE = map[string]AVSS_HORSEFLY_OPERATION_MODE{
	"MODE_HORSEFLY_MANUAL_CTRL":  MODE_HORSEFLY_MANUAL_CTRL,
	"MODE_HORSEFLY_AUTO_TAKEOFF": MODE_HORSEFLY_AUTO_TAKEOFF,
	"MODE_HORSEFLY_AUTO_LANDING": MODE_HORSEFLY_AUTO_LANDING,
	"MODE_HORSEFLY_NAVI_GO_HOME": MODE_HORSEFLY_NAVI_GO_HOME,
	"MODE_HORSEFLY_DROP":         MODE_HORSEFLY_DROP,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e AVSS_HORSEFLY_OPERATION_MODE) MarshalText() ([]byte, error) {
	if name, ok := labels_AVSS_HORSEFLY_OPERATION_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *AVSS_HORSEFLY_OPERATION_MODE) UnmarshalText(text []byte) error {
	if value, ok := values_AVSS_HORSEFLY_OPERATION_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = AVSS_HORSEFLY_OPERATION_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e AVSS_HORSEFLY_OPERATION_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
