//autogenerated:yes
//nolint:revive,misspell,govet,lll
package ardupilotmega

// Control on-board Camera Control System to take shots.
type MessageDigicamControl struct {
	// System ID.
	TargetSystem uint8
	// Component ID.
	TargetComponent uint8
	// 0: stop, 1: start or keep it up //Session control e.g. show/hide lens.
	Session uint8
	// 1 to N //Zoom's absolute position (0 means ignore).
	ZoomPos uint8
	// -100 to 100 //Zooming step value to offset zoom from the current position.
	ZoomStep int8
	// 0: unlock focus or keep unlocked, 1: lock focus or keep locked, 3: re-lock focus.
	FocusLock uint8
	// 0: ignore, 1: shot or start filming.
	Shot uint8
	// Command Identity (incremental loop: 0 to 255)//A command sent multiple times will be executed or pooled just once.
	CommandId uint8
	// Extra parameters enumeration (0 means ignore).
	ExtraParam uint8
	// Correspondent value to given extra_param.
	ExtraValue float32
}

// GetID implements the message.Message interface.
func (*MessageDigicamControl) GetID() uint32 {
	return 155
}
