//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags in RALLY_POINT message.
type RALLY_FLAGS uint64

const (
	// Flag set when requiring favorable winds for landing.
	FAVORABLE_WIND RALLY_FLAGS = 1
	// Flag set when plane is to immediately descend to break altitude and land without GCS intervention. Flag not set when plane is to loiter at Rally point until commanded to land.
	LAND_IMMEDIATELY RALLY_FLAGS = 2
	// True if the following altitude frame value is valid.
	ALT_FRAME_VALID RALLY_FLAGS = 4
	// 2 bit value representing altitude frame. 0: absolute, 1: relative home, 2: relative origin, 3: relative terrain
	ALT_FRAME RALLY_FLAGS = 24
)

var labels_RALLY_FLAGS = map[RALLY_FLAGS]string{
	FAVORABLE_WIND:   "FAVORABLE_WIND",
	LAND_IMMEDIATELY: "LAND_IMMEDIATELY",
	ALT_FRAME_VALID:  "ALT_FRAME_VALID",
	ALT_FRAME:        "ALT_FRAME",
}

var values_RALLY_FLAGS = map[string]RALLY_FLAGS{
	"FAVORABLE_WIND":   FAVORABLE_WIND,
	"LAND_IMMEDIATELY": LAND_IMMEDIATELY,
	"ALT_FRAME_VALID":  ALT_FRAME_VALID,
	"ALT_FRAME":        ALT_FRAME,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e RALLY_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 4; i++ {
		mask := RALLY_FLAGS(1 << i)
		if e&mask == mask {
			names = append(names, labels_RALLY_FLAGS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *RALLY_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask RALLY_FLAGS
	for _, label := range labels {
		if value, ok := values_RALLY_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= RALLY_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e RALLY_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
