//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
	"strings"
)

type LIMIT_MODULE uint64

const (
	// Pre-initialization.
	LIMIT_GPSLOCK LIMIT_MODULE = 1
	// Disabled.
	LIMIT_GEOFENCE LIMIT_MODULE = 2
	// Checking limits.
	LIMIT_ALTITUDE LIMIT_MODULE = 4
)

var labels_LIMIT_MODULE = map[LIMIT_MODULE]string{
	LIMIT_GPSLOCK:  "LIMIT_GPSLOCK",
	LIMIT_GEOFENCE: "LIMIT_GEOFENCE",
	LIMIT_ALTITUDE: "LIMIT_ALTITUDE",
}

var values_LIMIT_MODULE = map[string]LIMIT_MODULE{
	"LIMIT_GPSLOCK":  LIMIT_GPSLOCK,
	"LIMIT_GEOFENCE": LIMIT_GEOFENCE,
	"LIMIT_ALTITUDE": LIMIT_ALTITUDE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e LIMIT_MODULE) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 3; i++ {
		mask := LIMIT_MODULE(1 << i)
		if e&mask == mask {
			names = append(names, labels_LIMIT_MODULE[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *LIMIT_MODULE) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask LIMIT_MODULE
	for _, label := range labels {
		if value, ok := values_LIMIT_MODULE[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= LIMIT_MODULE(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e LIMIT_MODULE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
