//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GOPRO_REQUEST_STATUS uint64

const (
	// The write message with ID indicated succeeded.
	GOPRO_REQUEST_SUCCESS GOPRO_REQUEST_STATUS = 0
	// The write message with ID indicated failed.
	GOPRO_REQUEST_FAILED GOPRO_REQUEST_STATUS = 1
)

var labels_GOPRO_REQUEST_STATUS = map[GOPRO_REQUEST_STATUS]string{
	GOPRO_REQUEST_SUCCESS: "GOPRO_REQUEST_SUCCESS",
	GOPRO_REQUEST_FAILED:  "GOPRO_REQUEST_FAILED",
}

var values_GOPRO_REQUEST_STATUS = map[string]GOPRO_REQUEST_STATUS{
	"GOPRO_REQUEST_SUCCESS": GOPRO_REQUEST_SUCCESS,
	"GOPRO_REQUEST_FAILED":  GOPRO_REQUEST_FAILED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GOPRO_REQUEST_STATUS) MarshalText() ([]byte, error) {
	if name, ok := labels_GOPRO_REQUEST_STATUS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GOPRO_REQUEST_STATUS) UnmarshalText(text []byte) error {
	if value, ok := values_GOPRO_REQUEST_STATUS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GOPRO_REQUEST_STATUS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GOPRO_REQUEST_STATUS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
