//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

// Deepstall flight stage.
type DEEPSTALL_STAGE uint64

const (
	// Flying to the landing point.
	DEEPSTALL_STAGE_FLY_TO_LANDING DEEPSTALL_STAGE = 0
	// Building an estimate of the wind.
	DEEPSTALL_STAGE_ESTIMATE_WIND DEEPSTALL_STAGE = 1
	// Waiting to breakout of the loiter to fly the approach.
	DEEPSTALL_STAGE_WAIT_FOR_BREAKOUT DEEPSTALL_STAGE = 2
	// Flying to the first arc point to turn around to the landing point.
	DEEPSTALL_STAGE_FLY_TO_ARC DEEPSTALL_STAGE = 3
	// Turning around back to the deepstall landing point.
	DEEPSTALL_STAGE_ARC DEEPSTALL_STAGE = 4
	// Approaching the landing point.
	DEEPSTALL_STAGE_APPROACH DEEPSTALL_STAGE = 5
	// Stalling and steering towards the land point.
	DEEPSTALL_STAGE_LAND DEEPSTALL_STAGE = 6
)

var labels_DEEPSTALL_STAGE = map[DEEPSTALL_STAGE]string{
	DEEPSTALL_STAGE_FLY_TO_LANDING:    "DEEPSTALL_STAGE_FLY_TO_LANDING",
	DEEPSTALL_STAGE_ESTIMATE_WIND:     "DEEPSTALL_STAGE_ESTIMATE_WIND",
	DEEPSTALL_STAGE_WAIT_FOR_BREAKOUT: "DEEPSTALL_STAGE_WAIT_FOR_BREAKOUT",
	DEEPSTALL_STAGE_FLY_TO_ARC:        "DEEPSTALL_STAGE_FLY_TO_ARC",
	DEEPSTALL_STAGE_ARC:               "DEEPSTALL_STAGE_ARC",
	DEEPSTALL_STAGE_APPROACH:          "DEEPSTALL_STAGE_APPROACH",
	DEEPSTALL_STAGE_LAND:              "DEEPSTALL_STAGE_LAND",
}

var values_DEEPSTALL_STAGE = map[string]DEEPSTALL_STAGE{
	"DEEPSTALL_STAGE_FLY_TO_LANDING":    DEEPSTALL_STAGE_FLY_TO_LANDING,
	"DEEPSTALL_STAGE_ESTIMATE_WIND":     DEEPSTALL_STAGE_ESTIMATE_WIND,
	"DEEPSTALL_STAGE_WAIT_FOR_BREAKOUT": DEEPSTALL_STAGE_WAIT_FOR_BREAKOUT,
	"DEEPSTALL_STAGE_FLY_TO_ARC":        DEEPSTALL_STAGE_FLY_TO_ARC,
	"DEEPSTALL_STAGE_ARC":               DEEPSTALL_STAGE_ARC,
	"DEEPSTALL_STAGE_APPROACH":          DEEPSTALL_STAGE_APPROACH,
	"DEEPSTALL_STAGE_LAND":              DEEPSTALL_STAGE_LAND,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e DEEPSTALL_STAGE) MarshalText() ([]byte, error) {
	if name, ok := labels_DEEPSTALL_STAGE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *DEEPSTALL_STAGE) UnmarshalText(text []byte) error {
	if value, ok := values_DEEPSTALL_STAGE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = DEEPSTALL_STAGE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e DEEPSTALL_STAGE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
