//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package uavionix

import (
	"fmt"
	"strconv"
	"strings"
)

// Status flags for ADS-B transponder dynamic output
type UAVIONIX_ADSB_RF_HEALTH uint64

const (
	UAVIONIX_ADSB_RF_HEALTH_INITIALIZING UAVIONIX_ADSB_RF_HEALTH = 0
	UAVIONIX_ADSB_RF_HEALTH_OK           UAVIONIX_ADSB_RF_HEALTH = 1
	UAVIONIX_ADSB_RF_HEALTH_FAIL_TX      UAVIONIX_ADSB_RF_HEALTH = 2
	UAVIONIX_ADSB_RF_HEALTH_FAIL_RX      UAVIONIX_ADSB_RF_HEALTH = 16
)

var labels_UAVIONIX_ADSB_RF_HEALTH = map[UAVIONIX_ADSB_RF_HEALTH]string{
	UAVIONIX_ADSB_RF_HEALTH_INITIALIZING: "UAVIONIX_ADSB_RF_HEALTH_INITIALIZING",
	UAVIONIX_ADSB_RF_HEALTH_OK:           "UAVIONIX_ADSB_RF_HEALTH_OK",
	UAVIONIX_ADSB_RF_HEALTH_FAIL_TX:      "UAVIONIX_ADSB_RF_HEALTH_FAIL_TX",
	UAVIONIX_ADSB_RF_HEALTH_FAIL_RX:      "UAVIONIX_ADSB_RF_HEALTH_FAIL_RX",
}

var values_UAVIONIX_ADSB_RF_HEALTH = map[string]UAVIONIX_ADSB_RF_HEALTH{
	"UAVIONIX_ADSB_RF_HEALTH_INITIALIZING": UAVIONIX_ADSB_RF_HEALTH_INITIALIZING,
	"UAVIONIX_ADSB_RF_HEALTH_OK":           UAVIONIX_ADSB_RF_HEALTH_OK,
	"UAVIONIX_ADSB_RF_HEALTH_FAIL_TX":      UAVIONIX_ADSB_RF_HEALTH_FAIL_TX,
	"UAVIONIX_ADSB_RF_HEALTH_FAIL_RX":      UAVIONIX_ADSB_RF_HEALTH_FAIL_RX,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UAVIONIX_ADSB_RF_HEALTH) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 4; i++ {
		mask := UAVIONIX_ADSB_RF_HEALTH(1 << i)
		if e&mask == mask {
			names = append(names, labels_UAVIONIX_ADSB_RF_HEALTH[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UAVIONIX_ADSB_RF_HEALTH) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask UAVIONIX_ADSB_RF_HEALTH
	for _, label := range labels {
		if value, ok := values_UAVIONIX_ADSB_RF_HEALTH[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= UAVIONIX_ADSB_RF_HEALTH(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e UAVIONIX_ADSB_RF_HEALTH) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
