//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ualberta

import (
	"fmt"
	"strconv"
)

// Navigation filter mode
type UALBERTA_NAV_MODE uint64

const (
	NAV_AHRS_INIT UALBERTA_NAV_MODE = 1
	// AHRS mode
	NAV_AHRS UALBERTA_NAV_MODE = 2
	// INS/GPS initialization mode
	NAV_INS_GPS_INIT UALBERTA_NAV_MODE = 3
	// INS/GPS mode
	NAV_INS_GPS UALBERTA_NAV_MODE = 4
)

var labels_UALBERTA_NAV_MODE = map[UALBERTA_NAV_MODE]string{
	NAV_AHRS_INIT:    "NAV_AHRS_INIT",
	NAV_AHRS:         "NAV_AHRS",
	NAV_INS_GPS_INIT: "NAV_INS_GPS_INIT",
	NAV_INS_GPS:      "NAV_INS_GPS",
}

var values_UALBERTA_NAV_MODE = map[string]UALBERTA_NAV_MODE{
	"NAV_AHRS_INIT":    NAV_AHRS_INIT,
	"NAV_AHRS":         NAV_AHRS,
	"NAV_INS_GPS_INIT": NAV_INS_GPS_INIT,
	"NAV_INS_GPS":      NAV_INS_GPS,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UALBERTA_NAV_MODE) MarshalText() ([]byte, error) {
	if name, ok := labels_UALBERTA_NAV_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UALBERTA_NAV_MODE) UnmarshalText(text []byte) error {
	if value, ok := values_UALBERTA_NAV_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = UALBERTA_NAV_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e UALBERTA_NAV_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
