//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package storm32

import (
	"fmt"
	"strconv"
)

// Gimbal manager client ID. In a prioritizing profile, the priorities are determined by the implementation; they could e.g. be custom1 > onboard > GCS > autopilot/camera > GCS2 > custom2.
type MAV_STORM32_GIMBAL_MANAGER_CLIENT uint64

const (
	// For convenience.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_NONE MAV_STORM32_GIMBAL_MANAGER_CLIENT = 0
	// This is the onboard/companion computer client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_ONBOARD MAV_STORM32_GIMBAL_MANAGER_CLIENT = 1
	// This is the autopilot client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_AUTOPILOT MAV_STORM32_GIMBAL_MANAGER_CLIENT = 2
	// This is the GCS client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS MAV_STORM32_GIMBAL_MANAGER_CLIENT = 3
	// This is the camera client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA MAV_STORM32_GIMBAL_MANAGER_CLIENT = 4
	// This is the GCS2 client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS2 MAV_STORM32_GIMBAL_MANAGER_CLIENT = 5
	// This is the camera2 client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA2 MAV_STORM32_GIMBAL_MANAGER_CLIENT = 6
	// This is the custom client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM MAV_STORM32_GIMBAL_MANAGER_CLIENT = 7
	// This is the custom2 client.
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM2 MAV_STORM32_GIMBAL_MANAGER_CLIENT = 8
)

var labels_MAV_STORM32_GIMBAL_MANAGER_CLIENT = map[MAV_STORM32_GIMBAL_MANAGER_CLIENT]string{
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_NONE:      "MAV_STORM32_GIMBAL_MANAGER_CLIENT_NONE",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_ONBOARD:   "MAV_STORM32_GIMBAL_MANAGER_CLIENT_ONBOARD",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_AUTOPILOT: "MAV_STORM32_GIMBAL_MANAGER_CLIENT_AUTOPILOT",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS:       "MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA:    "MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS2:      "MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS2",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA2:   "MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA2",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM:    "MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM",
	MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM2:   "MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM2",
}

var values_MAV_STORM32_GIMBAL_MANAGER_CLIENT = map[string]MAV_STORM32_GIMBAL_MANAGER_CLIENT{
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_NONE":      MAV_STORM32_GIMBAL_MANAGER_CLIENT_NONE,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_ONBOARD":   MAV_STORM32_GIMBAL_MANAGER_CLIENT_ONBOARD,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_AUTOPILOT": MAV_STORM32_GIMBAL_MANAGER_CLIENT_AUTOPILOT,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS":       MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA":    MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS2":      MAV_STORM32_GIMBAL_MANAGER_CLIENT_GCS2,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA2":   MAV_STORM32_GIMBAL_MANAGER_CLIENT_CAMERA2,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM":    MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM,
	"MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM2":   MAV_STORM32_GIMBAL_MANAGER_CLIENT_CUSTOM2,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_STORM32_GIMBAL_MANAGER_CLIENT) MarshalText() ([]byte, error) {
	if name, ok := labels_MAV_STORM32_GIMBAL_MANAGER_CLIENT[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_STORM32_GIMBAL_MANAGER_CLIENT) UnmarshalText(text []byte) error {
	if value, ok := values_MAV_STORM32_GIMBAL_MANAGER_CLIENT[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_STORM32_GIMBAL_MANAGER_CLIENT(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_STORM32_GIMBAL_MANAGER_CLIENT) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
