//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package storm32

import (
	"fmt"
	"strconv"
	"strings"
)

// STorM32 camera prearm check flags.
type MAV_STORM32_CAMERA_PREARM_FLAGS uint64

const (
	// The camera has been found and is connected.
	MAV_STORM32_CAMERA_PREARM_FLAGS_CONNECTED MAV_STORM32_CAMERA_PREARM_FLAGS = 1
)

var labels_MAV_STORM32_CAMERA_PREARM_FLAGS = map[MAV_STORM32_CAMERA_PREARM_FLAGS]string{
	MAV_STORM32_CAMERA_PREARM_FLAGS_CONNECTED: "MAV_STORM32_CAMERA_PREARM_FLAGS_CONNECTED",
}

var values_MAV_STORM32_CAMERA_PREARM_FLAGS = map[string]MAV_STORM32_CAMERA_PREARM_FLAGS{
	"MAV_STORM32_CAMERA_PREARM_FLAGS_CONNECTED": MAV_STORM32_CAMERA_PREARM_FLAGS_CONNECTED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_STORM32_CAMERA_PREARM_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 1; i++ {
		mask := MAV_STORM32_CAMERA_PREARM_FLAGS(1 << i)
		if e&mask == mask {
			names = append(names, labels_MAV_STORM32_CAMERA_PREARM_FLAGS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_STORM32_CAMERA_PREARM_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MAV_STORM32_CAMERA_PREARM_FLAGS
	for _, label := range labels {
		if value, ok := values_MAV_STORM32_CAMERA_PREARM_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MAV_STORM32_CAMERA_PREARM_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_STORM32_CAMERA_PREARM_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
