//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
	"strings"
)

// RADIO_RC_CHANNELS flags (bitmask).
type RADIO_RC_CHANNELS_FLAGS uint64

const (
	// Failsafe is active. The content of the RC channels data in the RADIO_RC_CHANNELS message is implementation dependent.
	RADIO_RC_CHANNELS_FLAGS_FAILSAFE RADIO_RC_CHANNELS_FLAGS = 1
	// Channel data may be out of date. This is set when the receiver is unable to validate incoming data from the transmitter and has therefore resent the last valid data it received.
	RADIO_RC_CHANNELS_FLAGS_OUTDATED RADIO_RC_CHANNELS_FLAGS = 2
)

var labels_RADIO_RC_CHANNELS_FLAGS = map[RADIO_RC_CHANNELS_FLAGS]string{
	RADIO_RC_CHANNELS_FLAGS_FAILSAFE: "RADIO_RC_CHANNELS_FLAGS_FAILSAFE",
	RADIO_RC_CHANNELS_FLAGS_OUTDATED: "RADIO_RC_CHANNELS_FLAGS_OUTDATED",
}

var values_RADIO_RC_CHANNELS_FLAGS = map[string]RADIO_RC_CHANNELS_FLAGS{
	"RADIO_RC_CHANNELS_FLAGS_FAILSAFE": RADIO_RC_CHANNELS_FLAGS_FAILSAFE,
	"RADIO_RC_CHANNELS_FLAGS_OUTDATED": RADIO_RC_CHANNELS_FLAGS_OUTDATED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e RADIO_RC_CHANNELS_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 2; i++ {
		mask := RADIO_RC_CHANNELS_FLAGS(1 << i)
		if e&mask == mask {
			names = append(names, labels_RADIO_RC_CHANNELS_FLAGS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *RADIO_RC_CHANNELS_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask RADIO_RC_CHANNELS_FLAGS
	for _, label := range labels {
		if value, ok := values_RADIO_RC_CHANNELS_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= RADIO_RC_CHANNELS_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e RADIO_RC_CHANNELS_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
