//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
)

// Signal jamming state in a GPS receiver.
type GPS_JAMMING_STATE uint64

const (
	// The GPS receiver does not provide GPS signal jamming info.
	GPS_JAMMING_STATE_UNKNOWN GPS_JAMMING_STATE = 0
	// The GPS receiver detected no signal jamming.
	GPS_JAMMING_STATE_OK GPS_JAMMING_STATE = 1
	// The GPS receiver detected and mitigated signal jamming.
	GPS_JAMMING_STATE_MITIGATED GPS_JAMMING_STATE = 2
	// The GPS receiver detected signal jamming.
	GPS_JAMMING_STATE_DETECTED GPS_JAMMING_STATE = 3
)

var labels_GPS_JAMMING_STATE = map[GPS_JAMMING_STATE]string{
	GPS_JAMMING_STATE_UNKNOWN:   "GPS_JAMMING_STATE_UNKNOWN",
	GPS_JAMMING_STATE_OK:        "GPS_JAMMING_STATE_OK",
	GPS_JAMMING_STATE_MITIGATED: "GPS_JAMMING_STATE_MITIGATED",
	GPS_JAMMING_STATE_DETECTED:  "GPS_JAMMING_STATE_DETECTED",
}

var values_GPS_JAMMING_STATE = map[string]GPS_JAMMING_STATE{
	"GPS_JAMMING_STATE_UNKNOWN":   GPS_JAMMING_STATE_UNKNOWN,
	"GPS_JAMMING_STATE_OK":        GPS_JAMMING_STATE_OK,
	"GPS_JAMMING_STATE_MITIGATED": GPS_JAMMING_STATE_MITIGATED,
	"GPS_JAMMING_STATE_DETECTED":  GPS_JAMMING_STATE_DETECTED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GPS_JAMMING_STATE) MarshalText() ([]byte, error) {
	if name, ok := labels_GPS_JAMMING_STATE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GPS_JAMMING_STATE) UnmarshalText(text []byte) error {
	if value, ok := values_GPS_JAMMING_STATE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GPS_JAMMING_STATE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GPS_JAMMING_STATE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
