//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
)

// Signal authentication state in a GPS receiver.
type GPS_AUTHENTICATION_STATE uint64

const (
	// The GPS receiver does not provide GPS signal authentication info.
	GPS_AUTHENTICATION_STATE_UNKNOWN GPS_AUTHENTICATION_STATE = 0
	// The GPS receiver is initializing signal authentication.
	GPS_AUTHENTICATION_STATE_INITIALIZING GPS_AUTHENTICATION_STATE = 1
	// The GPS receiver encountered an error while initializing signal authentication.
	GPS_AUTHENTICATION_STATE_ERROR GPS_AUTHENTICATION_STATE = 2
	// The GPS receiver has correctly authenticated all signals.
	GPS_AUTHENTICATION_STATE_OK GPS_AUTHENTICATION_STATE = 3
	// GPS signal authentication is disabled on the receiver.
	GPS_AUTHENTICATION_STATE_DISABLED GPS_AUTHENTICATION_STATE = 4
)

var labels_GPS_AUTHENTICATION_STATE = map[GPS_AUTHENTICATION_STATE]string{
	GPS_AUTHENTICATION_STATE_UNKNOWN:      "GPS_AUTHENTICATION_STATE_UNKNOWN",
	GPS_AUTHENTICATION_STATE_INITIALIZING: "GPS_AUTHENTICATION_STATE_INITIALIZING",
	GPS_AUTHENTICATION_STATE_ERROR:        "GPS_AUTHENTICATION_STATE_ERROR",
	GPS_AUTHENTICATION_STATE_OK:           "GPS_AUTHENTICATION_STATE_OK",
	GPS_AUTHENTICATION_STATE_DISABLED:     "GPS_AUTHENTICATION_STATE_DISABLED",
}

var values_GPS_AUTHENTICATION_STATE = map[string]GPS_AUTHENTICATION_STATE{
	"GPS_AUTHENTICATION_STATE_UNKNOWN":      GPS_AUTHENTICATION_STATE_UNKNOWN,
	"GPS_AUTHENTICATION_STATE_INITIALIZING": GPS_AUTHENTICATION_STATE_INITIALIZING,
	"GPS_AUTHENTICATION_STATE_ERROR":        GPS_AUTHENTICATION_STATE_ERROR,
	"GPS_AUTHENTICATION_STATE_OK":           GPS_AUTHENTICATION_STATE_OK,
	"GPS_AUTHENTICATION_STATE_DISABLED":     GPS_AUTHENTICATION_STATE_DISABLED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GPS_AUTHENTICATION_STATE) MarshalText() ([]byte, error) {
	if name, ok := labels_GPS_AUTHENTICATION_STATE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GPS_AUTHENTICATION_STATE) UnmarshalText(text []byte) error {
	if value, ok := values_GPS_AUTHENTICATION_STATE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GPS_AUTHENTICATION_STATE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GPS_AUTHENTICATION_STATE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
