//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Airborne status of UAS.
type UTM_FLIGHT_STATE uint64

const (
	// The flight state can't be determined.
	UTM_FLIGHT_STATE_UNKNOWN UTM_FLIGHT_STATE = 1
	// UAS on ground.
	UTM_FLIGHT_STATE_GROUND UTM_FLIGHT_STATE = 2
	// UAS airborne.
	UTM_FLIGHT_STATE_AIRBORNE UTM_FLIGHT_STATE = 3
	// UAS is in an emergency flight state.
	UTM_FLIGHT_STATE_EMERGENCY UTM_FLIGHT_STATE = 16
	// UAS has no active controls.
	UTM_FLIGHT_STATE_NOCTRL UTM_FLIGHT_STATE = 32
)

var labels_UTM_FLIGHT_STATE = map[UTM_FLIGHT_STATE]string{
	UTM_FLIGHT_STATE_UNKNOWN:   "UTM_FLIGHT_STATE_UNKNOWN",
	UTM_FLIGHT_STATE_GROUND:    "UTM_FLIGHT_STATE_GROUND",
	UTM_FLIGHT_STATE_AIRBORNE:  "UTM_FLIGHT_STATE_AIRBORNE",
	UTM_FLIGHT_STATE_EMERGENCY: "UTM_FLIGHT_STATE_EMERGENCY",
	UTM_FLIGHT_STATE_NOCTRL:    "UTM_FLIGHT_STATE_NOCTRL",
}

var values_UTM_FLIGHT_STATE = map[string]UTM_FLIGHT_STATE{
	"UTM_FLIGHT_STATE_UNKNOWN":   UTM_FLIGHT_STATE_UNKNOWN,
	"UTM_FLIGHT_STATE_GROUND":    UTM_FLIGHT_STATE_GROUND,
	"UTM_FLIGHT_STATE_AIRBORNE":  UTM_FLIGHT_STATE_AIRBORNE,
	"UTM_FLIGHT_STATE_EMERGENCY": UTM_FLIGHT_STATE_EMERGENCY,
	"UTM_FLIGHT_STATE_NOCTRL":    UTM_FLIGHT_STATE_NOCTRL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UTM_FLIGHT_STATE) MarshalText() ([]byte, error) {
	if name, ok := labels_UTM_FLIGHT_STATE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UTM_FLIGHT_STATE) UnmarshalText(text []byte) error {
	if value, ok := values_UTM_FLIGHT_STATE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = UTM_FLIGHT_STATE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e UTM_FLIGHT_STATE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
