//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags to indicate usage for a particular storage (see STORAGE_INFORMATION.storage_usage and MAV_CMD_SET_STORAGE_USAGE).
type STORAGE_USAGE_FLAG uint64

const (
	// Always set to 1 (indicates STORAGE_INFORMATION.storage_usage is supported).
	STORAGE_USAGE_FLAG_SET STORAGE_USAGE_FLAG = 1
	// Storage for saving photos.
	STORAGE_USAGE_FLAG_PHOTO STORAGE_USAGE_FLAG = 2
	// Storage for saving videos.
	STORAGE_USAGE_FLAG_VIDEO STORAGE_USAGE_FLAG = 4
	// Storage for saving logs.
	STORAGE_USAGE_FLAG_LOGS STORAGE_USAGE_FLAG = 8
)

var labels_STORAGE_USAGE_FLAG = map[STORAGE_USAGE_FLAG]string{
	STORAGE_USAGE_FLAG_SET:   "STORAGE_USAGE_FLAG_SET",
	STORAGE_USAGE_FLAG_PHOTO: "STORAGE_USAGE_FLAG_PHOTO",
	STORAGE_USAGE_FLAG_VIDEO: "STORAGE_USAGE_FLAG_VIDEO",
	STORAGE_USAGE_FLAG_LOGS:  "STORAGE_USAGE_FLAG_LOGS",
}

var values_STORAGE_USAGE_FLAG = map[string]STORAGE_USAGE_FLAG{
	"STORAGE_USAGE_FLAG_SET":   STORAGE_USAGE_FLAG_SET,
	"STORAGE_USAGE_FLAG_PHOTO": STORAGE_USAGE_FLAG_PHOTO,
	"STORAGE_USAGE_FLAG_VIDEO": STORAGE_USAGE_FLAG_VIDEO,
	"STORAGE_USAGE_FLAG_LOGS":  STORAGE_USAGE_FLAG_LOGS,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e STORAGE_USAGE_FLAG) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 4; i++ {
		mask := STORAGE_USAGE_FLAG(1 << i)
		if e&mask == mask {
			names = append(names, labels_STORAGE_USAGE_FLAG[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *STORAGE_USAGE_FLAG) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask STORAGE_USAGE_FLAG
	for _, label := range labels {
		if value, ok := values_STORAGE_USAGE_FLAG[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= STORAGE_USAGE_FLAG(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e STORAGE_USAGE_FLAG) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
